
#pragma used+
sfrb TWBR=0;
sfrb TWSR=1;
sfrb TWAR=2;
sfrb TWDR=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRRL=9;
sfrb UCSRB=0xa;
sfrb UCSRA=0xb;
sfrb UDR=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   
sfrb UBRRH=0x20;
sfrb UCSRC=0X20;
sfrb WDTCR=0x21;
sfrb ASSR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb SFIOR=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TWCR=0x36;
sfrb SPMCR=0x37;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a;
sfrb GICR=0x3b;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

void LCD_init ( void );
void LCD_clear ( void );
void LCD_gotoXY ( unsigned char x, unsigned char );
void LCD_writeChar ( unsigned char );
void LCD_writeData ( unsigned char );
void LCD_writeCommand ( unsigned char );
void LCD_writeString_F ( flash unsigned char*);

typedef char *va_list;

#pragma used+

char getchar(void);
void putchar(char c);
void puts(char *str);
void putsf(char flash *str);
int printf(char flash *fmtstr,...);
int sprintf(char *str, char flash *fmtstr,...);
int vprintf(char flash * fmtstr, va_list argptr);
int vsprintf(char *str, char flash * fmtstr, va_list argptr);

char *gets(char *str,unsigned int len);
int snprintf(char *str, unsigned int size, char flash *fmtstr,...);
int vsnprintf(char *str, unsigned int size, char flash * fmtstr, va_list argptr);

int scanf(char flash *fmtstr,...);
int sscanf(char *str, char flash *fmtstr,...);

#pragma used-

#pragma library stdio.lib

char CACHECHAR;
int PROJECTORMODE = 0; 

int PROJECTORENAB = 0;
int CACHECOUNTER = 1;

char rx_buffer[8];

unsigned char rx_wr_index,rx_rd_index,rx_counter;
bit rx_buffer_overflow;
interrupt [12] void usart_rx_isr(void)
{
char status,data;
status=UCSRA;
data=UDR;
if ((status & ((1<<4) | (1<<2) | (1<<3)))==0)
{
rx_buffer[rx_wr_index]=data;
if (++rx_wr_index == 8) rx_wr_index=0;
if (++rx_counter == 8)
{
rx_counter=0;
rx_buffer_overflow=1;
};
};
}

#pragma used+
char getchar(void)
{
char data;
while (rx_counter==0);
data=rx_buffer[rx_rd_index];
if (++rx_rd_index == 8) rx_rd_index=0;
#asm("cli")
--rx_counter;
#asm("sei")
return data;
}
#pragma used-

void main(void) {

PORTB = 0x00;
DDRB  = 0x3F;
PORTC = 0x00; 
DDRC  = 0xFF;
PORTD = 0x00;
DDRD  = 0x00;

SPCR = 0x58;

TWCR= 0X00;
TWBR= 0x02;
TWSR= 0x00;
TWAR= 0x00;
TWCR= 0x44;

MCUCR = 0x00;
GICR  = 0x00;

TIMSK = 0x00;

UCSRA=0x00;
UCSRB=0x98;
UCSRC=0x86;
UBRRH=0x00;
UBRRL=0x19;

delay_ms(100);
PORTB.1 = 0xFF;
LCD_init();
delay_ms(100);	   

LCD_gotoXY (6,0); LCD_writeString_F("!");
LCD_gotoXY (6,1); LCD_writeString_F(" ");
LCD_gotoXY (6,2); LCD_writeString_F("'0x0B' ");
LCD_gotoXY (6,3); LCD_writeString_F("");

#asm("sei") 

while(1) {      
CACHECHAR = getchar();
switch ( CACHECHAR ) {
case 0x01: if (PROJECTORMODE == 0) {PROJECTORMODE = 0;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; 
case 0x02: if (PROJECTORMODE == 0) {PROJECTORMODE = 1; LCD_gotoXY (0,0);}       else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; 
case 0x03: if (PROJECTORMODE == 0) {LCD_gotoXY (0,0);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x04: if (PROJECTORMODE == 0) {LCD_gotoXY (0,1);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x05: if (PROJECTORMODE == 0) {LCD_gotoXY (0,2);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x06: if (PROJECTORMODE == 0) {LCD_gotoXY (0,3);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x07: if (PROJECTORMODE == 0) {LCD_gotoXY (0,4);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x08: if (PROJECTORMODE == 0) {LCD_gotoXY (0,5);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x0A: if (PROJECTORMODE == 0) {LCD_gotoXY (0,6);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x0B: if (PROJECTORMODE == 0) {PROJECTORENAB = 1;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
case 0x09: if (PROJECTORMODE == 0) { if (PROJECTORENAB == 1) { LCD_clear(); }}  else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
default:
if (PROJECTORENAB == 1) { 
if (PROJECTORMODE == 0) { putchar(CACHECHAR); LCD_writeChar(CACHECHAR); break; }
if (PROJECTORMODE == 1) { 
if (CACHECOUNTER < 503) {
CACHECOUNTER++; 
LCD_writeData(CACHECHAR);
} 
else { CACHECOUNTER = 1; PROJECTORMODE = 0;  break; }} 
}
} } }
