#include <mega8.h>
#include <delay.h>
#include "3310_routines.h"
#include <stdio.h>

char CACHECHAR;
int PROJECTORMODE = 0; //0x01-CHAR //0x02-E
//int PROJECTORPAGE = 0; //0x03-0PAGE //0x04-1PAGE //0x05-2PAGE //0x06-3PAGE //0x07-4PAGE //0x08-5PAGE
int PROJECTORENAB = 0;
int CACHECOUNTER = 1;

/* PROJECTOR COMMANDS
|0x01   |   CHARMODE        |
|0x02   |   EMODE           |
|0x03   |   0PAGE           |       
|0x04   |   1PAGE           |
|0x05   |   2PAGE           |
|0x06   |   3PAGE           |
|0x07   |   4PAGE           |
|0x08   |   5PAGE           |
|0x09   |   CLEARSCR        |
|0x0A   |   ON              |
*/
//////////////////////////////////////////////////////////////
#ifndef RXB8
#define RXB8 1
#endif

#ifndef TXB8
#define TXB8 0
#endif

#ifndef UPE
#define UPE 2
#endif
         
#ifndef DOR
#define DOR 3
#endif

#ifndef FE
#define FE 4
#endif

#ifndef UDRE
#define UDRE 5
#endif

#ifndef RXC
#define RXC 7
#endif

#define FRAMING_ERROR (1<<FE)
#define PARITY_ERROR (1<<UPE)
#define DATA_OVERRUN (1<<DOR)
#define DATA_REGISTER_EMPTY (1<<UDRE)
#define RX_COMPLETE (1<<RXC)

#define RX_BUFFER_SIZE 8
char rx_buffer[RX_BUFFER_SIZE];

#if RX_BUFFER_SIZE<256
unsigned char rx_wr_index,rx_rd_index,rx_counter;
#else
unsigned int rx_wr_index,rx_rd_index,rx_counter;
#endif
bit rx_buffer_overflow;
interrupt [USART_RXC] void usart_rx_isr(void)
{
char status,data;
status=UCSRA;
data=UDR;
if ((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN))==0)
   {
   rx_buffer[rx_wr_index]=data;
   if (++rx_wr_index == RX_BUFFER_SIZE) rx_wr_index=0;
   if (++rx_counter == RX_BUFFER_SIZE)
      {
      rx_counter=0;
      rx_buffer_overflow=1;
      };
   };
}

#ifndef _DEBUG_TERMINAL_IO_
#define _ALTERNATE_GETCHAR_
#pragma used+
char getchar(void)
{
char data;
while (rx_counter==0);
data=rx_buffer[rx_rd_index];
if (++rx_rd_index == RX_BUFFER_SIZE) rx_rd_index=0;
#asm("cli")
--rx_counter;
#asm("sei")
return data;
}
#pragma used-
#endif
//////////////////////////////////////////////////////////////

void main(void) {

PORTB = 0x00;
DDRB  = 0x3F;
PORTC = 0x00; 
DDRC  = 0xFF;
PORTD = 0x00;
DDRD  = 0x00;

SPCR = 0x58;

TWCR= 0X00;
TWBR= 0x02;
TWSR= 0x00;
TWAR= 0x00;
TWCR= 0x44;

MCUCR = 0x00;
GICR  = 0x00;

TIMSK = 0x00;

UCSRA=0x00;
UCSRB=0x98;
UCSRC=0x86;
UBRRH=0x00;
UBRRL=0x19;


delay_ms(100);
PORTB.1 = 0xFF;
LCD_init();
delay_ms(100);	   
   
LCD_gotoXY (6,0); LCD_writeString_F("!");
LCD_gotoXY (6,1); LCD_writeString_F(" ");
LCD_gotoXY (6,2); LCD_writeString_F("'0x0B' ");
LCD_gotoXY (6,3); LCD_writeString_F("");

#asm("sei") 
 
while(1) {      
        CACHECHAR = getchar();
        switch ( CACHECHAR ) {
            case 0x01: if (PROJECTORMODE == 0) {PROJECTORMODE = 0;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; //CHAR MODE
            case 0x02: if (PROJECTORMODE == 0) {PROJECTORMODE = 1; LCD_gotoXY (0,0);}       else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; //E MODE
            case 0x03: if (PROJECTORMODE == 0) {LCD_gotoXY (0,0);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x04: if (PROJECTORMODE == 0) {LCD_gotoXY (0,1);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x05: if (PROJECTORMODE == 0) {LCD_gotoXY (0,2);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x06: if (PROJECTORMODE == 0) {LCD_gotoXY (0,3);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x07: if (PROJECTORMODE == 0) {LCD_gotoXY (0,4);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x08: if (PROJECTORMODE == 0) {LCD_gotoXY (0,5);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x0A: if (PROJECTORMODE == 0) {LCD_gotoXY (0,6);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x0B: if (PROJECTORMODE == 0) {PROJECTORENAB = 1;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            case 0x09: if (PROJECTORMODE == 0) { if (PROJECTORENAB == 1) { LCD_clear(); }}  else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
            default:
            if (PROJECTORENAB == 1) { 
                if (PROJECTORMODE == 0) { putchar(CACHECHAR); LCD_writeChar(CACHECHAR); break; }
                if (PROJECTORMODE == 1) { 
                    if (CACHECOUNTER < 503) {
                    CACHECOUNTER++; 
                    LCD_writeData(CACHECHAR);
                    } 
                    else { CACHECOUNTER = 1; PROJECTORMODE = 0;  break; }} 
            }
} } }