
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega8
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : Yes
;8 bit enums              : No
;global 'const' stored in FLASH: Yes
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega8
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1024
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _CACHECHAR=R5
	.DEF _PROJECTORMODE=R6
	.DEF _PROJECTORENAB=R8
	.DEF _CACHECOUNTER=R10
	.DEF _rx_wr_index=R4
	.DEF _rx_rd_index=R13
	.DEF _rx_counter=R12

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _usart_rx_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_smallFont:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x4C,0x2C,0x10,0x68,0x64,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x0,0x50,0x30
	.DB  0x0,0x10,0x10,0x10,0x10,0x10,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x3E,0x51,0x49,0x45,0x3E,0x0,0x42,0x7F
	.DB  0x40,0x0,0x42,0x61,0x51,0x49,0x46,0x21
	.DB  0x41,0x45,0x4B,0x31,0x18,0x14,0x12,0x7F
	.DB  0x10,0x27,0x45,0x45,0x45,0x39,0x3C,0x4A
	.DB  0x49,0x49,0x30,0x1,0x71,0x9,0x5,0x3
	.DB  0x36,0x49,0x49,0x49,0x36,0x6,0x49,0x49
	.DB  0x29,0x1E,0x0,0x36,0x36,0x0,0x0,0x0
	.DB  0x56,0x36,0x0,0x0,0x8,0x14,0x22,0x41
	.DB  0x0,0x14,0x14,0x14,0x14,0x14,0x0,0x41
	.DB  0x22,0x14,0x8,0x2,0x1,0x51,0x9,0x6
	.DB  0x3C,0x42,0x5A,0x56,0xC,0x7E,0x11,0x11
	.DB  0x11,0x7E,0x7F,0x49,0x49,0x49,0x36,0x3E
	.DB  0x41,0x41,0x41,0x22,0x7F,0x41,0x41,0x22
	.DB  0x1C,0x7F,0x49,0x49,0x49,0x41,0x7F,0x9
	.DB  0x9,0x9,0x1,0x3E,0x41,0x49,0x49,0x7A
	.DB  0x7F,0x8,0x8,0x8,0x7F,0x0,0x41,0x7F
	.DB  0x41,0x0,0x20,0x40,0x41,0x3F,0x1,0x7F
	.DB  0x8,0x14,0x22,0x41,0x7F,0x40,0x40,0x40
	.DB  0x40,0x7F,0x2,0xC,0x2,0x7F,0x7F,0x4
	.DB  0x8,0x10,0x7F,0x3E,0x41,0x41,0x41,0x3E
	.DB  0x7F,0x9,0x9,0x9,0x6,0x3E,0x41,0x51
	.DB  0x21,0x5E,0x7F,0x9,0x19,0x29,0x46,0x46
	.DB  0x49,0x49,0x49,0x31,0x1,0x1,0x7F,0x1
	.DB  0x1,0x3F,0x40,0x40,0x40,0x3F,0x1F,0x20
	.DB  0x40,0x20,0x1F,0x3F,0x40,0x38,0x40,0x3F
	.DB  0x63,0x14,0x8,0x14,0x63,0x7,0x8,0x70
	.DB  0x8,0x7,0x61,0x51,0x49,0x45,0x43,0x0
	.DB  0x7F,0x41,0x41,0x0,0x2,0x4,0x8,0x10
	.DB  0x20,0x0,0x41,0x41,0x7F,0x0,0x4,0x2
	.DB  0x1,0x2,0x4,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0x1,0x2,0x4,0x0,0x20,0x54,0x54
	.DB  0x54,0x78,0x7F,0x48,0x44,0x44,0x38,0x38
	.DB  0x44,0x44,0x44,0x20,0x38,0x44,0x44,0x48
	.DB  0x7F,0x38,0x54,0x54,0x54,0x18,0x8,0x7E
	.DB  0x9,0x1,0x2,0xC,0x52,0x52,0x52,0x3E
	.DB  0x7F,0x8,0x4,0x4,0x78,0x0,0x44,0x7D
	.DB  0x40,0x0,0x20,0x40,0x44,0x3D,0x0,0x7F
	.DB  0x10,0x28,0x44,0x0,0x0,0x41,0x7F,0x40
	.DB  0x0,0x7C,0x4,0x18,0x4,0x78,0x7C,0x8
	.DB  0x4,0x4,0x78,0x38,0x44,0x44,0x44,0x38
	.DB  0x7C,0x14,0x14,0x14,0x8,0x8,0x14,0x14
	.DB  0x18,0x7C,0x7C,0x8,0x4,0x4,0x8,0x48
	.DB  0x54,0x54,0x54,0x20,0x4,0x3F,0x44,0x40
	.DB  0x20,0x3C,0x40,0x40,0x20,0x7C,0x1C,0x20
	.DB  0x40,0x20,0x1C,0x3C,0x40,0x30,0x40,0x3C
	.DB  0x44,0x28,0x10,0x28,0x44,0xC,0x50,0x50
	.DB  0x50,0x3C,0x44,0x64,0x54,0x4C,0x44,0x0
	.DB  0x8,0x36,0x41,0x0,0x0,0x0,0x7F,0x0
	.DB  0x0,0x0,0x41,0x36,0x8,0x0,0x8,0x4
	.DB  0x8,0x10,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x40,0x0,0x40,0x0,0x40,0x4,0x4
	.DB  0xFF,0x4,0x4,0x24,0x24,0xFF,0x24,0x24
	.DB  0x28,0x7C,0xAA,0xAA,0x82,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x18
	.DB  0x0,0x0,0x3C,0x3C,0x3C,0x3C,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x5
	.DB  0x0,0x0,0x0,0x0,0x5,0x3,0x0,0x6
	.DB  0x5,0x0,0x6,0x5,0x5,0x3,0x0,0x5
	.DB  0x3,0x18,0x3C,0x3C,0x3C,0x18,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x78,0x48,0x48,0x78,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x22,0x1C,0x14,0x1C
	.DB  0x22,0x7E,0x2,0x2,0x2,0x3,0x0,0x0
	.DB  0xE7,0x0,0x0,0x4A,0x95,0xA5,0xA9,0x52
	.DB  0x7C,0x55,0x54,0x45,0x44,0x0,0x18,0x24
	.DB  0x24,0x0,0x3E,0x49,0x49,0x41,0x22,0x8
	.DB  0x14,0x2A,0x14,0x22,0x4,0x4,0x4,0x4
	.DB  0xC,0x0,0x8,0x8,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x45,0x7C,0x45,0x0
	.DB  0x0,0x4,0xA,0x4,0x0,0x44,0x44,0x5F
	.DB  0x44,0x44,0x0,0x41,0x7F,0x41,0x0,0x0
	.DB  0x0,0x7A,0x0,0x0,0x0,0x78,0x8,0xC
	.DB  0x0,0x0,0xFC,0x20,0x3C,0x20,0xC,0x1E
	.DB  0xFE,0x2,0xFE,0x0,0x18,0x18,0x0,0x0
	.DB  0x39,0x54,0x54,0x49,0x0,0x78,0x10,0x20
	.DB  0x7B,0x3,0x38,0x54,0x54,0x44,0x0,0x22
	.DB  0x14,0x2A,0x14,0x8,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x54,0x70,0x44,0x0
	.DB  0x7C,0x12,0x11,0x12,0x7C,0x7F,0x49,0x49
	.DB  0x49,0x31,0x7F,0x49,0x49,0x49,0x36,0x7F
	.DB  0x1,0x1,0x1,0x1,0x60,0x3F,0x21,0x3F
	.DB  0x60,0x7F,0x49,0x49,0x49,0x41,0x77,0x8
	.DB  0x7F,0x8,0x77,0x22,0x41,0x49,0x49,0x36
	.DB  0x7F,0x10,0x8,0x4,0x7F,0x7E,0x10,0x9
	.DB  0x4,0x7E,0x7F,0x8,0x14,0x22,0x41,0x40
	.DB  0x3E,0x1,0x1,0x7F,0x7F,0x2,0xC,0x2
	.DB  0x7F,0x7F,0x8,0x8,0x8,0x7F,0x3E,0x41
	.DB  0x41,0x41,0x3E,0x7F,0x1,0x1,0x1,0x7F
	.DB  0x7F,0x9,0x9,0x9,0x6,0x3E,0x41,0x41
	.DB  0x41,0x22,0x1,0x1,0x7F,0x1,0x1,0x7
	.DB  0x48,0x48,0x48,0x3F,0xE,0x11,0x7F,0x11
	.DB  0xE,0x63,0x14,0x8,0x14,0x63,0x3F,0x20
	.DB  0x20,0x3F,0x60,0x7,0x8,0x8,0x8,0x7F
	.DB  0x7F,0x40,0x7E,0x40,0x7F,0x3F,0x20,0x3F
	.DB  0x20,0x7F,0x1,0x7F,0x48,0x48,0x30,0x7F
	.DB  0x48,0x30,0x0,0x7F,0x0,0x7F,0x48,0x48
	.DB  0x30,0x22,0x41,0x49,0x49,0x3E,0x7F,0x8
	.DB  0x3E,0x41,0x3E,0x46,0x29,0x19,0x9,0x7F
	.DB  0x20,0x54,0x54,0x54,0x78,0x3C,0x4A,0x4A
	.DB  0x4A,0x31,0x7C,0x54,0x54,0x28,0x0,0x7C
	.DB  0x4,0x4,0xC,0x0,0x60,0x3C,0x24,0x3C
	.DB  0x60,0x38,0x54,0x54,0x54,0x18,0x6C,0x10
	.DB  0x7C,0x10,0x6C,0x0,0x44,0x54,0x54,0x28
	.DB  0x7C,0x20,0x10,0x8,0x7C,0x7C,0x21,0x12
	.DB  0x9,0x7C,0x7C,0x10,0x28,0x44,0x0,0x40
	.DB  0x38,0x4,0x4,0x7C,0x7C,0x8,0x10,0x8
	.DB  0x7C,0x7C,0x10,0x10,0x10,0x7C,0x38,0x44
	.DB  0x44,0x44,0x38,0x7C,0x4,0x4,0x4,0x7C
	.DB  0x7C,0x14,0x14,0x14,0x8,0x38,0x44,0x44
	.DB  0x44,0x0,0x4,0x4,0x7C,0x4,0x4,0xC
	.DB  0x50,0x50,0x50,0x3C,0x8,0x14,0x7C,0x14
	.DB  0x8,0x44,0x28,0x10,0x28,0x44,0x3C,0x20
	.DB  0x20,0x3C,0x60,0xC,0x10,0x10,0x10,0x7C
	.DB  0x7C,0x40,0x7C,0x40,0x7C,0x3C,0x20,0x3C
	.DB  0x20,0x7C,0x4,0x7C,0x50,0x50,0x20,0x7C
	.DB  0x50,0x20,0x0,0x7C,0x0,0x7C,0x50,0x50
	.DB  0x20,0x28,0x44,0x54,0x54,0x38,0x7C,0x10
	.DB  0x38,0x44,0x38,0x48,0x54,0x34,0x14,0x7C
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x2003B:
	.DB  0x0,0x0,0x0,0x0,0x1,0x0
_0x20000:
	.DB  0xCF,0xD0,0xC8,0xC2,0xC5,0xD2,0x21,0x0
	.DB  0xC2,0xC2,0xC5,0xC4,0xC8,0xD2,0xC5,0x20
	.DB  0xCA,0xCE,0xC4,0x0,0x27,0x30,0x78,0x30
	.DB  0x42,0x27,0x20,0xD7,0xD2,0xCE,0xC1,0xDB
	.DB  0x0,0xCD,0xC0,0xD7,0xC0,0xD2,0xDC,0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x06
	.DW  0x06
	.DW  _0x2003B*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x400)
	LDI  R25,HIGH(0x400)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x45F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x45F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x160)
	LDI  R29,HIGH(0x160)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160

	.CSEG
;#include <mega8.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include "3310_routines.h"
;
;/*--------------------------------------------------------------------------------------------------
;                                     5x7 size character generator
;--------------------------------------------------------------------------------------------------*/
;flash unsigned char smallFont[] =
;{
;    0x00, 0x00, 0x00, 0x00, 0x00,   //   0x20  32
;    0x00, 0x00, 0x5F, 0x00, 0x00,   // ! 0x21  33
;    0x00, 0x07, 0x00, 0x07, 0x00,   // " 0x22  34
;    0x14, 0x7F, 0x14, 0x7F, 0x14,   // # 0x23  35
;    0x24, 0x2A, 0x7F, 0x2A, 0x12,   // $ 0x24  36
;    0x4C, 0x2C, 0x10, 0x68, 0x64,   // % 0x25  37
;    0x36, 0x49, 0x55, 0x22, 0x50,   // & 0x26  38
;    0x00, 0x05, 0x03, 0x00, 0x00,   // ' 0x27  39
;    0x00, 0x1C, 0x22, 0x41, 0x00,   // ( 0x28  40
;    0x00, 0x41, 0x22, 0x1C, 0x00,   // ) 0x29  41
;    0x14, 0x08, 0x3E, 0x08, 0x14,   // * 0x2A  42
;    0x08, 0x08, 0x3E, 0x08, 0x08,   // + 0x2B  43
;    0x00, 0x00, 0x50, 0x30, 0x00,   //   0x2C  44
;    0x10, 0x10, 0x10, 0x10, 0x10,   // - 0x2D  45
;    0x00, 0x60, 0x60, 0x00, 0x00,   // . 0x2E  46
;    0x20, 0x10, 0x08, 0x04, 0x02,   // / 0x2F  47
;    0x3E, 0x51, 0x49, 0x45, 0x3E,   // 0 0x30  48
;    0x00, 0x42, 0x7F, 0x40, 0x00,   // 1 0x31  49
;    0x42, 0x61, 0x51, 0x49, 0x46,   // 2 0x32  50
;    0x21, 0x41, 0x45, 0x4B, 0x31,   // 3 0x33  51
;    0x18, 0x14, 0x12, 0x7F, 0x10,   // 4 0x34  52
;    0x27, 0x45, 0x45, 0x45, 0x39,   // 5 0x35  53
;    0x3C, 0x4A, 0x49, 0x49, 0x30,   // 6 0x36  54
;    0x01, 0x71, 0x09, 0x05, 0x03,   // 7 0x37  55
;    0x36, 0x49, 0x49, 0x49, 0x36,   // 8 0x38  56
;    0x06, 0x49, 0x49, 0x29, 0x1E,   // 9 0x39  57
;    0x00, 0x36, 0x36, 0x00, 0x00,   // : 0x3A  58
;    0x00, 0x56, 0x36, 0x00, 0x00,   // ; 0x3B  59
;    0x08, 0x14, 0x22, 0x41, 0x00,   // < 0x3C  60
;    0x14, 0x14, 0x14, 0x14, 0x14,   // = 0x3D  61
;    0x00, 0x41, 0x22, 0x14, 0x08,   // > 0x3E  62
;    0x02, 0x01, 0x51, 0x09, 0x06,   // ? 0x3F  63
;    0x3C, 0x42, 0x5A, 0x56, 0x0C,   // @ 0x40  64
;    0x7E, 0x11, 0x11, 0x11, 0x7E,   // A 0x41  65
;    0x7F, 0x49, 0x49, 0x49, 0x36,   // B 0x42  66
;    0x3E, 0x41, 0x41, 0x41, 0x22,   // C 0x43  67
;    0x7F, 0x41, 0x41, 0x22, 0x1C,   // D 0x44  68
;    0x7F, 0x49, 0x49, 0x49, 0x41,   // E 0x45  69
;    0x7F, 0x09, 0x09, 0x09, 0x01,   // F 0x46  70
;    0x3E, 0x41, 0x49, 0x49, 0x7A,   // G 0x47  71
;    0x7F, 0x08, 0x08, 0x08, 0x7F,   // H 0x48  72
;    0x00, 0x41, 0x7F, 0x41, 0x00,   // I 0x49  73
;    0x20, 0x40, 0x41, 0x3F, 0x01,   // J 0x4A  74
;    0x7F, 0x08, 0x14, 0x22, 0x41,   // K 0x4B  75
;    0x7F, 0x40, 0x40, 0x40, 0x40,   // L 0x4C  76
;    0x7F, 0x02, 0x0C, 0x02, 0x7F,   // M 0x4D  77
;    0x7F, 0x04, 0x08, 0x10, 0x7F,   // N 0x4E  78
;    0x3E, 0x41, 0x41, 0x41, 0x3E,   // O 0x4F  79
;    0x7F, 0x09, 0x09, 0x09, 0x06,   // P 0x50  80
;    0x3E, 0x41, 0x51, 0x21, 0x5E,   // Q 0x51  81
;    0x7F, 0x09, 0x19, 0x29, 0x46,   // R 0x52  82
;    0x46, 0x49, 0x49, 0x49, 0x31,   // S 0x53  83
;    0x01, 0x01, 0x7F, 0x01, 0x01,   // T 0x54  84
;    0x3F, 0x40, 0x40, 0x40, 0x3F,   // U 0x55  85
;    0x1F, 0x20, 0x40, 0x20, 0x1F,   // V 0x56  86
;    0x3F, 0x40, 0x38, 0x40, 0x3F,   // W 0x57  87
;    0x63, 0x14, 0x08, 0x14, 0x63,   // X 0x58  88
;    0x07, 0x08, 0x70, 0x08, 0x07,   // Y 0x59  89
;    0x61, 0x51, 0x49, 0x45, 0x43,   // Z 0x5A  90
;    0x00, 0x7F, 0x41, 0x41, 0x00,   // [ 0x5B  91
;    0x02, 0x04, 0x08, 0x10, 0x20,   // \ 0x5C  92
;    0x00, 0x41, 0x41, 0x7F, 0x00,   // ] 0x5D  93
;    0x04, 0x02, 0x01, 0x02, 0x04,   // ^ 0x5E  94
;    0x40, 0x40, 0x40, 0x40, 0x40,   // _ 0x5F  95
;    0x00, 0x01, 0x02, 0x04, 0x00,   // ` 0x60  96
;    0x20, 0x54, 0x54, 0x54, 0x78,   // a 0x61  97
;    0x7F, 0x48, 0x44, 0x44, 0x38,   // b 0x62  98
;    0x38, 0x44, 0x44, 0x44, 0x20,   // c 0x63  99
;    0x38, 0x44, 0x44, 0x48, 0x7F,   // d 0x64 100
;    0x38, 0x54, 0x54, 0x54, 0x18,   // e 0x65 101
;    0x08, 0x7E, 0x09, 0x01, 0x02,   // f 0x66 102
;    0x0C, 0x52, 0x52, 0x52, 0x3E,   // g 0x67 103
;    0x7F, 0x08, 0x04, 0x04, 0x78,   // h 0x68 104
;    0x00, 0x44, 0x7D, 0x40, 0x00,   // i 0x69 105
;    0x20, 0x40, 0x44, 0x3D, 0x00,   // j 0x6A 106
;    0x7F, 0x10, 0x28, 0x44, 0x00,   // k 0x6B 107
;    0x00, 0x41, 0x7F, 0x40, 0x00,   // l 0x6C 108
;    0x7C, 0x04, 0x18, 0x04, 0x78,   // m 0x6D 109
;    0x7C, 0x08, 0x04, 0x04, 0x78,   // n 0x6E 110
;    0x38, 0x44, 0x44, 0x44, 0x38,   // o 0x6F 111
;    0x7C, 0x14, 0x14, 0x14, 0x08,   // p 0x70 112
;    0x08, 0x14, 0x14, 0x18, 0x7C,   // q 0x71 113
;    0x7C, 0x08, 0x04, 0x04, 0x08,   // r 0x72 114
;    0x48, 0x54, 0x54, 0x54, 0x20,   // s 0x73 115
;    0x04, 0x3F, 0x44, 0x40, 0x20,   // t 0x74 116
;    0x3C, 0x40, 0x40, 0x20, 0x7C,   // u 0x75 117
;    0x1C, 0x20, 0x40, 0x20, 0x1C,   // v 0x76 118
;    0x3C, 0x40, 0x30, 0x40, 0x3C,   // w 0x77 119
;    0x44, 0x28, 0x10, 0x28, 0x44,   // x 0x78 120
;    0x0C, 0x50, 0x50, 0x50, 0x3C,   // y 0x79 121
;    0x44, 0x64, 0x54, 0x4C, 0x44,   // z 0x7A 122
;    0x00, 0x08, 0x36, 0x41, 0x00,   //   0x7B 123
;    0x00, 0x00, 0x7F, 0x00, 0x00,   // | 0x7C 124
;    0x00, 0x41, 0x36, 0x08, 0x00,   //   0x7D 125
;    0x08, 0x04, 0x08, 0x10, 0x08,   // ~ 0x7E 126
;    0x00, 0x00, 0x00, 0x00, 0x00,   //   0x7F 127
;    0x00, 0x00, 0x00, 0x00, 0x00,   //   0x80 128
;    0x00, 0x00, 0x00, 0x00, 0x00,   //   0x81 129
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x82 130
;    0x00, 0x00, 0x00, 0x00, 0x00,   //   0x83 131
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x84 132
;    0x40, 0x00, 0x40, 0x00, 0x40,   //  0x85 133
;    0x04, 0x04, 0xFF, 0x04, 0x04,   //   0x86 134
;    0x24, 0x24, 0xFF, 0x24, 0x24,   //  0x87 135
;    0x28, 0x7C, 0xAA, 0xAA, 0x82,   //  0x88 136
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x89 137
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x8A 138
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x8B 139
;    0x00, 0x00, 0x18, 0x18, 0x00,   //  0x8C 140//LOADING DOT Small
;    0x00, 0x3C, 0x3C, 0x3C, 0x3C,   //  0x8D 141//LOADING DOT Big
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x8E 142
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x8F 143
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x90 144
;    0x00, 0x06, 0x05, 0x00, 0x00,   //  0x91 145
;    0x00, 0x00, 0x05, 0x03, 0x00,   //  0x92 146
;    0x06, 0x05, 0x00, 0x06, 0x05,   //  0x93 147
;    0x05, 0x03, 0x00, 0x05, 0x03,   //  0x94 148
;    0x18, 0x3C, 0x3C, 0x3C, 0x18,   //  0x95 149
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x96 150
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x97 151
;    0x78, 0x48, 0x48, 0x78, 0x00,   //   0x98 152
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x99 153
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9A 154
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9B 155
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9C 156
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9D 157
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9E 158
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0x9F 159
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xA0 160
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xA1 161
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xA2 162
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xA3 163
;    0x22, 0x1C, 0x14, 0x1C, 0x22,   //  0xA4 164
;    0x7E, 0x02, 0x02, 0x02, 0x03,   //  0xA5 165
;    0x00, 0x00, 0xE7, 0x00, 0x00,   //  0xA6 166
;    0x4A, 0x95, 0xA5, 0xA9, 0x52,   //  0xA7 167
;    0x7C, 0x55, 0x54, 0x45, 0x44,   //  0xA8 168
;    0x00, 0x18, 0x24, 0x24, 0x00,   //  0xA9 169
;    0x3E, 0x49, 0x49, 0x41, 0x22,   //  0xAA 170
;    0x08, 0x14, 0x2A, 0x14, 0x22,   //  0xAB 171
;    0x04, 0x04, 0x04, 0x04, 0x0C,   //  0xAC 172
;    0x00, 0x08, 0x08, 0x08, 0x00,   //  0xAD 173
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xAE 174
;    0x00, 0x45, 0x7C, 0x45, 0x00,   //  0xAF 175
;    0x00, 0x04, 0x0A, 0x04, 0x00,   //  0xB0 176
;    0x44, 0x44, 0x5F, 0x44, 0x44,   //  0xB1 177
;    0x00, 0x41, 0x7F, 0x41, 0x00,   //  0xB2 178
;    0x00, 0x00, 0x7A, 0x00, 0x00,   //  0xB3 179
;    0x00, 0x78, 0x08, 0x0C, 0x00,   //  0xB4 180
;    0x00, 0xFC, 0x20, 0x3C, 0x20,   //  0xB5 181
;    0x0C, 0x1E, 0xFE, 0x02, 0xFE,   //  0xB6 182
;    0x00, 0x18, 0x18, 0x00, 0x00,   //  0xB7 183
;    0x39, 0x54, 0x54, 0x49, 0x00,   //  0xB8 184
;    0x78, 0x10, 0x20, 0x7B, 0x03,   //  0xB9 185
;    0x38, 0x54, 0x54, 0x44, 0x00,   //  0xBA 186
;    0x22, 0x14, 0x2A, 0x14, 0x08,   //  0xBB 187
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xBC 188
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xBD 189
;    0x00, 0x00, 0x00, 0x00, 0x00,   //  0xBE 190
;    0x00, 0x54, 0x70, 0x44, 0x00,   //  0xBF 191
;    0x7C, 0x12, 0x11, 0x12, 0x7C,   //  0xC0 192
;    0x7F, 0x49, 0x49, 0x49, 0x31,   //  0xC1 193
;    0x7F, 0x49, 0x49, 0x49, 0x36,   //  0xC2 194
;    0x7F, 0x01, 0x01, 0x01, 0x01,   //  0xC3 195
;    0x60, 0x3F, 0x21, 0x3F, 0x60,   //  0xC4 196
;    0x7F, 0x49, 0x49, 0x49, 0x41,   //  0xC5 197
;    0x77, 0x08, 0x7F, 0x08, 0x77,   //  0xC6 198
;    0x22, 0x41, 0x49, 0x49, 0x36,   //  0xC7 199
;    0x7F, 0x10, 0x08, 0x04, 0x7F,   //  0xC8 200
;    0x7E, 0x10, 0x09, 0x04, 0x7E,   //  0xC9 201
;    0x7F, 0x08, 0x14, 0x22, 0x41,   //  0xCA 202
;    0x40, 0x3E, 0x01, 0x01, 0x7F,   //  0xCB 203
;    0x7F, 0x02, 0x0C, 0x02, 0x7F,   //  0xCC 204
;    0x7F, 0x08, 0x08, 0x08, 0x7F,   //  0xCD 205
;    0x3E, 0x41, 0x41, 0x41, 0x3E,   //  0xCE 206
;    0x7F, 0x01, 0x01, 0x01, 0x7F,   //  0xCF 207
;    0x7F, 0x09, 0x09, 0x09, 0x06,   //  0xD0 208
;    0x3E, 0x41, 0x41, 0x41, 0x22,   //  0xD1 209
;    0x01, 0x01, 0x7F, 0x01, 0x01,   //  0xD2 210
;    0x07, 0x48, 0x48, 0x48, 0x3F,   //  0xD3 211
;    0x0E, 0x11, 0x7F, 0x11, 0x0E,   //  0xD4 212
;    0x63, 0x14, 0x08, 0x14, 0x63,   //  0xD5 213
;    0x3F, 0x20, 0x20, 0x3F, 0x60,   //  0xD6 214
;    0x07, 0x08, 0x08, 0x08, 0x7F,   //  0xD7 215
;    0x7F, 0x40, 0x7E, 0x40, 0x7F,   //  0xD8 216
;    0x3F, 0x20, 0x3F, 0x20, 0x7F,   //  0xD9 217
;    0x01, 0x7F, 0x48, 0x48, 0x30,   //  0xDA 218
;    0x7F, 0x48, 0x30, 0x00, 0x7F,   //  0xDB 219
;    0x00, 0x7F, 0x48, 0x48, 0x30,   //  0xDC 220
;    0x22, 0x41, 0x49, 0x49, 0x3E,   //  0xDD 221
;    0x7F, 0x08, 0x3E, 0x41, 0x3E,   //  0xDE 222
;    0x46, 0x29, 0x19, 0x09, 0x7F,   //  0xDF 223
;    0x20, 0x54, 0x54, 0x54, 0x78,   //  0xE0 224
;    0x3C, 0x4A, 0x4A, 0x4A, 0x31,   //  0xE1 225
;    0x7C, 0x54, 0x54, 0x28, 0x00,   //  0xE2 226
;    0x7C, 0x04, 0x04, 0x0C, 0x00,   //  0xE3 227
;    0x60, 0x3C, 0x24, 0x3C, 0x60,   //  0xE4 228
;    0x38, 0x54, 0x54, 0x54, 0x18,   //  0xE5 229
;    0x6C, 0x10, 0x7C, 0x10, 0x6C,   //  0xE6 230
;    0x00, 0x44, 0x54, 0x54, 0x28,   //  0xE7 231
;    0x7C, 0x20, 0x10, 0x08, 0x7C,   //  0xE8 232
;    0x7C, 0x21, 0x12, 0x09, 0x7C,   //  0xE9 233
;    0x7C, 0x10, 0x28, 0x44, 0x00,   //  0xEA 234
;    0x40, 0x38, 0x04, 0x04, 0x7C,   //  0xEB 235
;    0x7C, 0x08, 0x10, 0x08, 0x7C,   //  0xEC 236
;    0x7C, 0x10, 0x10, 0x10, 0x7C,   //  0xED 237
;    0x38, 0x44, 0x44, 0x44, 0x38,   //  0xEE 238
;    0x7C, 0x04, 0x04, 0x04, 0x7C,   //  0xEF 239
;    0x7C, 0x14, 0x14, 0x14, 0x08,   //  0xF0 240
;    0x38, 0x44, 0x44, 0x44, 0x00,   //  0xF1 241
;    0x04, 0x04, 0x7C, 0x04, 0x04,   //  0xF2 242
;    0x0C, 0x50, 0x50, 0x50, 0x3C,   //  0xF3 243
;    0x08, 0x14, 0x7C, 0x14, 0x08,   //  0xF4 244
;    0x44, 0x28, 0x10, 0x28, 0x44,   //  0xF5 245
;    0x3C, 0x20, 0x20, 0x3C, 0x60,   //  0xF6 246
;    0x0C, 0x10, 0x10, 0x10, 0x7C,   //  0xF7 247
;    0x7C, 0x40, 0x7C, 0x40, 0x7C,   //  0xF8 248
;    0x3C, 0x20, 0x3C, 0x20, 0x7C,   //  0xF9 249
;    0x04, 0x7C, 0x50, 0x50, 0x20,   //  0xFA 250
;    0x7C, 0x50, 0x20, 0x00, 0x7C,   //  0xFB 251
;    0x00, 0x7C, 0x50, 0x50, 0x20,   //  0xFC 252
;    0x28, 0x44, 0x54, 0x54, 0x38,   //  0xFD 253
;    0x7C, 0x10, 0x38, 0x44, 0x38,   //  0xFE 254
;    0x48, 0x54, 0x34, 0x14, 0x7C    //  0xFF 255
;};
;
;void LCD_init ( void )
; 0000 00ED {

	.CSEG
_LCD_init:
; 0000 00EE 
; 0000 00EF 	delay_ms(100);
	RCALL SUBOPT_0x0
; 0000 00F0 
; 0000 00F1 	CLEAR_SCE_PIN;    //Enable LCD
	CBI  0x18,2
; 0000 00F2 
; 0000 00F3 	CLEAR_RST_PIN;	//reset LCD
	SBI  0x18,4
; 0000 00F4     delay_ms(100);
	RCALL SUBOPT_0x0
; 0000 00F5     SET_RST_PIN;
	SBI  0x18,4
; 0000 00F6 
; 0000 00F7 	SET_SCE_PIN;	//disable LCD
	SBI  0x18,2
; 0000 00F8 
; 0000 00F9     LCD_writeCommand( 0x21 );  // LCD Extended Commands.
	LDI  R30,LOW(33)
	RCALL SUBOPT_0x1
; 0000 00FA     LCD_writeCommand( 0xE0 );  // Set LCD Vop (Contrast).
	LDI  R30,LOW(224)
	RCALL SUBOPT_0x1
; 0000 00FB     LCD_writeCommand( 0x04 );  // Set Temp coefficent.
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x1
; 0000 00FC     LCD_writeCommand( 0x13 );  // LCD bias mode 1:48.
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x1
; 0000 00FD     LCD_writeCommand( 0x20 );  // LCD Standard Commands, Horizontal addressing mode.
	LDI  R30,LOW(32)
	RCALL SUBOPT_0x1
; 0000 00FE     LCD_writeCommand( 0x0c );  // LCD in normal mode.
	LDI  R30,LOW(12)
	RCALL SUBOPT_0x1
; 0000 00FF 
; 0000 0100     LCD_clear();
	RCALL _LCD_clear
; 0000 0101 }
	RET
;
;void LCD_writeCommand ( unsigned char command )
; 0000 0104 {
_LCD_writeCommand:
; 0000 0105     CLEAR_SCE_PIN;	  //enable LCD
;	command -> Y+0
	CBI  0x18,2
; 0000 0106 
; 0000 0107 	CLEAR_DC_PIN;	  //set LCD in command mode
	CBI  0x18,0
; 0000 0108 
; 0000 0109     //  Send data to display controller.
; 0000 010A     SPDR = command;
	LD   R30,Y
	OUT  0xF,R30
; 0000 010B 
; 0000 010C     //  Wait until Tx register empty.
; 0000 010D     while ( !(SPSR & 0x80) );
_0x3:
	SBIS 0xE,7
	RJMP _0x3
; 0000 010E 
; 0000 010F     SET_SCE_PIN;   	 //disable LCD
	SBI  0x18,2
; 0000 0110 }
	RJMP _0x2060001
;
;void LCD_writeData ( unsigned char Data )
; 0000 0113 {
_LCD_writeData:
; 0000 0114     CLEAR_SCE_PIN;	  //enable LCD
;	Data -> Y+0
	CBI  0x18,2
; 0000 0115 
; 0000 0116 	SET_DC_PIN;	  //set LCD in Data mode
	SBI  0x18,0
; 0000 0117 
; 0000 0118     //  Send data to display controller.
; 0000 0119     SPDR = Data;
	LD   R30,Y
	OUT  0xF,R30
; 0000 011A 
; 0000 011B     //  Wait until Tx register empty.
; 0000 011C     while ( !(SPSR & 0x80) );
_0x6:
	SBIS 0xE,7
	RJMP _0x6
; 0000 011D 
; 0000 011E     SET_SCE_PIN;   	 //disable LCD
	SBI  0x18,2
; 0000 011F }
	RJMP _0x2060001
;
;void LCD_clear ( void )
; 0000 0122 {
_LCD_clear:
; 0000 0123     int i,j;
; 0000 0124 
; 0000 0125 	LCD_gotoXY (0,0);  	//start with (0,0) position
	RCALL __SAVELOCR4
;	i -> R16,R17
;	j -> R18,R19
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x2
	RCALL _LCD_gotoXY
; 0000 0126 
; 0000 0127     for(i=0; i<8; i++)
	__GETWRN 16,17,0
_0xA:
	__CPWRN 16,17,8
	BRGE _0xB
; 0000 0128 	  for(j=0; j<90; j++)
	__GETWRN 18,19,0
_0xD:
	__CPWRN 18,19,90
	BRGE _0xE
; 0000 0129 	     LCD_writeData( 0x00 );
	RCALL SUBOPT_0x2
	RCALL _LCD_writeData
	__ADDWRN 18,19,1
	RJMP _0xD
_0xE:
; 0000 012B LCD_gotoXY (0,1);
	__ADDWRN 16,17,1
	RJMP _0xA
_0xB:
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
; 0000 012C }
	RCALL __LOADLOCR4
	ADIW R28,4
	RET
;
;void LCD_gotoXY ( unsigned char x, unsigned char y )
; 0000 012F {
_LCD_gotoXY:
; 0000 0130     LCD_writeCommand (0x80 | x);   //column
;	x -> Y+1
;	y -> Y+0
	LDD  R30,Y+1
	ORI  R30,0x80
	RCALL SUBOPT_0x1
; 0000 0131 	LCD_writeCommand (0x40 | y);   //row
	LD   R30,Y
	ORI  R30,0x40
	RCALL SUBOPT_0x1
; 0000 0132 }
	RJMP _0x2060002
;
;void LCD_writeChar ( unsigned char ch)
; 0000 0135 {
_LCD_writeChar:
; 0000 0136    unsigned char j;
; 0000 0137    for(j=0; j<5; j++)
	ST   -Y,R17
;	ch -> Y+1
;	j -> R17
	LDI  R17,LOW(0)
_0x10:
	CPI  R17,5
	BRSH _0x11
; 0000 0138      LCD_writeData( smallFont [(unsigned int)(ch-32)*5 + j] );
	LDD  R30,Y+1
	SUBI R30,LOW(32)
	LDI  R26,LOW(5)
	MUL  R30,R26
	MOVW R30,R0
	MOVW R26,R30
	MOV  R30,R17
	RCALL SUBOPT_0x4
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_smallFont*2)
	SBCI R31,HIGH(-_smallFont*2)
	LPM  R30,Z
	ST   -Y,R30
	RCALL _LCD_writeData
	SUBI R17,-1
	RJMP _0x10
_0x11:
; 0000 013A LCD_writeData( 0x00 );
	RCALL SUBOPT_0x2
	RCALL _LCD_writeData
; 0000 013B }
	LDD  R17,Y+0
	RJMP _0x2060002
;
;void LCD_writeString_F ( flash unsigned char *string )
; 0000 013E {
_LCD_writeString_F:
; 0000 013F     while ( *string )
;	*string -> Y+0
_0x12:
	LD   R30,Y
	LDD  R31,Y+1
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x14
; 0000 0140         LCD_writeChar( *string++ );
	LD   R30,Y
	LDD  R31,Y+1
	ADIW R30,1
	ST   Y,R30
	STD  Y+1,R31
	SBIW R30,1
	LPM  R30,Z
	ST   -Y,R30
	RCALL _LCD_writeChar
	RJMP _0x12
_0x14:
; 0000 0141 }
_0x2060002:
	ADIW R28,2
	RET
;#include <mega8.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include "3310_routines.h"
;#include <stdio.h>
;
;char CACHECHAR;
;int PROJECTORMODE = 0; //0x01-CHAR //0x02-E
;//int PROJECTORPAGE = 0; //0x03-0PAGE //0x04-1PAGE //0x05-2PAGE //0x06-3PAGE //0x07-4PAGE //0x08-5PAGE
;int PROJECTORENAB = 0;
;int CACHECOUNTER = 1;
;
;/* PROJECTOR COMMANDS
;|0x01   |   CHARMODE        |
;|0x02   |   EMODE           |
;|0x03   |   0PAGE           |
;|0x04   |   1PAGE           |
;|0x05   |   2PAGE           |
;|0x06   |   3PAGE           |
;|0x07   |   4PAGE           |
;|0x08   |   5PAGE           |
;|0x09   |   CLEARSCR        |
;|0x0A   |   ON              |
;*/
;//////////////////////////////////////////////////////////////
;#ifndef RXB8
;#define RXB8 1
;#endif
;
;#ifndef TXB8
;#define TXB8 0
;#endif
;
;#ifndef UPE
;#define UPE 2
;#endif
;
;#ifndef DOR
;#define DOR 3
;#endif
;
;#ifndef FE
;#define FE 4
;#endif
;
;#ifndef UDRE
;#define UDRE 5
;#endif
;
;#ifndef RXC
;#define RXC 7
;#endif
;
;#define FRAMING_ERROR (1<<FE)
;#define PARITY_ERROR (1<<UPE)
;#define DATA_OVERRUN (1<<DOR)
;#define DATA_REGISTER_EMPTY (1<<UDRE)
;#define RX_COMPLETE (1<<RXC)
;
;#define RX_BUFFER_SIZE 8
;char rx_buffer[RX_BUFFER_SIZE];
;
;#if RX_BUFFER_SIZE<256
;unsigned char rx_wr_index,rx_rd_index,rx_counter;
;#else
;unsigned int rx_wr_index,rx_rd_index,rx_counter;
;#endif
;bit rx_buffer_overflow;
;interrupt [USART_RXC] void usart_rx_isr(void)
; 0001 0045 {

	.CSEG
_usart_rx_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0001 0046 char status,data;
; 0001 0047 status=UCSRA;
	RCALL __SAVELOCR2
;	status -> R17
;	data -> R16
	IN   R17,11
; 0001 0048 data=UDR;
	IN   R16,12
; 0001 0049 if ((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN))==0)
	MOV  R30,R17
	ANDI R30,LOW(0x1C)
	BRNE _0x20003
; 0001 004A    {
; 0001 004B    rx_buffer[rx_wr_index]=data;
	MOV  R30,R4
	RCALL SUBOPT_0x4
	SUBI R30,LOW(-_rx_buffer)
	SBCI R31,HIGH(-_rx_buffer)
	ST   Z,R16
; 0001 004C    if (++rx_wr_index == RX_BUFFER_SIZE) rx_wr_index=0;
	INC  R4
	LDI  R30,LOW(8)
	CP   R30,R4
	BRNE _0x20004
	CLR  R4
; 0001 004D    if (++rx_counter == RX_BUFFER_SIZE)
_0x20004:
	INC  R12
	LDI  R30,LOW(8)
	CP   R30,R12
	BRNE _0x20005
; 0001 004E       {
; 0001 004F       rx_counter=0;
	CLR  R12
; 0001 0050       rx_buffer_overflow=1;
	SET
	BLD  R2,0
; 0001 0051       };
_0x20005:
; 0001 0052    };
_0x20003:
; 0001 0053 }
	RCALL __LOADLOCR2P
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;#ifndef _DEBUG_TERMINAL_IO_
;#define _ALTERNATE_GETCHAR_
;#pragma used+
;char getchar(void)
; 0001 0059 {
_getchar:
; 0001 005A char data;
; 0001 005B while (rx_counter==0);
	ST   -Y,R17
;	data -> R17
_0x20006:
	TST  R12
	BREQ _0x20006
; 0001 005C data=rx_buffer[rx_rd_index];
	MOV  R30,R13
	RCALL SUBOPT_0x4
	SUBI R30,LOW(-_rx_buffer)
	SBCI R31,HIGH(-_rx_buffer)
	LD   R17,Z
; 0001 005D if (++rx_rd_index == RX_BUFFER_SIZE) rx_rd_index=0;
	INC  R13
	LDI  R30,LOW(8)
	CP   R30,R13
	BRNE _0x20009
	CLR  R13
; 0001 005E #asm("cli")
_0x20009:
	cli
; 0001 005F --rx_counter;
	DEC  R12
; 0001 0060 #asm("sei")
	sei
; 0001 0061 return data;
	MOV  R30,R17
	LD   R17,Y+
	RET
; 0001 0062 }
;#pragma used-
;#endif
;//////////////////////////////////////////////////////////////
;
;void main(void) {
; 0001 0067 void main(void) {
_main:
; 0001 0068 
; 0001 0069 PORTB = 0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0001 006A DDRB  = 0x3F;
	LDI  R30,LOW(63)
	OUT  0x17,R30
; 0001 006B PORTC = 0x00;
	LDI  R30,LOW(0)
	OUT  0x15,R30
; 0001 006C DDRC  = 0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
; 0001 006D PORTD = 0x00;
	LDI  R30,LOW(0)
	OUT  0x12,R30
; 0001 006E DDRD  = 0x00;
	OUT  0x11,R30
; 0001 006F 
; 0001 0070 SPCR = 0x58;
	LDI  R30,LOW(88)
	OUT  0xD,R30
; 0001 0071 
; 0001 0072 TWCR= 0X00;
	LDI  R30,LOW(0)
	OUT  0x36,R30
; 0001 0073 TWBR= 0x02;
	LDI  R30,LOW(2)
	OUT  0x0,R30
; 0001 0074 TWSR= 0x00;
	LDI  R30,LOW(0)
	OUT  0x1,R30
; 0001 0075 TWAR= 0x00;
	OUT  0x2,R30
; 0001 0076 TWCR= 0x44;
	LDI  R30,LOW(68)
	OUT  0x36,R30
; 0001 0077 
; 0001 0078 MCUCR = 0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
; 0001 0079 GICR  = 0x00;
	OUT  0x3B,R30
; 0001 007A 
; 0001 007B TIMSK = 0x00;
	OUT  0x39,R30
; 0001 007C 
; 0001 007D UCSRA=0x00;
	OUT  0xB,R30
; 0001 007E UCSRB=0x98;
	LDI  R30,LOW(152)
	OUT  0xA,R30
; 0001 007F UCSRC=0x86;
	LDI  R30,LOW(134)
	OUT  0x20,R30
; 0001 0080 UBRRH=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
; 0001 0081 UBRRL=0x19;
	LDI  R30,LOW(25)
	OUT  0x9,R30
; 0001 0082 
; 0001 0083 
; 0001 0084 delay_ms(100);
	RCALL SUBOPT_0x0
; 0001 0085 PORTB.1 = 0xFF;
	SBI  0x18,1
; 0001 0086 LCD_init();
	RCALL _LCD_init
; 0001 0087 delay_ms(100);
	RCALL SUBOPT_0x0
; 0001 0088 
; 0001 0089 LCD_gotoXY (6,0); LCD_writeString_F("!");
	RCALL SUBOPT_0x5
	RCALL SUBOPT_0x2
	RCALL _LCD_gotoXY
	__POINTW1FN _0x20000,0
	RCALL SUBOPT_0x6
; 0001 008A LCD_gotoXY (6,1); LCD_writeString_F(" ");
	RCALL SUBOPT_0x3
	__POINTW1FN _0x20000,8
	RCALL SUBOPT_0x6
; 0001 008B LCD_gotoXY (6,2); LCD_writeString_F("'0x0B' ");
	LDI  R30,LOW(2)
	RCALL SUBOPT_0x7
	__POINTW1FN _0x20000,20
	RCALL SUBOPT_0x6
; 0001 008C LCD_gotoXY (6,3); LCD_writeString_F("");
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x7
	__POINTW1FN _0x20000,33
	ST   -Y,R31
	ST   -Y,R30
	RCALL _LCD_writeString_F
; 0001 008D 
; 0001 008E #asm("sei")
	sei
; 0001 008F 
; 0001 0090 while(1) {
_0x2000C:
; 0001 0091         CACHECHAR = getchar();
	RCALL _getchar
	MOV  R5,R30
; 0001 0092         switch ( CACHECHAR ) {
	MOV  R30,R5
; 0001 0093             case 0x01: if (PROJECTORMODE == 0) {PROJECTORMODE = 0;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; //CHAR MODE
	CPI  R30,LOW(0x1)
	BRNE _0x20012
	RCALL SUBOPT_0x8
	BRNE _0x20013
	CLR  R6
	CLR  R7
	RJMP _0x20014
_0x20013:
	RCALL SUBOPT_0x9
_0x20014:
	RJMP _0x20011
; 0001 0094             case 0x02: if (PROJECTORMODE == 0) {PROJECTORMODE = 1; LCD_gotoXY (0,0);}       else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break; //E MODE
_0x20012:
	CPI  R30,LOW(0x2)
	BRNE _0x20015
	RCALL SUBOPT_0x8
	BRNE _0x20016
	RCALL SUBOPT_0xA
	MOVW R6,R30
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x2
	RCALL _LCD_gotoXY
	RJMP _0x20017
_0x20016:
	RCALL SUBOPT_0x9
_0x20017:
	RJMP _0x20011
; 0001 0095             case 0x03: if (PROJECTORMODE == 0) {LCD_gotoXY (0,0);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x20015:
	CPI  R30,LOW(0x3)
	BRNE _0x20018
	RCALL SUBOPT_0x8
	BRNE _0x20019
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x2
	RCALL _LCD_gotoXY
	RJMP _0x2001A
_0x20019:
	RCALL SUBOPT_0x9
_0x2001A:
	RJMP _0x20011
; 0001 0096             case 0x04: if (PROJECTORMODE == 0) {LCD_gotoXY (0,1);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x20018:
	CPI  R30,LOW(0x4)
	BRNE _0x2001B
	RCALL SUBOPT_0x8
	BRNE _0x2001C
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	RJMP _0x2001D
_0x2001C:
	RCALL SUBOPT_0x9
_0x2001D:
	RJMP _0x20011
; 0001 0097             case 0x05: if (PROJECTORMODE == 0) {LCD_gotoXY (0,2);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x2001B:
	CPI  R30,LOW(0x5)
	BRNE _0x2001E
	RCALL SUBOPT_0x8
	BRNE _0x2001F
	RCALL SUBOPT_0x2
	LDI  R30,LOW(2)
	RCALL SUBOPT_0x7
	RJMP _0x20020
_0x2001F:
	RCALL SUBOPT_0x9
_0x20020:
	RJMP _0x20011
; 0001 0098             case 0x06: if (PROJECTORMODE == 0) {LCD_gotoXY (0,3);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x2001E:
	CPI  R30,LOW(0x6)
	BRNE _0x20021
	RCALL SUBOPT_0x8
	BRNE _0x20022
	RCALL SUBOPT_0x2
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x7
	RJMP _0x20023
_0x20022:
	RCALL SUBOPT_0x9
_0x20023:
	RJMP _0x20011
; 0001 0099             case 0x07: if (PROJECTORMODE == 0) {LCD_gotoXY (0,4);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x20021:
	CPI  R30,LOW(0x7)
	BRNE _0x20024
	RCALL SUBOPT_0x8
	BRNE _0x20025
	RCALL SUBOPT_0x2
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x7
	RJMP _0x20026
_0x20025:
	RCALL SUBOPT_0x9
_0x20026:
	RJMP _0x20011
; 0001 009A             case 0x08: if (PROJECTORMODE == 0) {LCD_gotoXY (0,5);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x20024:
	CPI  R30,LOW(0x8)
	BRNE _0x20027
	RCALL SUBOPT_0x8
	BRNE _0x20028
	RCALL SUBOPT_0x2
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x7
	RJMP _0x20029
_0x20028:
	RCALL SUBOPT_0x9
_0x20029:
	RJMP _0x20011
; 0001 009B             case 0x0A: if (PROJECTORMODE == 0) {LCD_gotoXY (0,6);}                          else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x20027:
	CPI  R30,LOW(0xA)
	BRNE _0x2002A
	RCALL SUBOPT_0x8
	BRNE _0x2002B
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x5
	RCALL _LCD_gotoXY
	RJMP _0x2002C
_0x2002B:
	RCALL SUBOPT_0x9
_0x2002C:
	RJMP _0x20011
; 0001 009C             case 0x0B: if (PROJECTORMODE == 0) {PROJECTORENAB = 1;}                         else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x2002A:
	CPI  R30,LOW(0xB)
	BRNE _0x2002D
	RCALL SUBOPT_0x8
	BRNE _0x2002E
	RCALL SUBOPT_0xA
	MOVW R8,R30
	RJMP _0x2002F
_0x2002E:
	RCALL SUBOPT_0x9
_0x2002F:
	RJMP _0x20011
; 0001 009D             case 0x09: if (PROJECTORMODE == 0) { if (PROJECTORENAB == 1) { LCD_clear(); }}  else { LCD_writeData(CACHECHAR); CACHECOUNTER++;} break;
_0x2002D:
	CPI  R30,LOW(0x9)
	BRNE _0x20034
	RCALL SUBOPT_0x8
	BRNE _0x20031
	RCALL SUBOPT_0xA
	CP   R30,R8
	CPC  R31,R9
	BRNE _0x20032
	RCALL _LCD_clear
_0x20032:
	RJMP _0x20033
_0x20031:
	RCALL SUBOPT_0x9
_0x20033:
	RJMP _0x20011
; 0001 009E             default:
_0x20034:
; 0001 009F             if (PROJECTORENAB == 1) {
	RCALL SUBOPT_0xA
	CP   R30,R8
	CPC  R31,R9
	BRNE _0x20035
; 0001 00A0                 if (PROJECTORMODE == 0) { putchar(CACHECHAR); LCD_writeChar(CACHECHAR); break; }
	RCALL SUBOPT_0x8
	BRNE _0x20036
	ST   -Y,R5
	RCALL _putchar
	ST   -Y,R5
	RCALL _LCD_writeChar
	RJMP _0x20011
; 0001 00A1                 if (PROJECTORMODE == 1) {
_0x20036:
	RCALL SUBOPT_0xA
	CP   R30,R6
	CPC  R31,R7
	BRNE _0x20037
; 0001 00A2                     if (CACHECOUNTER < 503) {
	LDI  R30,LOW(503)
	LDI  R31,HIGH(503)
	CP   R10,R30
	CPC  R11,R31
	BRGE _0x20038
; 0001 00A3                     CACHECOUNTER++;
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
; 0001 00A4                     LCD_writeData(CACHECHAR);
	ST   -Y,R5
	RCALL _LCD_writeData
; 0001 00A5                     }
; 0001 00A6                     else { CACHECOUNTER = 1; PROJECTORMODE = 0;  break; }}
	RJMP _0x20039
_0x20038:
	RCALL SUBOPT_0xA
	MOVW R10,R30
	CLR  R6
	CLR  R7
_0x20039:
; 0001 00A7             }
_0x20037:
; 0001 00A8 } } }
_0x20035:
_0x20011:
	RJMP _0x2000C
_0x2003A:
	RJMP _0x2003A
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_putchar:
putchar0:
     sbis usr,udre
     rjmp putchar0
     ld   r30,y
     out  udr,r30
_0x2060001:
	ADIW R28,1
	RET

	.CSEG

	.CSEG

	.DSEG
_rx_buffer:
	.BYTE 0x8

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x0:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1:
	ST   -Y,R30
	RJMP _LCD_writeCommand

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x2:
	LDI  R30,LOW(0)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDI  R30,LOW(1)
	ST   -Y,R30
	RJMP _LCD_gotoXY

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4:
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(6)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x6:
	ST   -Y,R31
	ST   -Y,R30
	RCALL _LCD_writeString_F
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7:
	ST   -Y,R30
	RJMP _LCD_gotoXY

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x8:
	MOV  R0,R6
	OR   R0,R7
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:38 WORDS
SUBOPT_0x9:
	ST   -Y,R5
	RCALL _LCD_writeData
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xA:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__LOADLOCR2P:
	LD   R16,Y+
	LD   R17,Y+
	RET

;END OF CODE MARKER
__END_OF_CODE:
