
#pragma used+
sfrb TWBR=0;
sfrb TWSR=1;
sfrb TWAR=2;
sfrb TWDR=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRRL=9;
sfrb UCSRB=0xa;
sfrb UCSRA=0xb;
sfrb UDR=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   
sfrb UBRRH=0x20;
sfrb UCSRC=0X20;
sfrb WDTCR=0x21;
sfrb ASSR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb SFIOR=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TWCR=0x36;
sfrb SPMCR=0x37;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a;
sfrb GICR=0x3b;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

void LCD_init ( void );
void LCD_clear ( void );
void LCD_gotoXY ( unsigned char x, unsigned char );
void LCD_writeChar ( unsigned char );
void LCD_writeData ( unsigned char );
void LCD_writeCommand ( unsigned char );
void LCD_writeString_F ( flash unsigned char*);

flash unsigned char smallFont[] =
{
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x5F, 0x00, 0x00,   
0x00, 0x07, 0x00, 0x07, 0x00,   
0x14, 0x7F, 0x14, 0x7F, 0x14,   
0x24, 0x2A, 0x7F, 0x2A, 0x12,   
0x4C, 0x2C, 0x10, 0x68, 0x64,   
0x36, 0x49, 0x55, 0x22, 0x50,   
0x00, 0x05, 0x03, 0x00, 0x00,   
0x00, 0x1C, 0x22, 0x41, 0x00,   
0x00, 0x41, 0x22, 0x1C, 0x00,   
0x14, 0x08, 0x3E, 0x08, 0x14,   
0x08, 0x08, 0x3E, 0x08, 0x08,   
0x00, 0x00, 0x50, 0x30, 0x00,   
0x10, 0x10, 0x10, 0x10, 0x10,   
0x00, 0x60, 0x60, 0x00, 0x00,   
0x20, 0x10, 0x08, 0x04, 0x02,   
0x3E, 0x51, 0x49, 0x45, 0x3E,   
0x00, 0x42, 0x7F, 0x40, 0x00,   
0x42, 0x61, 0x51, 0x49, 0x46,   
0x21, 0x41, 0x45, 0x4B, 0x31,   
0x18, 0x14, 0x12, 0x7F, 0x10,   
0x27, 0x45, 0x45, 0x45, 0x39,   
0x3C, 0x4A, 0x49, 0x49, 0x30,   
0x01, 0x71, 0x09, 0x05, 0x03,   
0x36, 0x49, 0x49, 0x49, 0x36,   
0x06, 0x49, 0x49, 0x29, 0x1E,   
0x00, 0x36, 0x36, 0x00, 0x00,   
0x00, 0x56, 0x36, 0x00, 0x00,   
0x08, 0x14, 0x22, 0x41, 0x00,   
0x14, 0x14, 0x14, 0x14, 0x14,   
0x00, 0x41, 0x22, 0x14, 0x08,   
0x02, 0x01, 0x51, 0x09, 0x06,   
0x3C, 0x42, 0x5A, 0x56, 0x0C,   
0x7E, 0x11, 0x11, 0x11, 0x7E,   
0x7F, 0x49, 0x49, 0x49, 0x36,   
0x3E, 0x41, 0x41, 0x41, 0x22,   
0x7F, 0x41, 0x41, 0x22, 0x1C,   
0x7F, 0x49, 0x49, 0x49, 0x41,   
0x7F, 0x09, 0x09, 0x09, 0x01,   
0x3E, 0x41, 0x49, 0x49, 0x7A,   
0x7F, 0x08, 0x08, 0x08, 0x7F,   
0x00, 0x41, 0x7F, 0x41, 0x00,   
0x20, 0x40, 0x41, 0x3F, 0x01,   
0x7F, 0x08, 0x14, 0x22, 0x41,   
0x7F, 0x40, 0x40, 0x40, 0x40,   
0x7F, 0x02, 0x0C, 0x02, 0x7F,   
0x7F, 0x04, 0x08, 0x10, 0x7F,   
0x3E, 0x41, 0x41, 0x41, 0x3E,   
0x7F, 0x09, 0x09, 0x09, 0x06,   
0x3E, 0x41, 0x51, 0x21, 0x5E,   
0x7F, 0x09, 0x19, 0x29, 0x46,   
0x46, 0x49, 0x49, 0x49, 0x31,   
0x01, 0x01, 0x7F, 0x01, 0x01,   
0x3F, 0x40, 0x40, 0x40, 0x3F,   
0x1F, 0x20, 0x40, 0x20, 0x1F,   
0x3F, 0x40, 0x38, 0x40, 0x3F,   
0x63, 0x14, 0x08, 0x14, 0x63,   
0x07, 0x08, 0x70, 0x08, 0x07,   
0x61, 0x51, 0x49, 0x45, 0x43,   
0x00, 0x7F, 0x41, 0x41, 0x00,   
0x02, 0x04, 0x08, 0x10, 0x20,   
0x00, 0x41, 0x41, 0x7F, 0x00,   
0x04, 0x02, 0x01, 0x02, 0x04,   
0x40, 0x40, 0x40, 0x40, 0x40,   
0x00, 0x01, 0x02, 0x04, 0x00,   
0x20, 0x54, 0x54, 0x54, 0x78,   
0x7F, 0x48, 0x44, 0x44, 0x38,   
0x38, 0x44, 0x44, 0x44, 0x20,   
0x38, 0x44, 0x44, 0x48, 0x7F,   
0x38, 0x54, 0x54, 0x54, 0x18,   
0x08, 0x7E, 0x09, 0x01, 0x02,   
0x0C, 0x52, 0x52, 0x52, 0x3E,   
0x7F, 0x08, 0x04, 0x04, 0x78,   
0x00, 0x44, 0x7D, 0x40, 0x00,   
0x20, 0x40, 0x44, 0x3D, 0x00,   
0x7F, 0x10, 0x28, 0x44, 0x00,   
0x00, 0x41, 0x7F, 0x40, 0x00,   
0x7C, 0x04, 0x18, 0x04, 0x78,   
0x7C, 0x08, 0x04, 0x04, 0x78,   
0x38, 0x44, 0x44, 0x44, 0x38,   
0x7C, 0x14, 0x14, 0x14, 0x08,   
0x08, 0x14, 0x14, 0x18, 0x7C,   
0x7C, 0x08, 0x04, 0x04, 0x08,   
0x48, 0x54, 0x54, 0x54, 0x20,   
0x04, 0x3F, 0x44, 0x40, 0x20,   
0x3C, 0x40, 0x40, 0x20, 0x7C,   
0x1C, 0x20, 0x40, 0x20, 0x1C,   
0x3C, 0x40, 0x30, 0x40, 0x3C,   
0x44, 0x28, 0x10, 0x28, 0x44,   
0x0C, 0x50, 0x50, 0x50, 0x3C,   
0x44, 0x64, 0x54, 0x4C, 0x44,   
0x00, 0x08, 0x36, 0x41, 0x00,   
0x00, 0x00, 0x7F, 0x00, 0x00,   
0x00, 0x41, 0x36, 0x08, 0x00,   
0x08, 0x04, 0x08, 0x10, 0x08,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x40, 0x00, 0x40, 0x00, 0x40,   
0x04, 0x04, 0xFF, 0x04, 0x04,   
0x24, 0x24, 0xFF, 0x24, 0x24,   
0x28, 0x7C, 0xAA, 0xAA, 0x82,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x18, 0x18, 0x00,   
0x00, 0x3C, 0x3C, 0x3C, 0x3C,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x06, 0x05, 0x00, 0x00,   
0x00, 0x00, 0x05, 0x03, 0x00,   
0x06, 0x05, 0x00, 0x06, 0x05,   
0x05, 0x03, 0x00, 0x05, 0x03,   
0x18, 0x3C, 0x3C, 0x3C, 0x18,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x78, 0x48, 0x48, 0x78, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x22, 0x1C, 0x14, 0x1C, 0x22,   
0x7E, 0x02, 0x02, 0x02, 0x03,   
0x00, 0x00, 0xE7, 0x00, 0x00,   
0x4A, 0x95, 0xA5, 0xA9, 0x52,   
0x7C, 0x55, 0x54, 0x45, 0x44,   
0x00, 0x18, 0x24, 0x24, 0x00,   
0x3E, 0x49, 0x49, 0x41, 0x22,   
0x08, 0x14, 0x2A, 0x14, 0x22,   
0x04, 0x04, 0x04, 0x04, 0x0C,   
0x00, 0x08, 0x08, 0x08, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x45, 0x7C, 0x45, 0x00,   
0x00, 0x04, 0x0A, 0x04, 0x00,   
0x44, 0x44, 0x5F, 0x44, 0x44,   
0x00, 0x41, 0x7F, 0x41, 0x00,   
0x00, 0x00, 0x7A, 0x00, 0x00,   
0x00, 0x78, 0x08, 0x0C, 0x00,   
0x00, 0xFC, 0x20, 0x3C, 0x20,   
0x0C, 0x1E, 0xFE, 0x02, 0xFE,   
0x00, 0x18, 0x18, 0x00, 0x00,   
0x39, 0x54, 0x54, 0x49, 0x00,   
0x78, 0x10, 0x20, 0x7B, 0x03,   
0x38, 0x54, 0x54, 0x44, 0x00,   
0x22, 0x14, 0x2A, 0x14, 0x08,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x00, 0x00, 0x00, 0x00,   
0x00, 0x54, 0x70, 0x44, 0x00,   
0x7C, 0x12, 0x11, 0x12, 0x7C,   
0x7F, 0x49, 0x49, 0x49, 0x31,   
0x7F, 0x49, 0x49, 0x49, 0x36,   
0x7F, 0x01, 0x01, 0x01, 0x01,   
0x60, 0x3F, 0x21, 0x3F, 0x60,   
0x7F, 0x49, 0x49, 0x49, 0x41,   
0x77, 0x08, 0x7F, 0x08, 0x77,   
0x22, 0x41, 0x49, 0x49, 0x36,   
0x7F, 0x10, 0x08, 0x04, 0x7F,   
0x7E, 0x10, 0x09, 0x04, 0x7E,   
0x7F, 0x08, 0x14, 0x22, 0x41,   
0x40, 0x3E, 0x01, 0x01, 0x7F,   
0x7F, 0x02, 0x0C, 0x02, 0x7F,   
0x7F, 0x08, 0x08, 0x08, 0x7F,   
0x3E, 0x41, 0x41, 0x41, 0x3E,   
0x7F, 0x01, 0x01, 0x01, 0x7F,   
0x7F, 0x09, 0x09, 0x09, 0x06,   
0x3E, 0x41, 0x41, 0x41, 0x22,   
0x01, 0x01, 0x7F, 0x01, 0x01,   
0x07, 0x48, 0x48, 0x48, 0x3F,   
0x0E, 0x11, 0x7F, 0x11, 0x0E,   
0x63, 0x14, 0x08, 0x14, 0x63,   
0x3F, 0x20, 0x20, 0x3F, 0x60,   
0x07, 0x08, 0x08, 0x08, 0x7F,   
0x7F, 0x40, 0x7E, 0x40, 0x7F,   
0x3F, 0x20, 0x3F, 0x20, 0x7F,   
0x01, 0x7F, 0x48, 0x48, 0x30,   
0x7F, 0x48, 0x30, 0x00, 0x7F,   
0x00, 0x7F, 0x48, 0x48, 0x30,   
0x22, 0x41, 0x49, 0x49, 0x3E,   
0x7F, 0x08, 0x3E, 0x41, 0x3E,   
0x46, 0x29, 0x19, 0x09, 0x7F,   
0x20, 0x54, 0x54, 0x54, 0x78,   
0x3C, 0x4A, 0x4A, 0x4A, 0x31,   
0x7C, 0x54, 0x54, 0x28, 0x00,   
0x7C, 0x04, 0x04, 0x0C, 0x00,   
0x60, 0x3C, 0x24, 0x3C, 0x60,   
0x38, 0x54, 0x54, 0x54, 0x18,   
0x6C, 0x10, 0x7C, 0x10, 0x6C,   
0x00, 0x44, 0x54, 0x54, 0x28,   
0x7C, 0x20, 0x10, 0x08, 0x7C,   
0x7C, 0x21, 0x12, 0x09, 0x7C,   
0x7C, 0x10, 0x28, 0x44, 0x00,   
0x40, 0x38, 0x04, 0x04, 0x7C,   
0x7C, 0x08, 0x10, 0x08, 0x7C,   
0x7C, 0x10, 0x10, 0x10, 0x7C,   
0x38, 0x44, 0x44, 0x44, 0x38,   
0x7C, 0x04, 0x04, 0x04, 0x7C,   
0x7C, 0x14, 0x14, 0x14, 0x08,   
0x38, 0x44, 0x44, 0x44, 0x00,   
0x04, 0x04, 0x7C, 0x04, 0x04,   
0x0C, 0x50, 0x50, 0x50, 0x3C,   
0x08, 0x14, 0x7C, 0x14, 0x08,   
0x44, 0x28, 0x10, 0x28, 0x44,   
0x3C, 0x20, 0x20, 0x3C, 0x60,   
0x0C, 0x10, 0x10, 0x10, 0x7C,   
0x7C, 0x40, 0x7C, 0x40, 0x7C,   
0x3C, 0x20, 0x3C, 0x20, 0x7C,   
0x04, 0x7C, 0x50, 0x50, 0x20,   
0x7C, 0x50, 0x20, 0x00, 0x7C,   
0x00, 0x7C, 0x50, 0x50, 0x20,   
0x28, 0x44, 0x54, 0x54, 0x38,   
0x7C, 0x10, 0x38, 0x44, 0x38,   
0x48, 0x54, 0x34, 0x14, 0x7C    
};

void LCD_init ( void )
{

delay_ms(100);

PORTB &= ~0x04;    

PORTB |= 0x10;	
delay_ms(100);
PORTB |= 0x10;

PORTB |= 0x04;	

LCD_writeCommand( 0x21 );  
LCD_writeCommand( 0xE0 );  
LCD_writeCommand( 0x04 );  
LCD_writeCommand( 0x13 );  
LCD_writeCommand( 0x20 );  
LCD_writeCommand( 0x0c );  

LCD_clear();
}

void LCD_writeCommand ( unsigned char command )
{
PORTB &= ~0x04;	  

PORTB &= ~0x01 ;	  

SPDR = command;

while ( !(SPSR & 0x80) );

PORTB |= 0x04;   	 
}

void LCD_writeData ( unsigned char Data )
{
PORTB &= ~0x04;	  

PORTB |= 0x01  ;	  

SPDR = Data;

while ( !(SPSR & 0x80) );

PORTB |= 0x04;   	 
}

void LCD_clear ( void )
{
int i,j;

LCD_gotoXY (0,0);  	

for(i=0; i<8; i++)
for(j=0; j<90; j++)
LCD_writeData( 0x00 );

LCD_gotoXY (0,1);	
}

void LCD_gotoXY ( unsigned char x, unsigned char y )
{
LCD_writeCommand (0x80 | x);   
LCD_writeCommand (0x40 | y);   
}

void LCD_writeChar ( unsigned char ch)
{
unsigned char j;  
for(j=0; j<5; j++)
LCD_writeData( smallFont [(unsigned int)(ch-32)*5 + j] );

LCD_writeData( 0x00 );
} 

void LCD_writeString_F ( flash unsigned char *string )
{
while ( *string )
LCD_writeChar( *string++ );
}
