/*
  PORT B 0 -   
  PORT B 1 -    
  PORT B 2 -  
  PORT B 3 - 
  
  
  
  
  -   
  -    -  ,  ,     
  -        -  ,    
  
   :
  -         
  -            
  
  :
  -  -  
  -  -   
  - 2   -   
  - 5   -   
  - 3   -     
  -   2        
  - 4 x       
  
  
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>

#ifdef _AVR_ATTINY13A_H_
#define F_CPU			4800000UL
#define CALIBRATION2    5000
#define ADCDEVISION		0b101	// adc prescale by /32 for tiny13
#else
#define F_CPU			16000000UL
#define CALIBRATION2    10000
#define ADCDEVISION		0b111	// adc prescale by /128 for tiny85
#endif						// mclock     
#include <util/delay.h>

#define CALIBRATION1    F_CPU / 8 / CALIBRATION2	// F_CPU / 1024 / 10000 -    10 000   

#define DELAY1 10       //       , 
#define DELAY2 60		//      , 
#define DELAY3 15		//       

// 512 -     (acs712  VCC/2  )
//  acs712-5a   185/ - 1024 / 5 * 0,185 = 38   ADC   
#define CURRENT_MEASURES	2000				// -    
#define CURRENT_MEASURES_AVG 5					// -      
#define CURRENT_OFF_MAXIMUM	500					// 0,5 -        
#define CURRENT_ON_MINIMUM	1000				//       
#define CURRENT_ON_MAXIMUM1	8800				//       
#define CURRENT_ON_MAXIMUM2	4800				//         DELAY_BEFORE_MAXIMUM2   
#define DELAY_BEFORE_MAXIMUM2	5				//        CURRENT_ON_MAXIMUM2   

//sbit  button_dis at PINB.B0;
//sbit  valve      at PORTB.B1;
//sbit  dispenser  at PORTB.B2;
//sbit  buzzer     at PORTB.B3;
//sbit  testbit    at PORTB.B4;

// Declare your global variables here
volatile unsigned int mclock;
volatile unsigned int mclock2;
enum status_list { status0=0, status1=1, status2=2, status3=3, status4=4 } status;

volatile unsigned int current;
volatile unsigned int current_max;
volatile unsigned int current_measures;

volatile unsigned int current_adc_avg;
volatile unsigned char current_avg_measures;

ISR (TIM0_OVF_vect)
{
     //TCNT0 = CALIBRATION1; //     10000   
     mclock2--;
     if(mclock2 == 0) {
		 //    
          mclock++;
          mclock2 = CALIBRATION2;
     }
}
// 
#define CURRENT_MULT 19			// = 5000 / 1024 / 0,185 * 0,704 -    
ISR (ADC_vect)
{
	//  asc712-5a
	//    VCC/2, .  = 512
	// 1024  5,   0,185  1
	// current(A) = abs(ADCW-512) * 5(V) / 1024 / 0,185(V) 
	
	ADCSRA |= 0x10;
	
	//   
	current_adc_avg += ADCW;
	current_avg_measures++;
	
	if(current_avg_measures >= CURRENT_MEASURES_AVG) {
		current_adc_avg /= CURRENT_MEASURES_AVG;			//    
	
		if(current_max < current_adc_avg) {
			current_max = current_adc_avg;
		}
		current_measures++;
		if(current_measures >= CURRENT_MEASURES) {
			current = (current_max - 512) * CURRENT_MULT;
			current_max      = 512;
			current_measures = 0;
		}
		current_adc_avg = 0;
		current_avg_measures = 0;
	}
}


static void init_mcu();
static void beep(unsigned char islong, unsigned char count);
static void delay_sec10(unsigned char delay);
static void valve_off();
static void valve_on();
static void dispenser_off();
static void dispenser_on();
static uint8_t check_button() { return PINB & (1<<PB0); }

int main(){
	unsigned int clock_stamp;
	unsigned int clock_stamp_delay2;
	uint8_t button_off_status;
	uint8_t delay2;

     init_mcu();

     mclock = 0;
     mclock2 = CALIBRATION2;
     
	 current			= 0;
	 current_max		= 512;
	 current_measures	= 0;
	 current_adc_avg	= 0;
	 current_avg_measures = 0;
	 delay2				= DELAY2;
	 clock_stamp		= 0;
	 clock_stamp_delay2	= 0;
	 
     status = status0;
     button_off_status = check_button();

     wdt_enable(WDTO_2S);
	 sei();

     beep(0, 1);
     
     while (1)
      {
		  		
      //      
      switch(status) {
      case status0:          //       
        break;
      default:
        if(button_off_status == check_button()) {
            status = status3;
        }
      }
	  	  
	  //   
	  switch(status) {
		case status0:
			//      -  
			if(current > CURRENT_OFF_MAXIMUM) {
				beep(0, 2);
			}
			break;
		case status2:
			//     -  
			if((current > CURRENT_ON_MAXIMUM1) || ((current > CURRENT_ON_MAXIMUM2 || current < CURRENT_ON_MINIMUM) && (mclock - clock_stamp > DELAY_BEFORE_MAXIMUM2))) {
				dispenser_off();
				beep(1, 5);
				status = status3;
			} else 
			//if((current < CURRENT_ON_MINIMUM) && (mclock - clock_stamp > DELAY_BEFORE_MAXIMUM2)) {
			//	dispenser_off();
			//	beep(0, 3);
			//	status = status3;
			//}
			break;
		default:
			break;
	  }

      switch(status) {
      case status1:    //    ,     
        if(mclock - clock_stamp > DELAY1) {
            beep(1, 2);
            delay_sec10(20);
            dispenser_on();
            clock_stamp = mclock;
            status = status2;
        }
        break;
      case status2:     //       ,  
        if(mclock - clock_stamp > delay2) {
            status = status3;
        }
        break;
      case status3:     //  ,   - 
        dispenser_off();
        delay_sec10(DELAY3*10); // 10 
        valve_off();
        status = status0;
        button_off_status = check_button();     //      
        clock_stamp_delay2 = mclock;			//       
        break;
      case status0:     //  ,  
      default:
        if(check_button() != button_off_status) {
            beep(1, 1);
            clock_stamp = mclock;
			//          -  
			if(mclock - clock_stamp_delay2 < 30) {
				if(delay2 < DELAY2*3) {
					delay2 += DELAY2;
				} else {
					//     -  
					beep(0, 4);
					break;
				} 
			} else {
				delay2 = DELAY2;
			}
            status = status1;
			mclock = 0;
            valve_on();
        }
      }
      delay_sec10(4);
      }
}


static void init_mcu() {
  //CLKPR=0x80;
  //CLKPR=0x00;
  //Port B initialization
  // Func5=In Func4=Out Func3=Out Func2=Out Func1=Out Func0=In
  // State5=T State4=T State3=0 State2=0 State1=0 State0=T
  DDRB=0b001110;
  //PORTB=0x01;

  // Clock source: System Clock

// Timer/Counter 0 initialization
TCCR0A=0x03;
// TCCR0B
// 
TCCR0B=0x0A;
//TCNT0=0x00;
OCR0A=CALIBRATION1;
//OCR0B=0x00;

  // Timer/Counter 0 Interrupt(s) initialization
#ifdef _AVR_ATTINY13A_H_
	TIMSK0=0x02;
#else
	TIMSK=0x02;
#endif

	// ADC initialization
	//DIDR0&=0x03;
	//DIDR0|=0x00;
	// ADCSRA
	// 7. ADEN = 1			- adc enabled
	// 5. ADATE = 1			- auto trigger 
	// 3. ADIE = 1			- interrupt are enabled
	// 0-2. ADPS = 0b101	- clock devision factor, should be 0b101 for 4,8mhz (div by 32) and 0b110 for 9,6mhz (div by 64) = 150khz, 16mhz = 0b111
	ADCSRA = (1 << ADEN) | (1 << ADATE) | (1 << ADIE) | ADCDEVISION;
	// ADCSRB
	// 0x100 - timer/counter overflow
	ADCSRB = (1 << ADTS2) | (0 << ADTS1) | (0 << ADTS0);
	//  ADMUX
	// REFS0 = 0 - VCC as reference voltage
	// ADLAR = 0 - right adjusted result
	// ADC2 is selected
	ADMUX = 2;							// 2-  ADC   
	// Delay needed for the stabilization of the ADC input voltage
	//_delay_us(10);
	// Start the AD conversion
	//ADCSRA |= (1 << ADSC);						//    
}

static void beep(unsigned char islong, unsigned char count) {
    for(;count > 0; count--) {
        PORTB |= (1 << PB3);
        delay_sec10((islong) ? 8 : 1);
        PORTB &= ~(1 << PB3);
        delay_sec10((islong) ? 3 : 1);
    }
}
//        watchdog
static void delay_sec10(unsigned char delay) {
     for(;delay > 0; delay--) {
         _delay_ms(98);
         wdt_reset();
     }
}

/*
  PORT B 0 -   
  PORT B 1 -    
  PORT B 2 -  
  PORT B 3 - 
*/
static void dispenser_off() { PORTB &= ~(1 << PB2); }
static void dispenser_on()  { PORTB |= (1 << PB2); }
static void valve_off() { PORTB &= ~(1 << PB1); }
static void valve_on() { PORTB |= (1 << PB1); }