/*****************************************************
Chip type               : ATmega8515
Program type            : Application
AVR Core Clock frequency: 8,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 128
*****************************************************/

#include <mega8515.h>
#include <delay.h>

// I2C Bus functions
#asm
   .equ __i2c_port=0x12 ;PORTD
   .equ __sda_bit=7
   .equ __scl_bit=6
#endasm
#include <i2c.h>
#include <ds1307.c>


#define but1 !PINB.0
#define but2 !PINB.1
#define but3 !PINB.2

#define mon_power_on()		PORTA.7 = 1
#define mon_power_off()		PORTA.7 = 0

#define mon_button_on()		PORTC.5 = 1
#define mon_button_off()	PORTC.5 = 0

#define eee_button_on()		PORTC.6 = 1
#define eee_button_off()	PORTC.6 = 0

#define eee_on_sense		!PIND.3
#define ir_on_sense             PIND.2

unsigned char null;
unsigned int i = 0;

unsigned char on_flag = 0;
unsigned char off_flag = 0;
unsigned char mon_on_flag = 0;

unsigned char time_on[2];
unsigned char time_off[2];

eeprom unsigned int e_null = 0; 

eeprom unsigned char time_on_e[2] = {0,0};
eeprom unsigned char time_off_e[2] = {0,0};

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
	{
        delay_ms (50);
        if (ir_on_sense && on_flag && eee_on_sense)
        	{
                mon_button_on();
                delay_ms(100);
                mon_button_off();
                delay_ms(2000);
                mon_power_off();
                mon_on_flag = 0;
                        
                eee_button_on();
                delay_ms(10000);
                eee_button_off();
                on_flag = 0;
                }
        }

// External Interrupt 1 service routine
interrupt [EXT_INT1] void ext_int1_isr(void)
	{

	}

unsigned char led_cnt = 0;
unsigned char led_byte[3]; 

unsigned char counter = 0;
unsigned char effect = 0;

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
	{
	TCNT0=0xC2;
        
        #asm ("wdr");
        
        ++counter;
        effect = 0b00000100;
        if (counter > 63)effect = 0b00000010;
        if (counter > 127)effect = 0b01000000;
        if (counter > 191)effect = 0b00010000;
	
        switch (led_cnt)
        	{
                case 0: {PORTC.4 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.0 = 1; led_cnt++;}; break;
                case 1: {PORTC.0 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.1 = 1; led_cnt++;}; break;
                case 2: {PORTC.1 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.2 = 1; led_cnt++;}; break;
                case 3: {PORTC.2 = 0; PORTA &= 0b10000000; PORTA |= effect; PORTC.4 = 1; led_cnt=0;};
                } 
        }

unsigned char led_code (unsigned char symbol)
	{
        unsigned char res = 0;
        
        switch(symbol)
   		{
      		case 0: res=0b00111111;		break;	//0 
      		case 1: res=0b00000011;		break; 
      		case 2: res=0b01101110;		break; 
      		case 3: res=0b01001111;		break; 
      		case 4: res=0b01010011;		break; 
      		case 5: res=0b01011101;		break; 
      		case 6: res=0b01111101;		break; 
      		case 7: res=0b00000111;		break; 
      		case 8: res=0b01111111;		break; 
      		case 9: res=0b01011111;		break; 
      		case 10: res=0b01000000;	break;	//- 
      		case 11: res=0b01101001;	break; 	//o
      		case 12: res=0b01100001;	break;  //n
      		case 13: res=0b01110100;	break;  //F
      		default: res=0; // ,   
   		}
        return res;
        }

void led_print (unsigned char a, unsigned char b, unsigned char c)
	{
        led_byte[0] = led_code(a);
        led_byte[1] = led_code(b);
        led_byte[2] = led_code(c);
        }
        
void sound_on (int time)	//  
        {
        int i = 0;
        while (i < time*2)
                {  
                PORTC.7 = 1;
                delay_us(250);
                PORTC.7 = 0;
                delay_us(250);                
                i++;
                }
        } 

void main(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port A initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTA=0x00;
DDRA=0xFF;

// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=P State1=P State0=P 
PORTB=0x07;
DDRB=0x00;

// Port C initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTC=0x00;
DDRC=0xFF;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=P State2=P State1=T State0=T 
PORTD=0x0C;
DDRD=0x00;

// Port E initialization
// Func2=In Func1=In Func0=In 
// State2=T State1=T State0=T 
PORTE=0x00;
DDRE=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 31,250 kHz
// Mode: Normal top=FFh
// OC0 output: Disconnected
TCCR0=0x04;
TCNT0=0xC2;
OCR0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Rising Edge
// INT1: On
// INT1 Mode: Falling Edge
// INT2: Off
GICR|=0xC0;
MCUCR=0x0B;
EMCUCR=0x00;
GIFR=0xC0;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x02;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;

// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/2048k
#pragma optsize-
WDTCR=0x1F;
WDTCR=0x0F;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

i2c_init();

// DS1307 Real Time Clock initialization
// Square wave output on pin SQW/OUT: Off
// SQW/OUT pin state: 0
rtc_init(0,0,0);

i2c_start();		//   
i2c_write(0xd0);
i2c_write(0);
i2c_start();
i2c_write(0xd1);
null=i2c_read(0);
i2c_stop();


if (null&0b10000000)                                                                 
        {
        i2c_start();
        i2c_write(0xd0);
        i2c_write(0);
        i2c_write(null&0b01111111);
        i2c_stop();
        }
        
e_null = 0;

if (time_on_e[0] > 23 || time_on_e[1] > 59 || time_off_e[0] > 23 || time_off_e[1] > 59)
	{time_on_e[0] = 9;
	time_on_e[1] = 0;
	time_off_e[0] = 0;
	time_off_e[1] = 0;
	}

time_on[0] = time_on_e[0];
time_on[1] = time_on_e[1];
time_off[0] = time_off_e[0];
time_off[1] = time_off_e[1];

// Global enable interrupts
#asm("sei")

while (1)
      	{
      	rtc_get_time();
        
        led_print(time[0]/10, time[0]%10, 10);
        while (!but1 && !but2 && !but3 && i<1000) {delay_ms(1); i++;};
        i = 0;
        
        led_print(10, time[1]/10, time[1]%10);
        while (!but1 && !but2 && !but3 && i<1000) {delay_ms(1); i++;};
        i = 0;
        
        if (time_on[0] != time_off[0] || time_on[1] != time_off[1])
		{
		if ((time[0] == time_on[0]) && (time[1] == time_on[1]) && !eee_on_sense)
			{
			eee_button_on();
                        delay_ms(100);
                        eee_button_off();
            
                        on_flag = 1;
                        delay_ms (40000);
            
                        mon_power_on();
                        mon_on_flag = 1;
                                   
                        delay_ms(2000);
                	mon_button_on();
               		delay_ms(200);
                	mon_button_off();
                	}
                        		
                if ((time[0] == time_off[0]) && (time[1] == time_off[1]) && eee_on_sense)
			{
                        eee_button_on();
        			
                        mon_button_on();
                        delay_ms(100);
                        mon_button_off();
                        
                        delay_ms(2000);
                        mon_power_off();
                        mon_on_flag = 0;
                                
                        eee_button_on();
                	delay_ms(10000);
                	eee_button_off();
                        on_flag = 0;
                        }
                        
		}
        
        if (!mon_on_flag && eee_on_sense)
        	{
                on_flag = 1;
                delay_ms (40000);
                mon_on_flag = 1;
                mon_power_on();
                delay_ms(2000);
                mon_button_on();
                delay_ms(200);
                mon_button_off();
                }
                
        if (mon_on_flag && !eee_on_sense)
        	{
                mon_on_flag = 0;
                mon_power_off();
                on_flag = 0;
                }
                
        if (but1)
      		{
                delay_ms(20);
                if (but1)
                	{
                        while(but1);
                        sound_on(20);
                        while (!but1 && i<3000) {led_print(time[0]/10, time[0]%10, 10); delay_ms(1); i++;};
                        i = 0;
                        while (but1)
                        	{
                                if (++time[0] > 23) time[0] = 0;
                                led_print(time[0]/10, time[0]%10, 10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        while (!but1 && i<3000) {led_print(10, time[1]/10, time[1]%10); delay_ms(1); i++;};
                        i = 0;
                        while (but1)
                        	{
                                if (++time[1] > 59) time[1] = 0;
                                led_print(10, time[1]/10, time[1]%10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        rtc_set_time (time[0], time[1], time[2]); 
                        }
                }
                
        if (but2)
      		{
                delay_ms(20);
                if (but2)
                	{
                        while(but2);
                        sound_on(20);
                        while (!but2 && i<3000) {led_print(time_on[0]/10, time_on[0]%10, 10); delay_ms(1); i++;};
                        i = 0;
                        while (but2)
                        	{
                                if (++time_on[0] > 23) time_on[0] = 0;
                                led_print(time_on[0]/10, time_on[0]%10, 10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        while (!but2 && i<3000) {led_print(10, time_on[1]/10, time_on[1]%10); delay_ms(1); i++;};
                        i = 0;
                        while (but2)
                        	{
                                if (++time_on[1] > 59) time_on[1] = 0;
                                led_print(10, time_on[1]/10, time_on[1]%10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        time_on_e[0] = time_on[0];
                        time_on_e[1] = time_on[1]; 
                        }
                }
                
        if (but3)
      		{
                delay_ms(20);
                if (but3)
                	{
                        while(but3);
                        sound_on(20);
                        while (!but3 && i<3000) {led_print(time_off[0]/10, time_off[0]%10, 10); delay_ms(1); i++;};
                        i = 0;
                        while (but3)
                        	{
                                if (++time_off[0] > 23) time_off[0] = 0;
                                led_print(time_off[0]/10, time_off[0]%10, 10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        while (!but3 && i<3000) {led_print(10, time_off[1]/10, time_off[1]%10); delay_ms(1); i++;};
                        i = 0;
                        while (but3)
                        	{
                                if (++time_off[1] > 59) time_off[1] = 0;
                                led_print(10, time_off[1]/10, time_off[1]%10);
                                delay_ms(200);
                                }
                        delay_ms(500);
                        sound_on(20);
                        time_off_e[0] = time_off[0];
                        time_off_e[1] = time_off[1]; 
                        }
                }
        };
}
