//***************************************************
// DS1307 Real Time Clock functions

#include <bcd.h>

unsigned char time [3];
unsigned char date [3];

#pragma used+

void rtc_init(unsigned char rs,unsigned char sqwe,unsigned char out)
{
rs&=3;
if (sqwe) rs|=0x10;
if (out) rs|=0x80;
i2c_start();
i2c_write(0xd0);
i2c_write(7);
i2c_write(rs);
i2c_stop();
}

void rtc_get_time(void)
{
i2c_start();
i2c_write(0xd0);
i2c_write(0);
i2c_start();
i2c_write(0xd1);
time[2]=bcd2bin(i2c_read(1));
time[1]=bcd2bin(i2c_read(1));
time[0]=bcd2bin(i2c_read(0));
i2c_stop();
}

void rtc_set_time(unsigned char hour,unsigned char min,unsigned char sec)
{
i2c_start();
i2c_write(0xd0);
i2c_write(0);
i2c_write(bin2bcd(sec));
i2c_write(bin2bcd(min));
i2c_write(bin2bcd(hour));
i2c_stop();
}

void rtc_get_date(void)
{
i2c_start();
i2c_write(0xd0);
i2c_write(4);
i2c_start();
i2c_write(0xd1);
date[0]=bcd2bin(i2c_read(1));
date[1]=bcd2bin(i2c_read(1));
date[2]=bcd2bin(i2c_read(0));
i2c_stop();
}

void rtc_set_date(unsigned char date,unsigned char month,unsigned char year)
{
i2c_start();
i2c_write(0xd0);
i2c_write(4);
i2c_write(bin2bcd(date));
i2c_write(bin2bcd(month));
i2c_write(bin2bcd(year));
i2c_stop();
}

#pragma used-
//***************************************************