
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega8515
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 128 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega8515
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 512
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCSR=0x34
	.EQU MCUCR=0x35
	.EQU EMCUCR=0x36
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _null=R5
	.DEF _i=R6
	.DEF _on_flag=R4
	.DEF _off_flag=R9
	.DEF _mon_on_flag=R8
	.DEF _led_cnt=R11
	.DEF _counter=R10
	.DEF _effect=R13

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP _ext_int0_isr
	RJMP _ext_int1_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_0xC9:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x0A
	.DW  0x04
	.DW  _0xC9*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30
	OUT  EMCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x200)
	LDI  R25,HIGH(0x200)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x25F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x25F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0xE0)
	LDI  R29,HIGH(0xE0)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0xE0

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.04.4a Advanced
;Automatic Program Generator
; Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 20.09.2010
;Author  : NeVaDa
;Company : 000
;Comments:
;
;
;Chip type               : ATmega8515
;Program type            : Application
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 128
;*****************************************************/
;
;#include <mega8515.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;// I2C Bus functions
;#asm
   .equ __i2c_port=0x12 ;PORTD
   .equ __sda_bit=7
   .equ __scl_bit=6
; 0000 0020 #endasm
;#include <i2c.h>
;#include <ds1307.c>
;//***************************************************
;// DS1307 Real Time Clock functions
;
;#include <bcd.h>
;
;unsigned char time [3];
;unsigned char date [3];
;
;#pragma used+
;
;void rtc_init(unsigned char rs,unsigned char sqwe,unsigned char out)
; 0000 0022 {

	.CSEG
_rtc_init:
;rs&=3;
;	rs -> Y+2
;	sqwe -> Y+1
;	out -> Y+0
	LDD  R30,Y+2
	ANDI R30,LOW(0x3)
	STD  Y+2,R30
;if (sqwe) rs|=0x10;
	LDD  R30,Y+1
	CPI  R30,0
	BREQ _0x3
	LDD  R30,Y+2
	ORI  R30,0x10
	STD  Y+2,R30
;if (out) rs|=0x80;
_0x3:
	LD   R30,Y
	CPI  R30,0
	BREQ _0x4
	LDD  R30,Y+2
	ORI  R30,0x80
	STD  Y+2,R30
;i2c_start();
_0x4:
	RCALL SUBOPT_0x0
;i2c_write(0xd0);
;i2c_write(7);
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x1
;i2c_write(rs);
	LDD  R30,Y+2
	RCALL SUBOPT_0x1
;i2c_stop();
	RCALL _i2c_stop
;}
	RJMP _0x2020001
;
;void rtc_get_time(void)
;{
_rtc_get_time:
;i2c_start();
	RCALL SUBOPT_0x0
;i2c_write(0xd0);
;i2c_write(0);
	RCALL SUBOPT_0x2
;i2c_start();
	RCALL _i2c_start
;i2c_write(0xd1);
	LDI  R30,LOW(209)
	RCALL SUBOPT_0x1
;time[2]=bcd2bin(i2c_read(1));
	RCALL SUBOPT_0x3
	__PUTB1MN _time,2
;time[1]=bcd2bin(i2c_read(1));
	RCALL SUBOPT_0x3
	__PUTB1MN _time,1
;time[0]=bcd2bin(i2c_read(0));
	RCALL SUBOPT_0x4
	RCALL _i2c_read
	ST   -Y,R30
	RCALL _bcd2bin
	STS  _time,R30
;i2c_stop();
	RCALL _i2c_stop
;}
	RET
;
;void rtc_set_time(unsigned char hour,unsigned char min,unsigned char sec)
;{
_rtc_set_time:
;i2c_start();
;	hour -> Y+2
;	min -> Y+1
;	sec -> Y+0
	RCALL SUBOPT_0x0
;i2c_write(0xd0);
;i2c_write(0);
	RCALL SUBOPT_0x2
;i2c_write(bin2bcd(sec));
	LD   R30,Y
	RCALL SUBOPT_0x5
;i2c_write(bin2bcd(min));
	LDD  R30,Y+1
	RCALL SUBOPT_0x5
;i2c_write(bin2bcd(hour));
	LDD  R30,Y+2
	RCALL SUBOPT_0x5
;i2c_stop();
	RCALL _i2c_stop
;}
	RJMP _0x2020001
;
;void rtc_get_date(void)
;{
;i2c_start();
;i2c_write(0xd0);
;i2c_write(4);
;i2c_start();
;i2c_write(0xd1);
;date[0]=bcd2bin(i2c_read(1));
;date[1]=bcd2bin(i2c_read(1));
;date[2]=bcd2bin(i2c_read(0));
;i2c_stop();
;}
;
;void rtc_set_date(unsigned char date,unsigned char month,unsigned char year)
;{
;i2c_start();
;	date -> Y+2
;	month -> Y+1
;	year -> Y+0
;i2c_write(0xd0);
;i2c_write(4);
;i2c_write(bin2bcd(date));
;i2c_write(bin2bcd(month));
;i2c_write(bin2bcd(year));
;i2c_stop();
;}
;
;#pragma used-
;//***************************************************
;
;
;#define but1 !PINB.0
;#define but2 !PINB.1
;#define but3 !PINB.2
;
;#define mon_power_on()		PORTA.7 = 1
;#define mon_power_off()		PORTA.7 = 0
;
;#define mon_button_on()		PORTC.5 = 1
;#define mon_button_off()	PORTC.5 = 0
;
;#define eee_button_on()		PORTC.6 = 1
;#define eee_button_off()	PORTC.6 = 0
;
;#define eee_on_sense		!PIND.3
;#define ir_on_sense             PIND.2
;
;unsigned char null;
;unsigned int i = 0;
;
;unsigned char on_flag = 0;
;unsigned char off_flag = 0;
;unsigned char mon_on_flag = 0;
;
;unsigned char time_on[2];
;unsigned char time_off[2];
;
;eeprom unsigned int e_null = 0;
;
;eeprom unsigned char time_on_e[2] = {0,0};
;eeprom unsigned char time_off_e[2] = {0,0};
;
;// External Interrupt 0 service routine
;interrupt [EXT_INT0] void ext_int0_isr(void)
; 0000 0046 	{
_ext_int0_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0047         delay_ms (50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	RCALL SUBOPT_0x6
; 0000 0048         if (ir_on_sense && on_flag && eee_on_sense)
	SBIS 0x10,2
	RJMP _0x6
	TST  R4
	BREQ _0x6
	SBIS 0x10,3
	RJMP _0x7
_0x6:
	RJMP _0x5
_0x7:
; 0000 0049         	{
; 0000 004A                 mon_button_on();
	RCALL SUBOPT_0x7
; 0000 004B                 delay_ms(100);
; 0000 004C                 mon_button_off();
	RCALL SUBOPT_0x8
; 0000 004D                 delay_ms(2000);
; 0000 004E                 mon_power_off();
	RCALL SUBOPT_0x9
; 0000 004F                 mon_on_flag = 0;
; 0000 0050 
; 0000 0051                 eee_button_on();
; 0000 0052                 delay_ms(10000);
; 0000 0053                 eee_button_off();
	CBI  0x15,6
; 0000 0054                 on_flag = 0;
	CLR  R4
; 0000 0055                 }
; 0000 0056         }
_0x5:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;// External Interrupt 1 service routine
;interrupt [EXT_INT1] void ext_int1_isr(void)
; 0000 005A 	{
_ext_int1_isr:
; 0000 005B 
; 0000 005C 	}
	RETI
;
;unsigned char led_cnt = 0;
;unsigned char led_byte[3];
;
;unsigned char counter = 0;
;unsigned char effect = 0;
;
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 0066 	{
_timer0_ovf_isr:
	ST   -Y,R26
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0067 	TCNT0=0xC2;
	LDI  R30,LOW(194)
	OUT  0x32,R30
; 0000 0068 
; 0000 0069         #asm ("wdr");
	wdr
; 0000 006A 
; 0000 006B         ++counter;
	INC  R10
; 0000 006C         effect = 0b00000100;
	LDI  R30,LOW(4)
	MOV  R13,R30
; 0000 006D         if (counter > 63)effect = 0b00000010;
	LDI  R30,LOW(63)
	CP   R30,R10
	BRSH _0x12
	LDI  R30,LOW(2)
	MOV  R13,R30
; 0000 006E         if (counter > 127)effect = 0b01000000;
_0x12:
	LDI  R30,LOW(127)
	CP   R30,R10
	BRSH _0x13
	LDI  R30,LOW(64)
	MOV  R13,R30
; 0000 006F         if (counter > 191)effect = 0b00010000;
_0x13:
	LDI  R30,LOW(191)
	CP   R30,R10
	BRSH _0x14
	LDI  R30,LOW(16)
	MOV  R13,R30
; 0000 0070 
; 0000 0071         switch (led_cnt)
_0x14:
	RCALL SUBOPT_0xA
; 0000 0072         	{
; 0000 0073                 case 0: {PORTC.4 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.0 = 1; led_cnt++;}; break;
	SBIW R30,0
	BRNE _0x18
	CBI  0x15,4
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xC
	SBI  0x15,0
	INC  R11
	RJMP _0x17
; 0000 0074                 case 1: {PORTC.0 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.1 = 1; led_cnt++;}; break;
_0x18:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x1D
	CBI  0x15,0
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xC
	SBI  0x15,1
	INC  R11
	RJMP _0x17
; 0000 0075                 case 2: {PORTC.1 = 0; PORTA &= 0b10000000; PORTA |= led_byte[led_cnt]; PORTC.2 = 1; led_cnt++;}; break;
_0x1D:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x22
	CBI  0x15,1
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xC
	SBI  0x15,2
	INC  R11
	RJMP _0x17
; 0000 0076                 case 3: {PORTC.2 = 0; PORTA &= 0b10000000; PORTA |= effect; PORTC.4 = 1; led_cnt=0;};
_0x22:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x17
	CBI  0x15,2
	IN   R30,0x1B
	ANDI R30,LOW(0x80)
	OUT  0x1B,R30
	IN   R30,0x1B
	OR   R30,R13
	OUT  0x1B,R30
	SBI  0x15,4
	CLR  R11
; 0000 0077                 }
_0x17:
; 0000 0078         }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R26,Y+
	RETI
;
;unsigned char led_code (unsigned char symbol)
; 0000 007B 	{
_led_code:
; 0000 007C         unsigned char res = 0;
; 0000 007D 
; 0000 007E         switch(symbol)
	ST   -Y,R17
;	symbol -> Y+1
;	res -> R17
	LDI  R17,0
	LDD  R30,Y+1
	LDI  R31,0
; 0000 007F    		{
; 0000 0080       		case 0: res=0b00111111;		break;	//0
	SBIW R30,0
	BRNE _0x2F
	LDI  R17,LOW(63)
	RJMP _0x2E
; 0000 0081       		case 1: res=0b00000011;		break;
_0x2F:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x30
	LDI  R17,LOW(3)
	RJMP _0x2E
; 0000 0082       		case 2: res=0b01101110;		break;
_0x30:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x31
	LDI  R17,LOW(110)
	RJMP _0x2E
; 0000 0083       		case 3: res=0b01001111;		break;
_0x31:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x32
	LDI  R17,LOW(79)
	RJMP _0x2E
; 0000 0084       		case 4: res=0b01010011;		break;
_0x32:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x33
	LDI  R17,LOW(83)
	RJMP _0x2E
; 0000 0085       		case 5: res=0b01011101;		break;
_0x33:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x34
	LDI  R17,LOW(93)
	RJMP _0x2E
; 0000 0086       		case 6: res=0b01111101;		break;
_0x34:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x35
	LDI  R17,LOW(125)
	RJMP _0x2E
; 0000 0087       		case 7: res=0b00000111;		break;
_0x35:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0x36
	LDI  R17,LOW(7)
	RJMP _0x2E
; 0000 0088       		case 8: res=0b01111111;		break;
_0x36:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x37
	LDI  R17,LOW(127)
	RJMP _0x2E
; 0000 0089       		case 9: res=0b01011111;		break;
_0x37:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0x38
	LDI  R17,LOW(95)
	RJMP _0x2E
; 0000 008A       		case 10: res=0b01000000;	break;	//-
_0x38:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x39
	LDI  R17,LOW(64)
	RJMP _0x2E
; 0000 008B       		case 11: res=0b01101001;	break; 	//o
_0x39:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x3A
	LDI  R17,LOW(105)
	RJMP _0x2E
; 0000 008C       		case 12: res=0b01100001;	break;  //n
_0x3A:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x3B
	LDI  R17,LOW(97)
	RJMP _0x2E
; 0000 008D       		case 13: res=0b01110100;	break;  //F
_0x3B:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x3D
	LDI  R17,LOW(116)
	RJMP _0x2E
; 0000 008E       		default: res=0; // ,   
_0x3D:
	LDI  R17,LOW(0)
; 0000 008F    		}
_0x2E:
; 0000 0090         return res;
	MOV  R30,R17
	LDD  R17,Y+0
	ADIW R28,2
	RET
; 0000 0091         }
;
;void led_print (unsigned char a, unsigned char b, unsigned char c)
; 0000 0094 	{
_led_print:
; 0000 0095         led_byte[0] = led_code(a);
;	a -> Y+2
;	b -> Y+1
;	c -> Y+0
	LDD  R30,Y+2
	ST   -Y,R30
	RCALL _led_code
	STS  _led_byte,R30
; 0000 0096         led_byte[1] = led_code(b);
	LDD  R30,Y+1
	ST   -Y,R30
	RCALL _led_code
	__PUTB1MN _led_byte,1
; 0000 0097         led_byte[2] = led_code(c);
	LD   R30,Y
	ST   -Y,R30
	RCALL _led_code
	__PUTB1MN _led_byte,2
; 0000 0098         }
_0x2020001:
	ADIW R28,3
	RET
;
;void sound_on (int time)	// 
; 0000 009B         {
_sound_on:
; 0000 009C         int i = 0;
; 0000 009D         while (i < time*2)
	RCALL __SAVELOCR2
;	time -> Y+2
;	i -> R16,R17
	__GETWRN 16,17,0
_0x3E:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LSL  R30
	ROL  R31
	CP   R16,R30
	CPC  R17,R31
	BRGE _0x40
; 0000 009E                 {
; 0000 009F                 PORTC.7 = 1;
	SBI  0x15,7
; 0000 00A0                 delay_us(250);
	RCALL SUBOPT_0xD
; 0000 00A1                 PORTC.7 = 0;
	CBI  0x15,7
; 0000 00A2                 delay_us(250);
	RCALL SUBOPT_0xD
; 0000 00A3                 i++;
	__ADDWRN 16,17,1
; 0000 00A4                 }
	RJMP _0x3E
_0x40:
; 0000 00A5         }
	RCALL __LOADLOCR2
	ADIW R28,4
	RET
;
;void main(void)
; 0000 00A8 {
_main:
; 0000 00A9 // Declare your local variables here
; 0000 00AA 
; 0000 00AB // Input/Output Ports initialization
; 0000 00AC // Port A initialization
; 0000 00AD // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 00AE // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 00AF PORTA=0x00;
	LDI  R30,LOW(0)
	OUT  0x1B,R30
; 0000 00B0 DDRA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1A,R30
; 0000 00B1 
; 0000 00B2 // Port B initialization
; 0000 00B3 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 00B4 // State7=T State6=T State5=T State4=T State3=T State2=P State1=P State0=P
; 0000 00B5 PORTB=0x07;
	LDI  R30,LOW(7)
	OUT  0x18,R30
; 0000 00B6 DDRB=0x00;
	LDI  R30,LOW(0)
	OUT  0x17,R30
; 0000 00B7 
; 0000 00B8 // Port C initialization
; 0000 00B9 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 00BA // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 00BB PORTC=0x00;
	OUT  0x15,R30
; 0000 00BC DDRC=0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
; 0000 00BD 
; 0000 00BE // Port D initialization
; 0000 00BF // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 00C0 // State7=T State6=T State5=T State4=T State3=P State2=P State1=T State0=T
; 0000 00C1 PORTD=0x0C;
	LDI  R30,LOW(12)
	OUT  0x12,R30
; 0000 00C2 DDRD=0x00;
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 0000 00C3 
; 0000 00C4 // Port E initialization
; 0000 00C5 // Func2=In Func1=In Func0=In
; 0000 00C6 // State2=T State1=T State0=T
; 0000 00C7 PORTE=0x00;
	OUT  0x7,R30
; 0000 00C8 DDRE=0x00;
	OUT  0x6,R30
; 0000 00C9 
; 0000 00CA // Timer/Counter 0 initialization
; 0000 00CB // Clock source: System Clock
; 0000 00CC // Clock value: 31,250 kHz
; 0000 00CD // Mode: Normal top=FFh
; 0000 00CE // OC0 output: Disconnected
; 0000 00CF TCCR0=0x04;
	LDI  R30,LOW(4)
	OUT  0x33,R30
; 0000 00D0 TCNT0=0xC2;
	LDI  R30,LOW(194)
	OUT  0x32,R30
; 0000 00D1 OCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x31,R30
; 0000 00D2 
; 0000 00D3 // Timer/Counter 1 initialization
; 0000 00D4 // Clock source: System Clock
; 0000 00D5 // Clock value: Timer1 Stopped
; 0000 00D6 // Mode: Normal top=FFFFh
; 0000 00D7 // OC1A output: Discon.
; 0000 00D8 // OC1B output: Discon.
; 0000 00D9 // Noise Canceler: Off
; 0000 00DA // Input Capture on Falling Edge
; 0000 00DB // Timer1 Overflow Interrupt: Off
; 0000 00DC // Input Capture Interrupt: Off
; 0000 00DD // Compare A Match Interrupt: Off
; 0000 00DE // Compare B Match Interrupt: Off
; 0000 00DF TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 00E0 TCCR1B=0x00;
	OUT  0x2E,R30
; 0000 00E1 TCNT1H=0x00;
	OUT  0x2D,R30
; 0000 00E2 TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 00E3 ICR1H=0x00;
	OUT  0x25,R30
; 0000 00E4 ICR1L=0x00;
	OUT  0x24,R30
; 0000 00E5 OCR1AH=0x00;
	OUT  0x2B,R30
; 0000 00E6 OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 00E7 OCR1BH=0x00;
	OUT  0x29,R30
; 0000 00E8 OCR1BL=0x00;
	OUT  0x28,R30
; 0000 00E9 
; 0000 00EA // External Interrupt(s) initialization
; 0000 00EB // INT0: On
; 0000 00EC // INT0 Mode: Rising Edge
; 0000 00ED // INT1: On
; 0000 00EE // INT1 Mode: Falling Edge
; 0000 00EF // INT2: Off
; 0000 00F0 GICR|=0xC0;
	IN   R30,0x3B
	ORI  R30,LOW(0xC0)
	OUT  0x3B,R30
; 0000 00F1 MCUCR=0x0B;
	LDI  R30,LOW(11)
	OUT  0x35,R30
; 0000 00F2 EMCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x36,R30
; 0000 00F3 GIFR=0xC0;
	LDI  R30,LOW(192)
	OUT  0x3A,R30
; 0000 00F4 
; 0000 00F5 // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 00F6 TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
; 0000 00F7 
; 0000 00F8 // Analog Comparator initialization
; 0000 00F9 // Analog Comparator: Off
; 0000 00FA // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 00FB ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 00FC 
; 0000 00FD // Watchdog Timer initialization
; 0000 00FE // Watchdog Timer Prescaler: OSC/2048k
; 0000 00FF #pragma optsize-
; 0000 0100 WDTCR=0x1F;
	LDI  R30,LOW(31)
	OUT  0x21,R30
; 0000 0101 WDTCR=0x0F;
	LDI  R30,LOW(15)
	OUT  0x21,R30
; 0000 0102 #ifdef _OPTIMIZE_SIZE_
; 0000 0103 #pragma optsize+
; 0000 0104 #endif
; 0000 0105 
; 0000 0106 i2c_init();
	RCALL _i2c_init
; 0000 0107 
; 0000 0108 // DS1307 Real Time Clock initialization
; 0000 0109 // Square wave output on pin SQW/OUT: Off
; 0000 010A // SQW/OUT pin state: 0
; 0000 010B rtc_init(0,0,0);
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x4
	RCALL _rtc_init
; 0000 010C 
; 0000 010D i2c_start();		//   
	RCALL SUBOPT_0x0
; 0000 010E i2c_write(0xd0);
; 0000 010F i2c_write(0);
	RCALL SUBOPT_0x2
; 0000 0110 i2c_start();
	RCALL _i2c_start
; 0000 0111 i2c_write(0xd1);
	LDI  R30,LOW(209)
	RCALL SUBOPT_0x1
; 0000 0112 null=i2c_read(0);
	RCALL SUBOPT_0x4
	RCALL _i2c_read
	MOV  R5,R30
; 0000 0113 i2c_stop();
	RCALL _i2c_stop
; 0000 0114 
; 0000 0115 
; 0000 0116 if (null&0b10000000)
	SBRS R5,7
	RJMP _0x45
; 0000 0117         {
; 0000 0118         i2c_start();
	RCALL SUBOPT_0x0
; 0000 0119         i2c_write(0xd0);
; 0000 011A         i2c_write(0);
	RCALL SUBOPT_0x2
; 0000 011B         i2c_write(null&0b01111111);
	MOV  R30,R5
	ANDI R30,0x7F
	RCALL SUBOPT_0x1
; 0000 011C         i2c_stop();
	RCALL _i2c_stop
; 0000 011D         }
; 0000 011E 
; 0000 011F e_null = 0;
_0x45:
	LDI  R26,LOW(_e_null)
	LDI  R27,HIGH(_e_null)
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RCALL __EEPROMWRW
; 0000 0120 
; 0000 0121 if (time_on_e[0] > 23 || time_on_e[1] > 59 || time_off_e[0] > 23 || time_off_e[1] > 59)
	RCALL SUBOPT_0xE
	RCALL __EEPROMRDB
	CPI  R30,LOW(0x18)
	BRSH _0x47
	RCALL SUBOPT_0xF
	RCALL __EEPROMRDB
	CPI  R30,LOW(0x3C)
	BRSH _0x47
	RCALL SUBOPT_0x10
	RCALL __EEPROMRDB
	CPI  R30,LOW(0x18)
	BRSH _0x47
	RCALL SUBOPT_0x11
	RCALL __EEPROMRDB
	CPI  R30,LOW(0x3C)
	BRLO _0x46
_0x47:
; 0000 0122 	{time_on_e[0] = 9;
	RCALL SUBOPT_0xE
	LDI  R30,LOW(9)
	RCALL __EEPROMWRB
; 0000 0123 	time_on_e[1] = 0;
	RCALL SUBOPT_0xF
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 0124 	time_off_e[0] = 0;
	RCALL SUBOPT_0x10
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 0125 	time_off_e[1] = 0;
	RCALL SUBOPT_0x11
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 0126 	}
; 0000 0127 
; 0000 0128 time_on[0] = time_on_e[0];
_0x46:
	RCALL SUBOPT_0xE
	RCALL __EEPROMRDB
	STS  _time_on,R30
; 0000 0129 time_on[1] = time_on_e[1];
	RCALL SUBOPT_0xF
	RCALL __EEPROMRDB
	__PUTB1MN _time_on,1
; 0000 012A time_off[0] = time_off_e[0];
	RCALL SUBOPT_0x10
	RCALL __EEPROMRDB
	STS  _time_off,R30
; 0000 012B time_off[1] = time_off_e[1];
	RCALL SUBOPT_0x11
	RCALL __EEPROMRDB
	__PUTB1MN _time_off,1
; 0000 012C 
; 0000 012D // Global enable interrupts
; 0000 012E #asm("sei")
	sei
; 0000 012F 
; 0000 0130 while (1)
_0x49:
; 0000 0131       	{
; 0000 0132       	rtc_get_time();
	RCALL _rtc_get_time
; 0000 0133 
; 0000 0134         led_print(time[0]/10, time[0]%10, 10);
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x14
; 0000 0135         while (!but1 && !but2 && !but3 && i<1000) {delay_ms(1); i++;};
_0x4C:
	SBIS 0x16,0
	RJMP _0x4F
	SBIS 0x16,1
	RJMP _0x4F
	SBIS 0x16,2
	RJMP _0x4F
	RCALL SUBOPT_0x15
	BRLO _0x50
_0x4F:
	RJMP _0x4E
_0x50:
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0x4C
_0x4E:
; 0000 0136         i = 0;
	RCALL SUBOPT_0x18
; 0000 0137 
; 0000 0138         led_print(10, time[1]/10, time[1]%10);
	RCALL SUBOPT_0x19
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1B
; 0000 0139         while (!but1 && !but2 && !but3 && i<1000) {delay_ms(1); i++;};
_0x51:
	SBIS 0x16,0
	RJMP _0x54
	SBIS 0x16,1
	RJMP _0x54
	SBIS 0x16,2
	RJMP _0x54
	RCALL SUBOPT_0x15
	BRLO _0x55
_0x54:
	RJMP _0x53
_0x55:
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0x51
_0x53:
; 0000 013A         i = 0;
	RCALL SUBOPT_0x18
; 0000 013B 
; 0000 013C         if (time_on[0] != time_off[0] || time_on[1] != time_off[1])
	LDS  R30,_time_off
	RCALL SUBOPT_0x1C
	CP   R30,R26
	BRNE _0x57
	RCALL SUBOPT_0x1D
	__GETB1MN _time_off,1
	CP   R30,R26
	BREQ _0x56
_0x57:
; 0000 013D 		{
; 0000 013E 		if ((time[0] == time_on[0]) && (time[1] == time_on[1]) && !eee_on_sense)
	LDS  R30,_time_on
	RCALL SUBOPT_0x12
	CP   R30,R26
	BRNE _0x5A
	RCALL SUBOPT_0x1A
	__GETB1MN _time_on,1
	CP   R30,R26
	BRNE _0x5A
	SBIC 0x10,3
	RJMP _0x5B
_0x5A:
	RJMP _0x59
_0x5B:
; 0000 013F 			{
; 0000 0140 			eee_button_on();
	SBI  0x15,6
; 0000 0141                         delay_ms(100);
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RCALL SUBOPT_0x6
; 0000 0142                         eee_button_off();
	CBI  0x15,6
; 0000 0143 
; 0000 0144                         on_flag = 1;
	RCALL SUBOPT_0x1E
; 0000 0145                         delay_ms (40000);
; 0000 0146 
; 0000 0147                         mon_power_on();
	SBI  0x1B,7
; 0000 0148                         mon_on_flag = 1;
	LDI  R30,LOW(1)
	MOV  R8,R30
; 0000 0149 
; 0000 014A                         delay_ms(2000);
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	RCALL SUBOPT_0x6
; 0000 014B                 	mon_button_on();
	RCALL SUBOPT_0x1F
; 0000 014C                		delay_ms(200);
; 0000 014D                 	mon_button_off();
	CBI  0x15,5
; 0000 014E                 	}
; 0000 014F 
; 0000 0150                 if ((time[0] == time_off[0]) && (time[1] == time_off[1]) && eee_on_sense)
_0x59:
	LDS  R30,_time_off
	RCALL SUBOPT_0x12
	CP   R30,R26
	BRNE _0x67
	RCALL SUBOPT_0x1A
	__GETB1MN _time_off,1
	CP   R30,R26
	BRNE _0x67
	SBIS 0x10,3
	RJMP _0x68
_0x67:
	RJMP _0x66
_0x68:
; 0000 0151 			{
; 0000 0152                         eee_button_on();
	SBI  0x15,6
; 0000 0153 
; 0000 0154                         mon_button_on();
	RCALL SUBOPT_0x7
; 0000 0155                         delay_ms(100);
; 0000 0156                         mon_button_off();
	RCALL SUBOPT_0x8
; 0000 0157 
; 0000 0158                         delay_ms(2000);
; 0000 0159                         mon_power_off();
	RCALL SUBOPT_0x9
; 0000 015A                         mon_on_flag = 0;
; 0000 015B 
; 0000 015C                         eee_button_on();
; 0000 015D                 	delay_ms(10000);
; 0000 015E                 	eee_button_off();
	CBI  0x15,6
; 0000 015F                         on_flag = 0;
	CLR  R4
; 0000 0160                         }
; 0000 0161 
; 0000 0162 		}
_0x66:
; 0000 0163 
; 0000 0164         if (!mon_on_flag && eee_on_sense)
_0x56:
	TST  R8
	BRNE _0x76
	SBIS 0x10,3
	RJMP _0x77
_0x76:
	RJMP _0x75
_0x77:
; 0000 0165         	{
; 0000 0166                 on_flag = 1;
	RCALL SUBOPT_0x1E
; 0000 0167                 delay_ms (40000);
; 0000 0168                 mon_on_flag = 1;
	LDI  R30,LOW(1)
	MOV  R8,R30
; 0000 0169                 mon_power_on();
	SBI  0x1B,7
; 0000 016A                 delay_ms(2000);
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	RCALL SUBOPT_0x6
; 0000 016B                 mon_button_on();
	RCALL SUBOPT_0x1F
; 0000 016C                 delay_ms(200);
; 0000 016D                 mon_button_off();
	CBI  0x15,5
; 0000 016E                 }
; 0000 016F 
; 0000 0170         if (mon_on_flag && !eee_on_sense)
_0x75:
	TST  R8
	BREQ _0x7F
	SBIC 0x10,3
	RJMP _0x80
_0x7F:
	RJMP _0x7E
_0x80:
; 0000 0171         	{
; 0000 0172                 mon_on_flag = 0;
	CLR  R8
; 0000 0173                 mon_power_off();
	CBI  0x1B,7
; 0000 0174                 on_flag = 0;
	CLR  R4
; 0000 0175                 }
; 0000 0176 
; 0000 0177         if (but1)
_0x7E:
	SBIC 0x16,0
	RJMP _0x83
; 0000 0178       		{
; 0000 0179                 delay_ms(20);
	RCALL SUBOPT_0x20
	RCALL SUBOPT_0x6
; 0000 017A                 if (but1)
	SBIC 0x16,0
	RJMP _0x84
; 0000 017B                 	{
; 0000 017C                         while(but1);
_0x85:
	SBIS 0x16,0
	RJMP _0x85
; 0000 017D                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 017E                         while (!but1 && i<3000) {led_print(time[0]/10, time[0]%10, 10); delay_ms(1); i++;};
_0x88:
	SBIS 0x16,0
	RJMP _0x8B
	RCALL SUBOPT_0x22
	BRLO _0x8C
_0x8B:
	RJMP _0x8A
_0x8C:
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0x88
_0x8A:
; 0000 017F                         i = 0;
	RCALL SUBOPT_0x18
; 0000 0180                         while (but1)
_0x8D:
	SBIC 0x16,0
	RJMP _0x8F
; 0000 0181                         	{
; 0000 0182                                 if (++time[0] > 23) time[0] = 0;
	RCALL SUBOPT_0x12
	SUBI R26,-LOW(1)
	STS  _time,R26
	CPI  R26,LOW(0x18)
	BRLO _0x90
	LDI  R30,LOW(0)
	STS  _time,R30
; 0000 0183                                 led_print(time[0]/10, time[0]%10, 10);
_0x90:
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x14
; 0000 0184                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 0185                                 }
	RJMP _0x8D
_0x8F:
; 0000 0186                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 0187                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 0188                         while (!but1 && i<3000) {led_print(10, time[1]/10, time[1]%10); delay_ms(1); i++;};
_0x91:
	SBIS 0x16,0
	RJMP _0x94
	RCALL SUBOPT_0x22
	BRLO _0x95
_0x94:
	RJMP _0x93
_0x95:
	RCALL SUBOPT_0x19
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0x91
_0x93:
; 0000 0189                         i = 0;
	RCALL SUBOPT_0x18
; 0000 018A                         while (but1)
_0x96:
	SBIC 0x16,0
	RJMP _0x98
; 0000 018B                         	{
; 0000 018C                                 if (++time[1] > 59) time[1] = 0;
	__GETB1MN _time,1
	SUBI R30,-LOW(1)
	__PUTB1MN _time,1
	CPI  R30,LOW(0x3C)
	BRLO _0x99
	LDI  R30,LOW(0)
	__PUTB1MN _time,1
; 0000 018D                                 led_print(10, time[1]/10, time[1]%10);
_0x99:
	RCALL SUBOPT_0x19
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x1B
; 0000 018E                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 018F                                 }
	RJMP _0x96
_0x98:
; 0000 0190                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 0191                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 0192                         rtc_set_time (time[0], time[1], time[2]);
	LDS  R30,_time
	ST   -Y,R30
	__GETB1MN _time,1
	ST   -Y,R30
	__GETB1MN _time,2
	ST   -Y,R30
	RCALL _rtc_set_time
; 0000 0193                         }
; 0000 0194                 }
_0x84:
; 0000 0195 
; 0000 0196         if (but2)
_0x83:
	SBIC 0x16,1
	RJMP _0x9A
; 0000 0197       		{
; 0000 0198                 delay_ms(20);
	RCALL SUBOPT_0x20
	RCALL SUBOPT_0x6
; 0000 0199                 if (but2)
	SBIC 0x16,1
	RJMP _0x9B
; 0000 019A                 	{
; 0000 019B                         while(but2);
_0x9C:
	SBIS 0x16,1
	RJMP _0x9C
; 0000 019C                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 019D                         while (!but2 && i<3000) {led_print(time_on[0]/10, time_on[0]%10, 10); delay_ms(1); i++;};
_0x9F:
	SBIS 0x16,1
	RJMP _0xA2
	RCALL SUBOPT_0x22
	BRLO _0xA3
_0xA2:
	RJMP _0xA1
_0xA3:
	RCALL SUBOPT_0x1C
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x25
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0x9F
_0xA1:
; 0000 019E                         i = 0;
	RCALL SUBOPT_0x18
; 0000 019F                         while (but2)
_0xA4:
	SBIC 0x16,1
	RJMP _0xA6
; 0000 01A0                         	{
; 0000 01A1                                 if (++time_on[0] > 23) time_on[0] = 0;
	RCALL SUBOPT_0x1C
	SUBI R26,-LOW(1)
	STS  _time_on,R26
	CPI  R26,LOW(0x18)
	BRLO _0xA7
	LDI  R30,LOW(0)
	STS  _time_on,R30
; 0000 01A2                                 led_print(time_on[0]/10, time_on[0]%10, 10);
_0xA7:
	RCALL SUBOPT_0x1C
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x25
; 0000 01A3                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 01A4                                 }
	RJMP _0xA4
_0xA6:
; 0000 01A5                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 01A6                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 01A7                         while (!but2 && i<3000) {led_print(10, time_on[1]/10, time_on[1]%10); delay_ms(1); i++;};
_0xA8:
	SBIS 0x16,1
	RJMP _0xAB
	RCALL SUBOPT_0x22
	BRLO _0xAC
_0xAB:
	RJMP _0xAA
_0xAC:
	LDI  R30,LOW(10)
	ST   -Y,R30
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0xA8
_0xAA:
; 0000 01A8                         i = 0;
	RCALL SUBOPT_0x18
; 0000 01A9                         while (but2)
_0xAD:
	SBIC 0x16,1
	RJMP _0xAF
; 0000 01AA                         	{
; 0000 01AB                                 if (++time_on[1] > 59) time_on[1] = 0;
	__GETB1MN _time_on,1
	SUBI R30,-LOW(1)
	__PUTB1MN _time_on,1
	CPI  R30,LOW(0x3C)
	BRLO _0xB0
	LDI  R30,LOW(0)
	__PUTB1MN _time_on,1
; 0000 01AC                                 led_print(10, time_on[1]/10, time_on[1]%10);
_0xB0:
	RCALL SUBOPT_0x26
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x1B
; 0000 01AD                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 01AE                                 }
	RJMP _0xAD
_0xAF:
; 0000 01AF                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 01B0                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 01B1                         time_on_e[0] = time_on[0];
	LDS  R30,_time_on
	RCALL SUBOPT_0xE
	RCALL __EEPROMWRB
; 0000 01B2                         time_on_e[1] = time_on[1];
	RCALL SUBOPT_0xF
	__GETB1MN _time_on,1
	RCALL __EEPROMWRB
; 0000 01B3                         }
; 0000 01B4                 }
_0x9B:
; 0000 01B5 
; 0000 01B6         if (but3)
_0x9A:
	SBIC 0x16,2
	RJMP _0xB1
; 0000 01B7       		{
; 0000 01B8                 delay_ms(20);
	RCALL SUBOPT_0x20
	RCALL SUBOPT_0x6
; 0000 01B9                 if (but3)
	SBIC 0x16,2
	RJMP _0xB2
; 0000 01BA                 	{
; 0000 01BB                         while(but3);
_0xB3:
	SBIS 0x16,2
	RJMP _0xB3
; 0000 01BC                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 01BD                         while (!but3 && i<3000) {led_print(time_off[0]/10, time_off[0]%10, 10); delay_ms(1); i++;};
_0xB6:
	SBIS 0x16,2
	RJMP _0xB9
	RCALL SUBOPT_0x22
	BRLO _0xBA
_0xB9:
	RJMP _0xB8
_0xBA:
	RCALL SUBOPT_0x27
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x28
	RCALL _led_print
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0xB6
_0xB8:
; 0000 01BE                         i = 0;
	RCALL SUBOPT_0x18
; 0000 01BF                         while (but3)
_0xBB:
	SBIC 0x16,2
	RJMP _0xBD
; 0000 01C0                         	{
; 0000 01C1                                 if (++time_off[0] > 23) time_off[0] = 0;
	RCALL SUBOPT_0x27
	SUBI R26,-LOW(1)
	STS  _time_off,R26
	CPI  R26,LOW(0x18)
	BRLO _0xBE
	LDI  R30,LOW(0)
	STS  _time_off,R30
; 0000 01C2                                 led_print(time_off[0]/10, time_off[0]%10, 10);
_0xBE:
	RCALL SUBOPT_0x27
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x28
	RCALL _led_print
; 0000 01C3                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 01C4                                 }
	RJMP _0xBB
_0xBD:
; 0000 01C5                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 01C6                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 01C7                         while (!but3 && i<3000) {led_print(10, time_off[1]/10, time_off[1]%10); delay_ms(1); i++;};
_0xBF:
	SBIS 0x16,2
	RJMP _0xC2
	RCALL SUBOPT_0x22
	BRLO _0xC3
_0xC2:
	RJMP _0xC1
_0xC3:
	RCALL SUBOPT_0x26
	RCALL SUBOPT_0x29
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x29
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
	RJMP _0xBF
_0xC1:
; 0000 01C8                         i = 0;
	RCALL SUBOPT_0x18
; 0000 01C9                         while (but3)
_0xC4:
	SBIC 0x16,2
	RJMP _0xC6
; 0000 01CA                         	{
; 0000 01CB                                 if (++time_off[1] > 59) time_off[1] = 0;
	__GETB1MN _time_off,1
	SUBI R30,-LOW(1)
	__PUTB1MN _time_off,1
	CPI  R30,LOW(0x3C)
	BRLO _0xC7
	LDI  R30,LOW(0)
	__PUTB1MN _time_off,1
; 0000 01CC                                 led_print(10, time_off[1]/10, time_off[1]%10);
_0xC7:
	RCALL SUBOPT_0x26
	RCALL SUBOPT_0x29
	RCALL SUBOPT_0x13
	RCALL SUBOPT_0x29
	RCALL SUBOPT_0x1B
; 0000 01CD                                 delay_ms(200);
	RCALL SUBOPT_0x23
; 0000 01CE                                 }
	RJMP _0xC4
_0xC6:
; 0000 01CF                         delay_ms(500);
	RCALL SUBOPT_0x24
; 0000 01D0                         sound_on(20);
	RCALL SUBOPT_0x21
; 0000 01D1                         time_off_e[0] = time_off[0];
	LDS  R30,_time_off
	RCALL SUBOPT_0x10
	RCALL __EEPROMWRB
; 0000 01D2                         time_off_e[1] = time_off[1];
	RCALL SUBOPT_0x11
	__GETB1MN _time_off,1
	RCALL __EEPROMWRB
; 0000 01D3                         }
; 0000 01D4                 }
_0xB2:
; 0000 01D5         };
_0xB1:
	RJMP _0x49
; 0000 01D6 }
_0xC8:
	NOP
	RJMP _0xC8

	.CSEG
_bcd2bin:
    ld   r30,y
    swap r30
    andi r30,0xf
    mov  r26,r30
    lsl  r26
    lsl  r26
    add  r30,r26
    lsl  r30
    ld   r26,y+
    andi r26,0xf
    add  r30,r26
    ret
_bin2bcd:
    ld   r26,y+
    clr  r30
bin2bcd0:
    subi r26,10
    brmi bin2bcd1
    subi r30,-16
    rjmp bin2bcd0
bin2bcd1:
    subi r26,-10
    add  r30,r26
    ret

	.DSEG
_time:
	.BYTE 0x3
_date:
	.BYTE 0x3
_time_on:
	.BYTE 0x2
_time_off:
	.BYTE 0x2

	.ESEG
_e_null:
	.DW  0x0
_time_on_e:
	.DW  0x0
_time_off_e:
	.DW  0x0

	.DSEG
_led_byte:
	.BYTE 0x3

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x0:
	RCALL _i2c_start
	LDI  R30,LOW(208)
	ST   -Y,R30
	RJMP _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x1:
	ST   -Y,R30
	RJMP _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2:
	LDI  R30,LOW(0)
	RJMP SUBOPT_0x1

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _i2c_read
	ST   -Y,R30
	RJMP _bcd2bin

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4:
	LDI  R30,LOW(0)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x5:
	ST   -Y,R30
	RCALL _bin2bcd
	RJMP SUBOPT_0x1

;OPTIMIZER ADDED SUBROUTINE, CALLED 37 TIMES, CODE SIZE REDUCTION:70 WORDS
SUBOPT_0x6:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x7:
	SBI  0x15,5
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x8:
	CBI  0x15,5
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x9:
	CBI  0x1B,7
	CLR  R8
	SBI  0x15,6
	LDI  R30,LOW(10000)
	LDI  R31,HIGH(10000)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xA:
	MOV  R30,R11
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0xB:
	IN   R30,0x1B
	ANDI R30,LOW(0x80)
	OUT  0x1B,R30
	IN   R30,0x1B
	MOV  R26,R30
	RJMP SUBOPT_0xA

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0xC:
	SUBI R30,LOW(-_led_byte)
	SBCI R31,HIGH(-_led_byte)
	LD   R30,Z
	OR   R30,R26
	OUT  0x1B,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xD:
	__DELAY_USW 500
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xE:
	LDI  R26,LOW(_time_on_e)
	LDI  R27,HIGH(_time_on_e)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xF:
	__POINTW2MN _time_on_e,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x10:
	LDI  R26,LOW(_time_off_e)
	LDI  R27,HIGH(_time_off_e)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x11:
	__POINTW2MN _time_off_e,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x12:
	LDS  R26,_time
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 14 TIMES, CODE SIZE REDUCTION:76 WORDS
SUBOPT_0x13:
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __DIVW21
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x14:
	RCALL SUBOPT_0x12
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __MODW21
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	RJMP _led_print

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x15:
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	CP   R6,R30
	CPC  R7,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x16:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x17:
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x18:
	CLR  R6
	CLR  R7
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x19:
	LDI  R30,LOW(10)
	ST   -Y,R30
	__GETB2MN _time,1
	RJMP SUBOPT_0x13

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1A:
	__GETB2MN _time,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:40 WORDS
SUBOPT_0x1B:
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __MODW21
	ST   -Y,R30
	RJMP _led_print

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1C:
	LDS  R26,_time_on
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1D:
	__GETB2MN _time_on,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1E:
	LDI  R30,LOW(1)
	MOV  R4,R30
	LDI  R30,LOW(40000)
	LDI  R31,HIGH(40000)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1F:
	SBI  0x15,5
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x20:
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:22 WORDS
SUBOPT_0x21:
	RCALL SUBOPT_0x20
	ST   -Y,R31
	ST   -Y,R30
	RJMP _sound_on

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x22:
	LDI  R30,LOW(3000)
	LDI  R31,HIGH(3000)
	CP   R6,R30
	CPC  R7,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x23:
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x24:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x25:
	RCALL SUBOPT_0x1C
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __MODW21
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	RJMP _led_print

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x26:
	LDI  R30,LOW(10)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x27:
	LDS  R26,_time_off
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x28:
	RCALL SUBOPT_0x27
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __MODW21
	ST   -Y,R30
	RJMP SUBOPT_0x26

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x29:
	__GETB2MN _time_off,1
	RET


	.CSEG
	.equ __i2c_dir=__i2c_port-1
	.equ __i2c_pin=__i2c_port-2
_i2c_init:
	cbi  __i2c_port,__scl_bit
	cbi  __i2c_port,__sda_bit
	sbi  __i2c_dir,__scl_bit
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay2
_i2c_start:
	cbi  __i2c_dir,__sda_bit
	cbi  __i2c_dir,__scl_bit
	clr  r30
	nop
	sbis __i2c_pin,__sda_bit
	ret
	sbis __i2c_pin,__scl_bit
	ret
	rcall __i2c_delay1
	sbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	ldi  r30,1
__i2c_delay1:
	ldi  r22,13
	rjmp __i2c_delay2l
_i2c_stop:
	sbi  __i2c_dir,__sda_bit
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
__i2c_delay2:
	ldi  r22,27
__i2c_delay2l:
	dec  r22
	brne __i2c_delay2l
	ret
_i2c_read:
	ldi  r23,8
__i2c_read0:
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_read3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_read3
	rcall __i2c_delay1
	clc
	sbic __i2c_pin,__sda_bit
	sec
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	rol  r30
	dec  r23
	brne __i2c_read0
	ld   r23,y+
	tst  r23
	brne __i2c_read1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_read2
__i2c_read1:
	sbi  __i2c_dir,__sda_bit
__i2c_read2:
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay1

_i2c_write:
	ld   r30,y+
	ldi  r23,8
__i2c_write0:
	lsl  r30
	brcc __i2c_write1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_write2
__i2c_write1:
	sbi  __i2c_dir,__sda_bit
__i2c_write2:
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_write3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_write3
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	dec  r23
	brne __i2c_write0
	cbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	ldi  r30,1
	sbic __i2c_pin,__sda_bit
	clr  r30
	sbi  __i2c_dir,__scl_bit
	ret

_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRW:
	RCALL __EEPROMWRB
	ADIW R26,1
	PUSH R30
	MOV  R30,R31
	RCALL __EEPROMWRB
	POP  R30
	SBIW R26,1
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
