//Шина данных I2C от DS1307
//D2-->SCL
//D3-->SDA
//---------------------
//Шина данных модуля ЖК индикатора 0802А
//D4-D7-->DB4-DB7
//D8-->RS
//D9-->EN
//---------------------
//D10-->Выход ШИМ
//D11-->Вход А энкодера
//D12-->Вход Б энкодера
//D13-->Вход С энкодера
//----------------------
#include <DS1307.h>
#include <LiquidCrystal.h>
#include <EEPROM.h>
LiquidCrystal lcd(8,9,4,5,6,7);
DS1307 rtc(3,2);
Time real;
const byte pwm = 10;
const byte ncoderA = 11;
const byte ncoderB = 12;
const byte ncoderC = 13;
unsigned char menu = 0;
unsigned char shim=0;
unsigned char KnopkaC;
unsigned char lastKnopkaC;
unsigned long lastDrebezg=0;
unsigned long DrebezgDelay=50;
unsigned long currentTime;
unsigned long loopTime;
unsigned char KnopkaA;
unsigned char KnopkaB;
unsigned char lastKnopkaA=0;
unsigned char nochH=EEPROM.read(2), nochM=EEPROM.read(3);
unsigned char denH=EEPROM.read(0), denM=EEPROM.read(1);
boolean reduct=false;
boolean ustanovka=false;
boolean klick=false;
signed char chislo;
unsigned char rezhim;
char ru4=0;


void setup() 
{
  // initialize digital pin 13 as an output.
pinMode(pwm, OUTPUT);
pinMode(ncoderA, INPUT);
digitalWrite(ncoderA, HIGH);
pinMode(ncoderB, INPUT);
digitalWrite(ncoderB, HIGH);
pinMode(ncoderC, INPUT);
digitalWrite(ncoderC, HIGH);

rtc.begin();
//rtc.halt(false);
//rtc.setTime(20, 46, 00);
//rtc.setDate(01, 8, 2020);
//rtc.setDOW(7);

lcd.begin(8,2);
}

// the loop function runs over and over again forever
void loop() 
{
if (reduct==false)
{
menu=0;
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("  ");
lcd.print(rtc.getTimeStr(FORMAT_SHORT)); //выводим время
lcd.print(" ");
lcd.setCursor(0,1);
lcd.print(rtc.getDateStr(FORMAT_SHORT)); //выводим дату
real=rtc.getTime();
if (denH==real.hour && denM==real.min) 
digitalWrite(pwm, HIGH);                  //если время совпало, то день
if (nochH==real.hour && nochM==real.min)
digitalWrite(pwm, LOW);                   //если время совпало, то ночь
}


//********************Условия работы энкодра в меню**********************
if (reduct==true && ustanovka==false) //Передвижние в меню редактирования
menu=encoderAB(4, menu); //функция работы с энкодером.
//----------------------------------------------------------------
if (reduct==true && ustanovka==true && menu==0 && rezhim==2)
{
real.hour=encoderAB(23, real.hour);
rtc.setTime(real.hour, real.min, 00);
}

if (reduct==true && ustanovka==true && menu==0 && rezhim==3)
{
real.min=encoderAB(59, real.min);
rtc.setTime(real.hour, real.min, 00);
}
//-----------------------------------------------------------------
//Меню настроек
if (reduct==true && ustanovka==true && menu==1 && rezhim==2)
{
real.date=encoderAB(31, real.date);
rtc.setDate(real.date, real.mon, real.year);
}

if (reduct==true && ustanovka==true && menu==1 && rezhim==3)
{
real.mon=encoderAB(12, real.mon);
rtc.setDate(real.date, real.mon, real.year);
}

if (reduct==true && ustanovka==true && menu==1 && rezhim==4)
{
real.year=encoderAB(2099, real.year);
rtc.setDate(real.date, real.mon, real.year);
}
//-----------------------------------------------------------------
//Меню установки дня
if (reduct==true && ustanovka==true && menu==2 && rezhim==2)
denH=encoderAB(23, denH);

if (reduct==true && ustanovka==true && menu==2 && rezhim==3)
denM=encoderAB(59, denM);
//-----------------------------------------------------------------
//Меню установки ночи
if (reduct==true && ustanovka==true && menu==3 && rezhim==2)
nochH=encoderAB(23, nochH);

if (reduct==true && ustanovka==true && menu==3 && rezhim==3)
nochM=encoderAB(59, nochM);

//-----------------------------------------------------------------
//Ручное управление
if (reduct==true && ustanovka==true && menu==4 && rezhim==2)
ru4=encoderAB(1, ru4);

//*************Проверка кнопки энкодера с антидребезгом*******************
byte ReadKnopkaC=digitalRead(ncoderC);
if (ReadKnopkaC != lastKnopkaC) lastDrebezg = millis();  
if ((millis() - lastDrebezg) > DrebezgDelay)
{
if (ReadKnopkaC != KnopkaC)
{
KnopkaC=ReadKnopkaC;
if (KnopkaC==LOW)
  {
  lcd.clear();
  klick=true;               //Флаг нажатия кнопки энкодера или вращения энкодера
  rezhim++;
  switch (rezhim)
    {
    case 1:
    reduct=true;
    break;
    case 2:
    ustanovka=true;
    break;
    }
  }
}
}
lastKnopkaC=ReadKnopkaC;

//------------------------------------------------------------------
if (menu==0 && klick==true && reduct==true && ustanovka==false)
{
vremya();
}

if (menu==0 && klick==true && reduct==true && ustanovka==true)
{
if (rezhim==4) 
{
rezhim=0;
reduct=false;
ustanovka=false;
}
vremyaUst();
}

//------------------------------------------------------------------
if (menu==1 && klick==true && reduct==true && ustanovka==false)
{
data();
}

if (menu==1 && klick==true && reduct==true && ustanovka==true)
{ 
if (rezhim==5) 
{
rezhim=0;
reduct=false;
ustanovka=false;
}
dataUst();
}

//-------------------------------------------------------------------
if (menu==2 && klick==true && reduct==true && ustanovka==false)
{
den();
}
if (menu==2 && klick==true && reduct==true && ustanovka==true)
{
if (rezhim==4) 
{
EEPROM.write(0, denH);
EEPROM.write(1, denM);
rezhim=0;
reduct=false;
ustanovka=false;
}
denUst();
}

//------------------------------------------------------------------
if (menu==3 && klick==true && reduct==true && ustanovka==false)
{
noch();
}
if (menu==3 && klick==true && reduct==true && ustanovka==true)
{
if (rezhim==4) 
{
EEPROM.write(2, nochH);
EEPROM.write(3, nochM);
rezhim=0;
reduct=false;
ustanovka=false;
}
nochUst();
}

//-------------------------------------------------------------------
if (menu==4 && klick==true && reduct==true && ustanovka==false)
{
ru4noy();
}
if (menu==4 && klick==true && reduct==true && ustanovka==true)
{
if (rezhim==3) 
{
rezhim=0;
reduct=false;
ustanovka=false;
if (ru4==0) digitalWrite(pwm, LOW);
if (ru4==1) digitalWrite(pwm, HIGH);
}
ru4noyUst();
}

}

//****************Подпрограммы вывода на дисплей********************
void vremya()
{
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("Set Time");
lcd.setCursor(2,1);
lcd.print(rtc.getTimeStr(FORMAT_SHORT));
klick=false;  
}

void vremyaUst()
{
real=rtc.getTime();
lcd.setCursor(2,0);
lcd.print("HH:MM");
lcd.setCursor(2,1);
if (real.hour<10) lcd.print("0");
lcd.print(real.hour);
lcd.setCursor(4,1);
lcd.print(":");
if (real.min<10) lcd.print("0");
lcd.print(real.min);
lcd.blink();
if (rezhim==2) lcd.setCursor(3,1);
if (rezhim==3) lcd.setCursor(6,1);
klick=false;
}

void data()
{
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("Set Date");
lcd.setCursor(0,1);
lcd.print(rtc.getDateStr(FORMAT_SHORT));
klick=false;
}

void dataUst()
{
real=rtc.getTime();
if (rezhim==4) godUst();
else
{ 
lcd.setCursor(0,0);
lcd.print("DD.MM.YY");
lcd.setCursor(0,1);
if (real.date<10) lcd.print("0");
lcd.print(real.date);
lcd.setCursor(2,1);
lcd.print(".");
if (real.mon<10) lcd.print("0");
lcd.print(real.mon);
lcd.setCursor(5,1);
lcd.print(".");
lcd.print(real.year-2000);
lcd.blink();
if (rezhim==2) lcd.setCursor(1,1);
if (rezhim==3) lcd.setCursor(4,1);
}
klick=false;
}

void godUst()
{
lcd.clear();
lcd.setCursor(2,0);
lcd.print("YYYY");
lcd.setCursor(2,1);
lcd.print(real.year);
lcd.setCursor(5,1);
}

void den() 
{
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("Set Utro");
lcd.setCursor(2,1);
if (denH<10) lcd.print("0");
lcd.print(denH);
lcd.print(":");
if (denM<10) lcd.print("0");
lcd.print(denM);
klick=false;
}

void denUst()
{
lcd.setCursor(2,0);
lcd.print("HH:MM");
lcd.setCursor(2,1);
if (denH<10) lcd.print("0");
lcd.print(denH);
lcd.setCursor(4,1);
lcd.print(":");
if (denM<10) lcd.print("0");
lcd.print(denM);
lcd.blink();
if (rezhim==2) lcd.setCursor(3,1);
if (rezhim==3) lcd.setCursor(6,1);
klick=false;
}

void noch()
{
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("Set Noch");
lcd.setCursor(2,1);
if (nochH<10) lcd.print("0");
lcd.print(nochH);
lcd.print(":");
if (nochM<10) lcd.print("0");
lcd.print(nochM);
klick=false;
}

void nochUst()
{
lcd.setCursor(2,0);
lcd.print("HH:MM");
lcd.setCursor(2,1);
if (nochH<10) lcd.print("0");
lcd.print(nochH);
lcd.setCursor(4,1);
lcd.print(":");
if (nochM<10) lcd.print("0");
lcd.print(nochM);
lcd.blink();
if (rezhim==2) lcd.setCursor(3,1);
if (rezhim==3) lcd.setCursor(6,1);
klick=false;
}

void ru4noy()
{
lcd.noBlink();
lcd.setCursor(0,0);
lcd.print("RUCHNOY");
lcd.setCursor(0,1);
lcd.print("REZHIM");
klick=false;
}

void ru4noyUst()
{
lcd.setCursor(2,0);
lcd.print("LAMPA");
lcd.setCursor(2,1);
if (ru4==0) lcd.print("Off");
       else lcd.print("On");
}

//**************Функции********************************
int encoderAB(int chislo, int lastNumber)
{
int number;
number=lastNumber;
//Проверка энкодера с антидребезгом
currentTime = millis();
if(currentTime >=(loopTime+5))
{
  KnopkaA=digitalRead(ncoderA);
  KnopkaB=digitalRead(ncoderB);
  if ((!KnopkaA)&&(lastKnopkaA))
    {
    if (KnopkaB==true && reduct==true)
      {
      klick=true;
      number++;
      if (number==(chislo+1)) number=0;
      lcd.clear();
      }
    else if (KnopkaB==false && reduct==true)
      {
      klick=true;
      number--;
      if (number<=0) number=0;
      lcd.clear();
      }
    }
lastKnopkaA=KnopkaA;
loopTime=currentTime;
}
return number; 
}
