#include <avr/pgmspace.h>
#include "melody5.h"
#include "hardw.h"

typedef struct{

	uint8_t delta_index_note_table;
	uint8_t octave;
	uint16_t i;
	int16_t amplitude_index;//

}chanel_data ;

#define shift 128  //  
#define OCTAVE_SHIFT 0  //
#define SPEED 130	//  
#define MAX_CH 4 //  2

uint16_t index_melody=0;//  
uint8_t time_event=0;	//   
uint8_t main_iterator=0;//        

 int8_t sample0;
 chanel_data ch[MAX_CH];

 uint8_t ledPWM1;// 
 uint8_t ledPWM2;// 
 uint8_t iPWMLED;// LED

 //   64 
uint8_t sinT[] PROGMEM={0,12,25	,37	,49	,60	,71	,81	,90	,98	,106,112,117,122,125,126,127,126,125,122,117,112,106,98,90,81,71,60,49,37,25,12,0,-12,-25,-37,-49,-60,-71,-81,-90,-98,-106,-112,-117,-122,-125,-126,-127,-126,-125,-122,-117,-112,-106,-98,-90,-81,-71,-60,-49,-37,-25,-12};
 #define MASK_TABLE_SIN 0x3f
 //   16 (   )
 //uint8_t sinT[] PROGMEM={0,49,90,117,127,117,90,49,0,-49,-90,-117,-127,-117,-90,-49};
//#define MASK_TABLE_SIN 0x0f

// 
uint8_t note_table[] PROGMEM={0xF2,0xE4,0xD7,0xCB,0xC0,0xB5,0xAB,0xA1,0x98,0x90,0x88,0x80};

inline void getChanelSample(uint8_t ch_index){
	chanel_data *ch_data=(chanel_data*)(&ch[ch_index]);//     
	if ((*ch_data).amplitude_index>30000) {return ;};//    
	(*ch_data).i+=(*ch_data).delta_index_note_table;//

	int8_t sample=pgm_read_byte(&(sinT[MASK_TABLE_SIN&((*ch_data).i>>((*ch_data).octave))]));//    

	(*ch_data).amplitude_index++;
	uint8_t divider=(((*ch_data).amplitude_index)>>10);
	
	//   
	sample0=(sample0+sample)>>(divider+1);// 
	//sample0=sample>>divider;// 

};
inline void setNote(uint8_t note,uint8_t ch_index){//   

	if (!note) return;//   0 -  
	note=shift-note;
	
	ledPWM2=255;		//
	if (note&1) ledPWM1=255;//  
	if (note&2) ledPWM2+=128;//
	
	
	chanel_data *ch_data=(chanel_data*)&(ch[ch_index]);//     
	(*ch_data).i=0;
	(*ch_data).amplitude_index=0;



	(*ch_data).delta_index_note_table=((pgm_read_byte(&(note_table[note%12]))));//    
	(*ch_data).octave=OCTAVE_SHIFT+(note/12);// 

}


void getSample(){

getChanelSample((main_iterator++)&(MAX_CH-1));//       
	if ((main_iterator)==(255-SPEED)){
		main_iterator=(255-SPEED)&(MAX_CH-1);

		if (!(time_event--)) {
			uint8_t next_time_event=((pgm_read_byte(&(s_melody_events[index_melody])))/1)<<0;//    
			uint8_t note=(pgm_read_byte(&s_melody_notes[index_melody]));// 


			if (++index_melody>melodySize) {SLEEP;}//    - 

			setNote(note,((uint8_t)index_melody)&(MAX_CH-1));//     
			time_event=(next_time_event);
		}
		ledPWM1-=ledPWM1>3?3:ledPWM1;// 
		ledPWM2-=ledPWM2>1?1:ledPWM2;// 
	}

	iPWMLED++;
	if (iPWMLED>=ledPWM1) {LED1_OFF;} else LED1_ON;//
	if (iPWMLED>=ledPWM2) {LED2_OFF;} else LED2_ON;//  
}
