#include <avr/pgmspace.h>
#include "melody5.h"
#include "hardw.h"

typedef struct{

	uint8_t delta_index_note_table;
	uint8_t octave;
	uint16_t i;
	int16_t amplitude_index;//

}chanel_data ;

#define shift 128  //определение тональности и
#define OCTAVE_SHIFT 0  //октавы
#define SPEED 130	// скорость воспроизведения
#define MAX_CH 4 //кратно степени 2

uint16_t index_melody=0;//номер проигрываемой ноты
uint8_t time_event=0;	//время до следующего события
uint8_t main_iterator=0;//вспомогательный итератор для задания номера активного канала и скорости

 int8_t sample0;
 chanel_data ch[MAX_CH];

 uint8_t ledPWM1;//переменные для
 uint8_t ledPWM2;//програмного шима
 uint8_t iPWMLED;//для LED

 //таблица синуса на 64 значения
uint8_t sinT[] PROGMEM={0,12,25	,37	,49	,60	,71	,81	,90	,98	,106,112,117,122,125,126,127,126,125,122,117,112,106,98,90,81,71,60,49,37,25,12,0,-12,-25,-37,-49,-60,-71,-81,-90,-98,-106,-112,-117,-122,-125,-126,-127,-126,-125,-122,-117,-112,-106,-98,-90,-81,-71,-60,-49,-37,-25,-12};
 #define MASK_TABLE_SIN 0x3f
 //таблица синуса на 16 значений(раскоментировать вместе с маской)
 //uint8_t sinT[] PROGMEM={0,49,90,117,127,117,90,49,0,-49,-90,-117,-127,-117,-90,-49};
//#define MASK_TABLE_SIN 0x0f

//нотная таблица
uint8_t note_table[] PROGMEM={0xF2,0xE4,0xD7,0xCB,0xC0,0xB5,0xAB,0xA1,0x98,0x90,0x88,0x80};

inline void getChanelSample(uint8_t ch_index){
	chanel_data *ch_data=(chanel_data*)(&ch[ch_index]);//выбираем канал с которым будем работать
	if ((*ch_data).amplitude_index>30000) {return ;};//конец звучания ноты в канале
	(*ch_data).i+=(*ch_data).delta_index_note_table;//

	int8_t sample=pgm_read_byte(&(sinT[MASK_TABLE_SIN&((*ch_data).i>>((*ch_data).octave))]));//получение семпла из синусной таблицы

	(*ch_data).amplitude_index++;
	uint8_t divider=(((*ch_data).amplitude_index)>>10);
	
	//вычисление семпла с затуханием
	sample0=(sample0+sample)>>(divider+1);//меньше дребезга
	//sample0=sample>>divider;//экономия памяти

};
inline void setNote(uint8_t note,uint8_t ch_index){//включение ноты в канале

	if (!note) return;//нота с номером 0 - просто пауза
	note=shift-note;
	
	ledPWM2=255;		//включение
	if (note&1) ledPWM1=255;//светодиодов в такт
	if (note&2) ledPWM2+=128;//музыке
	
	
	chanel_data *ch_data=(chanel_data*)&(ch[ch_index]);//выбираем канал с которым будем работать
	(*ch_data).i=0;
	(*ch_data).amplitude_index=0;



	(*ch_data).delta_index_note_table=((pgm_read_byte(&(note_table[note%12]))));//получение итератора для синусной таблицы
	(*ch_data).octave=OCTAVE_SHIFT+(note/12);//вычисление октавы

}


void getSample(){

getChanelSample((main_iterator++)&(MAX_CH-1));//получаем семпл из текущего канала и переключаем канал
	if ((main_iterator)==(255-SPEED)){
		main_iterator=(255-SPEED)&(MAX_CH-1);

		if (!(time_event--)) {
			uint8_t next_time_event=((pgm_read_byte(&(s_melody_events[index_melody])))/1)<<0;//получаем время до следующего события
			uint8_t note=(pgm_read_byte(&s_melody_notes[index_melody]));//и ноту


			if (++index_melody>melodySize) {SLEEP;}// если мелодия сыграна - засыпаем

			setNote(note,((uint8_t)index_melody)&(MAX_CH-1));//в текущем канале включаем полученную ноту
			time_event=(next_time_event);
		}
		ledPWM1-=ledPWM1>3?3:ledPWM1;//затухание 
		ledPWM2-=ledPWM2>1?1:ledPWM2;//програмного шима
	}

	iPWMLED++;
	if (iPWMLED>=ledPWM1) {LED1_OFF;} else LED1_ON;//програмный
	if (iPWMLED>=ledPWM2) {LED2_OFF;} else LED2_ON;//шим для светодиодов
}