/*****************************************************
This program was produced by the
CodeWizardAVR V2.05.3 Standard
Automatic Program Generator
 Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : 
Version : 
Date    : 14.03.2014
Author  : PerTic@n
Company : If You Like This Software,Buy It
Comments: 


Chip type               : ATmega16A
Program type            : Application
AVR Core Clock frequency: 8,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 256
*****************************************************/

#include <mega16a.h>

// I2C Bus functions
#include <i2c.h>

// DS1307 Real Time Clock functions
#include <ds1307.h>

// 1 Wire Bus interface functions
//#include <1wire.h>

//       ds18b20
//#include <ds18b20.h>

// Graphic LCD functions
#include <glcd.h>

// Font used for displaying text
//        
#include <NumberBig.h>
//      c   
#include <Number.h>
//      ,    
#include <stdio.h>


//////////////////////////////////////////////////////////////////////////////////////

//    
//     
char lcd_buffer[8];
//       20  
int temp=0;
//      
int rotate=0;
// (  )   Rotate
int rotatePred=-1;
//    DS1307
char hour, minut, sec; 
//day, month, year, week_day;
//Reload=1     , ; Reload=0  
bit reload=0;
//Set=0 -  , Set=1 -  , Set=2 -  .
int set=0;
//  -
bit Flight=0;
//  -
bit Blight=0;
//        
bit light=0;
//   
int speed=0;

unsigned long int run=0;

///////////////////////////////////////////////////////////////////////////////////////


// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
    {
    // Place your code here
    speed++;
    run=run+26;
    }

void screen(void)
    {
    //
    glcd_setfont(Number);
    glcd_outtextxyf(0,37,"0");
    glcd_outtextxyf(3,27,"2");
    glcd_outtextxyf(9,18,"4");
    glcd_outtextxyf(22,10,"6");
    glcd_outtextxyf(38,4,"8");
    glcd_outtextxyf(54,10,"1");
    glcd_outtextxyf(59,10,"0");
    glcd_outtextxyf(68,18,"1");
    glcd_outtextxyf(73,18,"2");
    glcd_outtextxyf(72,28,"1");
    glcd_outtextxyf(77,28,"4");    
    glcd_setlinestyle(1,GLCD_LINE_SOLID);
    glcd_arc(41,47,0,180,32);
    glcd_line(7,47,6,47);
    glcd_line(8,46,6,46);
    glcd_line(7,45,6,45);
    glcd_line(10,35,10,35);
    glcd_line(18,24,17,23);
    glcd_line(17,24,16,23);
    glcd_line(18,23,17,22);
    glcd_line(29,16,29,16);
    glcd_line(41,14,41,12);
    glcd_line(40,13,40,12);
    glcd_line(42,13,42,12);
    glcd_line(53,16,53,16);
    glcd_line(64,24,65,23);
    glcd_line(64,23,65,22);
    glcd_line(65,24,66,23);
    glcd_line(72,35,72,35); 
    glcd_line(74,46,76,46);
    glcd_line(75,47,76,47);
    glcd_line(75,45,76,45);

    }

//     
void line_create (void)
    {
     glcd_setlinestyle(1,GLCD_LINE_SOLID);
     switch (rotate)
        {
        case 0:
        glcd_line(22,46,11,46);
        break;
        case 1:
        glcd_line(23,43,12,41);
        break;
        case 2:
        glcd_line(24,40,13,36);
        break;
        case 3:
        glcd_line(25,37,16,31);
        break;
        case 4:
        glcd_line(28,34,20,26);
        break;
        case 5:
        glcd_line(31,31,25,22);
        break;
        case 6:
        glcd_line(34,30,30,19);
        break;
        case 7:
        glcd_line(38,30,36,18);
        break;
        case 8:
        glcd_line(41,30,41,17);
        break;   
        case 9:
        glcd_line(44,30,46,18);
        break;
        case 10:
        glcd_line(48,30,52,19);                        
        break;
        case 11:
        glcd_line(51,31,57,22);
        break;
        case 12:
        glcd_line(54,34,62,26);
        break;
        case 13:
        glcd_line(57,37,66,31);
        break;
        case 14:
        glcd_line(58,40,69,36);
        break;
        case 15:
        glcd_line(59,43,70,41);
        break;
        case 16:
        glcd_line(60,46,71,46);
        break;                          
        default:
        glcd_line(65,40,65,47);
        glcd_line(64,40,64,46);
        glcd_line(66,40,66,46);
        glcd_line(62,44,68,44);
        glcd_line(63,45,67,45);
        break;            
        }
    }

//    
void line_clear(void)
    {
    glcd_setfont(NumberBig);
    switch (rotatePred)
            {
            case 0:
            glcd_outtextxyf(11,46,":");
            break;
            case 1:
            glcd_outtextxyf(12,41,":");
            break;
            case 2:
            glcd_outtextxyf(13,36,":");
            break;
            case 3:
            glcd_outtextxyf(16,31,":");
            break;
            case 4:
            glcd_outtextxyf(20,26,":");
            break;
            case 5:
            glcd_outtextxyf(25,22,":");
            break;
            case 6:
            glcd_outtextxyf(30,19,":");
            break;
            case 7:
            glcd_outtextxyf(36,18,":");
            break;
            case 8:
            glcd_outtextxyf(35,17,":");
            break;   
            case 9:
            glcd_outtextxyf(35,18,":");
            break;
            case 10:
            glcd_outtextxyf(40,19,":");
            break;
            case 11:
            glcd_outtextxyf(46,22,":");
            break;
            case 12:
            glcd_outtextxyf(51,26,":");
            break;
            case 13:
            glcd_outtextxyf(55,31,":");
            break;
            case 14:
            glcd_outtextxyf(58,36,":");
            break;
            case 15:
            glcd_outtextxyf(59,41,":");
            break;
            case 16:
            glcd_outtextxyf(60,46,":");
            break;
            default:
            glcd_outtextxyf(58,35,":");
            break;            
            }
    }

// 
void screen_reload (void)
    {
    //   
    if (set==0) rtc_get_time(&hour,&minut,&sec);

    if (sec==0 | reload==1)
        {
        switch (set)
            {
            case 0:
            sprintf(lcd_buffer,"%02d:%02d\n",hour,minut);
            glcd_setfont(Number);
            glcd_outtextxy(0,0,lcd_buffer);
            break;
            case 1:
            sprintf(lcd_buffer,"%02d\n",minut);
            glcd_setfont(Number);
            glcd_outtextxy(21,0,lcd_buffer);
            break;
            case 2:
            sprintf(lcd_buffer,"%02d\n",hour);
            glcd_setfont(Number);
            glcd_outtextxy(0,0,lcd_buffer);
            break;
            default:
            break; 
            }
        }


    if (reload==1)
            {
            //      
            if (set==0)
                {
                if (Flight==1) glcd_outtextxyf(4,9,")" );
                else glcd_outtextxyf(4,9,"-");
                if (Blight==1) glcd_outtextxyf(73,9,"(");
                else glcd_outtextxyf(73,9,"+");
                }
            }    
    sprintf(lcd_buffer,"%05d\n",run/100);
    glcd_setfont(Number);
    glcd_outtextxy(49,0,lcd_buffer); 
    }

void pause(unsigned int i) 
{
while (i) 
    {
    i--;
    };
}


void main(void)
{
// Declare your local variables here
//        
bit ping=0;

// Graphic LCD initialization data
GLCDINIT_t glcd_init_data;

// Input/Output Ports initialization
// Port A initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTA=0x00;
DDRA=0x00;

// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x00;

// Port C initialization
// Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=In Func1=In Func0=In 
// State7=P State6=P State5=P State4=T State3=0 State2=P State1=T State0=T 
PORTC=0xE4;
DDRC=0x08;

// Port D initialization
// Func7=Out Func6=In Func5=In Func4=Out Func3=In Func2=In Func1=In Func0=Out 
// State7=1 State6=P State5=T State4=1 State3=T State2=T State1=P State0=0 
PORTD=0xD2;
DDRD=0x91;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
// Mode: Normal top=0xFF
// OC0 output: Disconnected
TCCR0=0x00;
TCNT0=0x00;
OCR0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer1 Stopped
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Falling
// INT1: Off
// INT2: Off
GICR|=0x40;
MCUCR=0x02;
MCUCSR=0x00;
GIFR=0x40;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x00;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC disabled
ADCSRA=0x00;

// SPI initialization
// SPI disabled
SPCR=0x00;

// TWI initialization
// TWI disabled
TWCR=0x00;

// I2C Bus initialization
// I2C Port: PORTC
// I2C SDA bit: 0
// I2C SCL bit: 1
// Bit Rate: 100 kHz
// Note: I2C settings are specified in the
// Project|Configure|C Compiler|Libraries|I2C menu.
i2c_init();

// DS1307 Real Time Clock initialization
// Square wave output on pin SQW/OUT: On
// Square wave frequency: 1Hz
rtc_init(0,1,0);

// 1 Wire Bus initialization
// 1 Wire Data port: PORTA
// 1 Wire Data bit: 7
// Note: 1 Wire port settings are specified in the
// Project|Configure|C Compiler|Libraries|1 Wire menu.
//w1_init();

// Graphic LCD initialization
// The PCD8544 connections are specified in the
// Project|Configure|C Compiler|Libraries|Graphic LCD menu:
// SDIN - PORTB Bit 3
// SCLK - PORTB Bit 4
// D /C - PORTB Bit 2
// /SCE - PORTB Bit 1
// /RES - PORTB Bit 0

// Specify the current font for displaying text
//glcd_init_data.font=Rusfont;
glcd_init_data.font=Number;
glcd_init_data.font=NumberBig;
// No function is used for reading
// image data from external memory
glcd_init_data.readxmem=NULL;
// No function is used for writing
// image data to external memory
glcd_init_data.writexmem=NULL;
// Set the LCD temperature coefficient
glcd_init_data.temp_coef=PCD8544_DEFAULT_TEMP_COEF;
// Set the LCD bias
glcd_init_data.bias=PCD8544_DEFAULT_BIAS;
// Set the LCD contrast control voltage VLCD
glcd_init_data.vlcd=PCD8544_DEFAULT_VLCD;

glcd_init(&glcd_init_data);

// Global enable interrupts
#asm("sei")
/////////////////////////////////////////////////////////////////////
rtc_get_time(&hour,&minut,&sec);
if  (hour==0 & minut==0)
    {
    rtc_set_time(0,0,0);
    rtc_set_date(1,1,1,10);
    }
// 
screen();
reload=1;
// 
screen_reload();
///////////////////////////////////////////////////////////////////

while (1)
      {
      //       ds1307   if
      if (PINC.2==0) ping=1;
      if (PINC.2==1 & ping==1)
            {
            rotate=speed;
            if (rotate>99) rotate=99;
            speed=0;
            if (set==0)
                    {
                    if (rotatePred!=rotate)
                            {
                            //  
                            line_clear();
                            //   ,              
                            glcd_setfont(NumberBig);
                            if (rotatePred>9 & rotate<10) glcd_outtextxyf(28,34,"::");
                            sprintf(lcd_buffer,"%d)",rotate);
                            if (rotate<10)glcd_outtextxy(35,34,lcd_buffer);
                            else glcd_outtextxy(28,34,lcd_buffer);
                            //   Rotate 
                            rotatePred=rotate;
                            //  
                            line_create();
                            }
                    //     
                    screen_reload();
                    }
                        
            // -      
            if (light>0 & PINC.5==1 & PIND.6==1 & PINC.6==1) light=0;
                    
                
            //     20  
            if (set>0) 
                    {
                    temp++;
                    if (temp>20) set=0;
                    }

                        
            rotate=0;                
            ping=0;    
            }
            
      //                
      if (PINC.5==0 & light==0)
            {
            
            switch (set)
                {
                //         
                case 0:
                    light=1;
                    if (PIND.4==1)
                        {
                        PORTD.4=0;
                        Flight=1;                            
                        }
                    else
                        {
                        PORTD.4=1;
                        Flight=0;
                        }
                break;
                //       
                case 1:
                minut++;
                if (minut>59)minut=0;
                temp=0;
                pause(5000);
                break;
                case 2:
                hour++;
                if (hour>23)hour=0;
                temp=0;
                pause(5000);
                break;
                default:                
                break; 
                }
            // 
            reload=1;            
            screen_reload();
                      
            }

      //           
      if (PIND.6==0 & light==0)
            {
            switch (set)
                {
                case 0:
                //         
                    light=1;
                    if (PIND.7==1)
                        {
                        PORTD.7=0;
                        Blight=1;
                        }
                    else
                        {
                        PORTD.7=1;
                        Blight=0;
                        }                         
                break;
                //       
                case 1:
                if (minut==0)minut=60;
                minut--; 
                temp=0;
                pause(5000);
                break;
                case 2:
                if (hour==0)hour=24;
                hour--; 
                temp=0;
                pause(5000);
                break;
                default:                
                break; 
                }
            //     
            reload=1;
            screen_reload();      
            }
      //        , ,        
      if (PINC.7==0)
            {
            if (set!=0)rtc_set_time(hour,minut,sec);
            set=set+1;
            
            if (set>2) 
                {set=0;
                rotatePred=-1;
                }
            temp=0;
            if (set>0)
                {
                glcd_setfont(NumberBig);
                glcd_outtextxyf(28,34,"::");
                line_clear();
                glcd_setfont(Number);
                //    ,         
                if (set==1)glcd_outtextxyf(0,0,"  " );
                if (set==2)glcd_outtextxyf(21,0,"  " );
                }
                
                // 
            reload=1;
            screen_reload();
            pause(10000);
            }
      //              
      if (PINC.6==0 & light==0)
            {            
            if (PIND.0==1) PORTD.0=0;
            else PORTD.0=1;
            light=1;
            }
      if (PIND.1==0)
            {
            run=0;
            }
      }
}
