
;CodeVisionAVR C Compiler V2.05.3 Standard
;(C) Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega16A
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;Global 'const' stored in FLASH     : No
;Enhanced function parameter passing: Yes
;Enhanced core instructions         : On
;Smart register allocation          : On
;Automatic register allocation      : On

	#pragma AVRPART ADMIN PART_NAME ATmega16A
	#pragma AVRPART MEMORY PROG_FLASH 16384
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1119
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x045F
	.EQU __DSTACK_SIZE=0x0100
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _temp=R4
	.DEF _rotate=R6
	.DEF _rotatePred=R8
	.DEF _hour=R11
	.DEF _minut=R10
	.DEF _sec=R13

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  _ext_int0_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_NumberBig:
	.DB  0x0,0x10,0x30,0xB,0xC,0xC,0xC,0xC
	.DB  0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0
	.DB  0xF8,0xFE,0x6,0x3,0x83,0xC3,0x63,0x33
	.DB  0x1E,0xFE,0xF8,0x0,0x7,0x1F,0x1E,0x33
	.DB  0x31,0x30,0x30,0x30,0x18,0x1F,0x7,0x0
	.DB  0x0,0x0,0xC,0xC,0xE,0xFF,0xFF,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x30
	.DB  0x30,0x3F,0x3F,0x30,0x30,0x30,0x0,0x0
	.DB  0x1C,0x1E,0x7,0x3,0x3,0x83,0xC3,0xE3
	.DB  0x77,0x3E,0x1C,0x0,0x30,0x38,0x3C,0x3E
	.DB  0x37,0x33,0x31,0x30,0x30,0x30,0x30,0x0
	.DB  0xC,0xE,0x7,0xC3,0xC3,0xC3,0xC3,0xC3
	.DB  0xE7,0x7E,0x3C,0x0,0xC,0x1C,0x38,0x30
	.DB  0x30,0x30,0x30,0x30,0x39,0x1F,0xE,0x0
	.DB  0xC0,0xE0,0x70,0x38,0x1C,0xE,0x7,0xFF
	.DB  0xFF,0x0,0x0,0x0,0x3,0x3,0x3,0x3
	.DB  0x3,0x3,0x3,0x3F,0x3F,0x3,0x3,0x0
	.DB  0x3F,0x7F,0x63,0x63,0x63,0x63,0x63,0x63
	.DB  0xE3,0xC3,0x83,0x0,0xC,0x1C,0x38,0x30
	.DB  0x30,0x30,0x30,0x30,0x38,0x1F,0xF,0x0
	.DB  0xC0,0xF0,0xF8,0xDC,0xCE,0xC7,0xC3,0xC3
	.DB  0xC3,0x80,0x0,0x0,0xF,0x1F,0x39,0x30
	.DB  0x30,0x30,0x30,0x30,0x39,0x1F,0xF,0x0
	.DB  0x3,0x3,0x3,0x3,0x3,0x3,0xC3,0xF3
	.DB  0x3F,0xF,0x3,0x0,0x0,0x0,0x0,0x30
	.DB  0x3C,0xF,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xBC,0xFE,0xE7,0xC3,0xC3,0xC3,0xE7
	.DB  0xFE,0xBC,0x0,0x0,0xF,0x1F,0x39,0x30
	.DB  0x30,0x30,0x30,0x30,0x39,0x1F,0xF,0x0
	.DB  0x3C,0x7E,0xE7,0xC3,0xC3,0xC3,0xC3,0xC3
	.DB  0xE7,0xFE,0xFC,0x0,0x0,0x0,0x30,0x30
	.DB  0x30,0x38,0x1C,0xE,0x7,0x3,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0
_Number:
	.DB  0x6,0x8,0x20,0x21,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x6,0x5F,0x6,0x0
	.DB  0x0,0x7,0x3,0x0,0x7,0x3,0x0,0x24
	.DB  0x7E,0x24,0x7E,0x24,0x0,0x24,0x2B,0x6A
	.DB  0x12,0x0,0x0,0x63,0x13,0x8,0x64,0x63
	.DB  0x0,0x36,0x49,0x56,0x20,0x50,0x0,0x0
	.DB  0x0,0x7,0x5,0x7,0x1C,0x22,0x41,0x7F
	.DB  0x2A,0x49,0x49,0x2A,0x7F,0x41,0x22,0x1C
	.DB  0x0,0x8,0x3E,0x1C,0x3E,0x8,0x0,0x3C
	.DB  0x42,0x7E,0x0,0x0,0x0,0x0,0xE0,0x60
	.DB  0x0,0x0,0x0,0x0,0x7E,0x42,0x3C,0x0
	.DB  0x0,0x0,0x60,0x60,0x0,0x0,0x0,0x20
	.DB  0x10,0x8,0x4,0x2,0x0,0x3E,0x41,0x41
	.DB  0x41,0x3E,0x0,0x0,0x42,0x7F,0x40,0x0
	.DB  0x0,0x62,0x51,0x49,0x49,0x46,0x0,0x22
	.DB  0x49,0x49,0x49,0x36,0x0,0x18,0x14,0x12
	.DB  0x7F,0x10,0x0,0x2F,0x49,0x49,0x49,0x31
	.DB  0x0,0x3C,0x4A,0x49,0x49,0x30,0x0,0x1
	.DB  0x71,0x9,0x5,0x3,0x0,0x36,0x49,0x49
	.DB  0x49,0x36,0x0,0x6,0x49,0x49,0x29,0x1E
	.DB  0x0,0x0,0x6C,0x6C,0x0,0x0,0x0,0x0
	.DB  0xEC,0x6C,0x0,0x0,0x0,0x8,0x14,0x22
	.DB  0x41,0x0,0x0,0x24,0x24,0x24,0x24,0x24
	.DB  0x0,0x0,0x41,0x22,0x14,0x8,0x0,0x2
	.DB  0x1,0x59,0x9,0x6,0x0,0x3E,0x41,0x5D
	.DB  0x55,0x1E
__glcd_mask:
	.DB  0x0,0x1,0x3,0x7,0xF,0x1F,0x3F,0x7F
	.DB  0xFF
_tbl10_G105:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G105:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x84:
	.DB  0x0,0x0,0x0,0x0,0xFF,0xFF
_0x0:
	.DB  0x30,0x0,0x32,0x0,0x34,0x0,0x36,0x0
	.DB  0x38,0x0,0x31,0x0,0x3A,0x0,0x25,0x30
	.DB  0x32,0x64,0x3A,0x25,0x30,0x32,0x64,0xA
	.DB  0x0,0x29,0x0,0x2D,0x0,0x28,0x0,0x2B
	.DB  0x0,0x25,0x30,0x35,0x64,0xA,0x0,0x3A
	.DB  0x3A,0x0,0x25,0x64,0x29,0x0,0x20,0x20
	.DB  0x0
_0x2160060:
	.DB  0x1
_0x2160000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0,0x49,0x4E,0x46
	.DB  0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x06
	.DW  0x04
	.DW  _0x84*2

	.DW  0x01
	.DW  __seed_G10B
	.DW  _0x2160060*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.3 Standard
;Automatic Program Generator
; Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 14.03.2014
;Author  : PerTic@n
;Company : If You Like This Software,Buy It
;Comments:
;
;
;Chip type               : ATmega16A
;Program type            : Application
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 256
;*****************************************************/
;
;#include <mega16a.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;
;// I2C Bus functions
;#include <i2c.h>
;
;// DS1307 Real Time Clock functions
;#include <ds1307.h>
;
;// 1 Wire Bus interface functions
;//#include <1wire.h>
;
;//       ds18b20
;//#include <ds18b20.h>
;
;// Graphic LCD functions
;#include <glcd.h>
;
;// Font used for displaying text
;//        
;#include <NumberBig.h>
;//      c   
;#include <Number.h>
;//      ,    
;#include <stdio.h>
;
;
;//////////////////////////////////////////////////////////////////////////////////////
;
;//    
;//     
;char lcd_buffer[8];
;//       20  
;int temp=0;
;//      
;int rotate=0;
;// (  )   Rotate
;int rotatePred=-1;
;//    DS1307
;char hour, minut, sec;
;//day, month, year, week_day;
;//Reload=1     , ; Reload=0  
;bit reload=0;
;//Set=0 -  , Set=1 -  , Set=2 -  .
;int set=0;
;//  -
;bit Flight=0;
;//  -
;bit Blight=0;
;//        
;bit light=0;
;//   
;int speed=0;
;
;unsigned long int run=0;
;
;///////////////////////////////////////////////////////////////////////////////////////
;
;
;// External Interrupt 0 service routine
;interrupt [EXT_INT0] void ext_int0_isr(void)
; 0000 0054     {

	.CSEG
_ext_int0_isr:
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0055     // Place your code here
; 0000 0056     speed++;
	LDI  R26,LOW(_speed)
	LDI  R27,HIGH(_speed)
	CALL SUBOPT_0x0
; 0000 0057     run=run+26;
	LDS  R30,_run
	LDS  R31,_run+1
	LDS  R22,_run+2
	LDS  R23,_run+3
	__ADDD1N 26
	STS  _run,R30
	STS  _run+1,R31
	STS  _run+2,R22
	STS  _run+3,R23
; 0000 0058     }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R23,Y+
	LD   R22,Y+
	RETI
;
;void screen(void)
; 0000 005B     {
_screen:
; 0000 005C     //
; 0000 005D     glcd_setfont(Number);
	CALL SUBOPT_0x1
; 0000 005E     glcd_outtextxyf(0,37,"0");
	LDI  R30,LOW(37)
	ST   -Y,R30
	__POINTW2FN _0x0,0
	CALL _glcd_outtextxyf
; 0000 005F     glcd_outtextxyf(3,27,"2");
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDI  R30,LOW(27)
	ST   -Y,R30
	__POINTW2FN _0x0,2
	CALL _glcd_outtextxyf
; 0000 0060     glcd_outtextxyf(9,18,"4");
	LDI  R30,LOW(9)
	ST   -Y,R30
	LDI  R30,LOW(18)
	ST   -Y,R30
	__POINTW2FN _0x0,4
	CALL _glcd_outtextxyf
; 0000 0061     glcd_outtextxyf(22,10,"6");
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	__POINTW2FN _0x0,6
	CALL _glcd_outtextxyf
; 0000 0062     glcd_outtextxyf(38,4,"8");
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__POINTW2FN _0x0,8
	CALL _glcd_outtextxyf
; 0000 0063     glcd_outtextxyf(54,10,"1");
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(10)
	CALL SUBOPT_0x2
; 0000 0064     glcd_outtextxyf(59,10,"0");
	LDI  R30,LOW(59)
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	__POINTW2FN _0x0,0
	CALL _glcd_outtextxyf
; 0000 0065     glcd_outtextxyf(68,18,"1");
	LDI  R30,LOW(68)
	ST   -Y,R30
	LDI  R30,LOW(18)
	CALL SUBOPT_0x2
; 0000 0066     glcd_outtextxyf(73,18,"2");
	LDI  R30,LOW(73)
	ST   -Y,R30
	LDI  R30,LOW(18)
	ST   -Y,R30
	__POINTW2FN _0x0,2
	CALL _glcd_outtextxyf
; 0000 0067     glcd_outtextxyf(72,28,"1");
	LDI  R30,LOW(72)
	ST   -Y,R30
	LDI  R30,LOW(28)
	CALL SUBOPT_0x2
; 0000 0068     glcd_outtextxyf(77,28,"4");
	LDI  R30,LOW(77)
	ST   -Y,R30
	LDI  R30,LOW(28)
	ST   -Y,R30
	__POINTW2FN _0x0,4
	CALL _glcd_outtextxyf
; 0000 0069     glcd_setlinestyle(1,GLCD_LINE_SOLID);
	CALL SUBOPT_0x3
; 0000 006A     glcd_arc(41,47,0,180,32);
	LDI  R30,LOW(41)
	ST   -Y,R30
	LDI  R30,LOW(47)
	CALL SUBOPT_0x4
	LDI  R30,LOW(180)
	LDI  R31,HIGH(180)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(32)
	CALL _glcd_arc
; 0000 006B     glcd_line(7,47,6,47);
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(47)
	ST   -Y,R30
	LDI  R30,LOW(6)
	CALL SUBOPT_0x5
; 0000 006C     glcd_line(8,46,6,46);
	LDI  R30,LOW(8)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(6)
	CALL SUBOPT_0x6
; 0000 006D     glcd_line(7,45,6,45);
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(45)
	ST   -Y,R30
	LDI  R30,LOW(6)
	ST   -Y,R30
	LDI  R26,LOW(45)
	CALL _glcd_line
; 0000 006E     glcd_line(10,35,10,35);
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R26,LOW(35)
	CALL _glcd_line
; 0000 006F     glcd_line(18,24,17,23);
	LDI  R30,LOW(18)
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(17)
	CALL SUBOPT_0x7
; 0000 0070     glcd_line(17,24,16,23);
	LDI  R30,LOW(17)
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(16)
	CALL SUBOPT_0x7
; 0000 0071     glcd_line(18,23,17,22);
	LDI  R30,LOW(18)
	ST   -Y,R30
	LDI  R30,LOW(23)
	ST   -Y,R30
	LDI  R30,LOW(17)
	ST   -Y,R30
	LDI  R26,LOW(22)
	CALL _glcd_line
; 0000 0072     glcd_line(29,16,29,16);
	LDI  R30,LOW(29)
	ST   -Y,R30
	LDI  R30,LOW(16)
	ST   -Y,R30
	LDI  R30,LOW(29)
	ST   -Y,R30
	LDI  R26,LOW(16)
	CALL _glcd_line
; 0000 0073     glcd_line(41,14,41,12);
	LDI  R30,LOW(41)
	ST   -Y,R30
	LDI  R30,LOW(14)
	ST   -Y,R30
	LDI  R30,LOW(41)
	CALL SUBOPT_0x8
; 0000 0074     glcd_line(40,13,40,12);
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(13)
	ST   -Y,R30
	LDI  R30,LOW(40)
	CALL SUBOPT_0x8
; 0000 0075     glcd_line(42,13,42,12);
	LDI  R30,LOW(42)
	ST   -Y,R30
	LDI  R30,LOW(13)
	ST   -Y,R30
	LDI  R30,LOW(42)
	CALL SUBOPT_0x8
; 0000 0076     glcd_line(53,16,53,16);
	LDI  R30,LOW(53)
	ST   -Y,R30
	LDI  R30,LOW(16)
	ST   -Y,R30
	LDI  R30,LOW(53)
	ST   -Y,R30
	LDI  R26,LOW(16)
	CALL _glcd_line
; 0000 0077     glcd_line(64,24,65,23);
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(65)
	CALL SUBOPT_0x7
; 0000 0078     glcd_line(64,23,65,22);
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(23)
	ST   -Y,R30
	LDI  R30,LOW(65)
	ST   -Y,R30
	LDI  R26,LOW(22)
	CALL _glcd_line
; 0000 0079     glcd_line(65,24,66,23);
	LDI  R30,LOW(65)
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(66)
	CALL SUBOPT_0x7
; 0000 007A     glcd_line(72,35,72,35);
	LDI  R30,LOW(72)
	ST   -Y,R30
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(72)
	ST   -Y,R30
	LDI  R26,LOW(35)
	CALL _glcd_line
; 0000 007B     glcd_line(74,46,76,46);
	LDI  R30,LOW(74)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(76)
	CALL SUBOPT_0x6
; 0000 007C     glcd_line(75,47,76,47);
	LDI  R30,LOW(75)
	ST   -Y,R30
	LDI  R30,LOW(47)
	ST   -Y,R30
	LDI  R30,LOW(76)
	CALL SUBOPT_0x5
; 0000 007D     glcd_line(75,45,76,45);
	LDI  R30,LOW(75)
	ST   -Y,R30
	LDI  R30,LOW(45)
	ST   -Y,R30
	LDI  R30,LOW(76)
	ST   -Y,R30
	LDI  R26,LOW(45)
	CALL _glcd_line
; 0000 007E 
; 0000 007F     }
	RET
;
;//     
;void line_create (void)
; 0000 0083     {
_line_create:
; 0000 0084      glcd_setlinestyle(1,GLCD_LINE_SOLID);
	CALL SUBOPT_0x3
; 0000 0085      switch (rotate)
	MOVW R30,R6
; 0000 0086         {
; 0000 0087         case 0:
	SBIW R30,0
	BRNE _0x6
; 0000 0088         glcd_line(22,46,11,46);
	LDI  R30,LOW(22)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(11)
	ST   -Y,R30
	LDI  R26,LOW(46)
	RJMP _0x7D
; 0000 0089         break;
; 0000 008A         case 1:
_0x6:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x7
; 0000 008B         glcd_line(23,43,12,41);
	LDI  R30,LOW(23)
	ST   -Y,R30
	LDI  R30,LOW(43)
	ST   -Y,R30
	LDI  R30,LOW(12)
	ST   -Y,R30
	LDI  R26,LOW(41)
	RJMP _0x7D
; 0000 008C         break;
; 0000 008D         case 2:
_0x7:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x8
; 0000 008E         glcd_line(24,40,13,36);
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(13)
	ST   -Y,R30
	LDI  R26,LOW(36)
	RJMP _0x7D
; 0000 008F         break;
; 0000 0090         case 3:
_0x8:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x9
; 0000 0091         glcd_line(25,37,16,31);
	LDI  R30,LOW(25)
	ST   -Y,R30
	LDI  R30,LOW(37)
	ST   -Y,R30
	LDI  R30,LOW(16)
	ST   -Y,R30
	LDI  R26,LOW(31)
	RJMP _0x7D
; 0000 0092         break;
; 0000 0093         case 4:
_0x9:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0xA
; 0000 0094         glcd_line(28,34,20,26);
	CALL SUBOPT_0x9
	LDI  R30,LOW(20)
	ST   -Y,R30
	LDI  R26,LOW(26)
	RJMP _0x7D
; 0000 0095         break;
; 0000 0096         case 5:
_0xA:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0xB
; 0000 0097         glcd_line(31,31,25,22);
	LDI  R30,LOW(31)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R30,LOW(25)
	ST   -Y,R30
	LDI  R26,LOW(22)
	RJMP _0x7D
; 0000 0098         break;
; 0000 0099         case 6:
_0xB:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0xC
; 0000 009A         glcd_line(34,30,30,19);
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R26,LOW(19)
	RJMP _0x7D
; 0000 009B         break;
; 0000 009C         case 7:
_0xC:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0xD
; 0000 009D         glcd_line(38,30,36,18);
	LDI  R30,LOW(38)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(36)
	ST   -Y,R30
	LDI  R26,LOW(18)
	RJMP _0x7D
; 0000 009E         break;
; 0000 009F         case 8:
_0xD:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0xE
; 0000 00A0         glcd_line(41,30,41,17);
	LDI  R30,LOW(41)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(41)
	ST   -Y,R30
	LDI  R26,LOW(17)
	RJMP _0x7D
; 0000 00A1         break;
; 0000 00A2         case 9:
_0xE:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0xF
; 0000 00A3         glcd_line(44,30,46,18);
	LDI  R30,LOW(44)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R26,LOW(18)
	RJMP _0x7D
; 0000 00A4         break;
; 0000 00A5         case 10:
_0xF:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x10
; 0000 00A6         glcd_line(48,30,52,19);
	LDI  R30,LOW(48)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(52)
	ST   -Y,R30
	LDI  R26,LOW(19)
	RJMP _0x7D
; 0000 00A7         break;
; 0000 00A8         case 11:
_0x10:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x11
; 0000 00A9         glcd_line(51,31,57,22);
	LDI  R30,LOW(51)
	ST   -Y,R30
	LDI  R30,LOW(31)
	ST   -Y,R30
	LDI  R30,LOW(57)
	ST   -Y,R30
	LDI  R26,LOW(22)
	RJMP _0x7D
; 0000 00AA         break;
; 0000 00AB         case 12:
_0x11:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x12
; 0000 00AC         glcd_line(54,34,62,26);
	LDI  R30,LOW(54)
	ST   -Y,R30
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R26,LOW(26)
	RJMP _0x7D
; 0000 00AD         break;
; 0000 00AE         case 13:
_0x12:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x13
; 0000 00AF         glcd_line(57,37,66,31);
	LDI  R30,LOW(57)
	ST   -Y,R30
	LDI  R30,LOW(37)
	ST   -Y,R30
	LDI  R30,LOW(66)
	ST   -Y,R30
	LDI  R26,LOW(31)
	RJMP _0x7D
; 0000 00B0         break;
; 0000 00B1         case 14:
_0x13:
	CPI  R30,LOW(0xE)
	LDI  R26,HIGH(0xE)
	CPC  R31,R26
	BRNE _0x14
; 0000 00B2         glcd_line(58,40,69,36);
	LDI  R30,LOW(58)
	ST   -Y,R30
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(69)
	ST   -Y,R30
	LDI  R26,LOW(36)
	RJMP _0x7D
; 0000 00B3         break;
; 0000 00B4         case 15:
_0x14:
	CPI  R30,LOW(0xF)
	LDI  R26,HIGH(0xF)
	CPC  R31,R26
	BRNE _0x15
; 0000 00B5         glcd_line(59,43,70,41);
	LDI  R30,LOW(59)
	ST   -Y,R30
	LDI  R30,LOW(43)
	ST   -Y,R30
	LDI  R30,LOW(70)
	ST   -Y,R30
	LDI  R26,LOW(41)
	RJMP _0x7D
; 0000 00B6         break;
; 0000 00B7         case 16:
_0x15:
	CPI  R30,LOW(0x10)
	LDI  R26,HIGH(0x10)
	CPC  R31,R26
	BRNE _0x17
; 0000 00B8         glcd_line(60,46,71,46);
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(71)
	ST   -Y,R30
	LDI  R26,LOW(46)
	RJMP _0x7D
; 0000 00B9         break;
; 0000 00BA         default:
_0x17:
; 0000 00BB         glcd_line(65,40,65,47);
	LDI  R30,LOW(65)
	ST   -Y,R30
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(65)
	CALL SUBOPT_0x5
; 0000 00BC         glcd_line(64,40,64,46);
	LDI  R30,LOW(64)
	ST   -Y,R30
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(64)
	CALL SUBOPT_0x6
; 0000 00BD         glcd_line(66,40,66,46);
	LDI  R30,LOW(66)
	ST   -Y,R30
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(66)
	CALL SUBOPT_0x6
; 0000 00BE         glcd_line(62,44,68,44);
	LDI  R30,LOW(62)
	ST   -Y,R30
	LDI  R30,LOW(44)
	ST   -Y,R30
	LDI  R30,LOW(68)
	ST   -Y,R30
	LDI  R26,LOW(44)
	CALL _glcd_line
; 0000 00BF         glcd_line(63,45,67,45);
	LDI  R30,LOW(63)
	ST   -Y,R30
	LDI  R30,LOW(45)
	ST   -Y,R30
	LDI  R30,LOW(67)
	ST   -Y,R30
	LDI  R26,LOW(45)
_0x7D:
	CALL _glcd_line
; 0000 00C0         break;
; 0000 00C1         }
; 0000 00C2     }
	RET
;
;//    
;void line_clear(void)
; 0000 00C6     {
_line_clear:
; 0000 00C7     glcd_setfont(NumberBig);
	CALL SUBOPT_0xA
; 0000 00C8     switch (rotatePred)
	MOVW R30,R8
; 0000 00C9             {
; 0000 00CA             case 0:
	SBIW R30,0
	BRNE _0x1B
; 0000 00CB             glcd_outtextxyf(11,46,":");
	LDI  R30,LOW(11)
	ST   -Y,R30
	LDI  R30,LOW(46)
	RJMP _0x7E
; 0000 00CC             break;
; 0000 00CD             case 1:
_0x1B:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x1C
; 0000 00CE             glcd_outtextxyf(12,41,":");
	LDI  R30,LOW(12)
	ST   -Y,R30
	LDI  R30,LOW(41)
	RJMP _0x7E
; 0000 00CF             break;
; 0000 00D0             case 2:
_0x1C:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x1D
; 0000 00D1             glcd_outtextxyf(13,36,":");
	LDI  R30,LOW(13)
	ST   -Y,R30
	LDI  R30,LOW(36)
	RJMP _0x7E
; 0000 00D2             break;
; 0000 00D3             case 3:
_0x1D:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x1E
; 0000 00D4             glcd_outtextxyf(16,31,":");
	LDI  R30,LOW(16)
	ST   -Y,R30
	LDI  R30,LOW(31)
	RJMP _0x7E
; 0000 00D5             break;
; 0000 00D6             case 4:
_0x1E:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x1F
; 0000 00D7             glcd_outtextxyf(20,26,":");
	LDI  R30,LOW(20)
	ST   -Y,R30
	LDI  R30,LOW(26)
	RJMP _0x7E
; 0000 00D8             break;
; 0000 00D9             case 5:
_0x1F:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x20
; 0000 00DA             glcd_outtextxyf(25,22,":");
	LDI  R30,LOW(25)
	ST   -Y,R30
	LDI  R30,LOW(22)
	RJMP _0x7E
; 0000 00DB             break;
; 0000 00DC             case 6:
_0x20:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x21
; 0000 00DD             glcd_outtextxyf(30,19,":");
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R30,LOW(19)
	RJMP _0x7E
; 0000 00DE             break;
; 0000 00DF             case 7:
_0x21:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0x22
; 0000 00E0             glcd_outtextxyf(36,18,":");
	LDI  R30,LOW(36)
	ST   -Y,R30
	LDI  R30,LOW(18)
	RJMP _0x7E
; 0000 00E1             break;
; 0000 00E2             case 8:
_0x22:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x23
; 0000 00E3             glcd_outtextxyf(35,17,":");
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(17)
	RJMP _0x7E
; 0000 00E4             break;
; 0000 00E5             case 9:
_0x23:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0x24
; 0000 00E6             glcd_outtextxyf(35,18,":");
	LDI  R30,LOW(35)
	ST   -Y,R30
	LDI  R30,LOW(18)
	RJMP _0x7E
; 0000 00E7             break;
; 0000 00E8             case 10:
_0x24:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x25
; 0000 00E9             glcd_outtextxyf(40,19,":");
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(19)
	RJMP _0x7E
; 0000 00EA             break;
; 0000 00EB             case 11:
_0x25:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x26
; 0000 00EC             glcd_outtextxyf(46,22,":");
	LDI  R30,LOW(46)
	ST   -Y,R30
	LDI  R30,LOW(22)
	RJMP _0x7E
; 0000 00ED             break;
; 0000 00EE             case 12:
_0x26:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x27
; 0000 00EF             glcd_outtextxyf(51,26,":");
	LDI  R30,LOW(51)
	ST   -Y,R30
	LDI  R30,LOW(26)
	RJMP _0x7E
; 0000 00F0             break;
; 0000 00F1             case 13:
_0x27:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x28
; 0000 00F2             glcd_outtextxyf(55,31,":");
	LDI  R30,LOW(55)
	ST   -Y,R30
	LDI  R30,LOW(31)
	RJMP _0x7E
; 0000 00F3             break;
; 0000 00F4             case 14:
_0x28:
	CPI  R30,LOW(0xE)
	LDI  R26,HIGH(0xE)
	CPC  R31,R26
	BRNE _0x29
; 0000 00F5             glcd_outtextxyf(58,36,":");
	LDI  R30,LOW(58)
	ST   -Y,R30
	LDI  R30,LOW(36)
	RJMP _0x7E
; 0000 00F6             break;
; 0000 00F7             case 15:
_0x29:
	CPI  R30,LOW(0xF)
	LDI  R26,HIGH(0xF)
	CPC  R31,R26
	BRNE _0x2A
; 0000 00F8             glcd_outtextxyf(59,41,":");
	LDI  R30,LOW(59)
	ST   -Y,R30
	LDI  R30,LOW(41)
	RJMP _0x7E
; 0000 00F9             break;
; 0000 00FA             case 16:
_0x2A:
	CPI  R30,LOW(0x10)
	LDI  R26,HIGH(0x10)
	CPC  R31,R26
	BRNE _0x2C
; 0000 00FB             glcd_outtextxyf(60,46,":");
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(46)
	RJMP _0x7E
; 0000 00FC             break;
; 0000 00FD             default:
_0x2C:
; 0000 00FE             glcd_outtextxyf(58,35,":");
	LDI  R30,LOW(58)
	ST   -Y,R30
	LDI  R30,LOW(35)
_0x7E:
	ST   -Y,R30
	__POINTW2FN _0x0,12
	CALL _glcd_outtextxyf
; 0000 00FF             break;
; 0000 0100             }
; 0000 0101     }
	RET
;
;// 
;void screen_reload (void)
; 0000 0105     {
_screen_reload:
; 0000 0106     //   
; 0000 0107     if (set==0) rtc_get_time(&hour,&minut,&sec);
	CALL SUBOPT_0xB
	BRNE _0x2D
	CALL SUBOPT_0xC
; 0000 0108 
; 0000 0109     if (sec==0 | reload==1)
_0x2D:
	MOV  R26,R13
	CALL SUBOPT_0xD
	LDI  R26,0
	SBRC R2,0
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	OR   R30,R0
	BREQ _0x2E
; 0000 010A         {
; 0000 010B         switch (set)
	CALL SUBOPT_0xB
; 0000 010C             {
; 0000 010D             case 0:
	BRNE _0x32
; 0000 010E             sprintf(lcd_buffer,"%02d:%02d\n",hour,minut);
	CALL SUBOPT_0xE
	__POINTW1FN _0x0,14
	CALL SUBOPT_0xF
	CALL SUBOPT_0x10
	LDI  R24,8
	CALL _sprintf
	ADIW R28,12
; 0000 010F             glcd_setfont(Number);
	CALL SUBOPT_0x1
; 0000 0110             glcd_outtextxy(0,0,lcd_buffer);
	CALL SUBOPT_0x11
; 0000 0111             break;
	RJMP _0x31
; 0000 0112             case 1:
_0x32:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x33
; 0000 0113             sprintf(lcd_buffer,"%02d\n",minut);
	CALL SUBOPT_0xE
	__POINTW1FN _0x0,19
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x10
	CALL SUBOPT_0x12
; 0000 0114             glcd_setfont(Number);
	CALL SUBOPT_0x13
; 0000 0115             glcd_outtextxy(21,0,lcd_buffer);
	LDI  R30,LOW(21)
	ST   -Y,R30
	CALL SUBOPT_0x11
; 0000 0116             break;
	RJMP _0x31
; 0000 0117             case 2:
_0x33:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x35
; 0000 0118             sprintf(lcd_buffer,"%02d\n",hour);
	CALL SUBOPT_0xE
	__POINTW1FN _0x0,19
	CALL SUBOPT_0xF
	CALL SUBOPT_0x12
; 0000 0119             glcd_setfont(Number);
	CALL SUBOPT_0x1
; 0000 011A             glcd_outtextxy(0,0,lcd_buffer);
	CALL SUBOPT_0x11
; 0000 011B             break;
; 0000 011C             default:
_0x35:
; 0000 011D             break;
; 0000 011E             }
_0x31:
; 0000 011F         }
; 0000 0120 
; 0000 0121 
; 0000 0122     if (reload==1)
_0x2E:
	SBRS R2,0
	RJMP _0x36
; 0000 0123             {
; 0000 0124             //      
; 0000 0125             if (set==0)
	CALL SUBOPT_0xB
	BRNE _0x37
; 0000 0126                 {
; 0000 0127                 if (Flight==1) glcd_outtextxyf(4,9,")" );
	SBRS R2,1
	RJMP _0x38
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(9)
	ST   -Y,R30
	__POINTW2FN _0x0,25
	RJMP _0x7F
; 0000 0128                 else glcd_outtextxyf(4,9,"-");
_0x38:
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(9)
	ST   -Y,R30
	__POINTW2FN _0x0,27
_0x7F:
	CALL _glcd_outtextxyf
; 0000 0129                 if (Blight==1) glcd_outtextxyf(73,9,"(");
	SBRS R2,2
	RJMP _0x3A
	LDI  R30,LOW(73)
	ST   -Y,R30
	LDI  R30,LOW(9)
	ST   -Y,R30
	__POINTW2FN _0x0,29
	RJMP _0x80
; 0000 012A                 else glcd_outtextxyf(73,9,"+");
_0x3A:
	LDI  R30,LOW(73)
	ST   -Y,R30
	LDI  R30,LOW(9)
	ST   -Y,R30
	__POINTW2FN _0x0,31
_0x80:
	CALL _glcd_outtextxyf
; 0000 012B                 }
; 0000 012C             }
_0x37:
; 0000 012D     sprintf(lcd_buffer,"%05d\n",run/100);
_0x36:
	CALL SUBOPT_0xE
	__POINTW1FN _0x0,33
	ST   -Y,R31
	ST   -Y,R30
	LDS  R26,_run
	LDS  R27,_run+1
	LDS  R24,_run+2
	LDS  R25,_run+3
	__GETD1N 0x64
	CALL __DIVD21U
	CALL __PUTPARD1
	CALL SUBOPT_0x12
; 0000 012E     glcd_setfont(Number);
	CALL SUBOPT_0x13
; 0000 012F     glcd_outtextxy(49,0,lcd_buffer);
	LDI  R30,LOW(49)
	ST   -Y,R30
	CALL SUBOPT_0x11
; 0000 0130     }
	RET
;
;void pause(unsigned int i)
; 0000 0133 {
_pause:
; 0000 0134 while (i)
	ST   -Y,R27
	ST   -Y,R26
;	i -> Y+0
_0x3C:
	LD   R30,Y
	LDD  R31,Y+1
	SBIW R30,0
	BREQ _0x3E
; 0000 0135     {
; 0000 0136     i--;
	SBIW R30,1
	ST   Y,R30
	STD  Y+1,R31
; 0000 0137     };
	RJMP _0x3C
_0x3E:
; 0000 0138 }
	ADIW R28,2
	RET
;
;
;void main(void)
; 0000 013C {
_main:
; 0000 013D // Declare your local variables here
; 0000 013E //        
; 0000 013F bit ping=0;
; 0000 0140 
; 0000 0141 // Graphic LCD initialization data
; 0000 0142 GLCDINIT_t glcd_init_data;
; 0000 0143 
; 0000 0144 // Input/Output Ports initialization
; 0000 0145 // Port A initialization
; 0000 0146 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0147 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0148 PORTA=0x00;
	SBIW R28,8
;	ping -> R15.0
;	glcd_init_data -> Y+0
	CLR  R15
	LDI  R30,LOW(0)
	OUT  0x1B,R30
; 0000 0149 DDRA=0x00;
	OUT  0x1A,R30
; 0000 014A 
; 0000 014B // Port B initialization
; 0000 014C // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 014D // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 014E PORTB=0x00;
	OUT  0x18,R30
; 0000 014F DDRB=0x00;
	OUT  0x17,R30
; 0000 0150 
; 0000 0151 // Port C initialization
; 0000 0152 // Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=In Func1=In Func0=In
; 0000 0153 // State7=P State6=P State5=P State4=T State3=0 State2=P State1=T State0=T
; 0000 0154 PORTC=0xE4;
	LDI  R30,LOW(228)
	OUT  0x15,R30
; 0000 0155 DDRC=0x08;
	LDI  R30,LOW(8)
	OUT  0x14,R30
; 0000 0156 
; 0000 0157 // Port D initialization
; 0000 0158 // Func7=Out Func6=In Func5=In Func4=Out Func3=In Func2=In Func1=In Func0=Out
; 0000 0159 // State7=1 State6=P State5=T State4=1 State3=T State2=T State1=P State0=0
; 0000 015A PORTD=0xD2;
	LDI  R30,LOW(210)
	OUT  0x12,R30
; 0000 015B DDRD=0x91;
	LDI  R30,LOW(145)
	OUT  0x11,R30
; 0000 015C 
; 0000 015D // Timer/Counter 0 initialization
; 0000 015E // Clock source: System Clock
; 0000 015F // Clock value: Timer 0 Stopped
; 0000 0160 // Mode: Normal top=0xFF
; 0000 0161 // OC0 output: Disconnected
; 0000 0162 TCCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x33,R30
; 0000 0163 TCNT0=0x00;
	OUT  0x32,R30
; 0000 0164 OCR0=0x00;
	OUT  0x3C,R30
; 0000 0165 
; 0000 0166 // Timer/Counter 1 initialization
; 0000 0167 // Clock source: System Clock
; 0000 0168 // Clock value: Timer1 Stopped
; 0000 0169 // Mode: Normal top=0xFFFF
; 0000 016A // OC1A output: Discon.
; 0000 016B // OC1B output: Discon.
; 0000 016C // Noise Canceler: Off
; 0000 016D // Input Capture on Falling Edge
; 0000 016E // Timer1 Overflow Interrupt: Off
; 0000 016F // Input Capture Interrupt: Off
; 0000 0170 // Compare A Match Interrupt: Off
; 0000 0171 // Compare B Match Interrupt: Off
; 0000 0172 TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 0173 TCCR1B=0x00;
	OUT  0x2E,R30
; 0000 0174 TCNT1H=0x00;
	OUT  0x2D,R30
; 0000 0175 TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 0176 ICR1H=0x00;
	OUT  0x27,R30
; 0000 0177 ICR1L=0x00;
	OUT  0x26,R30
; 0000 0178 OCR1AH=0x00;
	OUT  0x2B,R30
; 0000 0179 OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 017A OCR1BH=0x00;
	OUT  0x29,R30
; 0000 017B OCR1BL=0x00;
	OUT  0x28,R30
; 0000 017C 
; 0000 017D // Timer/Counter 2 initialization
; 0000 017E // Clock source: System Clock
; 0000 017F // Clock value: Timer2 Stopped
; 0000 0180 // Mode: Normal top=0xFF
; 0000 0181 // OC2 output: Disconnected
; 0000 0182 ASSR=0x00;
	OUT  0x22,R30
; 0000 0183 TCCR2=0x00;
	OUT  0x25,R30
; 0000 0184 TCNT2=0x00;
	OUT  0x24,R30
; 0000 0185 OCR2=0x00;
	OUT  0x23,R30
; 0000 0186 
; 0000 0187 // External Interrupt(s) initialization
; 0000 0188 // INT0: On
; 0000 0189 // INT0 Mode: Falling
; 0000 018A // INT1: Off
; 0000 018B // INT2: Off
; 0000 018C GICR|=0x40;
	IN   R30,0x3B
	ORI  R30,0x40
	OUT  0x3B,R30
; 0000 018D MCUCR=0x02;
	LDI  R30,LOW(2)
	OUT  0x35,R30
; 0000 018E MCUCSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x34,R30
; 0000 018F GIFR=0x40;
	LDI  R30,LOW(64)
	OUT  0x3A,R30
; 0000 0190 
; 0000 0191 // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 0192 TIMSK=0x00;
	LDI  R30,LOW(0)
	OUT  0x39,R30
; 0000 0193 
; 0000 0194 // USART initialization
; 0000 0195 // USART disabled
; 0000 0196 UCSRB=0x00;
	OUT  0xA,R30
; 0000 0197 
; 0000 0198 // Analog Comparator initialization
; 0000 0199 // Analog Comparator: Off
; 0000 019A // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 019B ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 019C SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 019D 
; 0000 019E // ADC initialization
; 0000 019F // ADC disabled
; 0000 01A0 ADCSRA=0x00;
	OUT  0x6,R30
; 0000 01A1 
; 0000 01A2 // SPI initialization
; 0000 01A3 // SPI disabled
; 0000 01A4 SPCR=0x00;
	OUT  0xD,R30
; 0000 01A5 
; 0000 01A6 // TWI initialization
; 0000 01A7 // TWI disabled
; 0000 01A8 TWCR=0x00;
	OUT  0x36,R30
; 0000 01A9 
; 0000 01AA // I2C Bus initialization
; 0000 01AB // I2C Port: PORTC
; 0000 01AC // I2C SDA bit: 0
; 0000 01AD // I2C SCL bit: 1
; 0000 01AE // Bit Rate: 100 kHz
; 0000 01AF // Note: I2C settings are specified in the
; 0000 01B0 // Project|Configure|C Compiler|Libraries|I2C menu.
; 0000 01B1 i2c_init();
	CALL _i2c_init
; 0000 01B2 
; 0000 01B3 // DS1307 Real Time Clock initialization
; 0000 01B4 // Square wave output on pin SQW/OUT: On
; 0000 01B5 // Square wave frequency: 1Hz
; 0000 01B6 rtc_init(0,1,0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _rtc_init
; 0000 01B7 
; 0000 01B8 // 1 Wire Bus initialization
; 0000 01B9 // 1 Wire Data port: PORTA
; 0000 01BA // 1 Wire Data bit: 7
; 0000 01BB // Note: 1 Wire port settings are specified in the
; 0000 01BC // Project|Configure|C Compiler|Libraries|1 Wire menu.
; 0000 01BD //w1_init();
; 0000 01BE 
; 0000 01BF // Graphic LCD initialization
; 0000 01C0 // The PCD8544 connections are specified in the
; 0000 01C1 // Project|Configure|C Compiler|Libraries|Graphic LCD menu:
; 0000 01C2 // SDIN - PORTB Bit 3
; 0000 01C3 // SCLK - PORTB Bit 4
; 0000 01C4 // D /C - PORTB Bit 2
; 0000 01C5 // /SCE - PORTB Bit 1
; 0000 01C6 // /RES - PORTB Bit 0
; 0000 01C7 
; 0000 01C8 // Specify the current font for displaying text
; 0000 01C9 //glcd_init_data.font=Rusfont;
; 0000 01CA glcd_init_data.font=Number;
	LDI  R30,LOW(_Number*2)
	LDI  R31,HIGH(_Number*2)
	ST   Y,R30
	STD  Y+1,R31
; 0000 01CB glcd_init_data.font=NumberBig;
	LDI  R30,LOW(_NumberBig*2)
	LDI  R31,HIGH(_NumberBig*2)
	ST   Y,R30
	STD  Y+1,R31
; 0000 01CC // No function is used for reading
; 0000 01CD // image data from external memory
; 0000 01CE glcd_init_data.readxmem=NULL;
	LDI  R30,LOW(0)
	STD  Y+2,R30
	STD  Y+2+1,R30
; 0000 01CF // No function is used for writing
; 0000 01D0 // image data to external memory
; 0000 01D1 glcd_init_data.writexmem=NULL;
	STD  Y+4,R30
	STD  Y+4+1,R30
; 0000 01D2 // Set the LCD temperature coefficient
; 0000 01D3 glcd_init_data.temp_coef=PCD8544_DEFAULT_TEMP_COEF;
	LDD  R30,Y+6
	ANDI R30,LOW(0xFC)
	STD  Y+6,R30
; 0000 01D4 // Set the LCD bias
; 0000 01D5 glcd_init_data.bias=PCD8544_DEFAULT_BIAS;
	ANDI R30,LOW(0xE3)
	ORI  R30,LOW(0xC)
	STD  Y+6,R30
; 0000 01D6 // Set the LCD contrast control voltage VLCD
; 0000 01D7 glcd_init_data.vlcd=PCD8544_DEFAULT_VLCD;
	LDD  R30,Y+7
	ANDI R30,LOW(0x80)
	ORI  R30,LOW(0x32)
	STD  Y+7,R30
; 0000 01D8 
; 0000 01D9 glcd_init(&glcd_init_data);
	MOVW R26,R28
	RCALL _glcd_init
; 0000 01DA 
; 0000 01DB // Global enable interrupts
; 0000 01DC #asm("sei")
	sei
; 0000 01DD /////////////////////////////////////////////////////////////////////
; 0000 01DE rtc_get_time(&hour,&minut,&sec);
	CALL SUBOPT_0xC
; 0000 01DF if  (hour==0 & minut==0)
	MOV  R26,R11
	CALL SUBOPT_0xD
	MOV  R26,R10
	CALL SUBOPT_0x14
	BREQ _0x3F
; 0000 01E0     {
; 0000 01E1     rtc_set_time(0,0,0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _rtc_set_time
; 0000 01E2     rtc_set_date(1,1,1,10);
	LDI  R30,LOW(1)
	ST   -Y,R30
	ST   -Y,R30
	ST   -Y,R30
	LDI  R26,LOW(10)
	RCALL _rtc_set_date
; 0000 01E3     }
; 0000 01E4 // 
; 0000 01E5 screen();
_0x3F:
	RCALL _screen
; 0000 01E6 reload=1;
	CALL SUBOPT_0x15
; 0000 01E7 // 
; 0000 01E8 screen_reload();
; 0000 01E9 ///////////////////////////////////////////////////////////////////
; 0000 01EA 
; 0000 01EB while (1)
_0x40:
; 0000 01EC       {
; 0000 01ED       //       ds1307   if
; 0000 01EE       if (PINC.2==0) ping=1;
	SBIC 0x13,2
	RJMP _0x43
	SET
	BLD  R15,0
; 0000 01EF       if (PINC.2==1 & ping==1)
_0x43:
	LDI  R26,0
	SBIC 0x13,2
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	MOV  R0,R30
	LDI  R26,0
	SBRC R15,0
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	AND  R30,R0
	BRNE PC+3
	JMP _0x44
; 0000 01F0             {
; 0000 01F1             rotate=speed;
	__GETWRMN 6,7,0,_speed
; 0000 01F2             if (rotate>99) rotate=99;
	LDI  R30,LOW(99)
	LDI  R31,HIGH(99)
	CP   R30,R6
	CPC  R31,R7
	BRGE _0x45
	MOVW R6,R30
; 0000 01F3             speed=0;
_0x45:
	LDI  R30,LOW(0)
	STS  _speed,R30
	STS  _speed+1,R30
; 0000 01F4             if (set==0)
	CALL SUBOPT_0xB
	BRNE _0x46
; 0000 01F5                     {
; 0000 01F6                     if (rotatePred!=rotate)
	__CPWRR 6,7,8,9
	BREQ _0x47
; 0000 01F7                             {
; 0000 01F8                             //  
; 0000 01F9                             line_clear();
	RCALL _line_clear
; 0000 01FA                             //   ,  
; 0000 01FB                             glcd_setfont(NumberBig);
	CALL SUBOPT_0xA
; 0000 01FC                             if (rotatePred>9 & rotate<10) glcd_outtextxyf(28,34,"::");
	MOVW R26,R8
	LDI  R30,LOW(9)
	LDI  R31,HIGH(9)
	CALL __GTW12
	MOV  R0,R30
	MOVW R26,R6
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __LTW12
	AND  R30,R0
	BREQ _0x48
	CALL SUBOPT_0x9
	__POINTW2FN _0x0,39
	CALL _glcd_outtextxyf
; 0000 01FD                             sprintf(lcd_buffer,"%d)",rotate);
_0x48:
	CALL SUBOPT_0xE
	__POINTW1FN _0x0,42
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R6
	CALL __CWD1
	CALL __PUTPARD1
	CALL SUBOPT_0x12
; 0000 01FE                             if (rotate<10)glcd_outtextxy(35,34,lcd_buffer);
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CP   R6,R30
	CPC  R7,R31
	BRGE _0x49
	LDI  R30,LOW(35)
	RJMP _0x81
; 0000 01FF                             else glcd_outtextxy(28,34,lcd_buffer);
_0x49:
	LDI  R30,LOW(28)
_0x81:
	ST   -Y,R30
	LDI  R30,LOW(34)
	ST   -Y,R30
	LDI  R26,LOW(_lcd_buffer)
	LDI  R27,HIGH(_lcd_buffer)
	CALL _glcd_outtextxy
; 0000 0200                             //   Rotate
; 0000 0201                             rotatePred=rotate;
	MOVW R8,R6
; 0000 0202                             //  
; 0000 0203                             line_create();
	RCALL _line_create
; 0000 0204                             }
; 0000 0205                     // 
; 0000 0206                     screen_reload();
_0x47:
	RCALL _screen_reload
; 0000 0207                     }
; 0000 0208 
; 0000 0209             // -      
; 0000 020A             if (light>0 & PINC.5==1 & PIND.6==1 & PINC.6==1) light=0;
_0x46:
	LDI  R26,0
	SBRC R2,3
	LDI  R26,1
	LDI  R30,LOW(0)
	CALL __GTB12U
	MOV  R0,R30
	LDI  R26,0
	SBIC 0x13,5
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	AND  R0,R30
	LDI  R26,0
	SBIC 0x10,6
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	AND  R0,R30
	LDI  R26,0
	SBIC 0x13,6
	LDI  R26,1
	LDI  R30,LOW(1)
	CALL __EQB12
	AND  R30,R0
	BREQ _0x4B
	CLT
	BLD  R2,3
; 0000 020B 
; 0000 020C 
; 0000 020D             //     20  
; 0000 020E             if (set>0)
_0x4B:
	CALL SUBOPT_0x16
	CALL __CPW02
	BRGE _0x4C
; 0000 020F                     {
; 0000 0210                     temp++;
	MOVW R30,R4
	ADIW R30,1
	MOVW R4,R30
; 0000 0211                     if (temp>20) set=0;
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	CP   R30,R4
	CPC  R31,R5
	BRGE _0x4D
	LDI  R30,LOW(0)
	STS  _set,R30
	STS  _set+1,R30
; 0000 0212                     }
_0x4D:
; 0000 0213 
; 0000 0214 
; 0000 0215             rotate=0;
_0x4C:
	CLR  R6
	CLR  R7
; 0000 0216             ping=0;
	CLT
	BLD  R15,0
; 0000 0217             }
; 0000 0218 
; 0000 0219       //    
; 0000 021A       if (PINC.5==0 & light==0)
_0x44:
	LDI  R26,0
	SBIC 0x13,5
	LDI  R26,1
	CALL SUBOPT_0xD
	CALL SUBOPT_0x17
	BREQ _0x4E
; 0000 021B             {
; 0000 021C 
; 0000 021D             switch (set)
	CALL SUBOPT_0xB
; 0000 021E                 {
; 0000 021F                 //         
; 0000 0220                 case 0:
	BRNE _0x52
; 0000 0221                     light=1;
	SET
	BLD  R2,3
; 0000 0222                     if (PIND.4==1)
	SBIS 0x10,4
	RJMP _0x53
; 0000 0223                         {
; 0000 0224                         PORTD.4=0;
	CBI  0x12,4
; 0000 0225                         Flight=1;
	RJMP _0x82
; 0000 0226                         }
; 0000 0227                     else
_0x53:
; 0000 0228                         {
; 0000 0229                         PORTD.4=1;
	SBI  0x12,4
; 0000 022A                         Flight=0;
	CLT
_0x82:
	BLD  R2,1
; 0000 022B                         }
; 0000 022C                 break;
	RJMP _0x51
; 0000 022D                 //       
; 0000 022E                 case 1:
_0x52:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x59
; 0000 022F                 minut++;
	INC  R10
; 0000 0230                 if (minut>59)minut=0;
	LDI  R30,LOW(59)
	CP   R30,R10
	BRSH _0x5A
	CLR  R10
; 0000 0231                 temp=0;
_0x5A:
	CALL SUBOPT_0x18
; 0000 0232                 pause(5000);
; 0000 0233                 break;
	RJMP _0x51
; 0000 0234                 case 2:
_0x59:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x5D
; 0000 0235                 hour++;
	INC  R11
; 0000 0236                 if (hour>23)hour=0;
	LDI  R30,LOW(23)
	CP   R30,R11
	BRSH _0x5C
	CLR  R11
; 0000 0237                 temp=0;
_0x5C:
	CALL SUBOPT_0x18
; 0000 0238                 pause(5000);
; 0000 0239                 break;
; 0000 023A                 default:
_0x5D:
; 0000 023B                 break;
; 0000 023C                 }
_0x51:
; 0000 023D             // 
; 0000 023E             reload=1;
	CALL SUBOPT_0x15
; 0000 023F             screen_reload();
; 0000 0240 
; 0000 0241             }
; 0000 0242 
; 0000 0243       //    
; 0000 0244       if (PIND.6==0 & light==0)
_0x4E:
	LDI  R26,0
	SBIC 0x10,6
	LDI  R26,1
	CALL SUBOPT_0xD
	CALL SUBOPT_0x17
	BREQ _0x5E
; 0000 0245             {
; 0000 0246             switch (set)
	CALL SUBOPT_0xB
; 0000 0247                 {
; 0000 0248                 case 0:
	BRNE _0x62
; 0000 0249                 //         
; 0000 024A                     light=1;
	SET
	BLD  R2,3
; 0000 024B                     if (PIND.7==1)
	SBIS 0x10,7
	RJMP _0x63
; 0000 024C                         {
; 0000 024D                         PORTD.7=0;
	CBI  0x12,7
; 0000 024E                         Blight=1;
	RJMP _0x83
; 0000 024F                         }
; 0000 0250                     else
_0x63:
; 0000 0251                         {
; 0000 0252                         PORTD.7=1;
	SBI  0x12,7
; 0000 0253                         Blight=0;
	CLT
_0x83:
	BLD  R2,2
; 0000 0254                         }
; 0000 0255                 break;
	RJMP _0x61
; 0000 0256                 //       
; 0000 0257                 case 1:
_0x62:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x69
; 0000 0258                 if (minut==0)minut=60;
	TST  R10
	BRNE _0x6A
	LDI  R30,LOW(60)
	MOV  R10,R30
; 0000 0259                 minut--;
_0x6A:
	DEC  R10
; 0000 025A                 temp=0;
	CALL SUBOPT_0x18
; 0000 025B                 pause(5000);
; 0000 025C                 break;
	RJMP _0x61
; 0000 025D                 case 2:
_0x69:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x6D
; 0000 025E                 if (hour==0)hour=24;
	TST  R11
	BRNE _0x6C
	LDI  R30,LOW(24)
	MOV  R11,R30
; 0000 025F                 hour--;
_0x6C:
	DEC  R11
; 0000 0260                 temp=0;
	CALL SUBOPT_0x18
; 0000 0261                 pause(5000);
; 0000 0262                 break;
; 0000 0263                 default:
_0x6D:
; 0000 0264                 break;
; 0000 0265                 }
_0x61:
; 0000 0266             // 
; 0000 0267             reload=1;
	CALL SUBOPT_0x15
; 0000 0268             screen_reload();
; 0000 0269             }
; 0000 026A       //        , ,  
; 0000 026B       if (PINC.7==0)
_0x5E:
	SBIC 0x13,7
	RJMP _0x6E
; 0000 026C             {
; 0000 026D             if (set!=0)rtc_set_time(hour,minut,sec);
	CALL SUBOPT_0xB
	BREQ _0x6F
	ST   -Y,R11
	ST   -Y,R10
	MOV  R26,R13
	RCALL _rtc_set_time
; 0000 026E             set=set+1;
_0x6F:
	LDS  R30,_set
	LDS  R31,_set+1
	ADIW R30,1
	STS  _set,R30
	STS  _set+1,R31
; 0000 026F 
; 0000 0270             if (set>2)
	CALL SUBOPT_0x16
	SBIW R26,3
	BRLT _0x70
; 0000 0271                 {set=0;
	LDI  R30,LOW(0)
	STS  _set,R30
	STS  _set+1,R30
; 0000 0272                 rotatePred=-1;
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	MOVW R8,R30
; 0000 0273                 }
; 0000 0274             temp=0;
_0x70:
	CLR  R4
	CLR  R5
; 0000 0275             if (set>0)
	CALL SUBOPT_0x16
	CALL __CPW02
	BRGE _0x71
; 0000 0276                 {
; 0000 0277                 glcd_setfont(NumberBig);
	CALL SUBOPT_0xA
; 0000 0278                 glcd_outtextxyf(28,34,"::");
	CALL SUBOPT_0x9
	__POINTW2FN _0x0,39
	CALL _glcd_outtextxyf
; 0000 0279                 line_clear();
	RCALL _line_clear
; 0000 027A                 glcd_setfont(Number);
	CALL SUBOPT_0x13
; 0000 027B                 //    ,         
; 0000 027C                 if (set==1)glcd_outtextxyf(0,0,"  " );
	CALL SUBOPT_0x16
	SBIW R26,1
	BRNE _0x72
	LDI  R30,LOW(0)
	CALL SUBOPT_0x19
; 0000 027D                 if (set==2)glcd_outtextxyf(21,0,"  " );
_0x72:
	CALL SUBOPT_0x16
	SBIW R26,2
	BRNE _0x73
	LDI  R30,LOW(21)
	CALL SUBOPT_0x19
; 0000 027E                 }
_0x73:
; 0000 027F 
; 0000 0280                 // 
; 0000 0281             reload=1;
_0x71:
	CALL SUBOPT_0x15
; 0000 0282             screen_reload();
; 0000 0283             pause(10000);
	LDI  R26,LOW(10000)
	LDI  R27,HIGH(10000)
	RCALL _pause
; 0000 0284             }
; 0000 0285       //        
; 0000 0286       if (PINC.6==0 & light==0)
_0x6E:
	LDI  R26,0
	SBIC 0x13,6
	LDI  R26,1
	CALL SUBOPT_0xD
	CALL SUBOPT_0x17
	BREQ _0x74
; 0000 0287             {
; 0000 0288             if (PIND.0==1) PORTD.0=0;
	SBIS 0x10,0
	RJMP _0x75
	CBI  0x12,0
; 0000 0289             else PORTD.0=1;
	RJMP _0x78
_0x75:
	SBI  0x12,0
; 0000 028A             light=1;
_0x78:
	SET
	BLD  R2,3
; 0000 028B             }
; 0000 028C       if (PIND.1==0)
_0x74:
	SBIC 0x10,1
	RJMP _0x7B
; 0000 028D             {
; 0000 028E             run=0;
	LDI  R30,LOW(0)
	STS  _run,R30
	STS  _run+1,R30
	STS  _run+2,R30
	STS  _run+3,R30
; 0000 028F             }
; 0000 0290       }
_0x7B:
	RJMP _0x40
; 0000 0291 }
_0x7C:
	RJMP _0x7C

	.CSEG
_rtc_init:
	ST   -Y,R26
	LDD  R30,Y+2
	ANDI R30,LOW(0x3)
	STD  Y+2,R30
	LDD  R30,Y+1
	CPI  R30,0
	BREQ _0x2000003
	LDD  R30,Y+2
	ORI  R30,0x10
	STD  Y+2,R30
_0x2000003:
	LD   R30,Y
	CPI  R30,0
	BREQ _0x2000004
	LDD  R30,Y+2
	ORI  R30,0x80
	STD  Y+2,R30
_0x2000004:
	CALL SUBOPT_0x1A
	LDI  R26,LOW(7)
	CALL _i2c_write
	LDD  R26,Y+2
	CALL SUBOPT_0x1B
	JMP  _0x218000C
_rtc_get_time:
	ST   -Y,R27
	ST   -Y,R26
	CALL SUBOPT_0x1A
	LDI  R26,LOW(0)
	CALL SUBOPT_0x1B
	CALL _i2c_start
	LDI  R26,LOW(209)
	CALL _i2c_write
	CALL SUBOPT_0x1C
	LD   R26,Y
	LDD  R27,Y+1
	ST   X,R30
	CALL SUBOPT_0x1C
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ST   X,R30
	LDI  R26,LOW(0)
	CALL _i2c_read
	MOV  R26,R30
	CALL _bcd2bin
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	CALL _i2c_stop
	ADIW R28,6
	RET
_rtc_set_time:
	ST   -Y,R26
	CALL SUBOPT_0x1A
	LDI  R26,LOW(0)
	CALL SUBOPT_0x1D
	CALL SUBOPT_0x1E
	CALL SUBOPT_0x1F
	CALL SUBOPT_0x1B
	JMP  _0x218000C
_rtc_set_date:
	ST   -Y,R26
	CALL SUBOPT_0x1A
	LDI  R26,LOW(3)
	CALL _i2c_write
	LDD  R26,Y+3
	CALL SUBOPT_0x1F
	CALL SUBOPT_0x1E
	CALL SUBOPT_0x1D
	CALL SUBOPT_0x1B
	RJMP _0x2180012
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_pcd8544_delay_G101:
	RET
_pcd8544_wrbus_G101:
	ST   -Y,R26
	ST   -Y,R17
	CBI  0x18,1
	LDI  R17,LOW(8)
_0x2020004:
	RCALL _pcd8544_delay_G101
	LDD  R30,Y+1
	ANDI R30,LOW(0x80)
	BREQ _0x2020006
	SBI  0x18,3
	RJMP _0x2020007
_0x2020006:
	CBI  0x18,3
_0x2020007:
	LDD  R30,Y+1
	LSL  R30
	STD  Y+1,R30
	RCALL _pcd8544_delay_G101
	SBI  0x18,4
	RCALL _pcd8544_delay_G101
	CBI  0x18,4
	SUBI R17,LOW(1)
	CPI  R17,0
	BRNE _0x2020004
	SBI  0x18,1
	LDD  R17,Y+0
	RJMP _0x218000F
_pcd8544_wrcmd:
	ST   -Y,R26
	CBI  0x18,2
	LD   R26,Y
	RCALL _pcd8544_wrbus_G101
	RJMP _0x2180013
_pcd8544_wrdata_G101:
	ST   -Y,R26
	SBI  0x18,2
	LD   R26,Y
	RCALL _pcd8544_wrbus_G101
	RJMP _0x2180013
_pcd8544_setaddr_G101:
	ST   -Y,R26
	ST   -Y,R17
	LDD  R30,Y+1
	LSR  R30
	LSR  R30
	LSR  R30
	MOV  R17,R30
	LDI  R30,LOW(84)
	MUL  R30,R17
	MOVW R30,R0
	MOVW R26,R30
	LDD  R30,Y+2
	CALL SUBOPT_0x20
	STS  _gfx_addr_G101,R30
	STS  _gfx_addr_G101+1,R31
	MOV  R30,R17
	LDD  R17,Y+0
	RJMP _0x218000C
_pcd8544_gotoxy:
	ST   -Y,R26
	LDD  R30,Y+1
	ORI  R30,0x80
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R26,Y+1
	RCALL _pcd8544_setaddr_G101
	ORI  R30,0x40
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
	RJMP _0x218000F
_pcd8544_rdbyte:
	ST   -Y,R26
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R26,Y+1
	RCALL _pcd8544_gotoxy
	CALL SUBOPT_0x21
	LD   R30,Z
	RJMP _0x218000F
_pcd8544_wrbyte:
	ST   -Y,R26
	CALL SUBOPT_0x22
	SBIW R30,1
	SUBI R30,LOW(-_gfx_buffer_G101)
	SBCI R31,HIGH(-_gfx_buffer_G101)
	LD   R26,Y
	STD  Z+0,R26
	RCALL _pcd8544_wrdata_G101
	RJMP _0x2180013
_glcd_init:
	ST   -Y,R27
	ST   -Y,R26
	CALL __SAVELOCR4
	SBI  0x17,1
	SBI  0x18,1
	SBI  0x17,4
	CBI  0x18,4
	SBI  0x17,3
	SBI  0x17,2
	SBI  0x17,0
	CBI  0x18,0
	LDI  R26,LOW(10)
	LDI  R27,0
	CALL _delay_ms
	SBI  0x18,0
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,0
	BREQ _0x2020008
	LDD  R30,Z+6
	ANDI R30,LOW(0x3)
	MOV  R17,R30
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LDD  R30,Z+6
	LSR  R30
	LSR  R30
	ANDI R30,LOW(0x7)
	MOV  R16,R30
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LDD  R30,Z+7
	ANDI R30,0x7F
	MOV  R19,R30
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	CALL __GETW1P
	__PUTW1MN _glcd_state,4
	ADIW R26,2
	CALL __GETW1P
	__PUTW1MN _glcd_state,25
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,4
	CALL __GETW1P
	RJMP _0x20200A0
_0x2020008:
	LDI  R17,LOW(0)
	LDI  R16,LOW(3)
	LDI  R19,LOW(50)
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	__PUTW1MN _glcd_state,4
	__PUTW1MN _glcd_state,25
_0x20200A0:
	__PUTW1MN _glcd_state,27
	LDI  R26,LOW(33)
	RCALL _pcd8544_wrcmd
	MOV  R30,R17
	ORI  R30,4
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
	MOV  R30,R16
	ORI  R30,0x10
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
	MOV  R30,R19
	ORI  R30,0x80
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
	LDI  R26,LOW(32)
	RCALL _pcd8544_wrcmd
	LDI  R26,LOW(1)
	RCALL _glcd_display
	LDI  R30,LOW(1)
	STS  _glcd_state,R30
	LDI  R30,LOW(0)
	__PUTB1MN _glcd_state,1
	LDI  R30,LOW(1)
	__PUTB1MN _glcd_state,6
	__PUTB1MN _glcd_state,7
	CALL SUBOPT_0x3
	LDI  R30,LOW(1)
	__PUTB1MN _glcd_state,16
	__POINTW1MN _glcd_state,17
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDI  R26,LOW(8)
	LDI  R27,0
	CALL _memset
	RCALL _glcd_clear
	LDI  R30,LOW(1)
	CALL __LOADLOCR4
	RJMP _0x218000A
_glcd_display:
	ST   -Y,R26
	LD   R30,Y
	CPI  R30,0
	BREQ _0x202000A
	LDI  R30,LOW(12)
	RJMP _0x202000B
_0x202000A:
	LDI  R30,LOW(8)
_0x202000B:
	MOV  R26,R30
	RCALL _pcd8544_wrcmd
_0x2180013:
	ADIW R28,1
	RET
_glcd_clear:
	CALL __SAVELOCR4
	LDI  R19,0
	__GETB1MN _glcd_state,1
	CPI  R30,0
	BREQ _0x202000D
	LDI  R19,LOW(255)
_0x202000D:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _pcd8544_gotoxy
	__GETWRN 16,17,504
_0x202000E:
	MOVW R30,R16
	__SUBWRN 16,17,1
	SBIW R30,0
	BREQ _0x2020010
	MOV  R26,R19
	RCALL _pcd8544_wrbyte
	RJMP _0x202000E
_0x2020010:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _glcd_moveto
	CALL __LOADLOCR4
_0x2180012:
	ADIW R28,4
	RET
_glcd_putpixel:
	ST   -Y,R26
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+4
	CPI  R26,LOW(0x54)
	BRSH _0x2020012
	LDD  R26,Y+3
	CPI  R26,LOW(0x30)
	BRLO _0x2020011
_0x2020012:
	RJMP _0x2180011
_0x2020011:
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R26,Y+4
	RCALL _pcd8544_rdbyte
	MOV  R17,R30
	LDD  R30,Y+3
	ANDI R30,LOW(0x7)
	LDI  R26,LOW(1)
	CALL __LSLB12
	MOV  R16,R30
	LDS  R30,_glcd_state
	LDD  R26,Y+2
	CP   R30,R26
	BRNE _0x2020014
	OR   R17,R16
	RJMP _0x2020015
_0x2020014:
	MOV  R30,R16
	COM  R30
	AND  R17,R30
_0x2020015:
	MOV  R26,R17
	RCALL _pcd8544_wrbyte
_0x2180011:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
_glcd_getpixel:
	ST   -Y,R26
	LDD  R26,Y+1
	CPI  R26,LOW(0x54)
	BRSH _0x2020017
	LD   R26,Y
	CPI  R26,LOW(0x30)
	BRLO _0x2020016
_0x2020017:
	LDI  R30,LOW(0)
	RJMP _0x218000F
_0x2020016:
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R26,Y+1
	RCALL _pcd8544_setaddr_G101
	CALL SUBOPT_0x21
	LD   R1,Z
	LD   R30,Y
	ANDI R30,LOW(0x7)
	LDI  R26,LOW(1)
	CALL __LSLB12
	AND  R30,R1
	BREQ _0x2020019
	LDI  R30,LOW(1)
	RJMP _0x202001A
_0x2020019:
	LDI  R30,LOW(0)
_0x202001A:
	RJMP _0x218000F
_pcd8544_wrmasked_G101:
	ST   -Y,R26
	ST   -Y,R17
	LDD  R30,Y+5
	ST   -Y,R30
	LDD  R26,Y+5
	RCALL _pcd8544_rdbyte
	MOV  R17,R30
	LDD  R30,Y+1
	CPI  R30,LOW(0x6)
	BREQ _0x2020020
	CPI  R30,LOW(0x7)
	BRNE _0x2020021
_0x2020020:
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R26,Y+2
	CALL _glcd_mappixcolor1bit
	STD  Y+3,R30
	RJMP _0x2020022
_0x2020021:
	CPI  R30,LOW(0x3)
	BRNE _0x2020024
	LDD  R30,Y+3
	COM  R30
	STD  Y+3,R30
	RJMP _0x2020025
_0x2020024:
	CPI  R30,0
	BRNE _0x2020026
_0x2020025:
_0x2020022:
	LDD  R30,Y+2
	COM  R30
	AND  R17,R30
	RJMP _0x2020027
_0x2020026:
	CPI  R30,LOW(0x2)
	BRNE _0x2020028
_0x2020027:
	LDD  R30,Y+2
	LDD  R26,Y+3
	AND  R30,R26
	OR   R17,R30
	RJMP _0x202001E
_0x2020028:
	CPI  R30,LOW(0x1)
	BRNE _0x2020029
	LDD  R30,Y+2
	LDD  R26,Y+3
	AND  R30,R26
	EOR  R17,R30
	RJMP _0x202001E
_0x2020029:
	CPI  R30,LOW(0x4)
	BRNE _0x202001E
	LDD  R30,Y+2
	COM  R30
	LDD  R26,Y+3
	OR   R30,R26
	AND  R17,R30
_0x202001E:
	MOV  R26,R17
	RCALL _pcd8544_wrbyte
	LDD  R17,Y+0
	RJMP _0x218000A
_glcd_block:
	ST   -Y,R26
	SBIW R28,3
	CALL __SAVELOCR6
	LDD  R26,Y+16
	CPI  R26,LOW(0x54)
	BRSH _0x202002C
	LDD  R26,Y+15
	CPI  R26,LOW(0x30)
	BRSH _0x202002C
	LDD  R26,Y+14
	CPI  R26,LOW(0x0)
	BREQ _0x202002C
	LDD  R26,Y+13
	CPI  R26,LOW(0x0)
	BRNE _0x202002B
_0x202002C:
	RJMP _0x2180010
_0x202002B:
	LDD  R30,Y+14
	STD  Y+8,R30
	LDD  R26,Y+16
	CLR  R27
	LDD  R30,Y+14
	CALL SUBOPT_0x23
	CPI  R26,LOW(0x55)
	LDI  R30,HIGH(0x55)
	CPC  R27,R30
	BRLO _0x202002E
	LDD  R26,Y+16
	LDI  R30,LOW(84)
	SUB  R30,R26
	STD  Y+14,R30
_0x202002E:
	LDD  R18,Y+13
	LDD  R26,Y+15
	CLR  R27
	LDD  R30,Y+13
	CALL SUBOPT_0x23
	SBIW R26,49
	BRLO _0x202002F
	LDD  R26,Y+15
	LDI  R30,LOW(48)
	SUB  R30,R26
	STD  Y+13,R30
_0x202002F:
	LDD  R26,Y+9
	CPI  R26,LOW(0x5)
	BREQ PC+3
	JMP _0x2020030
	LDD  R30,Y+12
	CPI  R30,LOW(0x1)
	BRNE _0x2020034
	RJMP _0x2180010
_0x2020034:
	CPI  R30,LOW(0x3)
	BRNE _0x2020037
	__GETW1MN _glcd_state,27
	SBIW R30,0
	BRNE _0x2020036
	RJMP _0x2180010
_0x2020036:
_0x2020037:
	LDD  R16,Y+8
	LDD  R30,Y+13
	LSR  R30
	LSR  R30
	LSR  R30
	MOV  R19,R30
	MOV  R30,R18
	ANDI R30,LOW(0x7)
	BRNE _0x2020039
	LDD  R26,Y+13
	CP   R18,R26
	BREQ _0x2020038
_0x2020039:
	MOV  R26,R16
	CLR  R27
	MOV  R30,R19
	CALL SUBOPT_0x24
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
	LSR  R18
	LSR  R18
	LSR  R18
	MOV  R21,R19
_0x202003B:
	PUSH R21
	SUBI R21,-1
	MOV  R30,R18
	POP  R26
	CP   R30,R26
	BRLO _0x202003D
	MOV  R17,R16
_0x202003E:
	MOV  R30,R17
	SUBI R17,1
	CPI  R30,0
	BREQ _0x2020040
	CALL SUBOPT_0x25
	RJMP _0x202003E
_0x2020040:
	RJMP _0x202003B
_0x202003D:
_0x2020038:
	LDD  R26,Y+14
	CP   R16,R26
	BREQ _0x2020041
	LDD  R30,Y+14
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CALL SUBOPT_0x20
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R30,Y+13
	ANDI R30,LOW(0x7)
	BREQ _0x2020042
	SUBI R19,-LOW(1)
_0x2020042:
	LDI  R18,LOW(0)
_0x2020043:
	PUSH R18
	SUBI R18,-1
	MOV  R30,R19
	POP  R26
	CP   R26,R30
	BRSH _0x2020045
	LDD  R17,Y+14
_0x2020046:
	PUSH R17
	SUBI R17,-1
	MOV  R30,R16
	POP  R26
	CP   R26,R30
	BRSH _0x2020048
	CALL SUBOPT_0x25
	RJMP _0x2020046
_0x2020048:
	LDD  R30,Y+14
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CALL SUBOPT_0x20
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x2020043
_0x2020045:
_0x2020041:
_0x2020030:
	LDD  R30,Y+15
	ANDI R30,LOW(0x7)
	MOV  R19,R30
_0x2020049:
	LDD  R30,Y+13
	CPI  R30,0
	BRNE PC+3
	JMP _0x202004B
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(0)
	LDD  R16,Y+16
	CPI  R19,0
	BREQ PC+3
	JMP _0x202004C
	LDD  R26,Y+13
	CPI  R26,LOW(0x8)
	BRSH PC+3
	JMP _0x202004D
	LDD  R30,Y+9
	CPI  R30,0
	BREQ _0x2020052
	CPI  R30,LOW(0x3)
	BRNE _0x2020053
_0x2020052:
	RJMP _0x2020054
_0x2020053:
	CPI  R30,LOW(0x6)
	BRNE _0x2020055
_0x2020054:
	RJMP _0x2020056
_0x2020055:
	CPI  R30,LOW(0x7)
	BRNE _0x2020057
_0x2020056:
	RJMP _0x2020058
_0x2020057:
	CPI  R30,LOW(0x8)
	BRNE _0x2020059
_0x2020058:
	RJMP _0x202005A
_0x2020059:
	CPI  R30,LOW(0x9)
	BRNE _0x202005B
_0x202005A:
	ST   -Y,R16
	LDD  R26,Y+16
	RCALL _pcd8544_gotoxy
	RJMP _0x2020050
_0x202005B:
	CPI  R30,LOW(0x5)
	BRNE _0x2020050
	CALL SUBOPT_0x26
_0x2020050:
_0x202005D:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x202005F
	LDD  R26,Y+9
	CPI  R26,LOW(0x5)
	BRNE _0x2020060
	CALL SUBOPT_0x27
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x22
	SBIW R30,1
	SUBI R30,LOW(-_gfx_buffer_G101)
	SBCI R31,HIGH(-_gfx_buffer_G101)
	LD   R26,Z
	CALL _glcd_writemem
	RJMP _0x2020061
_0x2020060:
	LDD  R30,Y+9
	CPI  R30,LOW(0x8)
	BRNE _0x2020065
	LDI  R21,LOW(0)
	RJMP _0x2020066
_0x2020065:
	CPI  R30,LOW(0x9)
	BRNE _0x2020064
	LDI  R21,LOW(255)
	RJMP _0x2020066
_0x2020064:
	CALL SUBOPT_0x27
	CALL SUBOPT_0x28
	MOV  R21,R30
	LDD  R30,Y+9
	CPI  R30,LOW(0x6)
	BREQ _0x202006D
	CPI  R30,LOW(0x7)
	BRNE _0x202006E
_0x202006D:
_0x2020066:
	CALL SUBOPT_0x29
	MOV  R21,R30
	RJMP _0x202006F
_0x202006E:
	CPI  R30,LOW(0x3)
	BRNE _0x2020071
	COM  R21
	RJMP _0x2020072
_0x2020071:
	CPI  R30,0
	BRNE _0x2020074
_0x2020072:
_0x202006F:
	MOV  R26,R21
	RCALL _pcd8544_wrdata_G101
	RJMP _0x202006B
_0x2020074:
	CALL SUBOPT_0x2A
	LDI  R30,LOW(255)
	ST   -Y,R30
	LDD  R26,Y+13
	RCALL _pcd8544_wrmasked_G101
_0x202006B:
_0x2020061:
	RJMP _0x202005D
_0x202005F:
	LDD  R30,Y+15
	SUBI R30,-LOW(8)
	STD  Y+15,R30
	LDD  R30,Y+13
	SUBI R30,LOW(8)
	STD  Y+13,R30
	RJMP _0x2020075
_0x202004D:
	LDD  R21,Y+13
	LDI  R18,LOW(0)
	LDI  R30,LOW(0)
	STD  Y+13,R30
	RJMP _0x2020076
_0x202004C:
	MOV  R30,R19
	LDD  R26,Y+13
	ADD  R26,R30
	CPI  R26,LOW(0x9)
	BRSH _0x2020077
	LDD  R18,Y+13
	LDI  R30,LOW(0)
	STD  Y+13,R30
	RJMP _0x2020078
_0x2020077:
	LDI  R30,LOW(8)
	SUB  R30,R19
	MOV  R18,R30
_0x2020078:
	ST   -Y,R19
	MOV  R26,R18
	CALL _glcd_getmask
	MOV  R20,R30
	LDD  R30,Y+9
	CPI  R30,LOW(0x5)
	BRNE _0x202007C
	CALL SUBOPT_0x26
_0x202007D:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x202007F
	CALL SUBOPT_0x22
	SBIW R30,1
	SUBI R30,LOW(-_gfx_buffer_G101)
	SBCI R31,HIGH(-_gfx_buffer_G101)
	LD   R30,Z
	AND  R30,R20
	MOV  R26,R30
	MOV  R30,R19
	CALL __LSRB12
	CALL SUBOPT_0x2B
	MOV  R30,R19
	MOV  R26,R20
	CALL __LSRB12
	COM  R30
	AND  R30,R1
	OR   R21,R30
	CALL SUBOPT_0x27
	ST   -Y,R31
	ST   -Y,R30
	MOV  R26,R21
	CALL _glcd_writemem
	RJMP _0x202007D
_0x202007F:
	RJMP _0x202007B
_0x202007C:
	CPI  R30,LOW(0x8)
	BRNE _0x2020080
	LDI  R21,LOW(0)
	RJMP _0x2020081
_0x2020080:
	CPI  R30,LOW(0x9)
	BRNE _0x2020087
	LDI  R21,LOW(255)
_0x2020081:
	CALL SUBOPT_0x29
	MOV  R26,R30
	MOV  R30,R19
	CALL __LSLB12
	MOV  R21,R30
_0x2020084:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x2020086
	CALL SUBOPT_0x2A
	ST   -Y,R20
	LDI  R26,LOW(0)
	RCALL _pcd8544_wrmasked_G101
	RJMP _0x2020084
_0x2020086:
	RJMP _0x202007B
_0x2020087:
_0x2020088:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x202008A
	CALL SUBOPT_0x2C
	MOV  R26,R30
	MOV  R30,R19
	CALL __LSLB12
	ST   -Y,R30
	ST   -Y,R20
	LDD  R26,Y+13
	RCALL _pcd8544_wrmasked_G101
	RJMP _0x2020088
_0x202008A:
_0x202007B:
	LDD  R30,Y+13
	CPI  R30,0
	BRNE _0x202008B
	RJMP _0x202004B
_0x202008B:
	LDD  R26,Y+13
	CPI  R26,LOW(0x8)
	BRSH _0x202008C
	LDD  R30,Y+13
	SUB  R30,R18
	MOV  R21,R30
	LDI  R30,LOW(0)
	RJMP _0x20200A1
_0x202008C:
	MOV  R21,R19
	LDD  R30,Y+13
	SUBI R30,LOW(8)
_0x20200A1:
	STD  Y+13,R30
	LDI  R17,LOW(0)
	LDD  R30,Y+15
	SUBI R30,-LOW(8)
	STD  Y+15,R30
	LDI  R30,LOW(8)
	SUB  R30,R19
	MOV  R18,R30
	LDD  R16,Y+16
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x2020076:
	MOV  R30,R21
	LDI  R31,0
	SUBI R30,LOW(-__glcd_mask*2)
	SBCI R31,HIGH(-__glcd_mask*2)
	LPM  R20,Z
	LDD  R30,Y+9
	CPI  R30,LOW(0x5)
	BRNE _0x2020091
	CALL SUBOPT_0x26
_0x2020092:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x2020094
	CALL SUBOPT_0x22
	SBIW R30,1
	SUBI R30,LOW(-_gfx_buffer_G101)
	SBCI R31,HIGH(-_gfx_buffer_G101)
	LD   R30,Z
	AND  R30,R20
	MOV  R26,R30
	MOV  R30,R18
	CALL __LSLB12
	CALL SUBOPT_0x2B
	MOV  R30,R18
	MOV  R26,R20
	CALL __LSLB12
	COM  R30
	AND  R30,R1
	OR   R21,R30
	CALL SUBOPT_0x27
	ST   -Y,R31
	ST   -Y,R30
	MOV  R26,R21
	CALL _glcd_writemem
	RJMP _0x2020092
_0x2020094:
	RJMP _0x2020090
_0x2020091:
	CPI  R30,LOW(0x8)
	BRNE _0x2020095
	LDI  R21,LOW(0)
	RJMP _0x2020096
_0x2020095:
	CPI  R30,LOW(0x9)
	BRNE _0x202009C
	LDI  R21,LOW(255)
_0x2020096:
	CALL SUBOPT_0x29
	MOV  R26,R30
	MOV  R30,R18
	CALL __LSRB12
	MOV  R21,R30
_0x2020099:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x202009B
	CALL SUBOPT_0x2A
	ST   -Y,R20
	LDI  R26,LOW(0)
	RCALL _pcd8544_wrmasked_G101
	RJMP _0x2020099
_0x202009B:
	RJMP _0x2020090
_0x202009C:
_0x202009D:
	PUSH R17
	SUBI R17,-1
	LDD  R30,Y+14
	POP  R26
	CP   R26,R30
	BRSH _0x202009F
	CALL SUBOPT_0x2C
	MOV  R26,R30
	MOV  R30,R18
	CALL __LSRB12
	ST   -Y,R30
	ST   -Y,R20
	LDD  R26,Y+13
	RCALL _pcd8544_wrmasked_G101
	RJMP _0x202009D
_0x202009F:
_0x2020090:
_0x2020075:
	LDD  R30,Y+8
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CALL SUBOPT_0x20
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x2020049
_0x202004B:
_0x2180010:
	CALL __LOADLOCR6
	ADIW R28,17
	RET

	.CSEG
_glcd_clipx_G102:
	CALL SUBOPT_0x2D
	BRLT _0x2040003
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x218000F
_0x2040003:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x54)
	LDI  R30,HIGH(0x54)
	CPC  R27,R30
	BRLT _0x2040004
	LDI  R30,LOW(83)
	LDI  R31,HIGH(83)
	RJMP _0x218000F
_0x2040004:
	LD   R30,Y
	LDD  R31,Y+1
	RJMP _0x218000F
_glcd_clipy_G102:
	CALL SUBOPT_0x2D
	BRLT _0x2040005
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x218000F
_0x2040005:
	LD   R26,Y
	LDD  R27,Y+1
	SBIW R26,48
	BRLT _0x2040006
	LDI  R30,LOW(47)
	LDI  R31,HIGH(47)
	RJMP _0x218000F
_0x2040006:
	LD   R30,Y
	LDD  R31,Y+1
	RJMP _0x218000F
_glcd_setpixel:
	ST   -Y,R26
	LDD  R30,Y+1
	ST   -Y,R30
	LDD  R30,Y+1
	ST   -Y,R30
	LDS  R26,_glcd_state
	RCALL _glcd_putpixel
_0x218000F:
	ADIW R28,2
	RET
_glcd_getcharw_G102:
	ST   -Y,R27
	ST   -Y,R26
	SBIW R28,3
	CALL SUBOPT_0x2E
	MOVW R16,R30
	MOV  R0,R16
	OR   R0,R17
	BRNE _0x204000B
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x218000E
_0x204000B:
	CALL SUBOPT_0x2F
	STD  Y+7,R0
	CALL SUBOPT_0x2F
	STD  Y+6,R0
	CALL SUBOPT_0x2F
	STD  Y+8,R0
	LDD  R30,Y+11
	LDD  R26,Y+8
	CP   R30,R26
	BRSH _0x204000C
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x218000E
_0x204000C:
	MOVW R30,R16
	__ADDWRN 16,17,1
	LPM  R21,Z
	MOV  R30,R21
	LDD  R26,Y+8
	ADD  R26,R30
	LDD  R30,Y+11
	CP   R30,R26
	BRLO _0x204000D
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x218000E
_0x204000D:
	LDD  R30,Y+6
	LSR  R30
	LSR  R30
	LSR  R30
	MOV  R20,R30
	LDD  R30,Y+6
	ANDI R30,LOW(0x7)
	BREQ _0x204000E
	SUBI R20,-LOW(1)
_0x204000E:
	LDD  R30,Y+7
	CPI  R30,0
	BREQ _0x204000F
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ST   X,R30
	LDD  R26,Y+8
	LDD  R30,Y+11
	SUB  R30,R26
	LDI  R31,0
	MOVW R26,R30
	LDD  R30,Y+7
	CALL SUBOPT_0x24
	MOVW R26,R30
	MOV  R30,R20
	CALL SUBOPT_0x24
	ADD  R30,R16
	ADC  R31,R17
	RJMP _0x218000E
_0x204000F:
	MOVW R18,R16
	MOV  R30,R21
	LDI  R31,0
	__ADDWRR 16,17,30,31
_0x2040010:
	LDD  R26,Y+8
	SUBI R26,-LOW(1)
	STD  Y+8,R26
	SUBI R26,LOW(1)
	LDD  R30,Y+11
	CP   R26,R30
	BRSH _0x2040012
	MOVW R30,R18
	__ADDWRN 18,19,1
	LPM  R26,Z
	LDI  R27,0
	MOV  R30,R20
	CALL SUBOPT_0x24
	__ADDWRR 16,17,30,31
	RJMP _0x2040010
_0x2040012:
	MOVW R30,R18
	LPM  R30,Z
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ST   X,R30
	MOVW R30,R16
_0x218000E:
	CALL __LOADLOCR6
	ADIW R28,12
	RET
_glcd_new_line_G102:
	LDI  R30,LOW(0)
	__PUTB1MN _glcd_state,2
	__GETB2MN _glcd_state,3
	CLR  R27
	CALL SUBOPT_0x30
	CALL SUBOPT_0x23
	__GETB1MN _glcd_state,7
	CALL SUBOPT_0x23
	RCALL _glcd_clipy_G102
	__PUTB1MN _glcd_state,3
	RET
_glcd_putchar:
	ST   -Y,R26
	SBIW R28,1
	CALL SUBOPT_0x2E
	SBIW R30,0
	BRNE PC+3
	JMP _0x204001F
	LDD  R26,Y+7
	CPI  R26,LOW(0xA)
	BRNE _0x2040020
	RJMP _0x2040021
_0x2040020:
	LDD  R30,Y+7
	ST   -Y,R30
	MOVW R26,R28
	ADIW R26,7
	RCALL _glcd_getcharw_G102
	MOVW R20,R30
	SBIW R30,0
	BRNE _0x2040022
	RJMP _0x218000D
_0x2040022:
	__GETB1MN _glcd_state,6
	LDD  R26,Y+6
	ADD  R30,R26
	MOV  R19,R30
	__GETB2MN _glcd_state,2
	CLR  R27
	MOV  R30,R19
	CALL SUBOPT_0x20
	MOVW R16,R30
	__CPWRN 16,17,85
	BRLO _0x2040023
	MOV  R16,R19
	CLR  R17
	RCALL _glcd_new_line_G102
_0x2040023:
	__GETB1MN _glcd_state,2
	ST   -Y,R30
	__GETB1MN _glcd_state,3
	ST   -Y,R30
	LDD  R30,Y+8
	ST   -Y,R30
	CALL SUBOPT_0x30
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	ST   -Y,R21
	ST   -Y,R20
	LDI  R26,LOW(6)
	RCALL _glcd_block
	__GETB1MN _glcd_state,2
	LDD  R26,Y+6
	ADD  R30,R26
	ST   -Y,R30
	__GETB1MN _glcd_state,3
	ST   -Y,R30
	__GETB1MN _glcd_state,6
	ST   -Y,R30
	CALL SUBOPT_0x30
	ST   -Y,R30
	LDI  R30,LOW(0)
	CALL SUBOPT_0x4
	LDI  R26,LOW(8)
	RCALL _glcd_block
	__GETB1MN _glcd_state,2
	ST   -Y,R30
	__GETB2MN _glcd_state,3
	CALL SUBOPT_0x30
	ADD  R30,R26
	ST   -Y,R30
	ST   -Y,R19
	__GETB1MN _glcd_state,7
	ST   -Y,R30
	LDI  R30,LOW(0)
	CALL SUBOPT_0x4
	LDI  R26,LOW(8)
	RCALL _glcd_block
	LDI  R30,LOW(84)
	LDI  R31,HIGH(84)
	CP   R30,R16
	CPC  R31,R17
	BRNE _0x2040024
_0x2040021:
	RCALL _glcd_new_line_G102
	RJMP _0x218000D
_0x2040024:
_0x204001F:
	__PUTBMRN _glcd_state,2,16
_0x218000D:
	CALL __LOADLOCR6
	ADIW R28,8
	RET
_glcd_outtextxy:
	CALL SUBOPT_0x31
_0x2040025:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X+
	STD  Y+1,R26
	STD  Y+1+1,R27
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x2040027
	MOV  R26,R17
	RCALL _glcd_putchar
	RJMP _0x2040025
_0x2040027:
	LDD  R17,Y+0
	JMP  _0x2180005
_glcd_outtextxyf:
	CALL SUBOPT_0x31
_0x2040028:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x204002A
	MOV  R26,R17
	RCALL _glcd_putchar
	RJMP _0x2040028
_0x204002A:
	LDD  R17,Y+0
	JMP  _0x2180005
_glcd_putpixelm_G102:
	ST   -Y,R26
	LDD  R30,Y+2
	ST   -Y,R30
	LDD  R30,Y+2
	ST   -Y,R30
	__GETB1MN _glcd_state,9
	LDD  R26,Y+2
	AND  R30,R26
	BREQ _0x204003E
	LDS  R30,_glcd_state
	RJMP _0x204003F
_0x204003E:
	__GETB1MN _glcd_state,1
_0x204003F:
	MOV  R26,R30
	RCALL _glcd_putpixel
	LD   R30,Y
	LSL  R30
	ST   Y,R30
	CPI  R30,0
	BRNE _0x2040041
	LDI  R30,LOW(1)
	ST   Y,R30
_0x2040041:
	LD   R30,Y
_0x218000C:
	ADIW R28,3
	RET
_glcd_moveto:
	ST   -Y,R26
	LDD  R26,Y+1
	CLR  R27
	RCALL _glcd_clipx_G102
	__PUTB1MN _glcd_state,2
	LD   R26,Y
	CLR  R27
	RCALL _glcd_clipy_G102
	__PUTB1MN _glcd_state,3
	JMP  _0x2180004
_glcd_line:
	ST   -Y,R26
	SBIW R28,11
	CALL __SAVELOCR6
	LDD  R26,Y+20
	CLR  R27
	RCALL _glcd_clipx_G102
	STD  Y+20,R30
	LDD  R26,Y+18
	CLR  R27
	RCALL _glcd_clipx_G102
	STD  Y+18,R30
	LDD  R26,Y+19
	CLR  R27
	RCALL _glcd_clipx_G102
	STD  Y+19,R30
	LDD  R26,Y+17
	CLR  R27
	RCALL _glcd_clipx_G102
	STD  Y+17,R30
	LDD  R30,Y+18
	__PUTB1MN _glcd_state,2
	LDD  R30,Y+17
	__PUTB1MN _glcd_state,3
	LDI  R30,LOW(1)
	STD  Y+8,R30
	LDD  R30,Y+17
	LDD  R26,Y+19
	CP   R30,R26
	BRNE _0x2040042
	LDD  R17,Y+20
	LDD  R26,Y+18
	CP   R17,R26
	BRNE _0x2040043
	ST   -Y,R17
	LDD  R30,Y+20
	ST   -Y,R30
	LDI  R26,LOW(1)
	RCALL _glcd_putpixelm_G102
	RJMP _0x218000B
_0x2040043:
	LDD  R26,Y+18
	CP   R17,R26
	BRSH _0x2040044
	LDD  R30,Y+18
	SUB  R30,R17
	MOV  R16,R30
	__GETWRN 20,21,1
	RJMP _0x2040045
_0x2040044:
	LDD  R26,Y+18
	MOV  R30,R17
	SUB  R30,R26
	MOV  R16,R30
	__GETWRN 20,21,-1
_0x2040045:
_0x2040047:
	LDD  R19,Y+19
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x2040049:
	CALL SUBOPT_0x32
	BRSH _0x204004B
	ST   -Y,R17
	ST   -Y,R19
	INC  R19
	LDD  R26,Y+10
	RCALL _glcd_putpixelm_G102
	STD  Y+7,R30
	RJMP _0x2040049
_0x204004B:
	LDD  R30,Y+7
	STD  Y+8,R30
	ADD  R17,R20
	MOV  R30,R16
	SUBI R16,1
	CPI  R30,0
	BRNE _0x2040047
	RJMP _0x204004C
_0x2040042:
	LDD  R30,Y+18
	LDD  R26,Y+20
	CP   R30,R26
	BRNE _0x204004D
	LDD  R19,Y+19
	LDD  R26,Y+17
	CP   R19,R26
	BRSH _0x204004E
	LDD  R30,Y+17
	SUB  R30,R19
	MOV  R18,R30
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	RJMP _0x204010A
_0x204004E:
	LDD  R26,Y+17
	MOV  R30,R19
	SUB  R30,R26
	MOV  R18,R30
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
_0x204010A:
	STD  Y+13,R30
	STD  Y+13+1,R31
_0x2040051:
	LDD  R17,Y+20
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x2040053:
	CALL SUBOPT_0x32
	BRSH _0x2040055
	ST   -Y,R17
	INC  R17
	CALL SUBOPT_0x33
	STD  Y+7,R30
	RJMP _0x2040053
_0x2040055:
	LDD  R30,Y+7
	STD  Y+8,R30
	LDD  R30,Y+13
	ADD  R19,R30
	MOV  R30,R18
	SUBI R18,1
	CPI  R30,0
	BRNE _0x2040051
	RJMP _0x2040056
_0x204004D:
	LDI  R30,LOW(0)
	STD  Y+6,R30
_0x2040057:
	CALL SUBOPT_0x32
	BRLO PC+3
	JMP _0x2040059
	LDD  R17,Y+20
	LDD  R19,Y+19
	LDI  R30,LOW(1)
	MOV  R18,R30
	MOV  R16,R30
	LDD  R26,Y+18
	CLR  R27
	LDD  R30,Y+20
	CALL SUBOPT_0x34
	MOVW R20,R26
	TST  R21
	BRPL _0x204005A
	LDI  R16,LOW(255)
	MOVW R30,R20
	CALL __ANEGW1
	MOVW R20,R30
_0x204005A:
	MOVW R30,R20
	LSL  R30
	ROL  R31
	STD  Y+15,R30
	STD  Y+15+1,R31
	LDD  R26,Y+17
	CLR  R27
	LDD  R30,Y+19
	CALL SUBOPT_0x34
	STD  Y+13,R26
	STD  Y+13+1,R27
	LDD  R26,Y+14
	TST  R26
	BRPL _0x204005B
	LDI  R18,LOW(255)
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	CALL __ANEGW1
	STD  Y+13,R30
	STD  Y+13+1,R31
_0x204005B:
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	LSL  R30
	ROL  R31
	STD  Y+11,R30
	STD  Y+11+1,R31
	ST   -Y,R17
	ST   -Y,R19
	LDI  R26,LOW(1)
	RCALL _glcd_putpixelm_G102
	STD  Y+8,R30
	LDI  R30,LOW(0)
	STD  Y+9,R30
	STD  Y+9+1,R30
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CP   R20,R26
	CPC  R21,R27
	BRLT _0x204005C
_0x204005E:
	ADD  R17,R16
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CALL SUBOPT_0x35
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	CP   R20,R26
	CPC  R21,R27
	BRGE _0x2040060
	ADD  R19,R18
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	CALL SUBOPT_0x36
_0x2040060:
	ST   -Y,R17
	CALL SUBOPT_0x33
	STD  Y+8,R30
	LDD  R30,Y+18
	CP   R30,R17
	BRNE _0x204005E
	RJMP _0x2040061
_0x204005C:
_0x2040063:
	ADD  R19,R18
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	CALL SUBOPT_0x35
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x2040065
	ADD  R17,R16
	LDD  R26,Y+11
	LDD  R27,Y+11+1
	CALL SUBOPT_0x36
_0x2040065:
	ST   -Y,R17
	CALL SUBOPT_0x33
	STD  Y+8,R30
	LDD  R30,Y+17
	CP   R30,R19
	BRNE _0x2040063
_0x2040061:
	LDD  R30,Y+19
	SUBI R30,-LOW(1)
	STD  Y+19,R30
	LDD  R30,Y+17
	SUBI R30,-LOW(1)
	STD  Y+17,R30
	RJMP _0x2040057
_0x2040059:
_0x2040056:
_0x204004C:
_0x218000B:
	CALL __LOADLOCR6
	ADIW R28,21
	RET
_round_G102:
	CALL __PUTPARD2
	ST   -Y,R17
	ST   -Y,R16
	__GETD2S 2
	CALL _floor
	CALL __CFD1
	MOVW R16,R30
	MOVW R30,R16
	__GETD2S 2
	CALL __CWD1
	CALL __CDF1
	CALL SUBOPT_0x37
	MOVW R26,R30
	MOVW R24,R22
	CALL SUBOPT_0x38
	BRLO _0x2040071
	__ADDWRN 16,17,1
_0x2040071:
	MOVW R30,R16
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x218000A:
	ADIW R28,6
	RET
_glcd_toradius_G102:
	ST   -Y,R27
	ST   -Y,R26
	SBIW R28,4
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CLR  R22
	CLR  R23
	CALL __CDF1
	__GETD2N 0x3C8EFA35
	CALL SUBOPT_0x39
	LDD  R30,Y+12
	LDI  R31,0
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x3A
	CALL _cos
	CALL SUBOPT_0x3B
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	RCALL _glcd_clipx_G102
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ST   X,R30
	LDD  R30,Y+11
	LDI  R31,0
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x3A
	CALL _sin
	CALL SUBOPT_0x3B
	POP  R26
	POP  R27
	SUB  R26,R30
	SBC  R27,R31
	RCALL _glcd_clipy_G102
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	RJMP _0x2180008
_glcd_plot8_G102:
	ST   -Y,R27
	ST   -Y,R26
	SBIW R28,3
	CALL __SAVELOCR6
	LDD  R30,Y+13
	STD  Y+8,R30
	__GETB1MN _glcd_state,8
	STD  Y+7,R30
	LDS  R30,_glcd_state
	STD  Y+6,R30
	LDD  R26,Y+18
	CLR  R27
	LDD  R30,Y+15
	CALL SUBOPT_0x20
	MOVW R16,R30
	LDD  R26,Y+17
	CLR  R27
	LDD  R30,Y+16
	CALL SUBOPT_0x34
	MOVW R18,R26
	LDD  R26,Y+17
	CLR  R27
	LDD  R30,Y+16
	CALL SUBOPT_0x20
	MOVW R20,R30
	LDD  R30,Y+8
	ANDI R30,LOW(0x81)
	CPI  R30,LOW(0x81)
	BREQ _0x2040073
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x2040075
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R30,LOW(90)
	LDI  R31,HIGH(90)
	CALL SUBOPT_0x3C
	BRLT _0x2040077
	CALL SUBOPT_0x3D
	BRGE _0x2040078
_0x2040077:
	RJMP _0x2040076
_0x2040078:
_0x2040073:
	TST  R19
	BRMI _0x2040079
	CALL SUBOPT_0x3E
_0x2040079:
	LDD  R26,Y+7
	CPI  R26,LOW(0x2)
	BRLO _0x204007B
	__CPWRN 18,19,2
	BRGE _0x204007C
_0x204007B:
	RJMP _0x204007A
_0x204007C:
	CALL SUBOPT_0x3F
	BRNE _0x204007D
	ST   -Y,R16
	MOV  R26,R18
	SUBI R26,LOW(1)
	RCALL _glcd_setpixel
_0x204007D:
_0x204007A:
_0x2040076:
_0x2040075:
	LDD  R30,Y+8
	ANDI R30,LOW(0x88)
	CPI  R30,LOW(0x88)
	BREQ _0x204007F
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x2040081
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-270)
	SBCI R27,HIGH(-270)
	CALL SUBOPT_0x40
	BRLT _0x2040083
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-270)
	SBCI R27,HIGH(-270)
	CALL SUBOPT_0x41
	BRGE _0x2040084
_0x2040083:
	RJMP _0x2040082
_0x2040084:
_0x204007F:
	CALL SUBOPT_0x42
	BRLO _0x2040085
	CALL SUBOPT_0x43
	BRNE _0x2040086
	ST   -Y,R16
	MOV  R26,R20
	SUBI R26,-LOW(1)
	RCALL _glcd_setpixel
_0x2040086:
_0x2040085:
_0x2040082:
_0x2040081:
	LDD  R26,Y+18
	CLR  R27
	LDD  R30,Y+15
	CALL SUBOPT_0x34
	MOVW R16,R26
	TST  R17
	BRPL PC+3
	JMP _0x2040087
	LDD  R30,Y+8
	ANDI R30,LOW(0x82)
	CPI  R30,LOW(0x82)
	BREQ _0x2040089
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x204008B
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-90)
	SBCI R27,HIGH(-90)
	CALL SUBOPT_0x40
	BRLT _0x204008D
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-90)
	SBCI R27,HIGH(-90)
	CALL SUBOPT_0x41
	BRGE _0x204008E
_0x204008D:
	RJMP _0x204008C
_0x204008E:
_0x2040089:
	TST  R19
	BRMI _0x204008F
	CALL SUBOPT_0x3E
_0x204008F:
	LDD  R26,Y+7
	CPI  R26,LOW(0x2)
	BRLO _0x2040091
	__CPWRN 18,19,2
	BRGE _0x2040092
_0x2040091:
	RJMP _0x2040090
_0x2040092:
	CALL SUBOPT_0x3F
	BRNE _0x2040093
	ST   -Y,R16
	MOV  R26,R18
	SUBI R26,LOW(1)
	RCALL _glcd_setpixel
_0x2040093:
_0x2040090:
_0x204008C:
_0x204008B:
	LDD  R30,Y+8
	ANDI R30,LOW(0x84)
	CPI  R30,LOW(0x84)
	BREQ _0x2040095
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x2040097
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R30,LOW(270)
	LDI  R31,HIGH(270)
	CALL SUBOPT_0x3C
	BRLT _0x2040099
	CALL SUBOPT_0x3D
	BRGE _0x204009A
_0x2040099:
	RJMP _0x2040098
_0x204009A:
_0x2040095:
	CALL SUBOPT_0x42
	BRLO _0x204009B
	CALL SUBOPT_0x43
	BRNE _0x204009C
	ST   -Y,R16
	MOV  R26,R20
	SUBI R26,-LOW(1)
	RCALL _glcd_setpixel
_0x204009C:
_0x204009B:
_0x2040098:
_0x2040097:
_0x2040087:
	LDD  R26,Y+18
	CLR  R27
	LDD  R30,Y+16
	CALL SUBOPT_0x20
	MOVW R16,R30
	LDD  R26,Y+17
	CLR  R27
	LDD  R30,Y+15
	CALL SUBOPT_0x34
	MOVW R18,R26
	LDD  R26,Y+17
	CLR  R27
	LDD  R30,Y+15
	CALL SUBOPT_0x20
	MOVW R20,R30
	LDD  R30,Y+8
	ANDI R30,LOW(0x81)
	CPI  R30,LOW(0x81)
	BREQ _0x204009E
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x20400A0
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x20400A2
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x20400A3
_0x20400A2:
	RJMP _0x20400A1
_0x20400A3:
_0x204009E:
	TST  R19
	BRMI _0x20400A4
	CALL SUBOPT_0x3E
	LDD  R26,Y+7
	CPI  R26,LOW(0x2)
	BRLO _0x20400A5
	MOV  R30,R16
	SUBI R30,-LOW(2)
	CALL SUBOPT_0x44
	BRNE _0x20400A6
	MOV  R30,R16
	SUBI R30,-LOW(1)
	ST   -Y,R30
	MOV  R26,R18
	RCALL _glcd_setpixel
_0x20400A6:
_0x20400A5:
_0x20400A4:
_0x20400A1:
_0x20400A0:
	LDD  R30,Y+8
	ANDI R30,LOW(0x88)
	CPI  R30,LOW(0x88)
	BREQ _0x20400A8
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x20400AA
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R30,LOW(360)
	LDI  R31,HIGH(360)
	CALL SUBOPT_0x3C
	BRLT _0x20400AC
	CALL SUBOPT_0x3D
	BRGE _0x20400AD
_0x20400AC:
	RJMP _0x20400AB
_0x20400AD:
_0x20400A8:
	CALL SUBOPT_0x42
	BRLO _0x20400AE
	MOV  R30,R16
	SUBI R30,-LOW(2)
	CALL SUBOPT_0x45
	BRNE _0x20400AF
	MOV  R30,R16
	SUBI R30,-LOW(1)
	ST   -Y,R30
	MOV  R26,R20
	RCALL _glcd_setpixel
_0x20400AF:
_0x20400AE:
_0x20400AB:
_0x20400AA:
	LDD  R26,Y+18
	CLR  R27
	LDD  R30,Y+16
	CALL SUBOPT_0x34
	MOVW R16,R26
	TST  R17
	BRPL PC+3
	JMP _0x20400B0
	LDD  R30,Y+8
	ANDI R30,LOW(0x82)
	CPI  R30,LOW(0x82)
	BREQ _0x20400B2
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x20400B4
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDI  R30,LOW(180)
	LDI  R31,HIGH(180)
	CALL SUBOPT_0x3C
	BRLT _0x20400B6
	CALL SUBOPT_0x3D
	BRGE _0x20400B7
_0x20400B6:
	RJMP _0x20400B5
_0x20400B7:
_0x20400B2:
	TST  R19
	BRMI _0x20400B8
	CALL SUBOPT_0x3E
	LDD  R26,Y+7
	CPI  R26,LOW(0x2)
	BRLO _0x20400BA
	__CPWRN 16,17,2
	BRGE _0x20400BB
_0x20400BA:
	RJMP _0x20400B9
_0x20400BB:
	MOV  R30,R16
	SUBI R30,LOW(2)
	CALL SUBOPT_0x44
	BRNE _0x20400BC
	MOV  R30,R16
	SUBI R30,LOW(1)
	ST   -Y,R30
	MOV  R26,R18
	RCALL _glcd_setpixel
_0x20400BC:
_0x20400B9:
_0x20400B8:
_0x20400B5:
_0x20400B4:
	LDD  R30,Y+8
	ANDI R30,LOW(0x84)
	CPI  R30,LOW(0x84)
	BREQ _0x20400BE
	LDD  R30,Y+8
	ANDI R30,LOW(0x80)
	BRNE _0x20400C0
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-180)
	SBCI R27,HIGH(-180)
	CALL SUBOPT_0x40
	BRLT _0x20400C2
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	SUBI R26,LOW(-180)
	SBCI R27,HIGH(-180)
	CALL SUBOPT_0x41
	BRGE _0x20400C3
_0x20400C2:
	RJMP _0x20400C1
_0x20400C3:
_0x20400BE:
	CALL SUBOPT_0x42
	BRLO _0x20400C5
	__CPWRN 16,17,2
	BRGE _0x20400C6
_0x20400C5:
	RJMP _0x20400C4
_0x20400C6:
	MOV  R30,R16
	SUBI R30,LOW(2)
	CALL SUBOPT_0x45
	BRNE _0x20400C7
	MOV  R30,R16
	SUBI R30,LOW(1)
	ST   -Y,R30
	MOV  R26,R20
	RCALL _glcd_setpixel
_0x20400C7:
_0x20400C4:
_0x20400C1:
_0x20400C0:
_0x20400B0:
	CALL __LOADLOCR6
	ADIW R28,19
	RET
_glcd_checkarc_G102:
	ST   -Y,R27
	ST   -Y,R26
	CALL __SAVELOCR4
	LDD  R26,Y+9
	CPI  R26,LOW(0x54)
	BRSH _0x20400D7
	LDD  R26,Y+8
	CPI  R26,LOW(0x30)
	BRLO _0x20400D6
_0x20400D7:
	LDI  R30,LOW(0)
	RJMP _0x2180009
_0x20400D6:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R16,X+
	LD   R17,X
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R18,X+
	LD   R19,X
	MOVW R26,R16
	LDI  R30,LOW(360)
	LDI  R31,HIGH(360)
	CALL __MODW21U
	MOVW R16,R30
	MOVW R26,R18
	LDI  R30,LOW(361)
	LDI  R31,HIGH(361)
	CALL __MODW21U
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ST   X+,R16
	ST   X,R17
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X+,R18
	ST   X,R19
	MOVW R30,R18
	MOVW R26,R16
	CALL __LEW12U
_0x2180009:
	CALL __LOADLOCR4
	ADIW R28,10
	RET
_glcd_arc:
	ST   -Y,R26
	CALL __SAVELOCR6
	CALL SUBOPT_0x46
	MOVW R30,R28
	ADIW R30,11
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R28
	ADIW R26,11
	RCALL _glcd_checkarc_G102
	CPI  R30,0
	BRNE PC+3
	JMP _0x20400D9
	LDD  R30,Y+12
	__PUTB1MN _glcd_state,10
	LDD  R30,Y+11
	__PUTB1MN _glcd_state,11
	CALL SUBOPT_0x46
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	__POINTW1MN _glcd_state,12
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _glcd_state,13
	RCALL _glcd_toradius_G102
	CALL SUBOPT_0x46
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+10
	ST   -Y,R30
	__POINTW1MN _glcd_state,14
	ST   -Y,R31
	ST   -Y,R30
	__POINTW2MN _glcd_state,15
	RCALL _glcd_toradius_G102
	__GETBRMN 21,_glcd_state,8
_0x20400DA:
	MOV  R30,R21
	SUBI R21,1
	CPI  R30,0
	BRNE PC+3
	JMP _0x20400DC
	LDD  R30,Y+6
	CPI  R30,0
	BRNE _0x20400DD
	RJMP _0x2180007
_0x20400DD:
	LDD  R30,Y+6
	SUBI R30,LOW(1)
	STD  Y+6,R30
	SUBI R30,-LOW(1)
	MOV  R16,R30
	MOV  R30,R16
	LDI  R31,0
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	SUB  R26,R30
	SBC  R27,R31
	MOVW R30,R26
	CALL __LSLW2
	CALL __ASRW2
	MOVW R18,R30
	LDI  R17,LOW(0)
_0x20400DF:
	CALL SUBOPT_0x46
	ST   -Y,R17
	ST   -Y,R16
	MOV  R30,R16
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __CDF1
	CALL __PUTPARD1
	MOV  R30,R17
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __CDF1
	MOVW R26,R30
	MOVW R24,R22
	CALL _atan2
	__GETD2N 0x42652EE1
	CALL __MULF12
	CALL __CFD1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+15
	LDD  R27,Y+15+1
	RCALL _glcd_plot8_G102
	SUBI R17,-1
	TST  R19
	BRPL _0x20400E1
	MOV  R30,R17
	LDI  R31,0
	RJMP _0x204010C
_0x20400E1:
	SUBI R16,1
	MOV  R26,R17
	CLR  R27
	MOV  R30,R16
	CALL SUBOPT_0x34
	MOVW R30,R26
_0x204010C:
	LSL  R30
	ROL  R31
	ADIW R30,1
	__ADDWRR 18,19,30,31
	CP   R16,R17
	BRSH _0x20400DF
	RJMP _0x20400DA
_0x20400DC:
_0x20400D9:
_0x2180007:
	CALL __LOADLOCR6
_0x2180008:
	ADIW R28,13
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_put_buff_G105:
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x20A0010
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,4
	CALL __GETW1P
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x20A0012
	__CPWRN 16,17,2
	BRLO _0x20A0013
	MOVW R30,R16
	SBIW R30,1
	MOVW R16,R30
	__PUTW1SNS 2,4
_0x20A0012:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ADIW R26,2
	CALL SUBOPT_0x0
	SBIW R30,1
	LDD  R26,Y+4
	STD  Z+0,R26
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CALL __GETW1P
	TST  R31
	BRMI _0x20A0014
	CALL SUBOPT_0x0
_0x20A0014:
_0x20A0013:
	RJMP _0x20A0015
_0x20A0010:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	ST   X+,R30
	ST   X,R31
_0x20A0015:
	LDD  R17,Y+1
	LDD  R16,Y+0
	JMP  _0x2180005
__print_G105:
	ST   -Y,R27
	ST   -Y,R26
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
_0x20A0016:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x20A0018
	MOV  R30,R17
	CPI  R30,0
	BRNE _0x20A001C
	CPI  R18,37
	BRNE _0x20A001D
	LDI  R17,LOW(1)
	RJMP _0x20A001E
_0x20A001D:
	CALL SUBOPT_0x47
_0x20A001E:
	RJMP _0x20A001B
_0x20A001C:
	CPI  R30,LOW(0x1)
	BRNE _0x20A001F
	CPI  R18,37
	BRNE _0x20A0020
	CALL SUBOPT_0x47
	RJMP _0x20A00C9
_0x20A0020:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x20A0021
	LDI  R16,LOW(1)
	RJMP _0x20A001B
_0x20A0021:
	CPI  R18,43
	BRNE _0x20A0022
	LDI  R20,LOW(43)
	RJMP _0x20A001B
_0x20A0022:
	CPI  R18,32
	BRNE _0x20A0023
	LDI  R20,LOW(32)
	RJMP _0x20A001B
_0x20A0023:
	RJMP _0x20A0024
_0x20A001F:
	CPI  R30,LOW(0x2)
	BRNE _0x20A0025
_0x20A0024:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x20A0026
	ORI  R16,LOW(128)
	RJMP _0x20A001B
_0x20A0026:
	RJMP _0x20A0027
_0x20A0025:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x20A001B
_0x20A0027:
	CPI  R18,48
	BRLO _0x20A002A
	CPI  R18,58
	BRLO _0x20A002B
_0x20A002A:
	RJMP _0x20A0029
_0x20A002B:
	LDI  R26,LOW(10)
	MUL  R21,R26
	MOV  R21,R0
	MOV  R30,R18
	SUBI R30,LOW(48)
	ADD  R21,R30
	RJMP _0x20A001B
_0x20A0029:
	MOV  R30,R18
	CPI  R30,LOW(0x63)
	BRNE _0x20A002F
	CALL SUBOPT_0x48
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	LDD  R26,Z+4
	ST   -Y,R26
	CALL SUBOPT_0x49
	RJMP _0x20A0030
_0x20A002F:
	CPI  R30,LOW(0x73)
	BRNE _0x20A0032
	CALL SUBOPT_0x48
	CALL SUBOPT_0x4A
	CALL _strlen
	MOV  R17,R30
	RJMP _0x20A0033
_0x20A0032:
	CPI  R30,LOW(0x70)
	BRNE _0x20A0035
	CALL SUBOPT_0x48
	CALL SUBOPT_0x4A
	CALL _strlenf
	MOV  R17,R30
	ORI  R16,LOW(8)
_0x20A0033:
	ORI  R16,LOW(2)
	ANDI R16,LOW(127)
	LDI  R19,LOW(0)
	RJMP _0x20A0036
_0x20A0035:
	CPI  R30,LOW(0x64)
	BREQ _0x20A0039
	CPI  R30,LOW(0x69)
	BRNE _0x20A003A
_0x20A0039:
	ORI  R16,LOW(4)
	RJMP _0x20A003B
_0x20A003A:
	CPI  R30,LOW(0x75)
	BRNE _0x20A003C
_0x20A003B:
	LDI  R30,LOW(_tbl10_G105*2)
	LDI  R31,HIGH(_tbl10_G105*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x20A003D
_0x20A003C:
	CPI  R30,LOW(0x58)
	BRNE _0x20A003F
	ORI  R16,LOW(8)
	RJMP _0x20A0040
_0x20A003F:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x20A0071
_0x20A0040:
	LDI  R30,LOW(_tbl16_G105*2)
	LDI  R31,HIGH(_tbl16_G105*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x20A003D:
	SBRS R16,2
	RJMP _0x20A0042
	CALL SUBOPT_0x48
	CALL SUBOPT_0x4B
	LDD  R26,Y+11
	TST  R26
	BRPL _0x20A0043
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x20A0043:
	CPI  R20,0
	BREQ _0x20A0044
	SUBI R17,-LOW(1)
	RJMP _0x20A0045
_0x20A0044:
	ANDI R16,LOW(251)
_0x20A0045:
	RJMP _0x20A0046
_0x20A0042:
	CALL SUBOPT_0x48
	CALL SUBOPT_0x4B
_0x20A0046:
_0x20A0036:
	SBRC R16,0
	RJMP _0x20A0047
_0x20A0048:
	CP   R17,R21
	BRSH _0x20A004A
	SBRS R16,7
	RJMP _0x20A004B
	SBRS R16,2
	RJMP _0x20A004C
	ANDI R16,LOW(251)
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x20A004D
_0x20A004C:
	LDI  R18,LOW(48)
_0x20A004D:
	RJMP _0x20A004E
_0x20A004B:
	LDI  R18,LOW(32)
_0x20A004E:
	CALL SUBOPT_0x47
	SUBI R21,LOW(1)
	RJMP _0x20A0048
_0x20A004A:
_0x20A0047:
	MOV  R19,R17
	SBRS R16,1
	RJMP _0x20A004F
_0x20A0050:
	CPI  R19,0
	BREQ _0x20A0052
	SBRS R16,3
	RJMP _0x20A0053
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LPM  R18,Z+
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x20A0054
_0x20A0053:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R18,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x20A0054:
	CALL SUBOPT_0x47
	CPI  R21,0
	BREQ _0x20A0055
	SUBI R21,LOW(1)
_0x20A0055:
	SUBI R19,LOW(1)
	RJMP _0x20A0050
_0x20A0052:
	RJMP _0x20A0056
_0x20A004F:
_0x20A0058:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x20A005A:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x20A005C
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x20A005A
_0x20A005C:
	CPI  R18,58
	BRLO _0x20A005D
	SBRS R16,3
	RJMP _0x20A005E
	SUBI R18,-LOW(7)
	RJMP _0x20A005F
_0x20A005E:
	SUBI R18,-LOW(39)
_0x20A005F:
_0x20A005D:
	SBRC R16,4
	RJMP _0x20A0061
	CPI  R18,49
	BRSH _0x20A0063
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x20A0062
_0x20A0063:
	RJMP _0x20A00CA
_0x20A0062:
	CP   R21,R19
	BRLO _0x20A0067
	SBRS R16,0
	RJMP _0x20A0068
_0x20A0067:
	RJMP _0x20A0066
_0x20A0068:
	LDI  R18,LOW(32)
	SBRS R16,7
	RJMP _0x20A0069
	LDI  R18,LOW(48)
_0x20A00CA:
	ORI  R16,LOW(16)
	SBRS R16,2
	RJMP _0x20A006A
	ANDI R16,LOW(251)
	ST   -Y,R20
	CALL SUBOPT_0x49
	CPI  R21,0
	BREQ _0x20A006B
	SUBI R21,LOW(1)
_0x20A006B:
_0x20A006A:
_0x20A0069:
_0x20A0061:
	CALL SUBOPT_0x47
	CPI  R21,0
	BREQ _0x20A006C
	SUBI R21,LOW(1)
_0x20A006C:
_0x20A0066:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x20A0059
	RJMP _0x20A0058
_0x20A0059:
_0x20A0056:
	SBRS R16,0
	RJMP _0x20A006D
_0x20A006E:
	CPI  R21,0
	BREQ _0x20A0070
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL SUBOPT_0x49
	RJMP _0x20A006E
_0x20A0070:
_0x20A006D:
_0x20A0071:
_0x20A0030:
_0x20A00C9:
	LDI  R17,LOW(0)
_0x20A001B:
	RJMP _0x20A0016
_0x20A0018:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL __GETW1P
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_sprintf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	CALL __SAVELOCR4
	CALL SUBOPT_0x4C
	SBIW R30,0
	BRNE _0x20A0072
	LDI  R30,LOW(65535)
	LDI  R31,HIGH(65535)
	RJMP _0x2180006
_0x20A0072:
	MOVW R26,R28
	ADIW R26,6
	CALL __ADDW2R15
	MOVW R16,R26
	CALL SUBOPT_0x4C
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R30,LOW(0)
	STD  Y+8,R30
	STD  Y+8+1,R30
	MOVW R26,R28
	ADIW R26,10
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(_put_buff_G105)
	LDI  R31,HIGH(_put_buff_G105)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R28
	ADIW R26,10
	RCALL __print_G105
	MOVW R18,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
	MOVW R30,R18
_0x2180006:
	CALL __LOADLOCR4
	ADIW R28,10
	POP  R15
	RET

	.CSEG
_bcd2bin:
	ST   -Y,R26
    ld   r30,y
    swap r30
    andi r30,0xf
    mov  r26,r30
    lsl  r26
    lsl  r26
    add  r30,r26
    lsl  r30
    ld   r26,y+
    andi r26,0xf
    add  r30,r26
    ret
_bin2bcd:
	ST   -Y,R26
    ld   r26,y+
    clr  r30
bin2bcd0:
    subi r26,10
    brmi bin2bcd1
    subi r30,-16
    rjmp bin2bcd0
bin2bcd1:
    subi r26,-10
    add  r30,r26
    ret

	.CSEG
_memset:
	ST   -Y,R27
	ST   -Y,R26
    ldd  r27,y+1
    ld   r26,y
    adiw r26,0
    breq memset1
    ldd  r31,y+4
    ldd  r30,y+3
    ldd  r22,y+2
memset0:
    st   z+,r22
    sbiw r26,1
    brne memset0
memset1:
    ldd  r30,y+3
    ldd  r31,y+4
_0x2180005:
	ADIW R28,5
	RET
_strlen:
	ST   -Y,R27
	ST   -Y,R26
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
	ST   -Y,R27
	ST   -Y,R26
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
	lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret

	.CSEG
_glcd_getmask:
	ST   -Y,R26
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__glcd_mask*2)
	SBCI R31,HIGH(-__glcd_mask*2)
	LPM  R26,Z
	LDD  R30,Y+1
	CALL __LSLB12
_0x2180004:
	ADIW R28,2
	RET
_glcd_mappixcolor1bit:
	ST   -Y,R26
	ST   -Y,R17
	LDD  R30,Y+1
	CPI  R30,LOW(0x6)
	BREQ _0x2100007
	CPI  R30,LOW(0x9)
	BRNE _0x2100008
_0x2100007:
	LDS  R17,_glcd_state
	RJMP _0x2100009
_0x2100008:
	CPI  R30,LOW(0x8)
	BRNE _0x210000B
	__GETBRMN 17,_glcd_state,1
	RJMP _0x2100009
_0x210000B:
	CPI  R30,LOW(0x7)
	BRNE _0x2100005
	__GETBRMN 17,_glcd_state,16
_0x2100009:
	__GETB1MN _glcd_state,1
	CPI  R30,0
	BREQ _0x210000E
	CPI  R17,0
	BREQ _0x210000F
	LDI  R30,LOW(255)
	LDD  R17,Y+0
	RJMP _0x2180003
_0x210000F:
	LDD  R30,Y+2
	COM  R30
	LDD  R17,Y+0
	RJMP _0x2180003
_0x210000E:
	CPI  R17,0
	BRNE _0x2100011
	LDI  R30,LOW(0)
	LDD  R17,Y+0
	RJMP _0x2180003
_0x2100011:
_0x2100005:
	LDD  R30,Y+2
	LDD  R17,Y+0
	RJMP _0x2180003
_glcd_readmem:
	ST   -Y,R27
	ST   -Y,R26
	LDD  R30,Y+2
	CPI  R30,LOW(0x1)
	BRNE _0x2100015
	LD   R30,Y
	LDD  R31,Y+1
	LPM  R30,Z
	RJMP _0x2180003
_0x2100015:
	CPI  R30,LOW(0x2)
	BRNE _0x2100016
	LD   R26,Y
	LDD  R27,Y+1
	CALL __EEPROMRDB
	RJMP _0x2180003
_0x2100016:
	CPI  R30,LOW(0x3)
	BRNE _0x2100018
	LD   R26,Y
	LDD  R27,Y+1
	__CALL1MN _glcd_state,25
	RJMP _0x2180003
_0x2100018:
	LD   R26,Y
	LDD  R27,Y+1
	LD   R30,X
_0x2180003:
	ADIW R28,3
	RET
_glcd_writemem:
	ST   -Y,R26
	LDD  R30,Y+3
	CPI  R30,0
	BRNE _0x210001C
	LD   R30,Y
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ST   X,R30
	RJMP _0x210001B
_0x210001C:
	CPI  R30,LOW(0x2)
	BRNE _0x210001D
	LD   R30,Y
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	CALL __EEPROMWRB
	RJMP _0x210001B
_0x210001D:
	CPI  R30,LOW(0x3)
	BRNE _0x210001B
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R26,Y+2
	__CALL1MN _glcd_state,27
_0x210001B:
	JMP  _0x2180002

	.CSEG
_ftrunc:
	CALL __PUTPARD2
   ldd  r23,y+3
   ldd  r22,y+2
   ldd  r31,y+1
   ld   r30,y
   bst  r23,7
   lsl  r23
   sbrc r22,7
   sbr  r23,1
   mov  r25,r23
   subi r25,0x7e
   breq __ftrunc0
   brcs __ftrunc0
   cpi  r25,24
   brsh __ftrunc1
   clr  r26
   clr  r27
   clr  r24
__ftrunc2:
   sec
   ror  r24
   ror  r27
   ror  r26
   dec  r25
   brne __ftrunc2
   and  r30,r26
   and  r31,r27
   and  r22,r24
   rjmp __ftrunc1
__ftrunc0:
   clt
   clr  r23
   clr  r30
   clr  r31
   clr  r22
__ftrunc1:
   cbr  r22,0x80
   lsr  r23
   brcc __ftrunc3
   sbr  r22,0x80
__ftrunc3:
   bld  r23,7
   ld   r26,y+
   ld   r27,y+
   ld   r24,y+
   ld   r25,y+
   cp   r30,r26
   cpc  r31,r27
   cpc  r22,r24
   cpc  r23,r25
   bst  r25,7
   ret
_floor:
	CALL SUBOPT_0x4D
	CALL _ftrunc
	CALL __PUTD1S0
    brne __floor1
__floor0:
	CALL SUBOPT_0x4E
	RJMP _0x2180002
__floor1:
    brtc __floor0
	CALL SUBOPT_0x4F
	CALL __SUBF12
	RJMP _0x2180002
_sin:
	CALL __PUTPARD2
	SBIW R28,4
	ST   -Y,R17
	LDI  R17,0
	CALL SUBOPT_0x50
	__GETD1N 0x3E22F983
	CALL __MULF12
	CALL SUBOPT_0x51
	RCALL _floor
	CALL SUBOPT_0x50
	CALL SUBOPT_0x37
	CALL SUBOPT_0x51
	CALL SUBOPT_0x38
	BREQ PC+2
	BRCC PC+3
	JMP  _0x2120017
	CALL SUBOPT_0x52
	__GETD2N 0x3F000000
	CALL SUBOPT_0x53
	LDI  R17,LOW(1)
_0x2120017:
	CALL SUBOPT_0x50
	__GETD1N 0x3E800000
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x2120018
	CALL SUBOPT_0x50
	__GETD1N 0x3F000000
	CALL SUBOPT_0x53
_0x2120018:
	CPI  R17,0
	BREQ _0x2120019
	CALL SUBOPT_0x52
	CALL __ANEGF1
	__PUTD1S 5
_0x2120019:
	CALL SUBOPT_0x52
	CALL SUBOPT_0x50
	CALL __MULF12
	__PUTD1S 1
	__GETD2N 0x4226C4B1
	CALL __MULF12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x422DE51D
	CALL SUBOPT_0x37
	CALL SUBOPT_0x54
	__GETD2N 0x4104534C
	CALL __ADDF12
	CALL SUBOPT_0x50
	CALL __MULF12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	__GETD1S 1
	__GETD2N 0x3FDEED11
	CALL __ADDF12
	CALL SUBOPT_0x54
	__GETD2N 0x3FA87B5E
	CALL __ADDF12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __DIVF21
	LDD  R17,Y+0
	ADIW R28,9
	RET
_cos:
	CALL SUBOPT_0x4D
	__GETD1N 0x3FC90FDB
	CALL __SUBF12
	MOVW R26,R30
	MOVW R24,R22
	RCALL _sin
	RJMP _0x2180002
_xatan:
	CALL SUBOPT_0x55
	CALL SUBOPT_0x56
	CALL SUBOPT_0x39
	CALL SUBOPT_0x4E
	__GETD2N 0x40CBD065
	CALL SUBOPT_0x57
	CALL SUBOPT_0x56
	CALL __MULF12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x4E
	__GETD2N 0x41296D00
	CALL __ADDF12
	CALL SUBOPT_0x3A
	CALL SUBOPT_0x57
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __DIVF21
	ADIW R28,8
	RET
_yatan:
	CALL SUBOPT_0x4D
	__GETD1N 0x3ED413CD
	CALL __CMPF12
	BRSH _0x2120020
	CALL SUBOPT_0x3A
	RCALL _xatan
	RJMP _0x2180002
_0x2120020:
	CALL SUBOPT_0x3A
	__GETD1N 0x401A827A
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x2120021
	CALL SUBOPT_0x4F
	CALL SUBOPT_0x58
	__GETD2N 0x3FC90FDB
	CALL SUBOPT_0x37
	RJMP _0x2180002
_0x2120021:
	CALL SUBOPT_0x4F
	CALL __SUBF12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x4F
	CALL __ADDF12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x58
	__GETD2N 0x3F490FDB
	CALL __ADDF12
_0x2180002:
	ADIW R28,4
	RET
_atan2:
	CALL SUBOPT_0x55
	CALL __CPD10
	BRNE _0x212002D
	__GETD1S 8
	CALL __CPD10
	BRNE _0x212002E
	__GETD1N 0x7F7FFFFF
	RJMP _0x2180001
_0x212002E:
	__GETD2S 8
	CALL __CPD02
	BRGE _0x212002F
	__GETD1N 0x3FC90FDB
	RJMP _0x2180001
_0x212002F:
	__GETD1N 0xBFC90FDB
	RJMP _0x2180001
_0x212002D:
	__GETD1S 4
	__GETD2S 8
	CALL __DIVF21
	CALL __PUTD1S0
	CALL SUBOPT_0x56
	CALL __CPD02
	BRGE _0x2120030
	LDD  R26,Y+11
	TST  R26
	BRMI _0x2120031
	CALL SUBOPT_0x3A
	RCALL _yatan
	RJMP _0x2180001
_0x2120031:
	CALL SUBOPT_0x59
	CALL __ANEGF1
	RJMP _0x2180001
_0x2120030:
	LDD  R26,Y+11
	TST  R26
	BRMI _0x2120032
	CALL SUBOPT_0x59
	__GETD2N 0x40490FDB
	CALL SUBOPT_0x37
	RJMP _0x2180001
_0x2120032:
	CALL SUBOPT_0x3A
	RCALL _yatan
	__GETD2N 0xC0490FDB
	CALL __ADDF12
_0x2180001:
	ADIW R28,12
	RET

	.CSEG

	.CSEG

	.DSEG

	.CSEG

	.DSEG
_glcd_state:
	.BYTE 0x1D
_lcd_buffer:
	.BYTE 0x8
_set:
	.BYTE 0x2
_speed:
	.BYTE 0x2
_run:
	.BYTE 0x4
_gfx_addr_G101:
	.BYTE 0x2
_gfx_buffer_G101:
	.BYTE 0x1F8
__seed_G10B:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x0:
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x1:
	LDI  R30,LOW(_Number*2)
	LDI  R31,HIGH(_Number*2)
	__PUTW1MN _glcd_state,4
	LDI  R30,LOW(0)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x2:
	ST   -Y,R30
	__POINTW2FN _0x0,10
	JMP  _glcd_outtextxyf

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x3:
	LDI  R30,LOW(1)
	__PUTB1MN _glcd_state,8
	LDI  R30,LOW(255)
	__PUTB1MN _glcd_state,9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x4:
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5:
	ST   -Y,R30
	LDI  R26,LOW(47)
	JMP  _glcd_line

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x6:
	ST   -Y,R30
	LDI  R26,LOW(46)
	JMP  _glcd_line

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7:
	ST   -Y,R30
	LDI  R26,LOW(23)
	JMP  _glcd_line

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x8:
	ST   -Y,R30
	LDI  R26,LOW(12)
	JMP  _glcd_line

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x9:
	LDI  R30,LOW(28)
	ST   -Y,R30
	LDI  R30,LOW(34)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0xA:
	LDI  R30,LOW(_NumberBig*2)
	LDI  R31,HIGH(_NumberBig*2)
	__PUTW1MN _glcd_state,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0xB:
	LDS  R30,_set
	LDS  R31,_set+1
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xC:
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(13)
	LDI  R27,HIGH(13)
	JMP  _rtc_get_time

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0xD:
	LDI  R30,LOW(0)
	CALL __EQB12
	MOV  R0,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0xE:
	LDI  R30,LOW(_lcd_buffer)
	LDI  R31,HIGH(_lcd_buffer)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xF:
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R11
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x10:
	MOV  R30,R10
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x11:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(_lcd_buffer)
	LDI  R27,HIGH(_lcd_buffer)
	JMP  _glcd_outtextxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x12:
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x13:
	LDI  R30,LOW(_Number*2)
	LDI  R31,HIGH(_Number*2)
	__PUTW1MN _glcd_state,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x14:
	LDI  R30,LOW(0)
	CALL __EQB12
	AND  R30,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x15:
	SET
	BLD  R2,0
	JMP  _screen_reload

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x16:
	LDS  R26,_set
	LDS  R27,_set+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x17:
	LDI  R26,0
	SBRC R2,3
	LDI  R26,1
	RJMP SUBOPT_0x14

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x18:
	CLR  R4
	CLR  R5
	LDI  R26,LOW(5000)
	LDI  R27,HIGH(5000)
	JMP  _pause

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x19:
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__POINTW2FN _0x0,46
	JMP  _glcd_outtextxyf

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1A:
	CALL _i2c_start
	LDI  R26,LOW(208)
	JMP  _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1B:
	CALL _i2c_write
	JMP  _i2c_stop

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1C:
	LDI  R26,LOW(1)
	CALL _i2c_read
	MOV  R26,R30
	JMP  _bcd2bin

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1D:
	CALL _i2c_write
	LD   R26,Y
	CALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1E:
	CALL _i2c_write
	LDD  R26,Y+1
	CALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1F:
	CALL _i2c_write
	LDD  R26,Y+2
	CALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x20:
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x21:
	LDS  R30,_gfx_addr_G101
	LDS  R31,_gfx_addr_G101+1
	SUBI R30,LOW(-_gfx_buffer_G101)
	SBCI R31,HIGH(-_gfx_buffer_G101)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x22:
	LDI  R26,LOW(_gfx_addr_G101)
	LDI  R27,HIGH(_gfx_addr_G101)
	RJMP SUBOPT_0x0

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x23:
	LDI  R31,0
	ADD  R26,R30
	ADC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x24:
	LDI  R31,0
	CALL __MULW12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x25:
	LDD  R30,Y+12
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ADIW R30,1
	STD  Y+7,R30
	STD  Y+7+1,R31
	SBIW R30,1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(0)
	JMP  _glcd_writemem

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x26:
	ST   -Y,R16
	LDD  R26,Y+16
	JMP  _pcd8544_setaddr_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x27:
	LDD  R30,Y+12
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ADIW R30,1
	STD  Y+7,R30
	STD  Y+7+1,R31
	SBIW R30,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x28:
	CLR  R22
	CLR  R23
	MOVW R26,R30
	MOVW R24,R22
	JMP  _glcd_readmem

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x29:
	ST   -Y,R21
	LDD  R26,Y+10
	JMP  _glcd_mappixcolor1bit

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x2A:
	ST   -Y,R16
	INC  R16
	LDD  R30,Y+16
	ST   -Y,R30
	ST   -Y,R21
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2B:
	MOV  R21,R30
	LDD  R30,Y+12
	ST   -Y,R30
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	CLR  R24
	CLR  R25
	CALL _glcd_readmem
	MOV  R1,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x2C:
	ST   -Y,R16
	INC  R16
	LDD  R30,Y+16
	ST   -Y,R30
	LDD  R30,Y+14
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ADIW R30,1
	STD  Y+9,R30
	STD  Y+9+1,R31
	SBIW R30,1
	RJMP SUBOPT_0x28

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2D:
	ST   -Y,R27
	ST   -Y,R26
	LD   R26,Y
	LDD  R27,Y+1
	CALL __CPW02
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2E:
	CALL __SAVELOCR6
	__GETW1MN _glcd_state,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2F:
	MOVW R30,R16
	__ADDWRN 16,17,1
	LPM  R0,Z
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x30:
	__GETW1MN _glcd_state,4
	ADIW R30,1
	LPM  R30,Z
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x31:
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R26,Y+4
	JMP  _glcd_moveto

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x32:
	LDD  R26,Y+6
	SUBI R26,-LOW(1)
	STD  Y+6,R26
	SUBI R26,LOW(1)
	__GETB1MN _glcd_state,8
	CP   R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x33:
	ST   -Y,R19
	LDD  R26,Y+10
	JMP  _glcd_putpixelm_G102

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x34:
	LDI  R31,0
	SUB  R26,R30
	SBC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x35:
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+9,R30
	STD  Y+9+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x36:
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+9,R30
	STD  Y+9+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x37:
	CALL __SWAPD12
	CALL __SUBF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x38:
	__GETD1N 0x3F000000
	CALL __CMPF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x39:
	CALL __MULF12
	CALL __PUTD1S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x3A:
	CALL __GETD2S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x3B:
	LDD  R26,Y+8
	CLR  R27
	CLR  R24
	CLR  R25
	CALL __CDF2
	CALL __MULF12
	MOVW R26,R30
	MOVW R24,R22
	JMP  _round_G102

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x3C:
	SUB  R30,R26
	SBC  R31,R27
	MOVW R0,R30
	MOVW R26,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CP   R26,R30
	CPC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3D:
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CP   R30,R0
	CPC  R31,R1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3E:
	ST   -Y,R16
	MOV  R26,R18
	JMP  _glcd_setpixel

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3F:
	ST   -Y,R16
	MOV  R26,R18
	SUBI R26,LOW(2)
	CALL _glcd_getpixel
	MOV  R26,R30
	LDD  R30,Y+6
	CP   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x40:
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CP   R26,R30
	CPC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x41:
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CP   R30,R26
	CPC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x42:
	ST   -Y,R16
	MOV  R26,R20
	CALL _glcd_setpixel
	LDD  R26,Y+7
	CPI  R26,LOW(0x2)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x43:
	ST   -Y,R16
	MOV  R26,R20
	SUBI R26,-LOW(2)
	CALL _glcd_getpixel
	MOV  R26,R30
	LDD  R30,Y+6
	CP   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x44:
	ST   -Y,R30
	MOV  R26,R18
	CALL _glcd_getpixel
	MOV  R26,R30
	LDD  R30,Y+6
	CP   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x45:
	ST   -Y,R30
	MOV  R26,R20
	CALL _glcd_getpixel
	MOV  R26,R30
	LDD  R30,Y+6
	CP   R30,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x46:
	LDD  R30,Y+12
	ST   -Y,R30
	LDD  R30,Y+12
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x47:
	ST   -Y,R18
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x48:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x49:
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x4A:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4B:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4C:
	MOVW R26,R28
	ADIW R26,12
	CALL __ADDW2R15
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4D:
	CALL __PUTPARD2
	RJMP SUBOPT_0x3A

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x4E:
	CALL __GETD1S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x4F:
	RCALL SUBOPT_0x4E
	__GETD2N 0x3F800000
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x50:
	__GETD2S 5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x51:
	__PUTD1S 5
	RJMP SUBOPT_0x50

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x52:
	__GETD1S 5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x53:
	CALL __SUBF12
	__PUTD1S 5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x54:
	__GETD2S 1
	CALL __MULF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x55:
	CALL __PUTPARD2
	SBIW R28,4
	__GETD1S 4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x56:
	__GETD2S 4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x57:
	CALL __MULF12
	__GETD2N 0x414A8F4E
	CALL __ADDF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x58:
	CALL __DIVF21
	MOVW R26,R30
	MOVW R24,R22
	JMP  _xatan

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x59:
	RCALL SUBOPT_0x4E
	CALL __ANEGF1
	MOVW R26,R30
	MOVW R24,R22
	JMP  _yatan


	.CSEG
	.equ __sda_bit=0
	.equ __scl_bit=1
	.equ __i2c_port=0x15 ;PORTC
	.equ __i2c_dir=__i2c_port-1
	.equ __i2c_pin=__i2c_port-2

_i2c_init:
	cbi  __i2c_port,__scl_bit
	cbi  __i2c_port,__sda_bit
	sbi  __i2c_dir,__scl_bit
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay2
_i2c_start:
	cbi  __i2c_dir,__sda_bit
	cbi  __i2c_dir,__scl_bit
	clr  r30
	nop
	sbis __i2c_pin,__sda_bit
	ret
	sbis __i2c_pin,__scl_bit
	ret
	rcall __i2c_delay1
	sbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	ldi  r30,1
__i2c_delay1:
	ldi  r22,13
	rjmp __i2c_delay2l
_i2c_stop:
	sbi  __i2c_dir,__sda_bit
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
__i2c_delay2:
	ldi  r22,27
__i2c_delay2l:
	dec  r22
	brne __i2c_delay2l
	ret
_i2c_read:
	ldi  r23,8
__i2c_read0:
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_read3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_read3
	rcall __i2c_delay1
	clc
	sbic __i2c_pin,__sda_bit
	sec
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	rol  r30
	dec  r23
	brne __i2c_read0
	mov  r23,r26
	tst  r23
	brne __i2c_read1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_read2
__i2c_read1:
	sbi  __i2c_dir,__sda_bit
__i2c_read2:
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay1

_i2c_write:
	ldi  r23,8
__i2c_write0:
	lsl  r26
	brcc __i2c_write1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_write2
__i2c_write1:
	sbi  __i2c_dir,__sda_bit
__i2c_write2:
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_write3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_write3
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	dec  r23
	brne __i2c_write0
	cbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	ldi  r30,1
	sbic __i2c_pin,__sda_bit
	clr  r30
	sbi  __i2c_dir,__scl_bit
	rjmp __i2c_delay1

_delay_ms:
	adiw r26,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r26,1
	brne __delay_ms0
__delay_ms1:
	ret

	.equ __w1_port=0x1B
	.equ __w1_bit=0x07

__ANEGF1:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __ANEGF10
	SUBI R23,0x80
__ANEGF10:
	RET

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1U:
	SET
	RJMP __CFD1U0
__CFD1:
	CLT
__CFD1U0:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRTC __CFD19
	CPI  R21,9
__CFD19:
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	BLD  R23,7
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	PUSH R20
	MOVW R20,R30
	MOVW R30,R26
	MOVW R26,R20
	MOVW R20,R22
	MOVW R22,R24
	MOVW R24,R20
	MOV  R20,R0
	MOV  R0,R1
	MOV  R1,R20
	POP  R20
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__SUBF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129
	LDI  R21,0x80
	EOR  R1,R21

	RJMP __ADDF120

__ADDF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF1211
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF1211:
	BRCC __ADDF128
	RJMP __ADDF129
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __DIVF219
	RJMP __MINRES
__DIVF219:
	RJMP __MAXRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R1
	CLR  R17
	CLR  R18
	CLR  R19
	CLR  R20
	CLR  R21
	LDI  R25,32
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R20,R17
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R20,R17
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R21
	ROL  R18
	ROL  R19
	ROL  R1
	ROL  R26
	ROL  R27
	ROL  R24
	ROL  R20
	DEC  R25
	BRNE __DIVF212
	MOVW R30,R18
	MOV  R22,R1
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	TST  R22
	BRMI __DIVF215
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__CMPF12:
	TST  R25
	BRMI __CMPF120
	TST  R23
	BRMI __CMPF121
	CP   R25,R23
	BRLO __CMPF122
	BRNE __CMPF121
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __CMPF122
	BREQ __CMPF123
__CMPF121:
	CLZ
	CLC
	RET
__CMPF122:
	CLZ
	SEC
	RET
__CMPF123:
	SEZ
	CLC
	RET
__CMPF120:
	TST  R23
	BRPL __CMPF122
	CP   R25,R23
	BRLO __CMPF121
	BRNE __CMPF122
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	BRLO __CMPF122
	BREQ __CMPF123
	RJMP __CMPF121

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__LSRB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSRB12R
__LSRB12L:
	LSR  R30
	DEC  R0
	BRNE __LSRB12L
__LSRB12R:
	RET

__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__ASRW2:
	ASR  R31
	ROR  R30
	ASR  R31
	ROR  R30
	RET

__CBD1:
	MOV  R31,R30
	ADD  R31,R31
	SBC  R31,R31
	MOV  R22,R31
	MOV  R23,R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__CBD2:
	MOV  R27,R26
	ADD  R27,R27
	SBC  R27,R27
	MOV  R24,R27
	MOV  R25,R27
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__GTB12U:
	CP   R30,R26
	LDI  R30,1
	BRLO __GTB12U1
	CLR  R30
__GTB12U1:
	RET

__LTW12:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRLT __LTW12T
	CLR  R30
__LTW12T:
	RET

__GTW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRLT __GTW12T
	CLR  R30
__GTW12T:
	RET

__LEW12U:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRSH __LEW12UT
	CLR  R30
__LEW12UT:
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVD21U:
	PUSH R19
	PUSH R20
	PUSH R21
	CLR  R0
	CLR  R1
	CLR  R20
	CLR  R21
	LDI  R19,32
__DIVD21U1:
	LSL  R26
	ROL  R27
	ROL  R24
	ROL  R25
	ROL  R0
	ROL  R1
	ROL  R20
	ROL  R21
	SUB  R0,R30
	SBC  R1,R31
	SBC  R20,R22
	SBC  R21,R23
	BRCC __DIVD21U2
	ADD  R0,R30
	ADC  R1,R31
	ADC  R20,R22
	ADC  R21,R23
	RJMP __DIVD21U3
__DIVD21U2:
	SBR  R26,1
__DIVD21U3:
	DEC  R19
	BRNE __DIVD21U1
	MOVW R30,R26
	MOVW R22,R24
	MOVW R26,R0
	MOVW R24,R20
	POP  R21
	POP  R20
	POP  R19
	RET

__MODW21U:
	RCALL __DIVW21U
	MOVW R30,R26
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__GETD1S0:
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R22,Y+2
	LDD  R23,Y+3
	RET

__GETD2S0:
	LD   R26,Y
	LDD  R27,Y+1
	LDD  R24,Y+2
	LDD  R25,Y+3
	RET

__PUTD1S0:
	ST   Y,R30
	STD  Y+1,R31
	STD  Y+2,R22
	STD  Y+3,R23
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__PUTPARD2:
	ST   -Y,R25
	ST   -Y,R24
	ST   -Y,R27
	ST   -Y,R26
	RET

__CDF2U:
	SET
	RJMP __CDF2U0
__CDF2:
	CLT
__CDF2U0:
	RCALL __SWAPD12
	RCALL __CDF1U0

__SWAPD12:
	MOV  R1,R24
	MOV  R24,R22
	MOV  R22,R1
	MOV  R1,R25
	MOV  R25,R23
	MOV  R23,R1

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__CPD10:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	RET

__CPW02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	RET

__CPD02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	CPC  R0,R24
	CPC  R0,R25
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
