#include <mega32.h>
#include <delay.h>
#include <stdio.h>

// color definitions
#define    BLACK     0x0000
#define    BLUE      0x001F
#define    RED       0xF800
#define    GREEN     0x07E0
#define    CYAN      0x07FF
#define    MAGENTA   0xF81F
#define    YELLOW    0xFFE0
#define    WHITE	 0xFFFF



#define LCD_LO_DDR  DDRA
#define LCD_LO_PORT PORTA   //  ,  
#define GET_LCD_LO  PINA

#define LCD_HI_DDR  DDRC
#define LCD_HI_PORT PORTC   //  ,  
#define GET_LCD_HI  PINC

#define LCD_CS_DDR  DDRB
#define LCD_CS_PORT PORTB    // CS (Chip Select)
#define LCD_CS_PIN  PINB
#define LCD_CS_BIT  0

#define LCD_RS_DDR  DDRB
#define LCD_RS_PORT PORTB    // RS (Register Select)
#define LCD_RS_PIN  PINB
#define LCD_RS_BIT  1

#define LCD_RD_DDR  DDRB
#define LCD_RD_PORT PORTB    // RD (Read Data Select)
#define LCD_RD_PIN  PINB
#define LCD_RD_BIT  2

#define LCD_WR_DDR  DDRB
#define LCD_WR_PORT PORTB    // WR (Write Data Select)
#define LCD_WR_PIN  PINB
#define LCD_WR_BIT  3

#define LCD_RST_DDR  DDRB
#define LCD_RST_PORT PORTB  // RST (Chip Reset Select)
#define LCD_RST_PIN  PINB
#define LCD_RST_BIT  4


#define LCD_BL_DDR  DDRB
#define LCD_BL_PORT PORTB    // BL (Backlight Power)
#define LCD_BL_PIN  PINB
#define LCD_BL_BIT  5

#define LCD_CS_H() LCD_CS_PORT |= 1<<LCD_CS_BIT
#define LCD_CS_L() LCD_CS_PORT &= ~(1<<LCD_CS_BIT)

#define LCD_RS_H() LCD_RS_PORT |= 1<<LCD_RS_BIT
#define LCD_RS_L() LCD_RS_PORT &= ~(1<<LCD_RS_BIT)

#define LCD_WR_L() LCD_WR_PORT |= 1<<LCD_WR_BIT
#define LCD_WR_H() LCD_WR_PORT &= ~(1<<LCD_WR_BIT)

#define LCD_RD_H() LCD_RD_PORT |= 1<<LCD_RD_BIT
#define LCD_RD_L() LCD_RD_PORT &= ~(1<<LCD_RD_BIT)

#define LCD_RST_H() LCD_RST_PORT |= 1<<LCD_RST_BIT
#define LCD_RST_L() LCD_RST_PORT &= ~(1<<LCD_RST_BIT)

#define LCD_BL_H() LCD_BL_PORT |= 1<<LCD_BL_BIT
#define LCD_BL_L() LCD_BL_PORT &= ~(1<<LCD_BL_BIT)


//-------------------------------------------------------------
//     
//-------------------------------------------------------------

void DATA_INPUT(void)
{ 
   LCD_LO_DDR = 0x00; 
   LCD_HI_DDR = 0x00;
}  


//-------------------------------------------------------------
//     
//-------------------------------------------------------------

void DATA_OUTPUT(void)
{  
   LCD_LO_DDR = 0xFF;
   LCD_HI_DDR = 0xFF;
}


//-------------------------------------------------------------
//  .  
//-------------------------------------------------------------

void LCD_PORT_INI(void)
{
   LCD_BL_DDR |= 1<<LCD_BL_BIT;\
   LCD_CS_DDR |= 1<<LCD_CS_BIT;\
   LCD_RS_DDR |= 1<<LCD_RS_BIT;\
   LCD_WR_DDR |= 1<<LCD_WR_BIT;\
   LCD_RD_DDR |= 1<<LCD_RD_BIT;\
   LCD_RST_DDR|= 1<<LCD_RST_BIT;\
}


//-------------------------------------------------------------
//     
//-------------------------------------------------------------

    void LCD_WR_REG(unsigned int index,unsigned int data)
{
	LCD_CS_L();
	LCD_RS_L();
	DATA_OUTPUT();
	LCD_LO_PORT = index;
	LCD_HI_PORT = index>>8;
	LCD_WR_L();
	#asm("nop")
    #asm("nop") 
	LCD_WR_H();
	LCD_RS_H();
	LCD_LO_PORT = data;
	LCD_HI_PORT = data>>8;
	LCD_WR_L();
	#asm("nop")
    #asm("nop")
	LCD_WR_H();
	LCD_CS_H();
}


//-------------------------------------------------------------
//      
//-------------------------------------------------------------
 
 void LCD_Write_Data(unsigned int val)
{
	LCD_LO_PORT = (unsigned char)val;
	LCD_HI_PORT = (unsigned char)(val>>8);
	LCD_WR_L();
	#asm("nop")
    #asm("nop")
	LCD_WR_H();
}

     
     
//-------------------------------------------------------------
//      00022
//-------------------------------------------------------------

void LCD_Write_Start()
{
	LCD_CS_L();
	LCD_RS_L();
	DATA_OUTPUT();
	LCD_LO_PORT = 0x22;
	LCD_HI_PORT = 0x00;
	LCD_WR_L();
	#asm("nop")
    #asm("nop")
	LCD_WR_H();
	LCD_RS_H();
}


//-------------------------------------------------------------
//     ( )
//-------------------------------------------------------------

void LCD_Write_End()
{
     LCD_WR_H();
     LCD_CS_H();
}


//-------------------------------------------------------------
//    
//-------------------------------------------------------------

void Display_ON()  
{
	LCD_WR_REG(0x07,0x0173);
}


//-------------------------------------------------------------
//    
//-------------------------------------------------------------

void Display_OFF() 
{	
	LCD_WR_REG(0x07,0x0000);
}


//-------------------------------------------------------------
//    (  R61501)
//-------------------------------------------------------------

void LCD_Init()
{
    LCD_PORT_INI();
    DATA_OUTPUT(); // <change port to output>

	LCD_RST_L();
	delay_ms(10);
	LCD_RST_H();

	//delay 10ms
	delay_ms(10);
  
	//initializing funciton 1
	LCD_WR_REG(0xe5,0x8000);  // Set the internal vcore voltage
	LCD_WR_REG(0x00,0x0001);  // start OSC
	LCD_WR_REG(0x2b,0x0010);  //Set the frame rate as 80 when the internal resistor is used for oscillator circuit
	LCD_WR_REG(0x01,0x0100);  //s720  to  s1 ; G1 to G320
	LCD_WR_REG(0x02,0x0700);  //set the line inversion
	LCD_WR_REG(0x03,0x1018);  //65536 colors 
	//LCD_WR_REG(0x03,0x1030);
	LCD_WR_REG(0x04,0x0000);
	LCD_WR_REG(0x08,0x0202);  //specify the line number of front and back porch periods respectively
	LCD_WR_REG(0x09,0x0000);
	LCD_WR_REG(0x0a,0x0000);
	LCD_WR_REG(0x0c,0x0000);  //select  internal system clock
	LCD_WR_REG(0x0d,0x0000);
	LCD_WR_REG(0x0f,0x0000); 
	LCD_WR_REG(0x50,0x0000);  //0x50 -->0x53 set windows adress
	LCD_WR_REG(0x51,0x00ef);
	LCD_WR_REG(0x52,0x0000);
	LCD_WR_REG(0x53,0x013f);
	LCD_WR_REG(0x60,0x2700);
	LCD_WR_REG(0x61,0x0001);
	LCD_WR_REG(0x6a,0x0000);
	LCD_WR_REG(0x80,0x0000);
	LCD_WR_REG(0x81,0x0000);
	LCD_WR_REG(0x82,0x0000);
	LCD_WR_REG(0x83,0x0000);
	LCD_WR_REG(0x84,0x0000);
	LCD_WR_REG(0x85,0x0000);
	LCD_WR_REG(0x90,0x0010);
	LCD_WR_REG(0x92,0x0000);
	LCD_WR_REG(0x93,0x0003);
	LCD_WR_REG(0x95,0x0110);
	LCD_WR_REG(0x97,0x0000);
	LCD_WR_REG(0x98,0x0000); 

	//power setting function
	LCD_WR_REG(0x10,0x0000);
	LCD_WR_REG(0x11,0x0000);
	LCD_WR_REG(0x12,0x0000);
	LCD_WR_REG(0x13,0x0000);
	delay_ms(200);
	LCD_WR_REG(0x10,0x17b0);
	LCD_WR_REG(0x11,0x0004);
	delay_ms(50);
	LCD_WR_REG(0x12,0x013e);
	delay_ms(50);
	LCD_WR_REG(0x13,0x1f00);
	LCD_WR_REG(0x29,0x000f);
	delay_ms(50);
	LCD_WR_REG(0x20,0x0000);
	LCD_WR_REG(0x21,0x0000);

	//initializing function 2

	LCD_WR_REG(0x30,0x0204);
	LCD_WR_REG(0x31,0x0001);
	LCD_WR_REG(0x32,0x0000);
	LCD_WR_REG(0x35,0x0206);
	LCD_WR_REG(0x36,0x0600);
	LCD_WR_REG(0x37,0x0500);
	LCD_WR_REG(0x38,0x0505);
	LCD_WR_REG(0x39,0x0407);
	LCD_WR_REG(0x3c,0x0500);
	LCD_WR_REG(0x3d,0x0503);

	//display on
	LCD_WR_REG(0x07,0x0173);  
 	Display_ON();  	
}
      


//-------------------------------------------------------------
//    
//-------------------------------------------------------------

void LCD_Set_XY(unsigned int x, unsigned int y)
{
	LCD_WR_REG(0x20,x);
	LCD_WR_REG(0x21,y);
}


//-------------------------------------------------------------
//    
//-------------------------------------------------------------

void LCD_Set_Window(unsigned int startX,unsigned int startY,unsigned int endX,unsigned int endY)
{
	LCD_Set_XY(startX,startY);
	LCD_WR_REG(0x50, startX);
	LCD_WR_REG(0x51, endX);
	LCD_WR_REG(0x52, startY);
	LCD_WR_REG(0x53, endY);	
	//LCD_Set_XY(endX, endY);
}


//-------------------------------------------------------------
//    
//-------------------------------------------------------------

 void LCD_Clear(unsigned int color)
{
    long int i,;
    LCD_Set_XY(0,0);
    LCD_Write_Start();
	for(i=0;i<=76799;i++)
	{
    LCD_Write_Data(color);
    }
	LCD_Write_End();
 } 
 
 
//-------------------------------------------------------------
//     
//-------------------------------------------------------------
 
void LCD_PutPixel(char x, unsigned int y, unsigned int color)
{
  LCD_Set_XY(x,y);
  LCD_Write_Start();
  LCD_Write_Data(color);
}


//-------------------------------------------------------------
//    ( )
//-------------------------------------------------------------  

void LCD_test()
{
	unsigned int i,j;
    LCD_Set_Window(0,0,239,319);
	LCD_Write_Start();
	for(i=0;i<320;i++)
	{	for(j=0;j<240;j++)
		{
			if(i>279)LCD_Write_Data(0x0000);
			else if(i>239)LCD_Write_Data(0x001f);
			else if(i>199)LCD_Write_Data(0x07e0);
			else if(i>159)LCD_Write_Data(0x07ff);
			else if(i>119)LCD_Write_Data(0xf800);
			else if(i>79)LCD_Write_Data(0xf81f);
			else if(i>39)LCD_Write_Data(0xffe0);
			else LCD_Write_Data(0xffff);
		}
    }
	LCD_Write_End();
} 


//-------------------------------------------------------------
//   
//-------------------------------------------------------------

void main(void) 
{

  LCD_Init();
  LCD_Clear(BLACK);
  LCD_BL_H();  
  
   while(1)
    { 
    LCD_BL_H(); 
    
    LCD_test();
    
    delay_ms(5000);   
    
    LCD_Clear(BLACK);
    
    delay_ms(500);
    
    LCD_Clear(BLUE);
    
    delay_ms(500);
    
    LCD_Clear(RED);
    
    delay_ms(500);
    
    LCD_Clear(GREEN);
    
    delay_ms(500);
    
    LCD_Clear(CYAN);
    
    delay_ms(500);
    
    LCD_Clear(MAGENTA);
    
    delay_ms(500);
    
    LCD_Clear(YELLOW);  
    
    delay_ms(500);
    
    LCD_Clear(WHITE);
        
    delay_ms(500);  
    
    LCD_Clear(BLACK);
    LCD_PutPixel(50,50,RED);
    LCD_PutPixel(100,100,GREEN);   
    LCD_PutPixel(200,200,BLUE);   
    
    delay_ms(5000); 
     
    LCD_BL_L(); 
    delay_ms(500);  
}
                
}

