; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0037
	ORG 0x0004
	RETFIE
; Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	MOVF R2L,W
	RETURN
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	MOVF R0L,W
	RETURN
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	GOTO C007
C002:	MOVWF R1L
	MOVLW 0x02
	GOTO C007
C003:	MOVWF R1L
	MOVLW 0x06
	GOTO C007
C004:	MOVWF R1L
	MOVLW 0x03
	GOTO C007
C005:	MOVWF R1L
	MOVLW 0x04
	GOTO C007
C006:	MOVWF R1L
	MOVLW 0x01
	GOTO C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x3A
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x04
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine - Word Argument
Y001:	MOVLW 0x06
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	RLF R0L,F
	MOVLW 0x38
	ANDWF R0L,F
	MOVLW 0xC1
	IORWF R0L,W
	MOVWF ADCON0
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Lcdout Routine
LC01:	MOVWF R4L
	BSF 0x07,0
	MOVLW 0x0F
	ANDWF 0x06,F
	MOVF R4L,W
	ANDLW 0xF0
	IORWF 0x06,F
	CALL LCX1
	SWAPF R4L,F
	MOVLW 0x0F
	ANDWF 0x06,F
	MOVF R4L,W
	ANDLW 0xF0
	IORWF 0x06,F
	CALL LCX1
	MOVLW 0x64
	MOVWF R4L
	CALL X001
	RETURN
LCX1:	BSF 0x07,5
	NOP
	NOP
	NOP
	BCF 0x07,5
	RETURN
; Lcdcmdout Routine
LC02:	MOVWF R4L
	BCF 0x07,0
	MOVLW 0x0F
	ANDWF 0x06,F
	MOVF R4L,W
	ANDLW 0xF0
	IORWF 0x06,F
	CALL LCX1
	SWAPF R4L,F
	MOVLW 0x0F
	ANDWF 0x06,F
	MOVF R4L,W
	ANDLW 0xF0
	IORWF 0x06,F
	BSF 0x07,5
	NOP
	NOP
	NOP
	BCF 0x07,5
	MOVLW 0x88
	MOVWF R4L
	MOVLW 0x13
	MOVWF R4H
	CALL Y001
	RETURN
; Lcdout Decimal Conversion Routine
LC21:	BSF R3H,7
	MOVLW 0x27
	MOVWF R1H
	MOVLW 0x10
	CALL LC22
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	CALL LC22
	CLRF R1H
	MOVLW 0x64
	CALL LC22
	CLRF R1H
	MOVLW 0x0A
	CALL LC22
	MOVF R2L,W
	GOTO LC23
LC22:	MOVWF R1L
	MOVF R2H,W
	MOVWF R0H
	MOVF R2L,W
	MOVWF R0L
	CALL D001
	MOVF R0L,W
	BTFSS STATUS,Z
	BCF R3H,7
	BTFSC R3H,7
	RETURN
LC23:	ADDLW 0x30
	CALL LC01
	RETURN
; Hardware Serial Communication Routines
HS01:	BTFSC PIR1,TXIF
	GOTO HS02
	GOTO HS01
HS02:	MOVWF TXREG
	RETURN
HS10:	BTFSC PIR1,RCIF
	GOTO HS11
	GOTO HS10
HS11:	MOVF RCREG,W
	RETURN
; Hserout Decimal Conversion Routine
HS21:	BSF R3H,7
	MOVLW 0x27
	MOVWF R1H
	MOVLW 0x10
	CALL HS22
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	CALL HS22
	CLRF R1H
	MOVLW 0x64
	CALL HS22
	CLRF R1H
	MOVLW 0x0A
	CALL HS22
	MOVF R2L,W
	GOTO HS23
HS22:	MOVWF R1L
	MOVF R2H,W
	MOVWF R0H
	MOVF R2L,W
	MOVWF R0L
	CALL D001
	MOVF R0L,W
	BTFSS STATUS,Z
	BCF R3H,7
	BTFSC R3H,7
	RETURN
HS23:	ADDLW 0x30
	CALL HS01
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:	CALL IC21
	CALL IC23
	GOTO IC29
IC41:	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; I2CRead Routine
IC11:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC12:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC12
	CALL IC25
	CALL IC20
	CALL IC22
	CALL IC23
	CALL IC21
	MOVF R0L,W
	RETURN
IC13:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC14:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC14
	CALL IC25
	CALL IC21
	CALL IC22
	CALL IC23
	MOVF R0L,W
	RETURN
; Begin of program
L0037:
; 1: Define CONF_WORD = 0x3f72
; 2: Define CLOCK_FREQUENCY = 12
; 3: 
; 4: Symbol t_right = PORTB.3
;       The address of 't_right' is 0x6,3
; 5: Symbol t_down = PORTB.2
;       The address of 't_down' is 0x6,2
; 6: Symbol t_up = PORTB.1
;       The address of 't_up' is 0x6,1
; 7: Symbol t_left = PORTB.0
;       The address of 't_left' is 0x6,0
; 8: Symbol ledcharge = PORTA.1
;       The address of 'ledcharge' is 0x5,1
; 9: Symbol leddischarge = PORTA.5
;       The address of 'leddischarge' is 0x5,5
; 10: Symbol charge = PORTC.2
;       The address of 'charge' is 0x7,2
; 11: Symbol discharge = PORTC.1
;       The address of 'discharge' is 0x7,1
; 12: Symbol i2cclock = PORTC.3
;       The address of 'i2cclock' is 0x7,3
; 13: Symbol i2cdata = PORTC.4
;       The address of 'i2cdata' is 0x7,4
; 14: 
; 15: Define LCD_BITS = 4
; 16: Define LCD_DREG = PORTB
; 17: Define LCD_DBIT = 4
; 18: Define LCD_RSREG = PORTC
; 19: Define LCD_RSBIT = 0
; 20: Define LCD_EREG = PORTC
; 21: Define LCD_EBIT = 5
; 22: 
; 23: Const c_right = 1
;       The value of 'c_right' is 1
; 24: Const c_up = 2
;       The value of 'c_up' is 2
; 25: Const c_down = 3
;       The value of 'c_down' is 3
; 26: Const c_left = 4
;       The value of 'c_left' is 4
; 27: 
; 28: Dim vin As Word
;       The address of 'vin' is 0x31
	vin EQU 0x31
; 29: Dim i As Byte
;       The address of 'i' is 0x33
	i EQU 0x33
; 30: Dim j As Byte
;       The address of 'j' is 0x34
	j EQU 0x34
; 31: Dim an0 As Word
;       The address of 'an0' is 0x35
	an0 EQU 0x35
; 32: Dim vmod As Word
;       The address of 'vmod' is 0x37
	vmod EQU 0x37
; 33: Dim vfinal As Word
;       The address of 'vfinal' is 0x39
	vfinal EQU 0x39
; 34: 
; 35: Dim v(13) As Word
;       The address of 'v' is 0x3B
	v EQU 0x3B
; 36: Dim vmax As Word
;       The address of 'vmax' is 0x55
	vmax EQU 0x55
; 37: Dim vmaxdelay As Byte
;       The address of 'vmaxdelay' is 0x57
	vmaxdelay EQU 0x57
; 38: Dim vmaxnum As Byte
;       The address of 'vmaxnum' is 0x58
	vmaxnum EQU 0x58
; 39: 
; 40: Dim finish As Bit
;       The address of 'finish' is 0x30,0
; 41: Dim address As Word
;       The address of 'address' is 0x59
	address EQU 0x59
; 42: Dim seconds As Byte
;       The address of 'seconds' is 0x5B
	seconds EQU 0x5B
; 43: Dim minutes As Word
;       The address of 'minutes' is 0x5C
	minutes EQU 0x5C
; 44: Dim hours As Byte
;       The address of 'hours' is 0x5E
	hours EQU 0x5E
; 45: 
; 46: Dim voltage As Word
;       The address of 'voltage' is 0x5F
	voltage EQU 0x5F
; 47: Dim voltage1 As Word
;       The address of 'voltage1' is 0x61
	voltage1 EQU 0x61
; 48: Dim voltage2 As Word
;       The address of 'voltage2' is 0x63
	voltage2 EQU 0x63
; 49: Dim cnt As Word
;       The address of 'cnt' is 0x65
	cnt EQU 0x65
; 50: Dim sample As Word
;       The address of 'sample' is 0x67
	sample EQU 0x67
; 51: 
; 52: Dim program As Byte
;       The address of 'program' is 0x69
	program EQU 0x69
; 53: Dim phase As Byte
;       The address of 'phase' is 0x6A
	phase EQU 0x6A
; 54: Dim key As Byte
;       The address of 'key' is 0x6B
	key EQU 0x6B
; 55: 
; 56: Dim dischargelimit As Word
;       The address of 'dischargelimit' is 0x6C
	dischargelimit EQU 0x6C
; 57: Dim signalfiltertype As Byte
;       The address of 'signalfiltertype' is 0x6E
	signalfiltertype EQU 0x6E
; 58: Dim peakgap As Byte
;       The address of 'peakgap' is 0x6F
	peakgap EQU 0x6F
; 59: Dim peakdetect As Byte
;       The address of 'peakdetect' is 0x70
	peakdetect EQU 0x70
; 60: Dim mintime As Byte
;       The address of 'mintime' is 0x71
	mintime EQU 0x71
; 61: Dim minvalue As Word
;       The address of 'minvalue' is 0x72
	minvalue EQU 0x72
; 62: Dim maxtime As Word
;       The address of 'maxtime' is 0x74
	maxtime EQU 0x74
; 63: 
; 64: PORTA = 0
	CLRF 0x05
; 65: PORTB = 0
	CLRF 0x06
; 66: PORTC = 0
	CLRF 0x07
; 67: TRISA.1 = 0
	BSF STATUS,RP0
	BCF 0x05,1
	BCF STATUS,RP0
; 68: TRISA.5 = 0
	BSF STATUS,RP0
	BCF 0x05,5
	BCF STATUS,RP0
; 69: TRISC.2 = 0
	BSF STATUS,RP0
	BCF 0x07,2
	BCF STATUS,RP0
; 70: TRISC.1 = 0
	BSF STATUS,RP0
	BCF 0x07,1
	BCF STATUS,RP0
; 71: AllDigital
	BSF STATUS,RP0
	MOVLW 0x06
	MOVWF 0x1F
	BCF STATUS,RP0
; 72: ADCON1 = 0x0f
	BSF STATUS,RP0
	MOVLW 0x0F
	MOVWF 0x1F
	BCF STATUS,RP0
; 73: Hseropen 19200
;       Exact baud rate: 19231
;       Baud rate error: 31 (.161%)
	BSF STATUS,RP0
	MOVLW 0x26
	MOVWF SPBRG
	BSF TRISC,6
	BSF TRISC,7
	MOVLW 0x24
	MOVWF TXSTA
	BCF STATUS,RP0
	MOVLW 0x90
	MOVWF RCSTA
; 74: Lcdinit
	BCF 0x07,5
	BCF 0x07,0
	BSF STATUS,RP0
	BCF 0x07,5
	BCF 0x07,0
	MOVLW 0x0F
	ANDWF 0x06,F
	BCF STATUS,RP0
	MOVLW 0x64
	MOVWF R0L
	MOVLW 0x00
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
	MOVLW 0x33
	CALL LC02
	MOVLW 0x33
	CALL LC02
	MOVLW 0x33
	CALL LC02
	MOVLW 0x22
	CALL LC02
	MOVLW 0x28
	CALL LC02
	MOVLW 0x0C
	CALL LC02
	MOVLW 0x01
	CALL LC02
; 75: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 76: 
; 77: Gosub loadparameters
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0023
; 78: 
; 79: newprogram: 
L0001:
; 80: Gosub welcome
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0002
; 81: Gosub selectprogram
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 82: If program = 1 Then Gosub prog_charge
	MOVF 0x69,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0038
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0011
L0038:	MOVLW 0x1F
	ANDWF STATUS,F
; 83: If program = 2 Then Gosub prog_discharge
	MOVF 0x69,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0039
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0010
L0039:	MOVLW 0x1F
	ANDWF STATUS,F
; 84: If program = 3 Then Goto prog_cycle
	MOVF 0x69,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0040
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0012
L0040:	MOVLW 0x1F
	ANDWF STATUS,F
; 85: If program = 4 Then Goto prog_setup
	MOVF 0x69,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0041
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0014
L0041:	MOVLW 0x1F
	ANDWF STATUS,F
; 86: If program = 5 Then Gosub prog_setupdefaults
	MOVF 0x69,W
	SUBLW 0x05
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0042
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0013
L0042:	MOVLW 0x1F
	ANDWF STATUS,F
; 87: If program = 6 Then Goto prog_memory
	MOVF 0x69,W
	SUBLW 0x06
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0043
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0035
L0043:	MOVLW 0x1F
	ANDWF STATUS,F
; 88: Goto newprogram
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0001
; 89: End
	BCF PCLATH,3
	BCF PCLATH,4
L0044:	GOTO L0044
; 90: 
; 91: welcome: 
L0002:
; 92: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 93: Lcdout "OshonSoft Cycler"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4F
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x53
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x66
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x43
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x72
	CALL LC01
; 94: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 95: Lcdout "Initializing..."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x49
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x7A
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
; 96: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 97: Return
	RETURN
; 98: 
; 99: selectprogram: 
L0003:
; 100: phase = 1
	MOVLW 0x01
	MOVWF 0x6A
; 101: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 102: Lcdout "Select Program:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x53
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x50
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 103: loop1: 
L0004:
; 104: Lcdcmdout LcdLine2Clear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
	MOVLW 0x28
	MOVWF R0L
L0045:	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC01
	BCF PCLATH,3
	BCF PCLATH,4
	DECFSZ R0L,F
	GOTO L0045
	MOVLW 0xC0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC02
; 105: If phase = 1 Then Lcdout "1-Charge"
	MOVF 0x6A,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0046
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x31
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x43
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0046:	MOVLW 0x1F
	ANDWF STATUS,F
; 106: If phase = 2 Then Lcdout "2-Discharge"
	MOVF 0x6A,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0047
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x32
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x44
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0047:	MOVLW 0x1F
	ANDWF STATUS,F
; 107: If phase = 3 Then Lcdout "3-Cycle"
	MOVF 0x6A,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0048
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x33
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x43
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0048:	MOVLW 0x1F
	ANDWF STATUS,F
; 108: If phase = 4 Then Lcdout "4-Setup"
	MOVF 0x6A,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0049
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x34
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x53
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x70
	CALL LC01
L0049:	MOVLW 0x1F
	ANDWF STATUS,F
; 109: If phase = 5 Then Lcdout "5-Setup defaults"
	MOVF 0x6A,W
	SUBLW 0x05
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0050
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x35
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x53
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x64
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x66
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x73
	CALL LC01
L0050:	MOVLW 0x1F
	ANDWF STATUS,F
; 110: If phase = 6 Then Lcdout "6-Memory"
	MOVF 0x6A,W
	SUBLW 0x06
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0051
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x36
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x79
	CALL LC01
L0051:	MOVLW 0x1F
	ANDWF STATUS,F
; 111: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 112: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0052
; 113: phase = phase + 1
	MOVF 0x6A,W
	ADDLW 0x01
	MOVWF 0x6A
; 114: If phase = 7 Then phase = 1
	MOVF 0x6A,W
	SUBLW 0x07
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0053
	MOVLW 0x01
	MOVWF 0x6A
L0053:	MOVLW 0x1F
	ANDWF STATUS,F
; 115: Goto loop1
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0004
; 116: Endif
L0052:	MOVLW 0x1F
	ANDWF STATUS,F
; 117: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0054
; 118: phase = phase - 1
	MOVLW 0x01
	SUBWF 0x6A,W
	MOVWF 0x6A
; 119: If phase = 0 Then phase = 6
	MOVF 0x6A,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0055
	MOVLW 0x06
	MOVWF 0x6A
L0055:	MOVLW 0x1F
	ANDWF STATUS,F
; 120: Goto loop1
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0004
; 121: Endif
L0054:	MOVLW 0x1F
	ANDWF STATUS,F
; 122: If key = c_right Then program = phase
	MOVF 0x6B,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0056
	MOVF 0x6A,W
	MOVWF 0x69
L0056:	MOVLW 0x1F
	ANDWF STATUS,F
; 123: If key = c_left Then program = 0
	MOVF 0x6B,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0057
	CLRF 0x69
L0057:	MOVLW 0x1F
	ANDWF STATUS,F
; 124: Return
	RETURN
; 125: 
; 126: waitkey: 
L0005:
; 127: key = 0
	CLRF 0x6B
; 128: If t_right = 1 Then key = c_right
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,3
	GOTO L0058
	MOVLW 0x01
	MOVWF 0x6B
L0058:	MOVLW 0x1F
	ANDWF STATUS,F
; 129: If t_up = 1 Then key = c_up
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,1
	GOTO L0059
	MOVLW 0x02
	MOVWF 0x6B
L0059:	MOVLW 0x1F
	ANDWF STATUS,F
; 130: If t_down = 1 Then key = c_down
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,2
	GOTO L0060
	MOVLW 0x03
	MOVWF 0x6B
L0060:	MOVLW 0x1F
	ANDWF STATUS,F
; 131: If t_left = 1 Then key = c_left
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,0
	GOTO L0061
	MOVLW 0x04
	MOVWF 0x6B
L0061:	MOVLW 0x1F
	ANDWF STATUS,F
; 132: If key = 0 Then Goto waitkey
	MOVF 0x6B,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0062
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0005
L0062:	MOVLW 0x1F
	ANDWF STATUS,F
; 133: Gosub debounce
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0007
; 134: Return
	RETURN
; 135: 
; 136: getkey: 
L0006:
; 137: key = 0
	CLRF 0x6B
; 138: If t_right = 1 Then key = c_right
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,3
	GOTO L0063
	MOVLW 0x01
	MOVWF 0x6B
L0063:	MOVLW 0x1F
	ANDWF STATUS,F
; 139: If t_up = 1 Then key = c_up
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,1
	GOTO L0064
	MOVLW 0x02
	MOVWF 0x6B
L0064:	MOVLW 0x1F
	ANDWF STATUS,F
; 140: If t_down = 1 Then key = c_down
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,2
	GOTO L0065
	MOVLW 0x03
	MOVWF 0x6B
L0065:	MOVLW 0x1F
	ANDWF STATUS,F
; 141: If t_left = 1 Then key = c_left
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,0
	GOTO L0066
	MOVLW 0x04
	MOVWF 0x6B
L0066:	MOVLW 0x1F
	ANDWF STATUS,F
; 142: If key > 0 Then Gosub debounce
	MOVF 0x6B,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0067
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0007
L0067:	MOVLW 0x1F
	ANDWF STATUS,F
; 143: Return
	RETURN
; 144: 
; 145: debounce: 
L0007:
; 146: If t_right = 1 Then i = 0
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,3
	GOTO L0068
	CLRF 0x33
L0068:	MOVLW 0x1F
	ANDWF STATUS,F
; 147: If t_up = 1 Then i = 0
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,1
	GOTO L0069
	CLRF 0x33
L0069:	MOVLW 0x1F
	ANDWF STATUS,F
; 148: If t_down = 1 Then i = 0
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,2
	GOTO L0070
	CLRF 0x33
L0070:	MOVLW 0x1F
	ANDWF STATUS,F
; 149: If t_left = 1 Then i = 0
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,0
	GOTO L0071
	CLRF 0x33
L0071:	MOVLW 0x1F
	ANDWF STATUS,F
; 150: i = i + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 151: WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 152: If i < 10 Then Goto debounce
	MOVLW 0x0A
	SUBWF 0x33,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0072
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0007
L0072:	MOVLW 0x1F
	ANDWF STATUS,F
; 153: Return
	RETURN
; 154: 
; 155: scankey: 
L0008:
; 156: If t_right = 1 Then key = c_right
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,3
	GOTO L0073
	MOVLW 0x01
	MOVWF 0x6B
L0073:	MOVLW 0x1F
	ANDWF STATUS,F
; 157: If t_up = 1 Then key = c_up
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,1
	GOTO L0074
	MOVLW 0x02
	MOVWF 0x6B
L0074:	MOVLW 0x1F
	ANDWF STATUS,F
; 158: If t_down = 1 Then key = c_down
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,2
	GOTO L0075
	MOVLW 0x03
	MOVWF 0x6B
L0075:	MOVLW 0x1F
	ANDWF STATUS,F
; 159: If t_left = 1 Then key = c_left
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x06,0
	GOTO L0076
	MOVLW 0x04
	MOVWF 0x6B
L0076:	MOVLW 0x1F
	ANDWF STATUS,F
; 160: Return
	RETURN
; 161: 
; 162: initroutine: 
L0009:
; 163: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 164: Lcdout "Starting..."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x53
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
; 165: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 166: Gosub getvin
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0025
; 167: For i = 1 To 12
	MOVLW 0x01
	MOVWF 0x33
L0077:
	MOVF 0x33,W
	SUBLW 0x0C
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0078
; 168: v(i) = vin
	MOVF 0x31,W
	MOVWF R5L
	BCF STATUS,C
	RLF 0x33,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
	MOVF 0x32,W
	INCF FSR,F
	MOVWF INDF
; 169: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0077
L0078:	MOVLW 0x1F
	ANDWF STATUS,F
; 170: vmax = 0
	CLRF 0x55
	CLRF 0x56
; 171: vmaxdelay = 0
	CLRF 0x57
; 172: vmaxnum = 0
	CLRF 0x58
; 173: finish = 0
	BCF 0x30,0
; 174: address = 0
	CLRF 0x59
	CLRF 0x5A
; 175: seconds = 251
	MOVLW 0xFB
	MOVWF 0x5B
; 176: minutes = 0
	CLRF 0x5C
	CLRF 0x5D
; 177: hours = 0
	CLRF 0x5E
; 178: key = 0
	CLRF 0x6B
; 179: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 180: Return
	RETURN
; 181: 
; 182: prog_discharge: 
L0010:
; 183: discharge = 1
	BSF 0x07,1
; 184: leddischarge = 1
	BSF 0x05,5
; 185: Gosub initroutine
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0009
; 186: Lcdout "Discharging..."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x44
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
; 187: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 188: While finish = 0
L0079:
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x30,0
	GOTO L0080
; 189: If signalfiltertype = 1 Then Gosub getvfinal1
	MOVF 0x6E,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0081
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0026
L0081:	MOVLW 0x1F
	ANDWF STATUS,F
; 190: If signalfiltertype = 2 Then Gosub getvfinal2
	MOVF 0x6E,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0082
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0027
L0082:	MOVLW 0x1F
	ANDWF STATUS,F
; 191: If signalfiltertype = 3 Then Gosub getvfinal3
	MOVF 0x6E,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0083
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0028
L0083:	MOVLW 0x1F
	ANDWF STATUS,F
; 192: If vfinal <= dischargelimit Then finish = 1
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x6D,W
	MOVWF R1H
	MOVF 0x6C,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C006
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0084
	BSF 0x30,0
L0084:	MOVLW 0x1F
	ANDWF STATUS,F
; 193: Gosub settime
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0034
; 194: Gosub showvoltage
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0029
; 195: Gosub storeeeprom
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0033
; 196: Gosub serialroutine
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0031
; 197: If key = c_left Then finish = 1
	MOVF 0x6B,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0085
	BSF 0x30,0
L0085:	MOVLW 0x1F
	ANDWF STATUS,F
; 198: key = 0
	CLRF 0x6B
; 199: Wend
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0079
L0080:	MOVLW 0x1F
	ANDWF STATUS,F
; 200: Lcdcmdout LcdLine1Clear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x80
	CALL LC02
	MOVLW 0x28
	MOVWF R0L
L0086:	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC01
	BCF PCLATH,3
	BCF PCLATH,4
	DECFSZ R0L,F
	GOTO L0086
	MOVLW 0x80
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC02
; 201: Lcdout "Completed!"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x43
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x64
	CALL LC01
	MOVLW 0x21
	CALL LC01
; 202: discharge = 0
	BCF 0x07,1
; 203: leddischarge = 0
	BCF 0x05,5
; 204: Gosub endroutine
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0032
; 205: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 206: Return
	RETURN
; 207: 
; 208: prog_charge: 
L0011:
; 209: charge = 1
	BSF 0x07,2
; 210: ledcharge = 1
	BSF 0x05,1
; 211: Gosub initroutine
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0009
; 212: Lcdout "Charging..."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x43
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
; 213: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 214: While finish = 0
L0087:
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x30,0
	GOTO L0088
; 215: If signalfiltertype = 1 Then Gosub getvfinal1
	MOVF 0x6E,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0089
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0026
L0089:	MOVLW 0x1F
	ANDWF STATUS,F
; 216: If signalfiltertype = 2 Then Gosub getvfinal2
	MOVF 0x6E,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0090
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0027
L0090:	MOVLW 0x1F
	ANDWF STATUS,F
; 217: If signalfiltertype = 3 Then Gosub getvfinal3
	MOVF 0x6E,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0091
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0028
L0091:	MOVLW 0x1F
	ANDWF STATUS,F
; 218: If vfinal > vmax Then vmaxdelay = vmaxdelay + 1
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x56,W
	MOVWF R1H
	MOVF 0x55,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0092
	MOVF 0x57,W
	ADDLW 0x01
	MOVWF 0x57
L0092:	MOVLW 0x1F
	ANDWF STATUS,F
; 219: If vmaxdelay = 5 Then
	MOVF 0x57,W
	SUBLW 0x05
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0093
; 220: If vmaxnum < 5 Then vmaxnum = vmaxnum + 1
	MOVLW 0x05
	SUBWF 0x58,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0094
	MOVF 0x58,W
	ADDLW 0x01
	MOVWF 0x58
L0094:	MOVLW 0x1F
	ANDWF STATUS,F
; 221: vmax = vfinal
	MOVF 0x39,W
	MOVWF 0x55
	MOVF 0x3A,W
	MOVWF 0x56
; 222: vmaxdelay = 0
	CLRF 0x57
; 223: Endif
L0093:	MOVLW 0x1F
	ANDWF STATUS,F
; 224: If peakdetect = 1 Then
	MOVF 0x70,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0095
; 225: vfinal = vfinal + peakgap
	MOVF 0x39,W
	ADDWF 0x6F,W
	MOVWF 0x39
	MOVF 0x3A,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3A
; 226: If vfinal <= vmax Then finish = 1
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x56,W
	MOVWF R1H
	MOVF 0x55,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C006
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0096
	BSF 0x30,0
L0096:	MOVLW 0x1F
	ANDWF STATUS,F
; 227: vfinal = vfinal - peakgap
	MOVF 0x6F,W
	SUBWF 0x39,W
	MOVWF 0x39
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 228: If vmaxnum < 5 Then finish = 0
	MOVLW 0x05
	SUBWF 0x58,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0097
	BCF 0x30,0
L0097:	MOVLW 0x1F
	ANDWF STATUS,F
; 229: Endif
L0095:	MOVLW 0x1F
	ANDWF STATUS,F
; 230: If minutes < mintime Then
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
	CLRF R1H
	MOVF 0x71,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0098
; 231: finish = 0
	BCF 0x30,0
; 232: vmax = vfinal
	MOVF 0x39,W
	MOVWF 0x55
	MOVF 0x3A,W
	MOVWF 0x56
; 233: vmaxdelay = 0
	CLRF 0x57
; 234: Endif
L0098:	MOVLW 0x1F
	ANDWF STATUS,F
; 235: If vfinal < minvalue Then
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x73,W
	MOVWF R1H
	MOVF 0x72,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0099
; 236: finish = 0
	BCF 0x30,0
; 237: vmax = vfinal
	MOVF 0x39,W
	MOVWF 0x55
	MOVF 0x3A,W
	MOVWF 0x56
; 238: vmaxdelay = 0
	CLRF 0x57
; 239: Endif
L0099:	MOVLW 0x1F
	ANDWF STATUS,F
; 240: If minutes >= maxtime Then finish = 1
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
	MOVF 0x75,W
	MOVWF R1H
	MOVF 0x74,W
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C005
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0100
	BSF 0x30,0
L0100:	MOVLW 0x1F
	ANDWF STATUS,F
; 241: Gosub settime
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0034
; 242: Gosub showvoltage
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0029
; 243: Gosub storeeeprom
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0033
; 244: Gosub serialroutine
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0031
; 245: If key = c_left Then finish = 1
	MOVF 0x6B,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0101
	BSF 0x30,0
L0101:	MOVLW 0x1F
	ANDWF STATUS,F
; 246: key = 0
	CLRF 0x6B
; 247: Wend
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0087
L0088:	MOVLW 0x1F
	ANDWF STATUS,F
; 248: Lcdcmdout LcdLine1Clear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x80
	CALL LC02
	MOVLW 0x28
	MOVWF R0L
L0102:	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC01
	BCF PCLATH,3
	BCF PCLATH,4
	DECFSZ R0L,F
	GOTO L0102
	MOVLW 0x80
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC02
; 249: Lcdout "Completed!"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x43
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x64
	CALL LC01
	MOVLW 0x21
	CALL LC01
; 250: charge = 0
	BCF 0x07,2
; 251: ledcharge = 0
	BCF 0x05,1
; 252: Gosub endroutine
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0032
; 253: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 254: Return
	RETURN
; 255: 
; 256: prog_cycle: 
L0012:
; 257: Gosub prog_discharge
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0010
; 258: WaitMs 10000
	MOVLW 0x10
	MOVWF R0L
	MOVLW 0x27
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 259: Gosub prog_charge
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0011
; 260: Goto newprogram
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0001
; 261: Return
	RETURN
; 262: 
; 263: prog_setupdefaults: 
L0013:
; 264: dischargelimit = 290
	MOVLW 0x22
	MOVWF 0x6C
	MOVLW 0x01
	MOVWF 0x6D
; 265: signalfiltertype = 3
	MOVLW 0x03
	MOVWF 0x6E
; 266: peakgap = 2
	MOVLW 0x02
	MOVWF 0x6F
; 267: peakdetect = 1
	MOVLW 0x01
	MOVWF 0x70
; 268: mintime = 5
	MOVLW 0x05
	MOVWF 0x71
; 269: minvalue = 495
	MOVLW 0xEF
	MOVWF 0x72
	MOVLW 0x01
	MOVWF 0x73
; 270: maxtime = 600
	MOVLW 0x58
	MOVWF 0x74
	MOVLW 0x02
	MOVWF 0x75
; 271: Gosub saveparameters
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0024
; 272: Return
	RETURN
; 273: 
; 274: prog_setup: 
L0014:
; 275: phase = 1
	MOVLW 0x01
	MOVWF 0x6A
; 276: setuploop: 
L0015:
; 277: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 278: Lcdout "Setup Options:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x53
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x4F
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 279: Lcdcmdout LcdLine2Clear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
	MOVLW 0x28
	MOVWF R0L
L0103:	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC01
	BCF PCLATH,3
	BCF PCLATH,4
	DECFSZ R0L,F
	GOTO L0103
	MOVLW 0xC0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC02
; 280: If phase = 1 Then Lcdout "1-DischargeLimit"
	MOVF 0x6A,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0104
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x31
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x44
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x4C
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x74
	CALL LC01
L0104:	MOVLW 0x1F
	ANDWF STATUS,F
; 281: If phase = 2 Then Lcdout "2-FilterType"
	MOVF 0x6A,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0105
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x32
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x46
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0105:	MOVLW 0x1F
	ANDWF STATUS,F
; 282: If phase = 3 Then Lcdout "3-PeakGap"
	MOVF 0x6A,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0106
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x33
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x50
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6B
	CALL LC01
	MOVLW 0x47
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x70
	CALL LC01
L0106:	MOVLW 0x1F
	ANDWF STATUS,F
; 283: If phase = 4 Then Lcdout "4-PeakDetect"
	MOVF 0x6A,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0107
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x34
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x50
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6B
	CALL LC01
	MOVLW 0x44
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x74
	CALL LC01
L0107:	MOVLW 0x1F
	ANDWF STATUS,F
; 284: If phase = 5 Then Lcdout "5-MinTime"
	MOVF 0x6A,W
	SUBLW 0x05
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0108
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x35
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0108:	MOVLW 0x1F
	ANDWF STATUS,F
; 285: If phase = 6 Then Lcdout "6-MinValue"
	MOVF 0x6A,W
	SUBLW 0x06
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0109
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x36
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x56
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0109:	MOVLW 0x1F
	ANDWF STATUS,F
; 286: If phase = 7 Then Lcdout "7-MaxTime"
	MOVF 0x6A,W
	SUBLW 0x07
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0110
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x37
	CALL LC01
	MOVLW 0x2D
	CALL LC01
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x78
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x65
	CALL LC01
L0110:	MOVLW 0x1F
	ANDWF STATUS,F
; 287: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 288: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0111
; 289: phase = phase + 1
	MOVF 0x6A,W
	ADDLW 0x01
	MOVWF 0x6A
; 290: If phase = 8 Then phase = 1
	MOVF 0x6A,W
	SUBLW 0x08
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0112
	MOVLW 0x01
	MOVWF 0x6A
L0112:	MOVLW 0x1F
	ANDWF STATUS,F
; 291: Goto setuploop
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
; 292: Endif
L0111:	MOVLW 0x1F
	ANDWF STATUS,F
; 293: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0113
; 294: phase = phase - 1
	MOVLW 0x01
	SUBWF 0x6A,W
	MOVWF 0x6A
; 295: If phase = 0 Then phase = 7
	MOVF 0x6A,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0114
	MOVLW 0x07
	MOVWF 0x6A
L0114:	MOVLW 0x1F
	ANDWF STATUS,F
; 296: Goto setuploop
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
; 297: Endif
L0113:	MOVLW 0x1F
	ANDWF STATUS,F
; 298: If key = c_right Then
	MOVF 0x6B,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0115
; 299: If phase = 1 Then Gosub setup1
	MOVF 0x6A,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0116
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0016
L0116:	MOVLW 0x1F
	ANDWF STATUS,F
; 300: If phase = 2 Then Gosub setup2
	MOVF 0x6A,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0117
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0017
L0117:	MOVLW 0x1F
	ANDWF STATUS,F
; 301: If phase = 3 Then Gosub setup3
	MOVF 0x6A,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0118
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0018
L0118:	MOVLW 0x1F
	ANDWF STATUS,F
; 302: If phase = 4 Then Gosub setup4
	MOVF 0x6A,W
	SUBLW 0x04
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0119
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0019
L0119:	MOVLW 0x1F
	ANDWF STATUS,F
; 303: If phase = 5 Then Gosub setup5
	MOVF 0x6A,W
	SUBLW 0x05
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0120
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0020
L0120:	MOVLW 0x1F
	ANDWF STATUS,F
; 304: If phase = 6 Then Gosub setup6
	MOVF 0x6A,W
	SUBLW 0x06
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0121
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0021
L0121:	MOVLW 0x1F
	ANDWF STATUS,F
; 305: If phase = 7 Then Gosub setup7
	MOVF 0x6A,W
	SUBLW 0x07
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0122
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0022
L0122:	MOVLW 0x1F
	ANDWF STATUS,F
; 306: Goto setuploop
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
; 307: Endif
L0115:	MOVLW 0x1F
	ANDWF STATUS,F
; 308: If key = c_left Then Gosub saveparameters
	MOVF 0x6B,W
	SUBLW 0x04
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0123
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0024
L0123:	MOVLW 0x1F
	ANDWF STATUS,F
; 309: Goto newprogram
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0001
; 310: Return
	RETURN
; 311: 
; 312: setup1: 
L0016:
; 313: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 314: Lcdout "DischargeLimit:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x44
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x73
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x68
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x4C
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 315: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 316: Lcdout #dischargelimit
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x6C,W
	MOVWF R2L
	MOVF 0x6D,W
	MOVWF R2H
	CALL LC21
; 317: Lcdout "   "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 318: vfinal = dischargelimit
	MOVF 0x6C,W
	MOVWF 0x39
	MOVF 0x6D,W
	MOVWF 0x3A
; 319: Gosub showvoltageonly
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0030
; 320: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 321: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0124
; 322: If dischargelimit < 1000 Then dischargelimit = dischargelimit + 5 Else dischargelimit = 10
	MOVF 0x6C,W
	MOVWF R0L
	MOVF 0x6D,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0125
	MOVF 0x6C,W
	ADDLW 0x05
	MOVWF 0x6C
	MOVF 0x6D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x6D
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0126
L0125:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x0A
	MOVWF 0x6C
	CLRF 0x6D
L0126:	MOVLW 0x1F
	ANDWF STATUS,F
; 323: Goto setup1
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0016
; 324: Endif
L0124:	MOVLW 0x1F
	ANDWF STATUS,F
; 325: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0127
; 326: If dischargelimit > 10 Then dischargelimit = dischargelimit - 5 Else dischargelimit = 1000
	MOVF 0x6C,W
	MOVWF R0L
	MOVF 0x6D,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0128
	MOVLW 0x05
	SUBWF 0x6C,W
	MOVWF 0x6C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x6D,W
	MOVWF 0x6D
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0129
L0128:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0xE8
	MOVWF 0x6C
	MOVLW 0x03
	MOVWF 0x6D
L0129:	MOVLW 0x1F
	ANDWF STATUS,F
; 327: Goto setup1
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0016
; 328: Endif
L0127:	MOVLW 0x1F
	ANDWF STATUS,F
; 329: Return
	RETURN
; 330: 
; 331: setup2: 
L0017:
; 332: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 333: Lcdout "FilterType:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x46
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 334: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 335: Lcdout #signalfiltertype
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x6E,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
; 336: Lcdout "   "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 337: If signalfiltertype = 1 Then Lcdout "Raw values"
	MOVF 0x6E,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0130
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x52
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x77
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x76
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x73
	CALL LC01
L0130:	MOVLW 0x1F
	ANDWF STATUS,F
; 338: If signalfiltertype = 2 Then Lcdout "Average LO"
	MOVF 0x6E,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0131
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x41
	CALL LC01
	MOVLW 0x76
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x4C
	CALL LC01
	MOVLW 0x4F
	CALL LC01
L0131:	MOVLW 0x1F
	ANDWF STATUS,F
; 339: If signalfiltertype = 3 Then Lcdout "Average HI"
	MOVF 0x6E,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0132
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x41
	CALL LC01
	MOVLW 0x76
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x67
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x48
	CALL LC01
	MOVLW 0x49
	CALL LC01
L0132:	MOVLW 0x1F
	ANDWF STATUS,F
; 340: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 341: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0133
; 342: If signalfiltertype < 3 Then signalfiltertype = signalfiltertype + 1
	MOVLW 0x03
	SUBWF 0x6E,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0134
	MOVF 0x6E,W
	ADDLW 0x01
	MOVWF 0x6E
L0134:	MOVLW 0x1F
	ANDWF STATUS,F
; 343: Goto setup2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0017
; 344: Endif
L0133:	MOVLW 0x1F
	ANDWF STATUS,F
; 345: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0135
; 346: If signalfiltertype > 1 Then signalfiltertype = signalfiltertype - 1
	MOVF 0x6E,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0136
	MOVLW 0x01
	SUBWF 0x6E,W
	MOVWF 0x6E
L0136:	MOVLW 0x1F
	ANDWF STATUS,F
; 347: Goto setup2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0017
; 348: Endif
L0135:	MOVLW 0x1F
	ANDWF STATUS,F
; 349: Return
	RETURN
; 350: 
; 351: setup3: 
L0018:
; 352: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 353: Lcdout "PeakGap:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x50
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6B
	CALL LC01
	MOVLW 0x47
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x70
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 354: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 355: Lcdout #peakgap
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x6F,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
; 356: Lcdout "   "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 357: vfinal = peakgap
	MOVF 0x6F,W
	MOVWF 0x39
	CLRF 0x3A
; 358: Gosub showvoltageonly
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0030
; 359: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 360: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0137
; 361: If peakgap < 10 Then peakgap = peakgap + 1 Else peakgap = 1
	MOVLW 0x0A
	SUBWF 0x6F,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0138
	MOVF 0x6F,W
	ADDLW 0x01
	MOVWF 0x6F
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0139
L0138:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x01
	MOVWF 0x6F
L0139:	MOVLW 0x1F
	ANDWF STATUS,F
; 362: Goto setup3
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0018
; 363: Endif
L0137:	MOVLW 0x1F
	ANDWF STATUS,F
; 364: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0140
; 365: If peakgap > 1 Then peakgap = peakgap - 1 Else peakgap = 10
	MOVF 0x6F,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0141
	MOVLW 0x01
	SUBWF 0x6F,W
	MOVWF 0x6F
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0142
L0141:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x0A
	MOVWF 0x6F
L0142:	MOVLW 0x1F
	ANDWF STATUS,F
; 366: Goto setup3
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0018
; 367: Endif
L0140:	MOVLW 0x1F
	ANDWF STATUS,F
; 368: Return
	RETURN
; 369: 
; 370: setup4: 
L0019:
; 371: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 372: Lcdout "PeakDetect:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x50
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6B
	CALL LC01
	MOVLW 0x44
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x63
	CALL LC01
	MOVLW 0x74
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 373: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 374: Lcdout #peakdetect
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x70,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
; 375: Lcdout "   "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 376: If peakdetect = 0 Then Lcdout "Off"
	MOVF 0x70,W
	SUBLW 0x00
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0143
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4F
	CALL LC01
	MOVLW 0x66
	CALL LC01
	MOVLW 0x66
	CALL LC01
L0143:	MOVLW 0x1F
	ANDWF STATUS,F
; 377: If peakdetect = 1 Then Lcdout "On "
	MOVF 0x70,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0144
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4F
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x20
	CALL LC01
L0144:	MOVLW 0x1F
	ANDWF STATUS,F
; 378: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 379: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0145
; 380: peakdetect = 1
	MOVLW 0x01
	MOVWF 0x70
; 381: Goto setup4
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0019
; 382: Endif
L0145:	MOVLW 0x1F
	ANDWF STATUS,F
; 383: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0146
; 384: peakdetect = 0
	CLRF 0x70
; 385: Goto setup4
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0019
; 386: Endif
L0146:	MOVLW 0x1F
	ANDWF STATUS,F
; 387: Return
	RETURN
; 388: 
; 389: setup5: 
L0020:
; 390: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 391: Lcdout "MinTime:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 392: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 393: Lcdout #mintime, " min"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x71,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
	MOVLW 0x20
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
; 394: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 395: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0147
; 396: If mintime < 60 Then mintime = mintime + 1 Else mintime = 1
	MOVLW 0x3C
	SUBWF 0x71,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0148
	MOVF 0x71,W
	ADDLW 0x01
	MOVWF 0x71
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0149
L0148:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x01
	MOVWF 0x71
L0149:	MOVLW 0x1F
	ANDWF STATUS,F
; 397: Goto setup5
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0020
; 398: Endif
L0147:	MOVLW 0x1F
	ANDWF STATUS,F
; 399: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0150
; 400: If mintime > 1 Then mintime = mintime - 1 Else mintime = 60
	MOVF 0x71,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0151
	MOVLW 0x01
	SUBWF 0x71,W
	MOVWF 0x71
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0152
L0151:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x3C
	MOVWF 0x71
L0152:	MOVLW 0x1F
	ANDWF STATUS,F
; 401: Goto setup5
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0020
; 402: Endif
L0150:	MOVLW 0x1F
	ANDWF STATUS,F
; 403: Return
	RETURN
; 404: 
; 405: setup6: 
L0021:
; 406: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 407: Lcdout "MinValue:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
	MOVLW 0x56
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x6C
	CALL LC01
	MOVLW 0x75
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 408: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 409: Lcdout #minvalue
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x72,W
	MOVWF R2L
	MOVF 0x73,W
	MOVWF R2H
	CALL LC21
; 410: Lcdout "   "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 411: vfinal = minvalue
	MOVF 0x72,W
	MOVWF 0x39
	MOVF 0x73,W
	MOVWF 0x3A
; 412: Gosub showvoltageonly
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0030
; 413: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 414: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0153
; 415: If minvalue < 1000 Then minvalue = minvalue + 5 Else minvalue = 10
	MOVF 0x72,W
	MOVWF R0L
	MOVF 0x73,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0154
	MOVF 0x72,W
	ADDLW 0x05
	MOVWF 0x72
	MOVF 0x73,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x73
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0155
L0154:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x0A
	MOVWF 0x72
	CLRF 0x73
L0155:	MOVLW 0x1F
	ANDWF STATUS,F
; 416: Goto setup6
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0021
; 417: Endif
L0153:	MOVLW 0x1F
	ANDWF STATUS,F
; 418: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0156
; 419: If minvalue > 10 Then minvalue = minvalue - 5 Else minvalue = 1000
	MOVF 0x72,W
	MOVWF R0L
	MOVF 0x73,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0157
	MOVLW 0x05
	SUBWF 0x72,W
	MOVWF 0x72
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x73,W
	MOVWF 0x73
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0158
L0157:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0xE8
	MOVWF 0x72
	MOVLW 0x03
	MOVWF 0x73
L0158:	MOVLW 0x1F
	ANDWF STATUS,F
; 420: Goto setup6
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0021
; 421: Endif
L0156:	MOVLW 0x1F
	ANDWF STATUS,F
; 422: Return
	RETURN
; 423: 
; 424: setup7: 
L0022:
; 425: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 426: Lcdout "MaxTime:"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x78
	CALL LC01
	MOVLW 0x54
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x3A
	CALL LC01
; 427: Lcdcmdout LcdLine2Home
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
; 428: Lcdout #maxtime, " min"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x74,W
	MOVWF R2L
	MOVF 0x75,W
	MOVWF R2H
	CALL LC21
	MOVLW 0x20
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x69
	CALL LC01
	MOVLW 0x6E
	CALL LC01
; 429: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 430: If key = c_up Then
	MOVF 0x6B,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0159
; 431: If maxtime < 1000 Then maxtime = maxtime + 5 Else maxtime = 10
	MOVF 0x74,W
	MOVWF R0L
	MOVF 0x75,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0160
	MOVF 0x74,W
	ADDLW 0x05
	MOVWF 0x74
	MOVF 0x75,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x75
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0161
L0160:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0x0A
	MOVWF 0x74
	CLRF 0x75
L0161:	MOVLW 0x1F
	ANDWF STATUS,F
; 432: Goto setup7
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0022
; 433: Endif
L0159:	MOVLW 0x1F
	ANDWF STATUS,F
; 434: If key = c_down Then
	MOVF 0x6B,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0162
; 435: If maxtime > 10 Then maxtime = maxtime - 5 Else maxtime = 1000
	MOVF 0x74,W
	MOVWF R0L
	MOVF 0x75,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0163
	MOVLW 0x05
	SUBWF 0x74,W
	MOVWF 0x74
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x75,W
	MOVWF 0x75
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0164
L0163:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVLW 0xE8
	MOVWF 0x74
	MOVLW 0x03
	MOVWF 0x75
L0164:	MOVLW 0x1F
	ANDWF STATUS,F
; 436: Goto setup7
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0022
; 437: Endif
L0162:	MOVLW 0x1F
	ANDWF STATUS,F
; 438: Return
	RETURN
; 439: 
; 440: loadparameters: 
L0023:
; 441: address = 30000
	MOVLW 0x30
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 442: I2CRead i2cdata, i2cclock, 0xa0, address, dischargelimit.LB, dischargelimit.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC13
	MOVWF 0x6C
	CALL IC11
	MOVWF 0x6D
	CALL IC41
; 443: address = 30002
	MOVLW 0x32
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 444: I2CRead i2cdata, i2cclock, 0xa0, address, signalfiltertype
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x6E
	CALL IC41
; 445: address = 30003
	MOVLW 0x33
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 446: I2CRead i2cdata, i2cclock, 0xa0, address, peakgap
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x6F
	CALL IC41
; 447: address = 30004
	MOVLW 0x34
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 448: I2CRead i2cdata, i2cclock, 0xa0, address, peakdetect
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x70
	CALL IC41
; 449: address = 30005
	MOVLW 0x35
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 450: I2CRead i2cdata, i2cclock, 0xa0, address, mintime
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x71
	CALL IC41
; 451: address = 30006
	MOVLW 0x36
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 452: I2CRead i2cdata, i2cclock, 0xa0, address, minvalue.LB, minvalue.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC13
	MOVWF 0x72
	CALL IC11
	MOVWF 0x73
	CALL IC41
; 453: address = 30008
	MOVLW 0x38
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 454: I2CRead i2cdata, i2cclock, 0xa0, address, maxtime.LB, maxtime.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC13
	MOVWF 0x74
	CALL IC11
	MOVWF 0x75
	CALL IC41
; 455: If dischargelimit < 10 Then dischargelimit = 10
	MOVF 0x6C,W
	MOVWF R0L
	MOVF 0x6D,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0165
	MOVLW 0x0A
	MOVWF 0x6C
	CLRF 0x6D
L0165:	MOVLW 0x1F
	ANDWF STATUS,F
; 456: If dischargelimit > 1000 Then dischargelimit = 1000
	MOVF 0x6C,W
	MOVWF R0L
	MOVF 0x6D,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0166
	MOVLW 0xE8
	MOVWF 0x6C
	MOVLW 0x03
	MOVWF 0x6D
L0166:	MOVLW 0x1F
	ANDWF STATUS,F
; 457: If signalfiltertype < 1 Then signalfiltertype = 1
	MOVLW 0x01
	SUBWF 0x6E,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0167
	MOVLW 0x01
	MOVWF 0x6E
L0167:	MOVLW 0x1F
	ANDWF STATUS,F
; 458: If signalfiltertype > 3 Then signalfiltertype = 3
	MOVF 0x6E,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0168
	MOVLW 0x03
	MOVWF 0x6E
L0168:	MOVLW 0x1F
	ANDWF STATUS,F
; 459: If peakgap < 1 Then peakgap = 1
	MOVLW 0x01
	SUBWF 0x6F,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0169
	MOVLW 0x01
	MOVWF 0x6F
L0169:	MOVLW 0x1F
	ANDWF STATUS,F
; 460: If peakgap > 10 Then peakgap = 10
	MOVF 0x6F,W
	SUBLW 0x0A
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0170
	MOVLW 0x0A
	MOVWF 0x6F
L0170:	MOVLW 0x1F
	ANDWF STATUS,F
; 461: If peakdetect > 1 Then peakdetect = 1
	MOVF 0x70,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0171
	MOVLW 0x01
	MOVWF 0x70
L0171:	MOVLW 0x1F
	ANDWF STATUS,F
; 462: If mintime < 1 Then mintime = 1
	MOVLW 0x01
	SUBWF 0x71,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0172
	MOVLW 0x01
	MOVWF 0x71
L0172:	MOVLW 0x1F
	ANDWF STATUS,F
; 463: If mintime > 60 Then mintime = 60
	MOVF 0x71,W
	SUBLW 0x3C
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0173
	MOVLW 0x3C
	MOVWF 0x71
L0173:	MOVLW 0x1F
	ANDWF STATUS,F
; 464: If minvalue < 10 Then minvalue = 10
	MOVF 0x72,W
	MOVWF R0L
	MOVF 0x73,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0174
	MOVLW 0x0A
	MOVWF 0x72
	CLRF 0x73
L0174:	MOVLW 0x1F
	ANDWF STATUS,F
; 465: If minvalue > 1000 Then minvalue = 1000
	MOVF 0x72,W
	MOVWF R0L
	MOVF 0x73,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0175
	MOVLW 0xE8
	MOVWF 0x72
	MOVLW 0x03
	MOVWF 0x73
L0175:	MOVLW 0x1F
	ANDWF STATUS,F
; 466: If maxtime < 10 Then maxtime = 10
	MOVF 0x74,W
	MOVWF R0L
	MOVF 0x75,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0176
	MOVLW 0x0A
	MOVWF 0x74
	CLRF 0x75
L0176:	MOVLW 0x1F
	ANDWF STATUS,F
; 467: If maxtime > 1000 Then maxtime = 1000
	MOVF 0x74,W
	MOVWF R0L
	MOVF 0x75,W
	MOVWF R0H
	MOVLW 0x03
	MOVWF R1H
	MOVLW 0xE8
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0177
	MOVLW 0xE8
	MOVWF 0x74
	MOVLW 0x03
	MOVWF 0x75
L0177:	MOVLW 0x1F
	ANDWF STATUS,F
; 468: Return
	RETURN
; 469: 
; 470: saveparameters: 
L0024:
; 471: address = 30000
	MOVLW 0x30
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 472: I2CWrite i2cdata, i2cclock, 0xa0, address, dischargelimit.LB, dischargelimit.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x6C,W
	CALL IC01
	MOVF 0x6D,W
	CALL IC01
	CALL IC41
; 473: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 474: address = 30002
	MOVLW 0x32
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 475: I2CWrite i2cdata, i2cclock, 0xa0, address, signalfiltertype
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x6E,W
	CALL IC01
	CALL IC41
; 476: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 477: address = 30003
	MOVLW 0x33
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 478: I2CWrite i2cdata, i2cclock, 0xa0, address, peakgap
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x6F,W
	CALL IC01
	CALL IC41
; 479: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 480: address = 30004
	MOVLW 0x34
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 481: I2CWrite i2cdata, i2cclock, 0xa0, address, peakdetect
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x70,W
	CALL IC01
	CALL IC41
; 482: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 483: address = 30005
	MOVLW 0x35
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 484: I2CWrite i2cdata, i2cclock, 0xa0, address, mintime
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x71,W
	CALL IC01
	CALL IC41
; 485: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 486: address = 30006
	MOVLW 0x36
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 487: I2CWrite i2cdata, i2cclock, 0xa0, address, minvalue.LB, minvalue.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x72,W
	CALL IC01
	MOVF 0x73,W
	CALL IC01
	CALL IC41
; 488: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 489: address = 30008
	MOVLW 0x38
	MOVWF 0x59
	MOVLW 0x75
	MOVWF 0x5A
; 490: I2CWrite i2cdata, i2cclock, 0xa0, address, maxtime.LB, maxtime.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x74,W
	CALL IC01
	MOVF 0x75,W
	CALL IC01
	CALL IC41
; 491: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 492: Return
	RETURN
; 493: 
; 494: getvin: 
L0025:
; 495: vin = 0
	CLRF 0x31
	CLRF 0x32
; 496: For i = 1 To 60
	MOVLW 0x01
	MOVWF 0x33
L0178:
	MOVF 0x33,W
	SUBLW 0x3C
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0179
; 497: Adcin 0, an0
	BSF STATUS,RP0
	BSF ADCON1,ADFM
	BCF ADCON1,ADCS2
	MOVLW 0x00
	BCF STATUS,RP0
	MOVWF R0L
	BCF PCLATH,3
	BCF PCLATH,4
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x35
	MOVF ADRESH,W
	MOVWF 0x36
; 498: vin = vin + an0
	MOVF 0x31,W
	ADDWF 0x35,W
	MOVWF 0x31
	MOVF 0x32,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x36,W
	MOVWF 0x32
; 499: Gosub scankey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0008
; 500: WaitMs 83
	MOVLW 0x53
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 501: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0178
L0179:	MOVLW 0x1F
	ANDWF STATUS,F
; 502: vmod = vin Mod 60
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x37
	MOVF R2H,W
	MOVWF 0x38
; 503: vin = vin / 60
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x31
	MOVF R0H,W
	MOVWF 0x32
; 504: If vmod >= 30 Then vin = vin + 1
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x1E
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C005
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0180
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
	MOVF 0x32,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x32
L0180:	MOVLW 0x1F
	ANDWF STATUS,F
; 505: Return
	RETURN
; 506: 
; 507: getvfinal1: 
L0026:
; 508: Gosub getvin
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0025
; 509: vfinal = vin
	MOVF 0x31,W
	MOVWF 0x39
	MOVF 0x32,W
	MOVWF 0x3A
; 510: Return
	RETURN
; 511: 
; 512: getvfinal2: 
L0027:
; 513: For i = 1 To 5
	MOVLW 0x01
	MOVWF 0x33
L0181:
	MOVF 0x33,W
	SUBLW 0x05
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0182
; 514: j = i + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x34
; 515: v(i) = v(j)
	BCF STATUS,C
	RLF 0x34,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF INDF,W
	MOVWF R0L
	INCF FSR,F
	MOVF INDF,W
	MOVWF R0H
	MOVF R0L,W
	MOVWF R5L
	BCF STATUS,C
	RLF 0x33,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
	MOVF R0H,W
	INCF FSR,F
	MOVWF INDF
; 516: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0181
L0182:	MOVLW 0x1F
	ANDWF STATUS,F
; 517: Gosub getvin
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0025
; 518: v(6) = vin
	MOVF 0x31,W
	MOVWF 0x47
	MOVF 0x32,W
	MOVWF 0x48
; 519: vfinal = 0
	CLRF 0x39
	CLRF 0x3A
; 520: For i = 1 To 6
	MOVLW 0x01
	MOVWF 0x33
L0183:
	MOVF 0x33,W
	SUBLW 0x06
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0184
; 521: vfinal = vfinal + v(i)
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	BCF STATUS,C
	RLF 0x33,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF INDF,W
	MOVWF R1L
	INCF FSR,F
	MOVF INDF,W
	MOVWF R1H
	MOVF R0L,W
	ADDWF R1L,W
	MOVWF 0x39
	MOVF R0H,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF R1H,W
	MOVWF 0x3A
; 522: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0183
L0184:	MOVLW 0x1F
	ANDWF STATUS,F
; 523: vmod = vfinal Mod 6
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x06
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x37
	MOVF R2H,W
	MOVWF 0x38
; 524: vfinal = vfinal / 6
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x06
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x39
	MOVF R0H,W
	MOVWF 0x3A
; 525: If vmod >= 3 Then vfinal = vfinal + 1
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C005
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0185
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
	MOVF 0x3A,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3A
L0185:	MOVLW 0x1F
	ANDWF STATUS,F
; 526: Return
	RETURN
; 527: 
; 528: getvfinal3: 
L0028:
; 529: For i = 1 To 11
	MOVLW 0x01
	MOVWF 0x33
L0186:
	MOVF 0x33,W
	SUBLW 0x0B
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0187
; 530: j = i + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x34
; 531: v(i) = v(j)
	BCF STATUS,C
	RLF 0x34,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF INDF,W
	MOVWF R0L
	INCF FSR,F
	MOVF INDF,W
	MOVWF R0H
	MOVF R0L,W
	MOVWF R5L
	BCF STATUS,C
	RLF 0x33,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
	MOVF R0H,W
	INCF FSR,F
	MOVWF INDF
; 532: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0186
L0187:	MOVLW 0x1F
	ANDWF STATUS,F
; 533: Gosub getvin
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0025
; 534: v(12) = vin
	MOVF 0x31,W
	MOVWF 0x53
	MOVF 0x32,W
	MOVWF 0x54
; 535: vfinal = 0
	CLRF 0x39
	CLRF 0x3A
; 536: For i = 1 To 12
	MOVLW 0x01
	MOVWF 0x33
L0188:
	MOVF 0x33,W
	SUBLW 0x0C
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,C
	GOTO L0189
; 537: vfinal = vfinal + v(i)
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	BCF STATUS,C
	RLF 0x33,W
	ADDLW 0x3B
	MOVWF FSR
	MOVF INDF,W
	MOVWF R1L
	INCF FSR,F
	MOVF INDF,W
	MOVWF R1H
	MOVF R0L,W
	ADDWF R1L,W
	MOVWF 0x39
	MOVF R0H,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF R1H,W
	MOVWF 0x3A
; 538: Next i
	MOVLW 0x01
	ADDWF 0x33,F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0188
L0189:	MOVLW 0x1F
	ANDWF STATUS,F
; 539: vmod = vfinal Mod 12
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x0C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x37
	MOVF R2H,W
	MOVWF 0x38
; 540: vfinal = vfinal / 12
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x0C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x39
	MOVF R0H,W
	MOVWF 0x3A
; 541: If vmod >= 6 Then vfinal = vfinal + 1
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x06
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C005
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0190
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
	MOVF 0x3A,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3A
L0190:	MOVLW 0x1F
	ANDWF STATUS,F
; 542: Return
	RETURN
; 543: 
; 544: showvoltage: 
L0029:
; 545:  '0V=0  2.5V=1023  2500/1023=2.444
; 546: voltage = (vfinal * 2) + (vfinal * 4 / 10)
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x5F
	MOVF R2H,W
	MOVWF 0x60
;       The address of 'oshonsoft_temp_1' is 0x76
	oshonsoft_temp_1 EQU 0x76
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x76
	MOVF R2H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF R0L
	MOVF 0x77,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x76
	MOVF R0H,W
	MOVWF 0x77
	MOVF 0x5F,W
	ADDWF 0x76,W
	MOVWF 0x5F
	MOVF 0x60,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x77,W
	MOVWF 0x60
; 547: voltage = voltage + (vfinal * 4 / 100) + (vfinal * 4 / 1000)
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x76
	MOVF R2H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF R0L
	MOVF 0x77,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x76
	MOVF R0H,W
	MOVWF 0x77
	MOVF 0x5F,W
	ADDWF 0x76,W
	MOVWF 0x76
	MOVF 0x60,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x77,W
	MOVWF 0x77
;       The address of 'oshonsoft_temp_2' is 0x78
	oshonsoft_temp_2 EQU 0x78
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x78
	MOVF R2H,W
	MOVWF 0x79
	MOVF 0x78,W
	MOVWF R0L
	MOVF 0x79,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x78
	MOVF R0H,W
	MOVWF 0x79
	MOVF 0x76,W
	ADDWF 0x78,W
	MOVWF 0x76
	MOVF 0x77,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x79,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF 0x5F
	MOVF 0x77,W
	MOVWF 0x60
; 548: voltage1 = voltage / 1000
	MOVF 0x5F,W
	MOVWF R0L
	MOVF 0x60,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x61
	MOVF R0H,W
	MOVWF 0x62
; 549: voltage2 = voltage Mod 1000
	MOVF 0x5F,W
	MOVWF R0L
	MOVF 0x60,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x63
	MOVF R2H,W
	MOVWF 0x64
; 550: Lcdcmdout LcdLine2Clear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xC0
	CALL LC02
	MOVLW 0x28
	MOVWF R0L
L0191:	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC01
	BCF PCLATH,3
	BSF PCLATH,4
	DECFSZ R0L,F
	GOTO L0191
	MOVLW 0xC0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LC02
; 551: Lcdout #voltage1, "."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x61,W
	MOVWF R2L
	MOVF 0x62,W
	MOVWF R2H
	CALL LC21
	MOVLW 0x2E
	CALL LC01
; 552: If voltage2 < 100 Then Lcdout "0"
	MOVF 0x63,W
	MOVWF R0L
	MOVF 0x64,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x64
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0192
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0192:	MOVLW 0x1F
	ANDWF STATUS,F
; 553: If voltage2 < 10 Then Lcdout "0"
	MOVF 0x63,W
	MOVWF R0L
	MOVF 0x64,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0193
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0193:	MOVLW 0x1F
	ANDWF STATUS,F
; 554: Lcdout #voltage2, "V  "
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x63,W
	MOVWF R2L
	MOVF 0x64,W
	MOVWF R2H
	CALL LC21
	MOVLW 0x56
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x20
	CALL LC01
; 555: hours = minutes / 60
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x76
	MOVF R0H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF 0x5E
; 556: If hours < 10 Then Lcdout "0"
	MOVLW 0x0A
	SUBWF 0x5E,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0194
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0194:	MOVLW 0x1F
	ANDWF STATUS,F
; 557: Lcdout #hours, ":"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x5E,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
	MOVLW 0x3A
	CALL LC01
; 558: hours = minutes Mod 60
	MOVF 0x5C,W
	MOVWF R0L
	MOVF 0x5D,W
	MOVWF R0H
	MOVLW 0x3C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x76
	MOVF R2H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF 0x5E
; 559: If hours < 10 Then Lcdout "0"
	MOVLW 0x0A
	SUBWF 0x5E,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0195
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0195:	MOVLW 0x1F
	ANDWF STATUS,F
; 560: Lcdout #hours, ":"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x5E,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
	MOVLW 0x3A
	CALL LC01
; 561: If seconds < 10 Then Lcdout "0"
	MOVLW 0x0A
	SUBWF 0x5B,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0196
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0196:	MOVLW 0x1F
	ANDWF STATUS,F
; 562: Lcdout #seconds
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x5B,W
	MOVWF R2L
	CLRF R2H
	CALL LC21
; 563: Return
	RETURN
; 564: 
; 565: showvoltageonly: 
L0030:
; 566:  '0V=0  2.5V=1023  2500/1023=2.444
; 567: voltage = (vfinal * 2) + (vfinal * 4 / 10)
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x5F
	MOVF R2H,W
	MOVWF 0x60
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x76
	MOVF R2H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF R0L
	MOVF 0x77,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x76
	MOVF R0H,W
	MOVWF 0x77
	MOVF 0x5F,W
	ADDWF 0x76,W
	MOVWF 0x5F
	MOVF 0x60,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x77,W
	MOVWF 0x60
; 568: voltage = voltage + (vfinal * 4 / 100) + (vfinal * 4 / 1000)
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x76
	MOVF R2H,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF R0L
	MOVF 0x77,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x76
	MOVF R0H,W
	MOVWF 0x77
	MOVF 0x5F,W
	ADDWF 0x76,W
	MOVWF 0x76
	MOVF 0x60,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x77,W
	MOVWF 0x77
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL M001
	MOVWF 0x78
	MOVF R2H,W
	MOVWF 0x79
	MOVF 0x78,W
	MOVWF R0L
	MOVF 0x79,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x78
	MOVF R0H,W
	MOVWF 0x79
	MOVF 0x76,W
	ADDWF 0x78,W
	MOVWF 0x76
	MOVF 0x77,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x79,W
	MOVWF 0x77
	MOVF 0x76,W
	MOVWF 0x5F
	MOVF 0x77,W
	MOVWF 0x60
; 569: voltage1 = voltage / 1000
	MOVF 0x5F,W
	MOVWF R0L
	MOVF 0x60,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVWF 0x61
	MOVF R0H,W
	MOVWF 0x62
; 570: voltage2 = voltage Mod 1000
	MOVF 0x5F,W
	MOVWF R0L
	MOVF 0x60,W
	MOVWF R0H
	MOVLW 0xE8
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x63
	MOVF R2H,W
	MOVWF 0x64
; 571: Lcdout #voltage1, "."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x61,W
	MOVWF R2L
	MOVF 0x62,W
	MOVWF R2H
	CALL LC21
	MOVLW 0x2E
	CALL LC01
; 572: If voltage2 < 100 Then Lcdout "0"
	MOVF 0x63,W
	MOVWF R0L
	MOVF 0x64,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x64
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0197
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0197:	MOVLW 0x1F
	ANDWF STATUS,F
; 573: If voltage2 < 10 Then Lcdout "0"
	MOVF 0x63,W
	MOVWF R0L
	MOVF 0x64,W
	MOVWF R0H
	CLRF R1H
	MOVLW 0x0A
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0198
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x30
	CALL LC01
L0198:	MOVLW 0x1F
	ANDWF STATUS,F
; 574: Lcdout #voltage2, "V"
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x63,W
	MOVWF R2L
	MOVF 0x64,W
	MOVWF R2H
	CALL LC21
	MOVLW 0x56
	CALL LC01
; 575: Return
	RETURN
; 576: 
; 577: serialroutine: 
L0031:
; 578: Hserout #vfinal, Lf
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x39,W
	MOVWF R2L
	MOVF 0x3A,W
	MOVWF R2H
	CALL HS21
	MOVLW 0x0A
	CALL HS01
; 579: Return
	RETURN
; 580: 
; 581: endroutine: 
L0032:
; 582: address = address + 2
	MOVF 0x59,W
	ADDLW 0x02
	MOVWF 0x59
	MOVF 0x5A,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x5A
; 583: I2CWrite i2cdata, i2cclock, 0xa0, address, 255, 255
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVLW 0xFF
	CALL IC01
	MOVLW 0xFF
	CALL IC01
	CALL IC41
; 584: address = address - 2
	MOVLW 0x02
	SUBWF 0x59,W
	MOVWF 0x59
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x5A,W
	MOVWF 0x5A
; 585: Return
	RETURN
; 586: 
; 587: storeeeprom: 
L0033:
; 588: address = address + 2
	MOVF 0x59,W
	ADDLW 0x02
	MOVWF 0x59
	MOVF 0x5A,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x5A
; 589: I2CWrite i2cdata, i2cclock, 0xa0, address, vfinal.LB, vfinal.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x5A,W
	CALL IC01
	MOVF 0x59,W
	CALL IC01
	MOVF 0x39,W
	CALL IC01
	MOVF 0x3A,W
	CALL IC01
	CALL IC41
; 590: Return
	RETURN
; 591: 
; 592: settime: 
L0034:
; 593: seconds = seconds + 5
	MOVF 0x5B,W
	ADDLW 0x05
	MOVWF 0x5B
; 594: If seconds >= 60 Then
	MOVLW 0x3C
	SUBWF 0x5B,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,C
	GOTO L0199
; 595: seconds = 0
	CLRF 0x5B
; 596: minutes = minutes + 1
	MOVF 0x5C,W
	ADDLW 0x01
	MOVWF 0x5C
	MOVF 0x5D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x5D
; 597: Endif
L0199:	MOVLW 0x1F
	ANDWF STATUS,F
; 598: Return
	RETURN
; 599: 
; 600: prog_memory: 
L0035:
; 601: finish = 0
	BCF 0x30,0
; 602: While finish = 0
L0200:
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC 0x30,0
	GOTO L0201
; 603: Lcdcmdout LcdClear
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x01
	CALL LC02
; 604: Lcdout "Memory Ready..."
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x4D
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x6D
	CALL LC01
	MOVLW 0x6F
	CALL LC01
	MOVLW 0x72
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x20
	CALL LC01
	MOVLW 0x52
	CALL LC01
	MOVLW 0x65
	CALL LC01
	MOVLW 0x61
	CALL LC01
	MOVLW 0x64
	CALL LC01
	MOVLW 0x79
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
	MOVLW 0x2E
	CALL LC01
; 605: Gosub waitkey
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 606: If key = c_left Then finish = 1
	MOVF 0x6B,W
	SUBLW 0x04
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0202
	BSF 0x30,0
L0202:	MOVLW 0x1F
	ANDWF STATUS,F
; 607: If key = c_right Then
	MOVF 0x6B,W
	SUBLW 0x01
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0203
; 608: For cnt = 2 To 20000 Step 2
	MOVLW 0x02
	MOVWF 0x65
	CLRF 0x66
L0204:
	MOVF 0x65,W
	MOVWF R0L
	MOVF 0x66,W
	MOVWF R0H
	MOVLW 0x4E
	MOVWF R1H
	MOVLW 0x20
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C006
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0205
; 609: I2CRead i2cdata, i2cclock, 0xa0, cnt, sample.LB, sample.HB
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x66,W
	CALL IC01
	MOVF 0x65,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC13
	MOVWF 0x67
	CALL IC11
	MOVWF 0x68
	CALL IC41
; 610: If sample = 65535 Then Goto exit2
	MOVF 0x67,W
	MOVWF R0L
	MOVF 0x68,W
	MOVWF R0H
	MOVLW 0xFF
	MOVWF R1H
	MOVLW 0xFF
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C001
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0206
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0036
L0206:	MOVLW 0x1F
	ANDWF STATUS,F
; 611: Hserout #sample, Lf
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x67,W
	MOVWF R2L
	MOVF 0x68,W
	MOVWF R2H
	CALL HS21
	MOVLW 0x0A
	CALL HS01
; 612: Next cnt
	MOVLW 0x02
	ADDWF 0x65,F
	MOVLW 0x00
	BTFSC STATUS,C
	ADDLW 0x01
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0205
	ADDWF 0x66,F
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,C
	GOTO L0204
L0205:	MOVLW 0x1F
	ANDWF STATUS,F
; 613: exit2: 
L0036:
; 614: address = cnt - 2
	MOVLW 0x02
	SUBWF 0x65,W
	MOVWF 0x59
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x66,W
	MOVWF 0x5A
; 615: Endif
L0203:	MOVLW 0x1F
	ANDWF STATUS,F
; 616: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0200
L0201:	MOVLW 0x1F
	ANDWF STATUS,F
; 617: Goto newprogram
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0001
; 618: Return
	RETURN
; End of program
	BCF PCLATH,3
	BSF PCLATH,4
L0207:	GOTO L0207
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
