/* 
 * This file is part of the WinLIRC package, which was derived from
 * LIRC (Linux Infrared Remote Control) 0.8.6.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Copyright (C) 2010 Ian Curtis
 */

#ifndef WINLIRCAUDIOIN_H
#define WINLIRCAUDIOIN_H

//
// Serial Input API
//
#define SI_API __declspec(dllexport)

#ifdef __cplusplus
extern "C" {
#endif
	
SI_API int	init		(HANDLE exitEvent);
SI_API void	deinit		();
SI_API int	hasGui		();
SI_API void	loadSetupGui();
SI_API int	sendIR		(struct ir_remote *remotes, struct ir_ncode *code, int repeats);
SI_API int	decodeIR	(struct ir_remote *remotes, char *out);

//
// This function will be for the IR-record port, well that's the plan anyway
// It's not needed by the main app
//
SI_API struct hardware* getHardware();

#ifdef __cplusplus
}
#endif

#endif