	#include "delay.inc"
	#include "defines.inc"

	switch	.bsct

__LCD_X:			;     
	ds.b	1
__LCD_Y:	 		;    
	ds.b	1
__LCD_X_MAX:	;     
	ds.b	1

	switch	.text

;   "defines.inc"      
; :
					; PORT_A3-6 - Data4-7
					; PORT_E7 - RS
					; PORT_E6 - Enable
					; PORT_B7 - R/#W
	;#define LCD_DATA_PORT PA_ODR
	
	;       
	;        
	;#define LCD_DATA_SHIFT 1		;   1  (  3-6)

;      
__LCD_DATA_MASK:	equ	$F0 >> __LCD_DATA_SHIFT ;LCD_DATA_MASK=0xF0>>LVD_DATA_SHIFT
__LCD_DATA_MASK_NOT:	equ	~__LCD_DATA_MASK
	
	;     ,   
	;   
	;#define LCD_RS_PORT PE_ODR
	;#define LCD_RS_BIT 7
	;#define LCD_E_PORT PE_ODR
	;#define LCD_E_BIT 6
	;#define LCD_RW_PORT PB_ODR
	;#define LCD_RW_BIT 7

;    
; :  -    ( 0-3)
;    A, CC
lcd_write_nibble:	;   A -  ( 0-3)
	bres __LCD_RW_PORT, #__LCD_RW_BIT		;   RW=0
	;        
	; (      )
	if	__LCD_DATA_SHIFT < 4	; LCD_DATA_SHIFT<4
	sll	A
	endif
	if	__LCD_DATA_SHIFT < 3	; LCD_DATA_SHIFT<3
	sll	A
	endif
	if	__LCD_DATA_SHIFT < 2	; LCD_DATA_SHIFT<2
	sll	A
	endif
	if	__LCD_DATA_SHIFT == 0	; LCD_DATA_SHIFT=0
	sll	A
	endif
	
	and	A,#__LCD_DATA_MASK	;    
	push	A									;   
	ld	A, __LCD_DATA_PORT	; ,     
	and A,#__LCD_DATA_MASK_NOT	;  "" 
	or	A,(1,SP)							;   
	ld	__LCD_DATA_PORT, A			;     
	ld	A, #__LCD_DATA_MASK			; 
	or	A, __LCD_DATA_PORT+2	;      DDR
	ld	__LCD_DATA_PORT+2, A	;      (DDR)
	bset __LCD_E_PORT, #__LCD_E_BIT	;  E=1
	nop		;   437,5 ns (  16 MHz)
	nop
	nop
	nop
	nop
	nop
	addw	SP,#1
	bres __LCD_E_PORT, #__LCD_E_BIT		;  E=0
	ret
	
;  .      
; : 
;    A, CC
lcd_read_nibble:
	ld	A, #__LCD_DATA_MASK_NOT		; 
	and	A, __LCD_DATA_PORT+2 		;       DDR
	ld	__LCD_DATA_PORT+2, A		;    
	bset __LCD_RW_PORT, #__LCD_RW_BIT		; : RW=1
	nop													;  62ns ( 16 MHz)
	bset __LCD_E_PORT, #__LCD_E_BIT	;  E=1
	nop													;  250ns ( 16 MHz)
	nop
	nop
	nop
	ld	A, __LCD_DATA_PORT+1 		;   (IDR)
	and A, #__LCD_DATA_MASK				;  "" 
	;   ,      0-3
	;    
	if __LCD_DATA_SHIFT < 4	; LCD_DATA_SHIFT<4
	srl A
	endif
	if __LCD_DATA_SHIFT < 3	; LCD_DATA_SHIFT<3
	srl A
	endif
	if __LCD_DATA_SHIFT < 2	; LCD_DATA_SHIFT<2
	srl	A
	endif
	if __LCD_DATA_SHIFT == 0	; LCD_DATA_SHIFT=0
	srl	A
	endif
	
	nop			;  125ns ( 16MHz)
	nop

	bres __LCD_E_PORT, #__LCD_E_BIT		;  E=0

	ret		; ,  . A -   (  0-3)
	
;       DDRAM
; : 
;      
;    A, CC
	xdef	__lcd_read_status
__lcd_read_status:		; unsigned char _lcd_read_status(void)
	bres __LCD_RS_PORT, #__LCD_RS_BIT	;  RS=0
	call	lcd_read_nibble					;   
	swap	A												;   
	push	A												;  
	nop														;  250 ns ( 16 MHz)
	nop
	nop
	nop
	call	lcd_read_nibble					;   
	or	A,(1,SP)									;  
	addw	SP,#1										;   
	ret		; ,   A -  

;    
; :     -  A
;    A, CC
; void _lcd_write_cmd(unsigned char byte)
	xdef	__lcd_write_cmd
__lcd_write_cmd:		
	pushw	X									;    X
	push	A
_lcd_write_cmd_2:
	ldw	X,#2								;  20 
	call	__delay_us10				; 
	call	__lcd_read_status	;   
	and	A,#$80							;   
	jrne	_lcd_write_cmd_2	;   -    
_lcd_write_cmd_1:
	bres __LCD_RS_PORT, #__LCD_RS_BIT	;  ,  RS=0
	ld	A,(1,SP)									;   
	swap	A								;   
	call lcd_write_nibble ;   
	ld	A,(1,SP)					;   
	call	lcd_write_nibble	;   
	pop	A
	popw	X								;    Y
	ret										; 

;     
; :     -  
;    A, CC
; void _lcd_write_data(unsigned char byte)
	xdef	__lcd_write_data
__lcd_write_data:		
									; first hihg nibble, then low nibble
	pushw	X									;    Y
	push	A
_lcd_write_data_2:
	ldw X,#2								;   20 
	call	__delay_us10
	call	__lcd_read_status	;  
	and	A,#$80								;   
	jrne	_lcd_write_data_2
_lcd_write_data_1:
	bset __LCD_RS_PORT, #__LCD_RS_BIT	;  ,  RS=1
	ld	A,(1,SP)									;   byte
	swap	A												;   
	call lcd_write_nibble 				;   
	ld	A,(1,SP)									;   byte
	call	lcd_write_nibble				;   
	pop	A
	popw	X												;    Y
	ret														; 


;  
; :     () -  A
;   A, Y, CC
	xdef	__lcd_init
__lcd_init:	; void lcd_init(unsigned char width)
	pushw	X
	ld	__LCD_X_MAX, A				;     LCD_X_MAX
	;  ,    
	;  E - , push-pull, 2MHz, '0'
	bres __LCD_E_PORT, #__LCD_E_BIT		; ODR
	bset __LCD_E_PORT+3, #__LCD_E_BIT ; CR1
	bres __LCD_E_PORT+4, #__LCD_E_BIT ; CR2
	bset __LCD_E_PORT+2, #__LCD_E_BIT ; DDR
	;  RS - , push-pull, 2MHz, '0'
	bres __LCD_RS_PORT, #__LCD_RS_BIT		; ODR
	bset __LCD_RS_PORT+3, #__LCD_RS_BIT ; CR1
	bres __LCD_RS_PORT+4, #__LCD_RS_BIT ; CR2
	bset __LCD_RS_PORT+2, #__LCD_RS_BIT ; DDR
	;  R/#W - , push-pull, 2MHz, '0'
	bres __LCD_RW_PORT, #__LCD_RW_BIT		; ODR
	bset __LCD_RW_PORT+3, #__LCD_RW_BIT ; CR1
	bres __LCD_RW_PORT+4, #__LCD_RW_BIT ; CR2
	bset __LCD_RW_PORT+2, #__LCD_RW_BIT ; DDR
	;    
	;   4  - (), (push-pull),
	; (2 MHz), ('0'),   (      )
	ld	A, #__LCD_DATA_MASK
	or	A, __LCD_DATA_PORT+3 ; CR1
	ld	__LCD_DATA_PORT+3, A
	
	ld	A, #__LCD_DATA_MASK_NOT
	and	A, __LCD_DATA_PORT+4 ; CR2
	ld	__LCD_DATA_PORT+4, A
	
	ld	A, #__LCD_DATA_MASK_NOT
	and	A, __LCD_DATA_PORT+2 ; DDR
	ld	__LCD_DATA_PORT+2, A
	
	ldw	X,#30
	call __delay_ms 					;  30 

	bres __LCD_RS_PORT, #__LCD_RS_BIT		;  ,  RS=0
	
	ld	A, #3								;  8- 
	call lcd_write_nibble		;   

	ldw	X,#5								;  5 
	call __delay_ms						; 

	ld	A, #3								;  8- 
	call lcd_write_nibble		;   

	ldw	X, #11							;  110 
	call	__delay_us10				; 
	
	ld	A, #3								;  8- 
	call lcd_write_nibble		;    (8- )
	
	ldw	X, #4								;  40 
	call	__delay_us10				; 
	
	ld	A, #2								;  4- 
	call lcd_write_nibble		;    (8- )
;     4- 
	ldw	X, #4								;  40 
	call	__delay_us10				; 

	ld	A, #2								; : 2 ,  58
	call lcd_write_nibble		;    (4- )
	ld	A, #8								;  
	call lcd_write_nibble		;   
	
	ldw	X, #4								;  40 
	call	__delay_us10				; 

	ld	A, #0								;  
	call lcd_write_nibble		;   
	ld	A, #8	
	call lcd_write_nibble		;   

	ldw	X, #4								;  40 
	call	__delay_us10				; 

	ld	A, #0								;  
	call lcd_write_nibble		;   
	ld	A, #1
	call lcd_write_nibble		;   

	ldw	X, #160							;  1,6 
	call	__delay_us10				; 

	ld	A, #0								; : ,  
	call lcd_write_nibble		;   
	ld	A, #6	
	call lcd_write_nibble		;   
	
	ld	A, #$0C							;  ,  
	call	__lcd_write_cmd		;  

	ld	A, #$80							;     00
	call	__lcd_write_cmd		;  
	clr	__LCD_X								;     - 0 ( )
	clr	__LCD_Y								;   - 0
	popw	X
	ret											;   

;     
; :  (),  () - XH, XL
;  : A, CC
; void _lcd_gotoxy(unsigned char X (+3), unsigned char Y(+4))
	xdef	__lcd_gotoxy
__lcd_gotoxy:	
	ld	A,XH					;  X
	cp	A, __LCD_X_MAX			;     . X   
	jruge	_lcd_gotoxy_end ;  -  
	ld	A,XL					;  Y
	cp	A, #1							;	    . Y   
	jrugt	_lcd_gotoxy_end	;  -  
	ld	__LCD_Y, A					;  . Y
	swap A								;    (0-, 40h - )
	sll	A									;     40h
	sll	A
	push	A
	ld	A,XH					;    DDRAM (A=X+Y*40h)
	or	A,(1,SP)
	add SP,#1
	or	A,#$80						;     (80h)
	call	__lcd_write_cmd	;     .
	ld	A, XH					;  X
	ld	__LCD_X, A					;  . X
_lcd_gotoxy_end:
	ret										;   

;          . 
; :   () -  A
;   A, CC
; void _lcd_putchar(unsigned char c)
	xdef	__lcd_putchar
__lcd_putchar:	
	call	__lcd_write_data	;     
	inc	__LCD_X							;    . 
	ld	A, __LCD_X					;   LCD_X
	cp	A, __LCD_X_MAX			;      ?
	jrult	_lcd_putchar_end	;   -  
	clr	__LCD_X							;    
	inc	__LCD_Y							;	 
	ld	A, __LCD_Y					;  
	cp	A, #2							;      ?
	jrult	_lcd_putchar_1	;   -    DDRAM
	clr	A									;  ""
	ld	__LCD_Y, A					;   Y
_lcd_putchar_1:
	swap A								;     DDRAM
	sll	A									;   40h
	sll	A
	or	A, __LCD_X					; A=X+Y*40h
	or	A,#$80						;    DDRAM
	call	__lcd_write_cmd	;    DDRAM
_lcd_putchar_end:	
	ret										;   

;     Z-   
; :    () -  
;   A, X, CC
;   X- =0   
; unsigned int _lcd_putstr(unsigned char *s)
	xdef	__lcd_putstr
__lcd_putstr:	
	ld	A,(X)						;    
	tnz	A								; ?
	jreq	_lcd_putstr_1	;  -  
	call	__lcd_putchar		;  
	incw	X							;     
	jra	__lcd_putstr			;   
_lcd_putstr_1:
	ret									;   

;         
; :   () -  X
;   A, X, CC
; :  
; _lcd_putnum(unsigned int Num)
	xdef	__lcd_putnum
__lcd_putnum:
	pushw	Y
	clrw	Y
_lcd_putnum_2:
	ld	A,#10
	div	X,A
	jreq	_lcd_putnum_1
	push	A
	incw	Y
	jra	_lcd_putnum_2
_lcd_putnum_1:
	add	A, #'0'
	call	__lcd_putchar
	tnzw	Y
	jreq	_lcd_putnum_end
	decw	Y
	pop	A
	jra	_lcd_putnum_1
_lcd_putnum_end:
	popw	Y
	ret

;       
; :   -  
;   : A, CC
; : 
; void _lcd_puthexb(unsigned char b)
	xdef __lcd_puthexb
__lcd_puthexb:
	push	A								;    
	swap	A								;   
	and	A, #$0F						;  
	cp	A, #10						;   10?
	jrult _lcd_puthexb_1	;  - 
	add	A, #7							;  +7 ()
_lcd_puthexb_1:
	add	A, #'0'						;     
	call	__lcd_putchar			;  
	pop	A									;   
	and	A, #$0F						;   ()
	cp	A, #10						;   10?
	jrult _lcd_puthexb_2	;  - 
	add	A, #7							;  +7 ()
_lcd_puthexb_2:
	add	A, #'0'						;     
	call	__lcd_putchar			;  
	ret										;   
	
;       
; :   -  
;   : A, X, CC
; : 
; void _lcd_puthexw(unsigned int w)
	xdef	__lcd_puthexw
__lcd_puthexw:
	ld	A, XH					;  
	call	__lcd_puthexb	;  
	ld	A, XL					;  
	call	__lcd_puthexb	;  
	ret								;   


;  
; : 
;   A, CC
; void _lcd_clear(void)
	xdef	__lcd_clear
__lcd_clear:	
	ld	A,#1							;   
	call	__lcd_write_cmd	;  
	clr	__LCD_X							;  ""
	clr	__LCD_Y
	ret										;   
	
;   
; :     () -  X
;   A, X, Y, CC
; void _lcd_setuserfont(unsigned char *font) 64 Bytes
	xdef	__lcd_setucg
__lcd_setucg:
	pushw	Y
	ld	A, #$40						;    CGRAM   0
	call	__lcd_write_cmd	;  
	ldw	Y, #64						;   - 64 
_lcd_setucg_1:					;   
	ld	A,(X)							;     
	incw	X								;   
	call	__lcd_write_data	;   
	decw	Y								;  
	jrne	_lcd_setucg_1		;      -  
	ldw		X, __LCD_X
	call	__lcd_gotoxy			;     
	ret										;   

	end
