   1                     ;   : defines.inc
   2                     ;      :
   3                     ; lcd.asm -      .
   4                     ; delay.asm -  .
   5                     
   6                     	;  
   7                     ;	#include "stm8s105c6.inc"
   8                     
  10       00000001      	#define _DEFINES_INC
  11                     	
  12       007a1200      	#define __CPU_CLOCK 8000000 ;      
  13                     	;    444444    delay_xx  
  14                     	
  15                     	;       
  16                     					; PORT_A3-6 - Data4-7
  17                     					; PORT_E7 - RS
  18                     					; PORT_E6 - Enable
  19                     					; PORT_B7 - R/#W
  20       00005000      __LCD_DATA_PORT: equ $5000 ;PA_ODR
  21                     	
  22                     	;       
  23                     	;        
  24       00000001      __LCD_DATA_SHIFT:	equ	1		;   1  (  3-6)
  25                     	
  26                     	;     ,   
  27                     	;   
  28       00005014      __LCD_RS_PORT: equ $5014 ;PE_ODR  ;  RS (/)
  29       00000007      __LCD_RS_BIT:	equ 7
  30                     	
  31       00005014      __LCD_E_PORT: equ $5014 ;PE_ODR		;   ()
  32       00000006      __LCD_E_BIT: equ 6
  33                     	
  34       00005005      __LCD_RW_PORT: equ $5005 ;PB_ODR	;  R/#W (/)
  35       00000007      __LCD_RW_BIT: equ 7
  36                     
   2                     	
   3                     	switch	.ubsct
   4                     ;   	
   5                     xdef	_Sec, _Min, _Hour, _SecFlag
   6  0000 00            _Sec:	ds.b	1
   7  0001 00            _Min: ds.b	1
   8  0002 00            _Hour:	ds.b	1
   9  0003 00            _SecFlag:	ds.b	1
  10                     
  11                     xdef	_Key
  12  0004 00            _Key:	ds.b	1
  13  0005 00            _Msec: ds.b	1
  14  0006 00            _Kdelay:	ds.b	1
  15  0007 00            _Lastkey:	ds.b	1
  16                     
  17                     	switch	.text
  18                     	
  19  0000               KeyTable:
  20  0000 ffffffffffff  	dc.b	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 10
  21  0008 ffffff07ff04  	dc.b	0xFF,	0xFF, 0xFF, 7, 0xFF, 4, 1, 0xFF
  22  0010 ffffffffffff  	dc.b	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0
  23  0018 ffffff08ff05  	dc.b	0xFF,	0xFF, 0xFF, 8, 0xFF, 5, 2, 0xFF
  24  0020 ffffffffffff  	dc.b	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 11
  25  0028 ffffff09ff06  	dc.b	0xFF,	0xFF, 0xFF, 9, 0xFF, 6, 3, 0xFF
  26                     ;  	
  27                     	xdef	f_TIM1Interrupt
  28                     ;   TIM1
  29                     ;   stm8_interrupt_vector.c :
  30                     ; extern @far @interrupt void TIM1Interrupt(void);
  31                     ;   interrupt_vector  :
  32                     ;			{0x82, TIM1Interrupt}, /* irq11 */
  33  0030               f_TIM1Interrupt:
  34  0030 3a05          	dec _Msec
  35  0032 2624          	jrne	TIM1Int_2
  36  0034 35320005      	mov	_Msec, #50
  37  0038 3c00          	inc	_Sec
  38  003a a63c          	ld	A,#60
  39  003c b100          	cp	A, _Sec
  40  003e 2214          	jrugt	TIM1Int_1
  41  0040 3f00          	clr	_Sec
  42  0042 3c01          	inc	_Min
  43  0044 b101          	cp	A, _Min
  44  0046 220c          	jrugt	TIM1Int_1
  45  0048 3f01          	clr	_Min
  46  004a 3c02          	inc	_Hour
  47  004c a618          	ld	A,#24
  48  004e b101          	cp	A, _Min
  49  0050 2202          	jrugt	TIM1Int_1
  50  0052 3f02          	clr	_Hour
  51  0054               TIM1Int_1:
  52  0054 72100003      	bset	_SecFlag, #0
  53  0058               TIM1Int_2:
  54  0058 4b00          	push	#0
  55  005a 4b18          	push	#$18
  56  005c               TIM1Int_3:
  57  005c c6500f        	ld	A, $500F	; PD_ODR
  58  005f a4e3          	and	A,#$E3
  59  0061 1a01          	or	A,(1,SP)
  60  0063 c7500f        	ld	$500F, A
  61  0066 9d            	nop
  62  0067 9d            	nop
  63  0068 9d            	nop
  64  0069 a60f          	ld	A,#$0F
  65  006b c45015        	and	A, $5015	; PE_IDR
  66  006e a10f          	cp	A,#$0F
  67  0070 2720          	jreq	TIM1Int_7
  68  0072 6b01          	ld	(1,SP), A
  69  0074 7b02          	ld	A,(2,SP)
  70  0076 4e            	swap	A
  71  0077 1a01          	or	A,(1,SP)
  72  0079 5f            	clrw	X
  73  007a 97            	ld	XL,A
  74  007b d60000        	ld	A,(KeyTable,X)
  75  007e a1ff          	cp	A,#$FF
  76  0080 2722          	jreq	TIM1Int_4
  77  0082 b107          	cp	A,_Lastkey
  78  0084 2620          	jrne	TIM1Int_8
  79  0086 3a06          	dec	_Kdelay
  80  0088 2622          	jrne	TIM1Int_6
  81  008a 35190006      	mov	_Kdelay,#25
  82  008e b704          	ld	_Key, A
  83  0090 201a          	jra	TIM1Int_6
  84  0092               TIM1Int_7:
  85  0092 7b02          	ld	A,(2,SP)
  86  0094 a102          	cp	A,#2
  87  0096 270c          	jreq TIM1Int_4
  88  0098 4c            	inc	A
  89  0099 6b02          	ld	(2,SP),A
  90  009b a602          	ld	A,#2
  91  009d 1a01          	or	A,(1,SP)
  92  009f 48            	sll	A
  93  00a0 6b01          	ld	(1,SP),A
  94  00a2 20b8          	jra	TIM1Int_3
  95  00a4               TIM1Int_4:
  96  00a4 a6ff          	ld	A, #$FF
  97  00a6               TIM1Int_8:
  98  00a6 b707          	ld	_Lastkey,A
  99  00a8               TIM1Int_5:
 100  00a8 35050006      	mov	_Kdelay, #5
 101  00ac               TIM1Int_6:
 102  00ac 5b02          	addw	SP,#2
 103  00ae 72115255      	bres	$5255, #0	;    TIM1
 104  00b2 80            	iret
 105                     
 106                     	end
