

 void cfg_rcc(void)
 {
  RCC->AHBENR  |= RCC_AHBENR_GPIOAEN | RCC_AHBENR_GPIOFEN;

  RCC->APB1ENR |= RCC_APB1ENR_TIM14EN;
  RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;

  RCC->CFGR    |= 7<<8; //APB prescaler 16
 }

 void cfg_gpio(void)
 {
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;

 //PF1,PF0 - reset pullup
  GIS.GPIO_Pin   = GPIO_Pin_0|GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_IN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOF, &GIS);

 //PA0 - AF tim2
  GIS.GPIO_Pin   = GPIO_Pin_0;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  GPIOA->BSRR = 1<<0;

  GPIO_PinAFConfig(GPIOA, GPIO_PinSource0, GPIO_AF_2);

 //PA1, PA2, PA3 - btn
  GIS.GPIO_Pin   = GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_3;
  GIS.GPIO_Mode  = GPIO_Mode_IN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOA, &GIS);

 //PA4 - AF tim14
  GIS.GPIO_Pin   = GPIO_Pin_4;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  GPIO_PinAFConfig(GPIOA, GPIO_PinSource4, GPIO_AF_4);

 //PA5 - out upd signal
  GIS.GPIO_Pin   = GPIO_Pin_5;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

//  //PA6 - AF tim16, PA7 - AF tim17
//  GIS.GPIO_Pin   = GPIO_Pin_6|GPIO_Pin_7;
//  GIS.GPIO_Mode  = GPIO_Mode_AF;
//  GIS.GPIO_OType = GPIO_OType_PP;
//  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
//
//  GPIO_Init(GPIOA, &GIS);
//
//  GPIO_PinAFConfig(GPIOA, GPIO_PinSource6, GPIO_AF_5);
//  GPIO_PinAFConfig(GPIOA, GPIO_PinSource7, GPIO_AF_5);

  //PA7 - AF tim17
  GIS.GPIO_Pin   = GPIO_Pin_7;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  GPIO_PinAFConfig(GPIOA, GPIO_PinSource7, GPIO_AF_5);

//  //PB1 - btn
//  GIS.GPIO_Pin   = GPIO_Pin_1;
//  GIS.GPIO_Mode  = GPIO_Mode_IN;
//  GIS.GPIO_OType = GPIO_OType_OD;
//  GIS.GPIO_PuPd  = GPIO_PuPd_UP;
//
//  GPIO_Init(GPIOB, &GIS);

  //PA9 - AF tim1
  GIS.GPIO_Pin   = GPIO_Pin_9;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  GPIO_PinAFConfig(GPIOA, GPIO_PinSource9, GPIO_AF_2);
 }

 //    3 ,  30us
 void cfg_t1(void)
 {
  TIM1->ARR   = 30;
  TIM1->CCR2  = 27;
  TIM1->CCMR1 = pwm2 <<8;
  TIM1->CCER  = TIM_CCER_CC2E;
  TIM1->BDTR  = bin(11)<<8; //lock_2
  TIM1->EGR   = TIM_EGR_UG;
  TIM1->CR1   = TIM_CR1_CEN;
 }

 //  50
 void cfg_tim14(void)
 {
  TIM14->PSC   = 0;
  TIM14->ARR   = SYSTEM_FRQ/8/100 -1;
  TIM14->CCR1  = TIM14->ARR;
  TIM14->CCMR1 = toggle_on_match;
  TIM14->CCER  = TIM_CCER_CC1E;
  TIM14->BDTR  = TIM_BDTR_MOE;
  TIM14->EGR   = TIM_EGR_UG;
  TIM14->CR1   = TIM_CR1_CEN;
 }

 void cfg_systic()
 {
  SysTick->LOAD  = SYSTEM_FRQ;
  SysTick->VAL   = 0;
  SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_TICKINT_Msk|SysTick_CTRL_ENABLE_Msk;
  NVIC_SetPriority(SysTick_IRQn, 5);
 }











