/* ---------------------------------- */
/*   заголовочный файл устройства     */
/* "таймер обратного отсчета" timer.h */
/*-------------------------------------------------------- */
#ifndef _timer_H        // Блокируем повторное включение этого модуля
#define _timer_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
// #include <avr/interrupt.h> // обслуживание прерываний
// #include <avr/pgmspace.h> // подключить библиотеку работ с таблицами в ПЗУ
#include "sksi.h" // библиотека sksi
#include "bdbc.h" // табличные кодер/декодеры
              // упакованного двоично-десятичного значения 00-99
              //в код двоичный и обратно

//------------------------------------------------------------------------

// сигнальный вывод таймера
extern const byte HLtmr;
// активный уровень сигнального вывода таймера
extern const byte HLtmrWrk; 

// флаг разрешения счета для счетчиков и 
// вывода значений таймера на индикацию
extern volatile byte En_TmrF;

// инициализация панели устройства "таймер обратного отсчета"
extern void Tmr_Init();
// кнопка "пуск/стоп"
void Tmr_PS();
// кнопка "перезагрузка ранее введеной уставкой"
// (аналогия "сброс" секундомера, но не в 0, а
// на установленное значение)
void Tmr_RW();
// инициализация панели "ввод значений интервала времени"
// ( кнопка "+" в рабочей панели таймера )
void Tmr_ID();
// кнопка "+" ввода значений или
// кнопка "возврат в панель устройства
// "таймер обратного отсчета" с перезаписью уставки"
void Tmr_P();
// кнопка "-" ввода значений или
// кнопка "возврат в панель устройства
// "таймер обратного отсчета" без перезаписи уставки"
void Tmr_M();
// возврат из рабочей панели таймера
// в панель устройства - предшественника
// ( кнопка "-" в рабочей панели таймера )
void Tmr_Ret();
// функция обработчика контроля и декремента
// счетчиков таймера ( функция счета таймера )
extern void Tmr_wrk();
// функция печати текущих данных на индикаторе
void Tmr_Print();
// инициализация сигнального вывода таймера
// активный уровень единица (под мигающий светик)
extern void iTmrO();
// деактивация светового индикатора завершения отсчета
// и звукового сигнала таймера
void endTmZum();

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
