/* ------------------------------------------------------------- */
/* основной файл устройства "таймер обратного отсчета" timer.cpp */
//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "timer.h" // заголовочный *.h файл проекта
               // "таймер обратного отсчета"

//------------------------------------------------------------------------

// рабочие флаги и регистры таймера

// флаг разрешения счета для счетчиков и 
// вывода значений таймера на индикацию
volatile byte En_TmrF = 0;

// основные счетчики таймера
volatile byte Tmr_cntS = 0; // счетчик секунд таймера
volatile byte Tmr_cntM = 0; // счетчик минут таймера
volatile byte Tmr_cntH = 0; // счетчик часов таймера

// блок временной памяти уставок таймера
volatile byte Tmr_RamM = 0; // РВХ уставки минут таймера
volatile byte Tmr_RamH = 0; // РВХ уставки часов таймера

// инициализация панели устройства "таймер обратного отсчета"
extern void Tmr_Init()
{
 WS_Lock=1;
 DisClcInd = 1; // запрет индикации текущего времени
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // скопировать данные из буфера уставки
 // в счетчики, преобразовать счетчики в
 // сегменты видеопамяти и вывести на индикацию
 // вместе со значком ход/работа
 Tmr_cntH = Tmr_RamH; Tmr_cntM = Tmr_RamM;
 Tmr_cntS = 0; njx.v_ram[9] = fnt_o;
 Tmr_Print();
 /* записать новые значения в указатели кнопок
  * KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены"
  * KeyPtrL = Tmr_PS; //skL указатель на функцию "<<"
  * KeyPtrR = Tmr_RW; //skR указатель на функцию ">>"
  * KeyPtrP = Tmr_ID; //skP указатель на функцию "+"
  * KeyPtrM = Tmr_Ret; //skM указатель на функцию "-"
  * KeyPtrRK = breaker; //skRK stub указатель на функцию "RK" 
  */
 ReMapKey(SnZero, Tmr_PS, Tmr_RW, Tmr_ID, Tmr_Ret, breaker);
 // записать в стек возврата указатель
 // на предшественника (DevClockInit)
 RetSteckU = RetSteckH; RetSteckH = RetSteckL;
 RetSteckL = dev0_init;
}

// кнопка "пуск/стоп"
void Tmr_PS()
{
 static byte flag = 0;
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!flag)
    {
     flag = 1;
     En_TmrF = 1; njx.v_ram[9] = fnt_gradus;
     Tmr_Print();
    }
   else
    {
     flag = 0;
     En_TmrF = 0; njx.v_ram[9] = fnt_o;
     Tmr_Print();
    }
  }
}

// кнопка "перезагрузка ранее введеной уставкой"
// (аналогия "сброс" секундомера, но не в 0, а
// на установленное значение)
void Tmr_RW()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!En_TmrF)
    {
     // деактивация индикатора и звукового сигнала
     endTmZum();
     // перезагрузка значения уставки в счетчтки
     Tmr_cntH = Tmr_RamH; Tmr_cntM = Tmr_RamM;
     Tmr_cntS = 0; njx.v_ram[9] = fnt_o;
     Tmr_Print();
    }
  }
}

// инициализация панели "ввод значений интервала времени"
// ( кнопка "+" в рабочей панели таймера )
void Tmr_ID()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!En_TmrF)
    {
     // деактивация индикатора и звукового сигнала
     endTmZum();   
     LdMas(EnKurF, LenPozDisp, 0); // предочистка массива
     // заполнить массив флагов разрешенных позиций курсора
     EnKurF[9] = 1; EnKurF[7] = 1; EnKurF[6] = 1;
     EnKurF[4] = 1; EnKurF[3] = 1;
     // и номер позиции начального положения курсора
     NumPozKur = 9;
     njx.BlankVram(fnt_bl); // очистка видеопамяти
     // вывод заставки панели и текущего значения из
     // Tmr_RamH:Tmr_RamM на дисплей
     byte tmp;
     njx.v_ram[9] = fnt_qest;
     tmp = pgm_read_byte_near( BinDec + Tmr_RamM );
     njx.v_ram[7] = njx.znak((tmp & B00001111));
     njx.v_ram[6] = njx.znak(((tmp>>4) & B00001111));
     njx.v_ram[5] = fnt_minus;
     tmp = pgm_read_byte_near( BinDec + Tmr_RamH );
     njx.v_ram[4] = njx.znak((tmp & B00001111));
     njx.v_ram[3] = njx.znak(((tmp>>4) & B00001111));
     njx.v_ram[1] = fnt_T_sk; // fnt_2;
     njx.v_ram[0] = fnt_J; // 
     njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
     njx.WRglass();
     /* записать новые значения в указатели кнопок
      * KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены"
      * KeyPtrL = kurL; //skL указатель на функцию "<<"
      * KeyPtrR = kurR; //skR указатель на функцию ">>"
      * KeyPtrP = Tmr_P; //skP указатель на функцию "+"
      * KeyPtrM = Tmr_M; //skM указатель на функцию "-"
      * KeyPtrRK = breaker; //skRK stub указатель на функцию "RK"
      */
     ReMapKey(SnZero, kurL, kurR, Tmr_P, Tmr_M, breaker);
    }
  }
}

// кнопка "+" ввода значений уставки
// или перезапись уставки без выхода из режима
// ввода параметров
void Tmr_P()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(NumPozKur == 9)
    {
     // перезапись уставки с приведением
     // результата к часам и минутам
     Tmr_RamM = njx.overZnak(njx.v_ram[7]);
     Tmr_RamM = Tmr_RamM | (njx.overZnak(njx.v_ram[6]) << 4);
     Tmr_RamM = pgm_read_byte_near( DecBin + Tmr_RamM );
     Tmr_RamH = njx.overZnak(njx.v_ram[4]);
     Tmr_RamH = Tmr_RamH | (njx.overZnak(njx.v_ram[3]) << 4);
     Tmr_RamH = pgm_read_byte_near( DecBin + Tmr_RamH );
     if (Tmr_RamM >= 60)
      {
       Tmr_RamM = Tmr_RamM - 60; Tmr_RamH++;
       byte tmp;
       tmp = pgm_read_byte_near( BinDec + Tmr_RamM );
       njx.v_ram[7] = njx.znak((tmp & B00001111));
       njx.v_ram[6] = njx.znak(((tmp>>4) & B00001111));
       tmp = pgm_read_byte_near( BinDec + Tmr_RamH );
       njx.v_ram[4] = njx.znak((tmp & B00001111));
       njx.v_ram[3] = njx.znak(((tmp>>4) & B00001111));
      }
     // пикнуть для подтверждения перезаписи
     tone(DTM, 400, 100); Tmr_Init();
    }
   else { incKey(9); }
   njx.WRglass();
  }
}

// кнопка "-" ввода значений или
// кнопка "возврат в панель устройства
// "таймер обратного отсчета" без перезаписи уставки"
void Tmr_M()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(NumPozKur == 9)
    {
     // деактивация индикатора и звукового сигнала
     endTmZum();
     // возврат в режим рабочей панели таймера
     Tmr_Init();
    }
   else { decKey(9); njx.WRglass(); }
  }
}

// возврат из рабочей панели таймера
// в панель устройства - предшественника
// ( кнопка "-" в рабочей панели таймера )
void Tmr_Ret()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!En_TmrF)
    {
     // деактивация индикатора и звукового сигнала
     endTmZum();
     RetPtr = RetSteckL;
     RetSteckL = RetSteckH; RetSteckH = RetSteckU;
    }
  }
}

// функция обработчика контроля и декремента
// счетчиков таймера ( функция счета таймера )
void Tmr_wrk()
{
 Tmr_cntS--;
 if (Tmr_cntS == 0xFF)
  {
   if (Tmr_cntM ==0)
    {
     if (Tmr_cntH == 0)
      {
       Tmr_cntS = 0;
       En_TmrF = 0; // остановить отсчет
       // индикатор равен "нижнему кружку"
       njx.v_ram[9] = fnt_o;
       // активировать силовой вывод (светик)
       digitalWrite(HLtmr, HLtmrWrk);
       // и звуковой сигнал
       tone(DTM, 600);
      }
     else
      {
       Tmr_cntH--; Tmr_cntM = 59; Tmr_cntS = 59;
      }
    }
   else
    {
     Tmr_cntM--; Tmr_cntS = 59;
    }
  }
  Tmr_Print();
}

// функция печати текущих данных на индикаторе
void Tmr_Print()
{
 byte tmp;
 tmp = pgm_read_byte_near( BinDec + Tmr_cntS );
 njx.v_ram[7] = njx.znak((tmp & B00001111));
 njx.v_ram[6] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[5] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + Tmr_cntM );
 njx.v_ram[4] = njx.znak((tmp & B00001111));
 njx.v_ram[3] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[2] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + Tmr_cntH );
 njx.v_ram[1] = njx.znak((tmp & B00001111));
 njx.v_ram[0] = njx.znak(((tmp>>4) & B00001111));
 njx.WRglass();
}

// инициализация сигнального вывода таймера
// активный уровень = HLtmrWrk
void iTmrO()
{ digitalWrite(HLtmr, (!HLtmrWrk)); pinMode(HLtmr, OUTPUT); }

// деактивация светового индикатора завершения отсчета
// и звукового сигнала таймера
void endTmZum()
{
  if(digitalRead(HLtmr) == HLtmrWrk)
  { digitalWrite(HLtmr, (!HLtmrWrk)); noTone(DTM); }
}

//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
