/* ---------------------------------------------------- */
/*        заголовочный файл - DS18B20                   */
/*                    termo.h                           */
//-------------------------------------------------------
#ifndef _TERMO_H        // Блокируем повторное включение этого модуля
#define _TERMO_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
#include "sksi.h" // библиотека sksi
#include "bdbc.h" // табличные кодер/декодеры
              // упакованного двоично-десятичного значения 00-99
              //в код двоичный и обратно
#include "ds18b20_map.h" // карта ресурсов DS18B20
#include "OneWire.h" // заголовочный *.h файл библиотеки uLan
#include "dscrc.h" // заголовочный *.h файл обработчика CRC

//------------------------------------------------------------------------
// обьявление линии обмена данными с DS18B20
extern const byte DQ; // собственно линия данных датчика
                     // (внешний разъём контакт 7)
extern const byte SSW; // контрольная линия внешнео шлейфа
                     // (внешний разъём контакт 1)
extern byte present; // контрольный флаг ответа линии OneWire
extern byte data[]; // массив данных (блокнота) OneWire
extern byte addr[]; // массив данных (адреса) OneWire
extern OneWire ds; // объект ds класса OneWire

// триггер-флаг переключения задач
extern volatile byte F_termo;
// флаг знака данных температуры
extern volatile byte F_Tminus;
// флаг разрешения работы устройства "термометр"
extern volatile byte ENTermo;
// флаг ошибки CRC
extern volatile byte F_ErCrc;

// буфер данных для предобработки
extern volatile int Termo_dat;

// флаг разрешения работы вольтметр-показометра вместо
// термодатчика (SSW = 1)
extern volatile byte EN_volt;
// константа пересчета 1
const long mod_m1 = 111799; // 109677 рассчетное согласно схемы
// константа пересчета 2
const long mod_m2 = 100000;

//------------------------------------------------------------------------
// функции управления/обработки данных DS18B20

// однократно при обнаружении несоответствия при
// первом подключении  и при необходимостм задаем
// 12-битовый режим работы датчика
void reinit_ds();

// функция запуска преобразования
void T_work();

// функция считывания данных
void RD_termo();

// функция вывода на индикацию
void T_print();

// индикация "ошибка CRC" (не блокирующая)
void ER_CRC();

// ошибка отзыва датчика (линии uLan)
void Er_uLan();

//------------------------------------------------------------------------

// начальная инициализация устройства "термометр(терморегулятор)"
extern void TermoInit();

// кнопа "возврат" ("-")
void Tmetr_stop();

// индикация псевдовольтметра
void Volt();

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
