//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "termo.h" // заголовочный *.h файл датчика DS18B20

//------------------------------------------------------------------------
// инициализация линии обмена данными с DS18B20
byte present=0; // контрольный флаг OneWire
byte data[12]; // массив данных (блокнота) OneWire
byte addr[8]; // массив данных (адреса) OneWire

OneWire ds(DQ); // конструктор OneWire

// триггер-флаг переключения задач
volatile byte F_termo=0;
// флаг знака данных температуры
volatile byte F_Tminus=0;
// флаг разрешения работы устройства "термометр"
volatile byte ENTermo=0;
// флаг ошибки CRC
volatile byte F_ErCrc=0;
// буфер данных для предобработки
volatile int Termo_dat=0;

// флаг разрешения работы вольтметр-показометра вместо
// термодатчика (SSW = 1)
volatile byte EN_volt;

//------------------------------------------------------------------------
// функции управления/обработки данных DS18B20

// однократно при обнаружении несоответствия при
// первом подключении  и при необходимостм задаем
// 12-битовый режим работы датчика
void reinit_ds()
{
  F_ErCrc = 0;
if (!ds.reset()){ Er_uLan(); }
 ds.skip();
 ds.write(RdScrPad_F);
 ds.read_bytes(data, 9);
 F_ErCrc = dscrc.pcrc(data, crc_8, test_crc);
if(!F_ErCrc)
 {
 if (data[Conf] != 0x7F)
  {
  data[Conf] = 0x7F;
  if (!ds.reset()){ Er_uLan(); }
  ds.skip();
  ds.write(WrScrPad_F);
  ds.write(data[TUbh]);
  ds.write(data[TUbl]);
  ds.write(data[Conf]); // загружена конфигурация 12 битового режима
 // может быть добавлена проверка правильности записи конфигурации
 //present = ds.reset();
  if (!ds.reset()){ Er_uLan(); }
  ds.skip();
  ds.write(CopiScrPad_F);
  // сообщение о проведении перенастройки
  njx.BlankVram(fnt_bl);
  njx.v_ram[2] = fnt_I;
  njx.v_ram[3] = fnt_n;
  njx.v_ram[4] = fnt_I;
  njx.v_ram[5] = fnt_c;
  njx.v_ram[7] = fnt_d;
  njx.v_ram[8] = fnt_S;
  njx.WRglass(); // вывод v_ram в индикатор
  delay(2000);
  }
 }
else if(F_ErCrc)
 {
  // *допускается несколько подряд ошибок CRC
  ER_CRC(); delay(10);
 }
}

// функция запуска преобразования
void T_work()
{
  F_termo=1;
  if (!ds.reset()){ Er_uLan(); }
  ds.skip();
  ds.write(ConvertT_F);
}

// функция считывания данных
void RD_termo()
{
  F_termo=0; F_ErCrc=0;
  if (!ds.reset()){ Er_uLan(); }
  ds.skip();
  ds.write(RdScrPad_F);
  ds.read_bytes(data, 9);
  F_ErCrc=dscrc.pcrc(data, crc_8, test_crc);
  if(F_ErCrc){ER_CRC();}
}

// функция вывода на индикацию
void T_print()
{
 if(!F_ErCrc) // && (ENTermo)
 {
  Termo_dat=word(data[THdt], data[TLdt]); F_Tminus=0;
  if(bitRead(data[THdt],7))
    {
     Termo_dat = (~Termo_dat) + 1; F_Tminus=1;
    }
  Termo_dat = Termo_dat << 4;
  tempo[0]=highByte(Termo_dat);tempo[1]=lowByte(Termo_dat);
  if(F_Tminus)
   {
    njx.v_ram[1]=fnt_minus;
    tempo[0]=pgm_read_byte_near(BinDec+tempo[0]);
    njx.v_ram[3]=njx.znak(tempo[0] & 0x0F);
    njx.v_ram[2]=njx.znak((tempo[0]>>4) & 0x0F);
    if(njx.v_ram[2]==fnt_0)
      {njx.v_ram[1]=fnt_bl; njx.v_ram[2]=fnt_minus;}
     else {njx.v_ram[1]=fnt_minus;}
   }
  else
  {
   if(tempo[0]>=100){njx.v_ram[1]=fnt_1; tempo[0] -= 100;}
    else{njx.v_ram[1]=fnt_bl;}
   tempo[0]=pgm_read_byte_near(BinDec+tempo[0]);
   njx.v_ram[3]=njx.znak(tempo[0] & 0x0F);
   njx.v_ram[2]=njx.znak((tempo[0]>>4) & 0x0F);
   if((njx.v_ram[1]==fnt_bl) && (njx.v_ram[2]==fnt_0))
     {njx.v_ram[2]=fnt_bl;}
  }
  njx.v_ram[3] = njx.v_ram[3] | fnt_coma;
  // дробная часть
  tempo[1] = (tempo[1]>>4) & 0x0F;
  switch (tempo[1]) {
    case B00000000:
      njx.v_ram[4]=fnt_0; // 0
      njx.v_ram[5]=fnt_bl;
      //njx.v_ram[6]=fnt_bl;
      break;
    case B00000001:
      njx.v_ram[4]=fnt_0; // 625
      njx.v_ram[5]=fnt_6;
      //njx.v_ram[6]=fnt_2;
      break;
    case B00000010:
      njx.v_ram[4]=fnt_1; // 1250
      njx.v_ram[5]=fnt_2;
      //njx.v_ram[6]=fnt_5;
      break;
    case B00000011:
      njx.v_ram[4]=fnt_1; // 625+1250=1875
      njx.v_ram[5]=fnt_8;
      //njx.v_ram[6]=fnt_7;
      break;
    case B00000100:
      njx.v_ram[4]=fnt_2; // 2500
      njx.v_ram[5]=fnt_5;
      //njx.v_ram[6]=fnt_bl;
      break;
    case B00000101:
      njx.v_ram[4]=fnt_3; // 625+2500=3125
      njx.v_ram[5]=fnt_1;
      //njx.v_ram[6]=fnt_2;
      break;
    case B00000110:
      njx.v_ram[4]=fnt_3; // 1250+2500=3750
      njx.v_ram[5]=fnt_7;
      //njx.v_ram[6]=fnt_5;
      break;
    case B00000111:
      njx.v_ram[4]=fnt_4; // 625+1250+2500=4375
      njx.v_ram[5]=fnt_3;
      //njx.v_ram[6]=fnt_7;
      break;
    case B00001000:
      njx.v_ram[4]=fnt_5; // 5000
      njx.v_ram[5]=fnt_bl;
      //njx.v_ram[6]=fnt_bl;
      break;
    case B00001001:
      njx.v_ram[4]=fnt_5; // 625+5000=5625
      njx.v_ram[5]=fnt_6;
      //njx.v_ram[6]=fnt_2;
      break;
    case B00001010:
      njx.v_ram[4]=fnt_6; // 1250+5000=6250
      njx.v_ram[5]=fnt_2;
      //njx.v_ram[6]=fnt_5;
      break;
    case B00001011:
      njx.v_ram[4]=fnt_6; // 625+1250+5000=6875
      njx.v_ram[5]=fnt_8;
      //njx.v_ram[6]=fnt_7;
      break;
    case B00001100:
      njx.v_ram[4]=fnt_7; // 2500+5000=7500
      njx.v_ram[5]=fnt_5;
      //njx.v_ram[6]=fnt_bl;
      break;
    case B00001101:
      njx.v_ram[4]=fnt_8; // 625+2500+5000=8125
      njx.v_ram[5]=fnt_1;
      //njx.v_ram[6]=fnt_2;
      break;
    case B00001110:
      njx.v_ram[4]=fnt_8; // 1250+2500+5000=8750
      njx.v_ram[5]=fnt_7;
      //njx.v_ram[6]=fnt_5;
      break;
    case B00001111:
      njx.v_ram[4]=fnt_9; // 625+1250+2500+5000=9375
      njx.v_ram[5]=fnt_3;
      //njx.v_ram[6]=fnt_7;
      break;
    default: 
      njx.v_ram[4]=fnt_0;
      njx.v_ram[5]=fnt_bl;
      //njx.v_ram[6]=fnt_bl;
    break;
  }
  njx.v_ram[7]=fnt_gradus; //fnt_gradus
  njx.v_ram[8]=fnt_C;
  njx.WRglass(); // вывод v_ram в индикатор
 }
}

// индикация "ошибка CRC" (не блокирующая)
void ER_CRC()
{
 F_ErCrc=1;
 for(byte m=0; m<=9; m++){tempo[m]=njx.v_ram[m];}
 njx.BlankVram(fnt_bl);
 njx.v_ram[1]=fnt_E;
 njx.v_ram[2]=fnt_r;
 njx.v_ram[3]=fnt_C;
 njx.v_ram[5]=fnt_r;
 njx.v_ram[6]=fnt_C;
 njx.WRglass(); // вывод v_ram в индикатор
 for(byte m=0; m<=5; m++)
 {tone(DTM,1000);delay(100);noTone(DTM);delay(100);}
 for(byte m=0; m<=9; m++){njx.v_ram[m]=tempo[m];}
 njx.WRglass(); // вывод v_ram в индикатор
}

// ошибка отзыва датчика (линии uLan)
void Er_uLan()
{
 labelEror();
 njx.v_ram[4] = fnt_u;
 njx.v_ram[5] = fnt_L;
 njx.v_ram[6] = fnt_A;
 njx.v_ram[7] = fnt_n;
 njx.WRglass(); // вывод v_ram в индикатор
 delay(2000);
 // критическая ошибка = останов системы
 // while (1){}
}

//------------------------------------------------------------------------

// начальная инициализация устройства "термометр(терморегулятор)"
void TermoInit()
{
 WS_Lock=1;
 DisClcInd = 1; // запрет индикации текущего времени
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 
      // запуск индикативного вольтметра,
      // показывающего напряжение текущего системного
      // питания +Vcc(см. эл. схему)
 if (digitalRead(SSW))
 { 
  EN_volt = 1; 
  njx.v_ram[1] = fnt_U;
  njx.v_ram[2] = fnt_c;
  njx.v_ram[3] = fnt_c;
 }       
     // или обработка термодатчика
 else
  {
   EN_volt = 0; reinit_ds();
   njx.v_ram[1] = fnt_dnlin;
   njx.v_ram[2] = fnt_dnlin;
   njx.v_ram[3] = fnt_dnlin | fnt_coma;
   njx.v_ram[4] = fnt_dnlin;
   njx.v_ram[5] = fnt_dnlin;
   njx.v_ram[7] = fnt_gradus; //fnt_gradus
   njx.v_ram[8] = fnt_C;
   ENTermo = 1; T_work(); delay(1000);
  }
 njx.WRglass(); // вывод v_ram в индикатор
 /* записать новые значения в указатели кнопок
  * KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены" ***
  * KeyPtrL = stub; //skL указатель на функцию "<<"
  * KeyPtrR = stub; //skR указатель на функцию ">>"
  * KeyPtrP = stub; //skP указатель на функцию "+"
  * KeyPtrM = Tmetr_stop; //skM указатель на функцию "-"
  * KeyPtrRK = breaker; //skRK stub указатель на функцию "RK"
  */
 ReMapKey(SnZero, stub, stub, stub, Tmetr_stop, breaker);
 // записать в стек возврата указатель
 // на предшественника (DevClockInit)
 RetSteckU = RetSteckH; RetSteckH = RetSteckL;
 RetSteckL = dev0_init;
}

// кнопа "возврат" ("-")
void Tmetr_stop()
{
  // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   // здесь собственно то, что кнопа должна делать
   // по нажатию однократно
   // "простой возврат в "главные часы""
   ENTermo = 0; EN_volt = 0;
   RetPtr = RetSteckL;
   RetSteckL = RetSteckH; RetSteckH = RetSteckU;
  }
 else
  {
   // здесь функционал при 
   // длительном удержании
  }
}

// индикация псевдовольтметра
void Volt()
{
  byte n; int tmp;
  tmp = int((analogRead(Apwr) * mod_m1) / mod_m2);
  n = tmp / 100; // значение не может быть менее 300
  njx.v_ram[5] = njx.znak(n) | fnt_coma;
  tmp = tmp - (n * 100);
  tmp = pgm_read_byte_near( BinDec + tmp );
  njx.v_ram[6] =  njx.znak((tmp >> 4) & 0x0F);
  njx.v_ram[7] =  njx.znak(tmp & 0x0F);
}

//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
