/* ---------------------------------------------------- */
/*      заголовочный файл сканера кнопок sksi.h         */
//-------------------------------------------------------
#ifndef _sksi_H        // Блокируем повторное включение этого модуля
#define _sksi_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
// #include <avr/pgmspace.h> // подключить библиотеку работ с таблицами в ПЗУ
#include <avr/interrupt.h> // обслуживание прерываний
#include "nju6432xl.h" // библиотека nju6432xl (включая "стекло на лапках")
//------------------------------------------------------------------------
// указатель на функцию обработки клавиатуры
typedef void(*KeyPtr)();

// обьявление константы номера вывода
// системы контроля питающего напряжения
extern const byte Apwr; // вход АЦП

// обьявление системных силовых выводов аппаратной обвязки,
// общих для всех устройств
extern const byte HLtmr; // сигнального выхода таймера
extern const byte HLbud; // сигнальный вывод комплекта бодунов *!!
extern const byte DTM; // сигнальный вывод звуковой головки

// обьявление констант схемотехнических активных уровней для
// системных силовых выводов аппаратной обвязки
extern const byte HLtmrWrk; // сигнального выхода таймера
extern const byte HLbudWrk; // сигнальный вывод комплекта бодунов *!!

// флаг разрешения генерации звукового сигнала будильника
extern volatile byte EnZud;

// объявление константы активного уровня кнопок
// Al_Sn = 0 для простых механических замыкателей на "корпус"
// Al_Sn = 1 для "активных" (емкостные модули) генерирующих 1
extern const byte Al_Sn;

// объявление входных линий МК в соответствии с номерами кнопок
// (сенсоров), активный уровень на линии сенсора = 0
extern const byte PinToV; // D13 линия кнопки S4(Vkey)
extern const byte PinToM; // D17 линия кнопки S3(Down)
extern const byte PinToP; // D16 линия кнопки S2(Up)
extern const byte PinToR; // D15 линия кнопки S1(Right)
extern const byte PinToL; // D14 линия кнопки S0(Left)

// позиционные номера флагов кнопок в байте ЛВК (SnDat)
#define PozToZ 0 // все кнопки в пассивном состоянии
#define PozToL 0 // номер позиции кнопки S0(Left)
#define PozToR 1 // номер позиции кнопки S1(Right)
#define PozToP 2 // номер позиции кнопки S2(Up)
#define PozToM 3 // номер позиции кнопки S3(Down)
#define PozToV 4 // номер позиции флага кнопки S4(Vkey)

/* masks_sensor
 * для селекторов функций, выполняемых при нажатии
 * кнопы или их комбинации
 * представление через #define для возможности их синтеза
 * из позиционных номеров кноп в байте ЛВК
*/
#define mask0 PozToZ
#define mask1 (1<<PozToL)
#define mask2 (1<<PozToR)
#define mask3 (1<<PozToP)
#define mask4 (1<<PozToM)
#define mask5 (1<<PozToV)
#define mask6 ((1<<PozToL) | (1<<PozToR))
#define mask7 ((1<<PozToP) | (1<<PozToM))
#define mask8 ((1<<PozToL) | (1<<PozToP))
#define mask9 ((1<<PozToR) | (1<<PozToP))
#define mask10 ((1<<PozToL) | (1<<PozToM))
#define mask11 ((1<<PozToR) | (1<<PozToM))

// указатели на функции обработчиков комбинаций
// для модуля селектора задач ввода устройств
// возможные общие для всех устройств проекта
extern volatile KeyPtr KeyPtrZ; // указатель на функцию "все отпущены"
extern volatile KeyPtr KeyPtrL; // указатель на функцию "<<"
extern volatile KeyPtr KeyPtrR; // указатель на функцию ">>"
extern volatile KeyPtr KeyPtrP; // указатель на функцию "+"
extern volatile KeyPtr KeyPtrM; // указатель на функцию "-"
extern volatile KeyPtr KeyPtrRK; // указатель на функцию "RK"
/*             комбинационные нажатия
extern volatile KeyPtr KeyPtr_LR; // указатель на функцию "<<" & ">>"
extern volatile KeyPtr KeyPtr_PM; // указатель на функцию "+" & "-"
extern volatile KeyPtr KeyPtr_LP; // указатель на функцию "<<" & "+"
extern volatile KeyPtr KeyPtr_RP; // указатель на функцию ">>" & "+"
extern volatile KeyPtr KeyPtr_LM; // указатель на функцию "<<" & "-"
extern volatile KeyPtr KeyPtr_RM; // указатель на функцию ">>" & "-"
*/

// указатели на функции возврата в предыдущий модуль устройства
// (стек возврата из субменю) 3 уровня
// "растет вверх"
// extern volatile KeyPtr RetSteckUH; // уровень 4
// extern volatile KeyPtr RetSteckUL; // уровень 3
extern volatile KeyPtr RetSteckU; // уровень 2
extern volatile KeyPtr RetSteckH; // уровень 1
extern volatile KeyPtr RetSteckL; // уровень 0
// указатель на выполняемую при "все отключены"
// функцию возврата на предыдущий уровень
extern volatile KeyPtr RetPtr;

// указатели на функции инициализации
// имеющихся в системе "устройств"
extern volatile KeyPtr dev0_init; // основная панель главных часов
extern volatile KeyPtr dev1_init; // секундомер
extern volatile KeyPtr dev2_init; // таймер обратного отсчета
extern volatile KeyPtr dev3_init; // настройка параметров RTC и будильников
extern volatile KeyPtr dev4_init; // демонстрационка DS18b20
/*
extern volatile KeyPtr dev5_init; //
extern volatile KeyPtr dev6_init; //
extern volatile KeyPtr dev7_init; //
*/

//------------------------------------------------------------------------
// константа интервала опросов клавиатуры (сенсоров) в милисекундах
extern const byte skstm;

// флаг временного запрета обработки сканера клавиатуры
extern volatile byte DisSkan;
// флаг запроса обработчика нажатй комбинации
extern volatile byte QtTm;
// флаг - защелка "однократное действие выполнено"
extern volatile byte WS_Lock;
// транзитный временный буфер обработчика клавиатуры (байт ЛВК)
extern volatile byte SnDat;
// транзитный счетчик таймера "склерозника"
extern volatile unsigned int SnWDT;

// флаг запрета вывода текущего времени главых
// часов на индикацию (ход часов не останавливается)
extern volatile byte DisClcInd;

// константа количества позиций дисплея (8 или 10)
#define LenPozDisp 10
// номер текущей позиции курсора на дисплее
// 0-1-2-3-4-5-6-7-8-9 (или 0-1-2-3-4-5-6-7)
extern volatile byte NumPozKur;
// массив флагов разрешенных позиций курсора дисплея
extern byte EnKurF[];

// универсальный буфер временного хранения ***
extern byte tempo[];

//------------------------------------------------------------------------
// функции сканера клавиатуры

// инициализация состояния выводов МК
extern void skan_init();
// сканер со склерозником
//extern void skans();
// функция продвижки курсора влево
extern void kurL();
// функция продвижки курсора вправо
extern void kurR();
// функция "плюс" счет в позиции от 0 до F
extern void IncPoz();
// функция "минус" счет в позиции от F до 0
extern void DecPoz();
// функция статуса "все отпущены/не активны"
extern void SnZero();
// функция - заглушка (пустышка)
extern void stub();
// функция выключателя breaker
extern void breaker();

// функция загрузки массива байт mas
// длиной в len содержимым перменной dat
extern void LdMas(byte *mas, byte len, byte dat);

// "сердцевинка" инкрементной кнопы
// с модулем счета в качестве параметра
extern void incKey(byte mod);

// "сердцевинка" декрементной кнопы
// с модулем счета в качестве параметра
extern void decKey(byte mod);

// заставка "Егог" для вывода сообщения об ошибке
// общая для всех случаев ошибок
//(вывод данных главных часов на дисплей отключен)
extern void labelEror();

// сообщение о невозможности выполнения "устройства"
// в связи с отсутствием подключения внешнего модуля
extern void discon();

//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
// селектор задач для активных кноп/комбинаций кноп
// текущего устройства
void KeyDevFnSel();
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

/* для удобства поиска и изменения разрешенных кноп/комбинаций кноп
 * в ранее задействованных "устройствах" при добавлении/изменении
 * проекта добавлена функция     ReMapKey()
 * перечень аргументов соответствует указанному выше разделу
 * 
 * "указатели на функции обработчиков комбинаций
 * для модуля селектора задач ввода устройств
 * возможные общие для всех устройств проекта"
 * на текущий момент шаблон
 *     ReMapKey(skZ,skL,skR,skP,skM,skRK);
 */
extern void ReMapKey(KeyPtr,KeyPtr,KeyPtr,KeyPtr,KeyPtr,KeyPtr);

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
