/* ---------------------------------------------------- */
/*        основной файл сканера кнопок sksi.cpp         */
//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "sksi.h" // заголовочный *.h файл текущего проекта

//------------------------------------------------------------------------

// инициализация констант схемотехнических активных уровней для
// системных силовых выводов аппаратной обвязки
// const byte HLtmrWrk = ?; // сигнального выхода таймера
// const byte HLbudWrk = ?; // сигнальный вывод комплекта бодунов *!!

// флаг временного запрета обработки сканера клавиатуры
volatile byte DisSkan =0;
// флаг запроса обработчика нажатй комбинации
volatile byte QtTm =0;
// флаг - защелка "однократное действие выполнено"
volatile byte WS_Lock =0;
// транзитный временный буфер обработчика клавиатуры
volatile byte SnDat =0;
// транзитный счетчик таймера "склерозника"
volatile unsigned int SnWDT =0;

// флаг запрета вывода текущего времени главых
// часов на индикацию (ход часов не останавливается)
volatile byte DisClcInd =0;

// номер текущей позиции курсора на дисплее
// 0-1-2-3-4-5-6-7-8-9
volatile byte NumPozKur =0;
// массив флагов разрешенных позиций курсора дисплея
byte EnKurF[LenPozDisp];

// универсальный буфер временного хранения ***
byte tempo[10];

//***************************************************************************
// статус клавиатуры по "холодному старту"
volatile KeyPtr KeyPtrZ = SnZero; // указатель на функцию "все отпущены"
volatile KeyPtr KeyPtrL = stub; // указатель на функцию "сдвиг курсора влево"
volatile KeyPtr KeyPtrR = stub; // указатель на функцию "сдвиг курсора вправо"
volatile KeyPtr KeyPtrP = stub; // указатель на функцию "+"
volatile KeyPtr KeyPtrM = stub; // указатель на функцию "-"
volatile KeyPtr KeyPtrRK = stub; // указатель на функцию "RK"
/*
volatile KeyPtr KeyPtr_LR = stub; // указатель на функцию "<<" & ">>"
volatile KeyPtr KeyPtr_PM = stub; // указатель на функцию "+" & "-"
volatile KeyPtr KeyPtr_LP = stub; // указатель на функцию "<<" & "+"
volatile KeyPtr KeyPtr_RP = stub; // указатель на функцию ">>" & "+"
volatile KeyPtr KeyPtr_LM = stub; // указатель на функцию "<<" & "-"
volatile KeyPtr KeyPtr_RM = stub; // указатель на функцию ">>" & "-"
**************************************************************************** */

//***************************************************************************
//  Секция описания функций сканера кнопок
//***************************************************************************
// инициалзация выводов МК и генератора сетки опроса сенсоров/кнопок
void skan_init()
{
 digitalWrite(PinToV, HIGH);
 digitalWrite(PinToM, HIGH); digitalWrite(PinToP, HIGH);
 digitalWrite(PinToR, HIGH); digitalWrite(PinToL, HIGH);
 pinMode(PinToV, INPUT_PULLUP);
 pinMode(PinToM, INPUT_PULLUP); pinMode(PinToP, INPUT_PULLUP);
 pinMode(PinToR, INPUT_PULLUP); pinMode(PinToL, INPUT_PULLUP);
 cli(); //noInterrupts();
 OCR0A = 127; TIMSK0 |= (1<<OCIE0A); QtTm = 0; DisSkan = 0;
 sei(); //interrupts();
}

/* генератор сетки опроса сенсоров/кнопок (1mS)
 * и самого опроса ЛВК
 * по выходу при подтвержденной комбинации
 * QtTm=1, SnDat = коду комбинации,
 * SnWDT = время удержания комбинации в mS*skstm (35mS)
 */
ISR(TIMER0_COMPA_vect)
{
 static byte Cnt_A=0; static byte sn_tmp0;
 if (!DisSkan)
  {
   Cnt_A++; SnWDT++;
   if (Cnt_A == skstm)
    {
     Cnt_A=0;
     sn_tmp0 = (digitalRead(PinToL)<<PozToL) | \
     (digitalRead(PinToR)<<PozToR) | \
     (digitalRead(PinToP)<<PozToP) | \
     (digitalRead(PinToM)<<PozToM) | \
     (digitalRead(PinToV)<<PozToV);
     if(!Al_Sn){sn_tmp0 = ~sn_tmp0;} // инверсия при Al_Sn=0
     sn_tmp0 &= B00011111;
     if (SnDat == sn_tmp0){QtTm=1;}
     else {QtTm=0; SnWDT=0; SnDat = sn_tmp0;}
    }
  }
}

// функция продвижки курсора влево
void kurL()
{
  // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   njx.v_ram[NumPozKur]= njx.v_ram[NumPozKur] & (~fnt_coma);
  do{
    if (NumPozKur == 0){NumPozKur = 9;}
    else {NumPozKur--;}
  } while (!EnKurF[NumPozKur]);
  njx.v_ram[NumPozKur]= njx.v_ram[NumPozKur] | fnt_coma;
  }
 else
  {
    // длительное удержание
  }
 njx.WRglass();
}

// функция продвижки курсора вправо
void kurR()
{
  // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] & (~fnt_coma);
  do{
    if (NumPozKur == 9){NumPozKur = 0;}
    else {NumPozKur++;}
  } while (!EnKurF[NumPozKur]);
  njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
  }
 else
  {
    // длительное удержание
  }
 njx.WRglass();
}

// функция "плюс" счет в позиции от 0 до F
void IncPoz()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock){ WS_Lock=1; incKey(15); }
 else
  {
    // длительное удержание
  }
 njx.WRglass();
}

// функция "минус" счет в позиции от F до 0
void DecPoz()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock){ WS_Lock=1; decKey(15); }
 else
  {
    // длительное удержание
  }
 njx.WRglass();
}

// функция статуса "все отпущены/не активны"
// (возможно дополнение "контроля "зажатия"")
void SnZero()
{
 if(WS_Lock)
  {
   // проверка на "залипание"
   // если SnWDT более заданного интервала ожидания
   // то "ошибка клавиатуры"
   WS_Lock =0; RetPtr(); RetPtr = stub;
  }
 SnWDT = 0;
}

// функция - заглушка (пустышка)
void stub() { }

// функция выключателя breaker
void breaker()
{
  // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   // инверсия статуса силовой линии индикатора HLbud
   byte tmp = digitalRead(HLbud);
   tmp = tmp ? 0 : 1;
   digitalWrite(HLbud, tmp);
   // запрет генерации тонального сигнала бодуна А
   EnZud = 0;
  }
}

// функция загрузки массива байт mas
// длиной в len содержимым перменной dat
extern void LdMas(byte *mas, byte len, byte dat)
{
 for (byte cnt=0; cnt<=(len-1); cnt++)
   { mas[cnt] = dat; }
}

// "сердцевинка" инкрементной кнопы
// с модулем счета в качестве параметра
void incKey(byte mod)
{
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] & (~fnt_coma);
 njx.v_ram[NumPozKur] = njx.overZnak(njx.v_ram[NumPozKur]);
 if (njx.v_ram[NumPozKur] == mod){njx.v_ram[NumPozKur] = 0;}
  else {njx.v_ram[NumPozKur]++;}
 njx.v_ram[NumPozKur] = njx.znak(njx.v_ram[NumPozKur]);
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
}

// "сердцевинка" декрементной кнопы
// с модулем счета в качестве параметра
void decKey(byte mod)
{
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] & (~fnt_coma);
 njx.v_ram[NumPozKur] = njx.overZnak(njx.v_ram[NumPozKur]);
 if (njx.v_ram[NumPozKur] == 0){njx.v_ram[NumPozKur] = mod;}
  else {njx.v_ram[NumPozKur]--;}
 njx.v_ram[NumPozKur] = njx.znak(njx.v_ram[NumPozKur]);
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
}

//*********************************************************
// заставка "Егог" для вывода сообщения об ошибке
// общая для всех случаев ошибок
//(вывод данных главных часов на дисплей отключен)
void labelEror()
{
 DisClcInd = 1; // запрет вывода главных часов на индикацию
 njx.BlankVram(fnt_bl); // очистка дисплея
 njx.v_ram[0] = fnt_E; // загрузка общего фрагмента
 njx.v_ram[1] = fnt_r; // "Eror"
 njx.v_ram[2] = fnt_o;
 njx.v_ram[3] = fnt_r;
}

// сообщение о невозможности выполнения "устройства"
// в связи с отсутствием подключения внешнего модуля
// "disconnect"
void discon()
{
 njx.v_ram[0] = fnt_d;
 njx.v_ram[1] = 1<<s_C;
 njx.v_ram[2] = fnt_S;
 njx.v_ram[3] = fnt_C;
 njx.v_ram[4] = fnt_o;
 njx.v_ram[5] = fnt_n;
 njx.v_ram[6] = fnt_n;
 njx.v_ram[7] = fnt_E;
 njx.v_ram[8] = fnt_C;
 njx.v_ram[9] = fnt_I | fnt_minus;
}

//*********************************************************

//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
// селектор задач для активных кноп/комбинаций кноп
// текущего устройства
void KeyDevFnSel()
{
 switch (SnDat) {
  case mask0:
    KeyPtrZ(); // "все отпущены"
   break;
  case mask1:
    KeyPtrL(); // указатель на функцию кнопки "<<"
   break;
  case mask2:
    KeyPtrR(); // указатель на функцию кнопки ">>"
   break;
  case mask3:
    KeyPtrP(); // указатель на функцию кнопки "+"
   break;
  case mask4:
    KeyPtrM(); // указатель на функцию кнопки "-"
   break;
  case mask5:
    KeyPtrRK(); // указатель на функцию кнопки "RK"
   break;
/*
  case mask6:
    KeyPtr_LR(); // указатель на функцию кнопки "<<" & ">>"
   break;
  case mask7:
    KeyPtr_PM(); // указатель на функцию кнопки "+" & "-"
   break;
  case mask8:
    KeyPtr_LP(); // указатель на функцию кнопки "<<" & "+"
   break;
  case mask9:
    KeyPtr_RP(); // указатель на функцию кнопки ">>" & "+"
   break;
  case mask10:
    KeyPtr_LM(); // указатель на функцию кнопки "<<" & "-"
   break;
  case mask11:
    KeyPtr_RM(); // указатель на функцию кнопки ">>" & "-"
   break;
*/
  default: 
   // if nothing else matches, do the default
   // default is optional
   // ? склерозник повреждения ("зажатие") кноп ?
   break;
  }
}
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

/* для удобства поиска и изменения разрешенных кноп/комбинаций кноп
 * в ранее задействованных "устройствах" при добавлении/изменении
 * проекта добавлена функция     ReMapKey()
 * перечень аргументов соответствует указанному выше разделу
 * 
 * "указатели на функции обработчиков комбинаций
 * для модуля селектора задач ввода устройств
 * возможные общие для всех устройств проекта"
 */
void ReMapKey(KeyPtr skZ, KeyPtr skL, KeyPtr skR, \
 KeyPtr skP, KeyPtr skM, KeyPtr skRK)
{
 KeyPtrZ = skZ; // указатель на функцию "все отпущены"
 KeyPtrL = skL; // указатель на функцию "<<"
 KeyPtrR = skR; // указатель на функцию ">>"
 KeyPtrP = skP; // указатель на функцию "+"
 KeyPtrM = skM; // указатель на функцию "-"
 KeyPtrRK = skRK; // указатель на функцию "RK"
 /*             комбинационные нажатия
 KeyPtr_LR = ; // указатель на функцию "<<" & ">>"
 KeyPtr_PM = ; // указатель на функцию "+" & "-"
 KeyPtr_LP = ; // указатель на функцию "<<" & "+"
 KeyPtr_RP = ; // указатель на функцию ">>" & "+"
 KeyPtr_LM = ; // указатель на функцию "<<" & "-"
 KeyPtr_RM = ; // указатель на функцию ">>" & "-"
 */
}

//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
