/* ------------------------------------------------------- */
/*   заголовочный файл устройства "секундомер" secmetr.h   */
/*-------------------------------------------------------- */
#ifndef _secmetr_H        // Блокируем повторное включение этого модуля
#define _secmetr_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
#include "sksi.h" // библиотека sksi
#include "bdbc.h" // табличные кодер/декодеры
              // упакованного двоично-десятичного значения 00-99
              //в код двоичный и обратно
//------------------------------------------------------------------------

// транзитный флаг "секундомер включен"
extern volatile byte SecEN;

//------------------------------------------------------------------------

// инициализация панели устройства "секундомер"
extern void secmetrInit();
// совмещенная кнопка "пуск/стоп"
void SecPS();
// конпка "сброс показаний"
void SecReset();
// кнрпка "возврат к предыдущему устройству"
void SecReturn();
// функция приращения очередной секунды
extern void SecPlus();
// функция печати текущих данных на индикаторе
void SecPrint();

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
