/* ------------------------------------------------------- */
/*   основной файл устройства "секундомер" secmetr.cpp     */
//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "secmetr.h" // заголовочный *.h файл текущего проекта

//------------------------------------------------------------------------
volatile byte SecEN = 0; // транзитный флаг "секундомер включен"
volatile byte SecSec = 0; // счетчик секунд
volatile byte SecMin = 0; // счетчик минут
volatile byte SecHours = 0; // счетчик часов

//------------------------------------------------------------------------

// инициализация панели устройства "секундомер"
extern void secmetrInit()
{
 WS_Lock=1;
 DisClcInd = 1; // запрет индикации текущего времени
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // обнулить счетчики секундомера и флаг разрешения счета
 SecEN = 0; SecSec = 0;  SecMin = 0;  SecHours = 0;
 // преобразовать счетчики в сегменты видеопамяти и вывести на индикацию
 // вместе со значком ход/работа
 njx.v_ram[9] = fnt_o; SecPrint();
 /* записать новые значения в указатели кнопок
  * KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены"
  * KeyPtrL = SecPS; //skL указатель на функцию "<<"
  * KeyPtrR = SecReset; //skR указатель на функцию ">>"
  * KeyPtrP = stub; //skP указатель на функцию "+"
  * KeyPtrM = SecReturn; //skM указатель на функцию "-"
  * KeyPtrRK = breaker; //skRK stub указатель на функцию "RK" 
  */
 ReMapKey(SnZero, SecPS, SecReset, stub, SecReturn, breaker);
 // записать в стек возврата указатель
 // на предшественника (DevClockInit)
 RetSteckU = RetSteckH; RetSteckH = RetSteckL;
 RetSteckL = dev0_init;
}

// совмещенная кнопка "пуск/стоп"
void SecPS()
{ static byte flag = 0;
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!flag)
   {
    flag = 1;
    SecEN = 1; njx.v_ram[9] = fnt_gradus;
    SecPrint();
   }
   else
   {
    flag = 0;
    SecEN = 0; njx.v_ram[9] = fnt_o;
    SecPrint();
   }
  }
}

// конпка "сброс показаний"
// заблокирована при SecEN=1
// проводит сброс показаний в 00-00-00
void SecReset()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!SecEN)
    {
     SecSec = 0; SecMin = 0; SecHours = 0;
     SecPrint();
    }
  }
}

// кнрпка "возврат к предыдущему устройству"
// заблокирована при SecEN=1
// считать указатель из RetSteckL в локальный указатель
// переместить стек вниз и выполнить функцию передачи управления
void SecReturn()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(!SecEN)
    {
     RetPtr = RetSteckL;
     RetSteckL = RetSteckH; RetSteckH = RetSteckU;
    }
  }
}

// функция приращения очередной секунды
// счетчиков секундомера с выводом на индикацию
extern void SecPlus()
{
 SecSec++;
 if(SecSec == 60)
  {
   SecSec = 0; SecMin++;
   if(SecMin == 60)
    {
     SecMin = 0; SecHours++;
     if(SecHours == 99){SecHours = 0;}
    }
  }
 SecPrint();
}

// функция печати текущих данных на индикаторе
void SecPrint()
{
 byte tmp;
 tmp = pgm_read_byte_near( BinDec + SecSec );
 njx.v_ram[7] = njx.znak((tmp & B00001111));
 njx.v_ram[6] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[5] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + SecMin );
 njx.v_ram[4] = njx.znak((tmp & B00001111));
 njx.v_ram[3] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[2] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + SecHours );
 njx.v_ram[1] = njx.znak((tmp & B00001111));
 njx.v_ram[0] = njx.znak(((tmp>>4) & B00001111));
 njx.WRglass();
}

//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
