/* --------------------------------------------------------- */
/* заголовочный файл устройства главные часы (RTC) mainrtc.h */
/*---------------------------------------------------------- */
#ifndef _mainrtc_H   // Блокируем повторное включение этого модуля
#define _mainrtc_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
// #include <avr/interrupt.h> // обслуживание прерываний
// #include <avr/pgmspace.h> // подключить библиотеку работ с таблицами в ПЗУ
#include "sksi.h" // библиотека sksi
#include "bdbc.h" // табличные кодер/декодеры
              // упакованного двоично-десятичного значения 00-99
              //в код двоичный и обратно
#include "mxiicr.h" // заголовочный *.h файл комплекта библиотеки mxiicm
                   // (только физический протокол пересылки байта)
#include "ds3231_map.h" // файл карты ресурсов RTC DS3231

//------------------------------------------------------------------------
// обьявление управляющих выводов RTC
extern const byte L_QS; // вывод строба/прерываний RTC
extern const byte L_SDA; // вывод данных I2C
extern const byte L_SCL; // вывод строба I2C

// транзитный счетчик контроля отказа линии внешнего
// секунд-генератора
extern volatile byte ErIrqRTC;
// передаточный флаг запроса обработчика очередной секунды
extern volatile byte SecF;
// флаг запрета перезагрузки данных из RTC
extern volatile byte PGset;
// флаг РВХ для функций возврата из настроек RTC
extern volatile byte TmpNumPozKur;

// флаг переключения тона для генерации сигнала бодуна А
extern volatile byte ZudMode;

// байт секунд внутреннего счета
extern volatile byte Clc_cntS;
// байт минут внутреннего счета
extern volatile byte Clc_cntM;
// байт часов внутреннего счета
extern volatile byte Clc_cntH;

//------------------------------------------------------------------------
// свойства бодунов

// сигнальный вывод комплекта бодунов
extern const byte HLbud;
// активный уровень сигнального вывода
// комплекта бодунов
extern const byte HLbudWrk;

/*
*     "будильник А" (будильник bodS)
* бодун, устанавливаюзий при совпадении данных
* и текущего значения главых часов HLbud = Lw_bodA
*/
// флаг разрешения работы
extern volatile byte EN_bodA;
// флаг активного уровня для выходной линии
// при совпадении уставки
extern volatile byte Lw_bodA;
// регистр часов
extern volatile byte TH_bodA;
// регистр минут
extern volatile byte TM_bodA;

/*
*    "будильник B" (будильник bodR)
* бодун, устанавливаюзий при совпадении данных
* и текущего значения главых часов HLbud = Lw_bodB
*/
// флаг разрешения работы
extern volatile byte EN_bodB;
// флаг активного уровня для выходной линии
// при совпадении уставки
extern volatile byte Lw_bodB;
// регистр часов
extern volatile byte TH_bodB;
// регистр минут
extern volatile byte TM_bodB;

//------------------------------------------------------------------------

// запуск секунд-генератора от RTC
extern void genSecInit();

// ежескундное прерывание от RTC
extern void RtcSec();

// функция счета времени
extern void clock();

// функция преобразования и вывода на индикатор
// данных главных часов
extern void vrClcDisp();

//*********************************************************
// запись одиночного байта в RTC по заданному адресу
// в аргументах идет адрес согласно карты RTC и байт данных
extern void Wrtc(byte, byte);

// запись пары байт в RTC по заданному адресу
// в аргументах идет адрес согласно карты RTC и байт данных
extern void Wrtc2(byte adr, byte dat, byte dat1);

// чтение одиночного байта из RTC по заданному адресу
// возвращает принятый байт, аргументом идет адрес
// согласно карты RTC
extern byte Rrtc(byte);

// функция ошибки обмена по I2C
extern void erlinIIC();
//*********************************************************

// функция блокировки по отсутствию тактовых
// секунд-импульсов от RTC
extern void ERROR_RTC();

// первичная инициализация RTC DS3231 при
// первичной подаче питания и зажатой
// при включении питания(после аппаратного reset)
// кнопке RK
extern void HardRTC_init();

// инициализация устройства "главные часы"
extern void DevClockInit();

// функция "чтение часов и календаря"
// из RTC в регистры хранения и модификации
// адуринки
void ReadClokBooc();

//------------------------------------------------------------------------
// методы бодунов

// функция инициализации вывода L_bodOut
// как выход в состоянии 0
void i_bodOut();

// исполнительная функция 
// принимает счетчик часов, счетчик минут
// и статус активного лог.уровня 
// "будильника А"(N=1) или "будильника B"(N=2) соответственно
void bod_Wrk(byte, byte, byte, byte);

// защита от совмещения уставок бодунов
void protectBodAB();


//------------------------------------------------------------------------

// просмотр/ввод параметров RTC и бодунов
// (методы редактирования параметров RTC и бодунов)

// инициализация окна выбора параметров
extern void AdjRtcInit();


// инициализация окна редактирования секунд RTC
// (пуск по сигналу точного времени 00 секунд)
// "C0"
void STTim();

// инициализация окна редактирования значений
// часов и минут RTC
// "C1"
void EditHM();

// инициализация окна редактирования значений
// дня недели и числа RTC
// "C2"
void EditDD();

// инициализация окна редактирования значений
// месяца и года RTC
// "C3"
void EditME();

// инициализация окна редактирования значений
// корректора точности хода RTC
// "C4"
void EditTune();

// инициализация окна редактирования значений
// параметров будильника 1
// "B1"
void EditB1();

// инициализация окна редактирования значений
// параметров будильника 2
// "B2"
void EditB2();

// кнопка "+" в режиме окна
// выбора параметров
void choiceP();

// кнопка "+" в режиме окна
// редактирования параметров
void EditP();

// кнопка "-" в режиме окна
// выбора параметров
void choiceM();

// кнопка "-" в режиме окна
// редактирования параметров
void EditM();

// чтение байта data_Tune с
// нормированием для индикации
void RDiTune();

// фрагмент нормирования для проверки и ввода
// кнопа EditP для RTC часов/календаря
void EditP_normC();

// фрагмент нормирования для проверки и ввода
// кнопа EditP для будильников
void EditP_normB();

// сигнал при ошибке диапазона ввода
void ErInp();

// общий заголовок окна редактирования бодунов
void BlockBodus();

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
