/* ------------------------------------------------------- */
/* основной файл устройства главные часы (RTC) mainrtc.cpp */
//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "mainrtc.h" // заголовочный *.h файл текущего проекта

//------------------------------------------------------------------------

// транзитный счетчик контроля отказа линии внешнего
// секунд-генератора
volatile byte ErIrqRTC =0;
// передаточный флаг запроса обработчика очередной секунды
volatile byte SecF = 0;
// флаг запрета перезагрузки данных из RTC
volatile byte PGset = 0;
// флаг РВХ для функций возврата из настроек RTC
volatile byte TmpNumPozKur = 0;
// инициализация флага разрешения генерации звукового сигнала бодуна А
volatile byte EnZud = 0;
// флаг переключения тона для генерации сигнала бодуна А
volatile byte ZudMode = 0;

// байт секунд внутреннего счета
volatile byte Clc_cntS = 0;
// байт минут внутреннего счета
volatile byte Clc_cntM = 0;
// байт часов внутреннего счета
volatile byte Clc_cntH = 0;

// временные байты обработки RTC
volatile byte tmp_rtc_sec = 0; // данные из регистра секунд RTC
volatile byte tmp_rtc_min = 0; // данные из регистра минут RTC
volatile byte tmp_rtc_hours = 0; // данные из регистра часов RTC
volatile byte tmp_rtc_day = 0; // данные из регистра дня недели RTC
volatile byte tmp_rtc_date = 0; // данные из регистра даты (число) RTC
volatile byte tmp_rtc_mons = 0; // данные из регистра месяца RTC
volatile byte tmp_rtc_year = 0; // данные из регистра года RTC
volatile byte tmp_rtc_Tune = 0; // данные регистра коррекции RTC
volatile byte data_Tune = 0; // данные регистра предобработки

//------------------------------------------------------------------------
// свойства бодунов

/*
*     "будильник А" (будильник bodS)
* бодун, устанавливаюзий при совпадении данных
* и текущего значения главых часов HLbud = Lw_bodA
*/
// флаг разрешения работы
volatile byte EN_bodA=0;
// флаг активного уровня для выходной линии
// при совпадении уставки
volatile byte Lw_bodA = (!HLbudWrk);
// регистр часов
volatile byte TH_bodA=0;
// регистр минут
volatile byte TM_bodA=0;

/*
*    "будильник B" (будильник bodR)
* бодун, устанавливаюзий при совпадении данных
* и текущего значения главых часов HLbud = Lw_bodB
*/
// флаг разрешения работы
volatile byte EN_bodB=0;
// флаг активного уровня для выходной линии
// при совпадении уставки
volatile byte Lw_bodB = (!HLbudWrk);
// регистр часов
volatile byte TH_bodB=0;
// регистр минут
volatile byte TM_bodB=1;

//------------------------------------------------------------------------

// запуск секунд-генератора от RTC
void genSecInit()
{
 cli();
 attachInterrupt(digitalPinToInterrupt(L_QS), RtcSec, FALLING);
 sei();
}

// ежескундное прерывание от RTC
void RtcSec(){ ErIrqRTC = 0; SecF = 1; }

// функция счета времени
void clock()
{
 Clc_cntS++;
 if(Clc_cntS == 60)
  {
   Clc_cntS = 0; Clc_cntM++;
   if(Clc_cntM == 60)
    {
     Clc_cntM = 0; Clc_cntH++;
     if(Clc_cntH == 24){Clc_cntH = 0;}
    }
  }
}

// функция преобразования и вывода на индикатор
// данных главных часов
void vrClcDisp()
{ byte tmp;
 njx.v_ram[9] = fnt_bl;
 tmp = pgm_read_byte_near( BinDec + Clc_cntS );
 njx.v_ram[8] = njx.znak((tmp & B00001111));
 njx.v_ram[7] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[6] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + Clc_cntM );
 njx.v_ram[5] = njx.znak((tmp & B00001111));
 njx.v_ram[4] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[3] = fnt_minus;
 tmp = pgm_read_byte_near( BinDec + Clc_cntH );
 njx.v_ram[2] = njx.znak((tmp & B00001111));
 njx.v_ram[1] = njx.znak(((tmp>>4) & B00001111));
 njx.v_ram[0] = fnt_bl;
 njx.WRglass();
}

//*********************************************************
// запись одиночного байта в RTC по заданному адресу
// в аргументах идет адрес согласно карты RTC и байт данных
void Wrtc(byte adr, byte dat)
{byte erf=0;
 my_iic.mx_Start();
 erf=my_iic.mx_Txd(ds3231_W); // команда начать запись
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(adr); // адрес данных
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(dat); // данные
 if(erf){erlinIIC();}
 my_iic.mx_Stop();
}

// запись пары байт в RTC по заданному адресу
// в аргументах идет адрес согласно карты RTC и байт данных
void Wrtc2(byte adr, byte dat, byte dat1)
{byte erf=0;
 my_iic.mx_Start();
 erf=my_iic.mx_Txd(ds3231_W); // команда начать запись
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(adr); // адрес данных
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(dat); // данные
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(dat1); // данные
 if(erf){erlinIIC();}
 my_iic.mx_Stop();
}

// чтение одиночного байта из RTC по заданному адресу
// возвращает принятый байт, аргументом идет адрес
// согласно карты RTC
byte Rrtc(byte adr)
{byte erf=0;
 my_iic.mx_Start();
 erf=my_iic.mx_Txd(ds3231_W); // команда начать запись
 if(erf){erlinIIC();}
 erf=my_iic.mx_Txd(adr); // адрес данных
 if(erf){erlinIIC();}
 my_iic.mx_reStart();
 erf=my_iic.mx_Txda(ds3231_R); // команда начать чтение
 if(erf){erlinIIC();}
 erf=my_iic.mx_Rxd(mx_noAck);
 my_iic.mx_Stop();
 return erf;
}

// функция ошибки обмена по I2C
void erlinIIC()
{
 labelEror();
 // блокировка используемой силовой периферии
 // и источников команд(данных) ее управления

 njx.v_ram[5] = fnt_r; // загрузка прикладного фрагмента
 njx.v_ram[6] = fnt_I; // "rI2C"
 njx.v_ram[7] = fnt_2;
 njx.v_ram[8] = fnt_C;
 njx.WRglass();
 while (1)
 {
  // звуковой сигнал по желанию
 }
}
//*********************************************************

// функция блокировки по отсутствию тактовых
// секунд-импульсов от RTC
void ERROR_RTC()
{
 labelEror();
 // блокировка используемой силовой периферии
 // и источников команд(данных) ее управления

 njx.v_ram[5] = fnt_r; // загрузка прикладного фрагмента
 njx.v_ram[6] = fnt_c; // "rcLc"
 njx.v_ram[7] = fnt_L;
 njx.v_ram[8] = fnt_c;
 njx.WRglass();
 while (1)
 {
  // звуковой сигнал по желанию
 }
}


/* первичная инициализация RTC DS3231 при
 первичной подаче питания и зажатой
 при включении питания(после аппаратного reset)
 кнопке RK */
extern void HardRTC_init()
{byte erf=0;
 my_iic.mx_Start();
 erf=my_iic.mx_Txd(ds3231_W); // команда начать запись
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // начальный адрес 0
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 0 секунды главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 1 минуты главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 2 часы главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x06); // 3 день недели ( 6=суббота) главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x26); // 4 число месяца (26) главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x09); // 5 месяц (9-сентябрь) главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x23); // 6 год (23) главных часов
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 7 секунды alarm1
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 8 минуты alarm1
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // 9 часы alarm1
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x01); // A число месяца alarm1
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // B минуты alarm2
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // C часы alarm2
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0x01); // D число месяца alarm2
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(B01011000); // E выдача 1-секундного меандра
 if(erf){ erlinIIC(); }
 erf=my_iic.mx_Txd(0); // F
 if(erf){ erlinIIC(); }
 my_iic.mx_Stop();
 njx.BlankVram(fnt_bl);
 njx.v_ram[1]=fnt_r;
 njx.v_ram[2]=(1<<s_E)|(1<<s_F)|(1<<s_G);
 njx.v_ram[3]=fnt_C;
 njx.v_ram[5]=fnt_I;
 njx.v_ram[6]=fnt_n;
 njx.v_ram[7]=fnt_I;
 njx.v_ram[8]=(1<<s_E)|(1<<s_F)|(1<<s_G);
 njx.WRglass(); // вывод v_ram в индикатор
 tone(DTM, 1200); delay(500);
 while(digitalRead(PinToV)){delay(100);}
 noTone(DTM);
}

// инициализация устройства "главные часы"
extern void DevClockInit()
{
 // очистка дисплея
 njx.BlankVram(fnt_bl);
 // разрешить вывод на индикацию главных часов
 DisClcInd = 0;
 // считать часы и календарь из RTC в блок копии хранения
 // только при первичной подаче питания
 // при переключении меджу "устройствами" не требуется
 if(!PGset)
 { 
  ReadClokBooc(); PGset = 1;
  // преобразовать секунды, минуты и часы в двоичный формат
  // и записать результат в соответствующие регистры главных часов
  Clc_cntS = pgm_read_byte_near( DecBin + tmp_rtc_sec );
  Clc_cntM = pgm_read_byte_near( DecBin + tmp_rtc_min );
  Clc_cntH = pgm_read_byte_near( DecBin + tmp_rtc_hours );
 }
 WS_Lock = 1;
 // провести вывод данных на индикацию
 vrClcDisp();
 /* выполнить переприсвоение указателей комбинаций
 * к требуемому для основного статуса "устройства"
 * (индикация часов в ожидании команд клавиатуры)
 * KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены"
 * KeyPtrL = dev1_init; //skL СЕКУНДОМЕР (указатель на функцию "<<")
 * KeyPtrR = dev2_init; //skR ТАЙМЕР (указатель на функцию ">>")
 * KeyPtrP = dev4_init; //skP демотермометр(указатель на функцию "+")
 * KeyPtrM = dev3_init; //skM НАСТРОЙКИ RTC и БУДИЛЬНИКОВ
 *                     // указатель на функцию "-"
 * KeyPtrRK = breaker; //skRK stub указатель на функцию "RK" 
 */
 ReMapKey(SnZero, dev1_init, dev2_init, dev4_init, dev3_init, breaker);
 
 // загрузить указатель стека возврата
 RetSteckU = RetSteckH;
 RetSteckH = RetSteckL;
 RetSteckL = dev0_init; // он же DevClockInit
}

// функция "чтение часов и календаря"
void ReadClokBooc()
{
 byte error = 0;
 my_iic.mx_Start(); error = my_iic.mx_Txd(ds3231_W);
 if (error){ erlinIIC(); }
 error = my_iic.mx_Txd(adr_rtc_sec);
 if (error){ erlinIIC(); }
 my_iic.mx_reStart();
 error = my_iic.mx_Txda(ds3231_R);
 if (error){ erlinIIC(); }
 tmp_rtc_sec = my_iic.mx_Rxd(mx_Ack); // данные из адрес регистра секунд
 tmp_rtc_min = my_iic.mx_Rxd(mx_Ack); // данные из адрес регистра минут
 tmp_rtc_hours = my_iic.mx_Rxd(mx_Ack); // данные из адрес регистра часов
 tmp_rtc_day = my_iic.mx_Rxd(mx_Ack); // данные из регистра дня недели
 tmp_rtc_date = my_iic.mx_Rxd(mx_Ack); // данные из регистра даты (число)
 tmp_rtc_mons = my_iic.mx_Rxd(mx_Ack); // данные из регистра месяца
 tmp_rtc_year = my_iic.mx_Rxd(mx_noAck); // данные из регистра года
 my_iic.mx_Stop();
 tmp_rtc_Tune = Rrtc(adr_rtc_offset);
}

//------------------------------------------------------------------------
// методы бодунов

// функция инициализации вывода L_bodOut
// как выход в состоянии !HLbudWrk
void i_bodOut()
{ digitalWrite(HLbud, (!HLbudWrk)); pinMode(HLbud, OUTPUT); }

// исполнительная функция 
// принимает счетчик часов, счетчик минут
// и статус активного лог.уровня 
// "будильника А" или "будильника B" соответственно
// параметры TH_bodN, TM_bodN, Lw_bodN, N
void bod_Wrk(byte bcnth, byte bcntl, byte lwb, byte N)
{
 if((Clc_cntH == bcnth)&&(Clc_cntM == bcntl))
  {
   if((N == 1)&&(lwb == HLbudWrk)){EnZud = 1;}
   else if((N == 2)&&(lwb != HLbudWrk)){EnZud = 0;}
   digitalWrite(HLbud, lwb);
  }
}

// защита от совмещения уставок бодунов
void protectBodAB()
{
 if (TH_bodA == TH_bodB)
  {
   if (TM_bodA == TM_bodB)
    {
     if(TM_bodB == 59)
      {
       TM_bodB = 0;
       if (TH_bodB == 23){ TH_bodB = 0; }
       else { TH_bodB++; }
      }
     else { TM_bodB++; }
    }
  }
}

//------------------------------------------------------------------------

// просмотр/ввод параметров RTC и бодунов
// (методы редактирования параметров RTC и бодунов)

// инициализация окна выбора параметров
void AdjRtcInit()
{
 // первичное исполнение (одиночное)
 WS_Lock=1;
 DisClcInd = 1; // запрет индикации текущего времени
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_0;
 njx.v_ram[2] = fnt_1;
 njx.v_ram[3] = fnt_2;
 njx.v_ram[4] = fnt_3;
 njx.v_ram[5] = fnt_4;
 njx.v_ram[6] = fnt_bl;
 njx.v_ram[7] = fnt_b;
 njx.v_ram[8] = fnt_1;
 njx.v_ram[9] = fnt_2;
 LdMas(EnKurF, LenPozDisp, 1);
 EnKurF[0] = 0; EnKurF[6] = 0; EnKurF[7] = 0;
 if(PGset){NumPozKur = 1;}
 else{NumPozKur = TmpNumPozKur;}
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
 /* записать новые значения в указатели кнопок
 *  KeyPtrZ = SnZero; //skZ указатель на функцию "все отпущены"
 *  KeyPtrL = kurL; //skL указатель на функцию "<<"
 *  KeyPtrR = kurR; //skR указатель на функцию ">>"
 *  KeyPtrP = choiceP; //skP указатель на функцию "+"
 *  KeyPtrM = choiceM; //skM указатель на функцию "-"
 *  KeyPtrRK = breaker; //skRK указатель на функцию "RK" 
 */
 ReMapKey(SnZero,kurL,kurR,choiceP,choiceM,breaker);

  // записать в стек возврата указатель
 // на предшественника (DevClockInit)
 RetSteckU = RetSteckH; RetSteckH = RetSteckL;
 RetSteckL = dev0_init;
 if (PGset)
  {
  // считать данные из RTC только при PGset = 1
  ReadClokBooc(); PGset = 0;
  }
}

// инициализация окна редактирования секунд RTC
// (пуск по сигналу точного времени 00 секунд)
// "C0"
void STTim()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_0;
 njx.v_ram[3] = fnt_dnlin;
 njx.v_ram[4] = fnt_dnlin;
 njx.v_ram[5] = fnt_minus;
 njx.v_ram[6] = fnt_0;
 njx.v_ram[7] = fnt_0;
 njx.v_ram[9] = fnt_qest;
 LdMas(EnKurF, LenPozDisp, 0);
 EnKurF[9] = 1; NumPozKur = 9;
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
}

// инициализация окна редактирования значений
// часов и минут RTC
// "C1"
void EditHM()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_1;
 njx.v_ram[5] = fnt_minus;
 njx.v_ram[9] = fnt_qest;
 njx.v_ram[7] = njx.znak((tmp_rtc_min & B00001111));
 njx.v_ram[6] = njx.znak(((tmp_rtc_min>>4) & B00001111));
 njx.v_ram[4] = njx.znak((tmp_rtc_hours & B00001111));
 njx.v_ram[3] = njx.znak(((tmp_rtc_hours>>4) & B00001111));
 LdMas(EnKurF, LenPozDisp, 0);
 EnKurF[9] = 1; EnKurF[7] = 1; EnKurF[6] = 1;
 EnKurF[4] = 1; EnKurF[3] = 1; NumPozKur = 9;
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
}

// инициализация окна редактирования значений
// дня недели и числа RTC
// "C2"
void EditDD()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_2;
 njx.v_ram[5] = fnt_minus;
 njx.v_ram[9] = fnt_qest;
 njx.v_ram[7] = njx.znak((tmp_rtc_date & B00001111));
 njx.v_ram[6] = njx.znak(((tmp_rtc_date>>4) & B00001111));
 njx.v_ram[4] = njx.znak((tmp_rtc_day & B00001111));
 njx.v_ram[3] = njx.znak(((tmp_rtc_day>>4) & B00001111));
 LdMas(EnKurF, LenPozDisp, 0);
 EnKurF[9] = 1; EnKurF[7] = 1; EnKurF[6] = 1;
 EnKurF[4] = 1; EnKurF[3] = 1; NumPozKur = 9;
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
}

// инициализация окна редактирования значений
// месяца и года RTC
// "C3"
void EditME()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_3;
 njx.v_ram[5] = fnt_minus;
 njx.v_ram[9] = fnt_qest;
 njx.v_ram[7] = njx.znak((tmp_rtc_year & B00001111));
 njx.v_ram[6] = njx.znak(((tmp_rtc_year>>4) & B00001111));
 njx.v_ram[4] = njx.znak((tmp_rtc_mons & B00001111));
 njx.v_ram[3] = njx.znak(((tmp_rtc_mons>>4) & B00001111));
 LdMas(EnKurF, LenPozDisp, 0);
 EnKurF[9] = 1; EnKurF[7] = 1; EnKurF[6] = 1;
 EnKurF[4] = 1; EnKurF[3] = 1; NumPozKur = 9;
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
}

// инициализация окна редактирования значений
// корректора точности хода RTC
// "C4"
void EditTune()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_C;
 njx.v_ram[1] = fnt_4;
 njx.v_ram[9] = fnt_qest;
 if(bitRead(tmp_rtc_Tune, 7))
  {
   njx.v_ram[3] = fnt_minus;
   data_Tune = (~tmp_rtc_Tune) + 1;
  }
 else {data_Tune = tmp_rtc_Tune; }
 RDiTune();
 LdMas(EnKurF, LenPozDisp, 0);
 EnKurF[9] = 1; EnKurF[6] = 1; NumPozKur = 9;
 njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
 njx.WRglass();
}

// инициализация окна редактирования значений
// параметров будильника 1
// "B1"
void EditB1()
{
 BlockBodus(); njx.v_ram[1] = fnt_1;
 njx.v_ram[2] = EN_bodA ? fnt_E : fnt_d;
 njx.v_ram[3] = Lw_bodA ? fnt_H : fnt_L;
 njx.v_ram[5] = pgm_read_byte_near( BinDec + TH_bodA );
 njx.v_ram[4] = njx.znak(((njx.v_ram[5] >> 4) & B00001111));
 njx.v_ram[5] = njx.znak((njx.v_ram[5] & B00001111));
 njx.v_ram[7] = pgm_read_byte_near( BinDec + TM_bodA );
 njx.v_ram[6] = njx.znak(((njx.v_ram[7] >> 4) & B00001111));
 njx.v_ram[7] = njx.znak((njx.v_ram[7] & B00001111));
 njx.WRglass();
}

// инициализация окна редактирования значений
// параметров будильника 2
// "B2"
void EditB2()
{
 BlockBodus(); njx.v_ram[1] = fnt_2;
 njx.v_ram[2] = EN_bodB ? fnt_E : fnt_d;
 njx.v_ram[3] = Lw_bodB ? fnt_H : fnt_L;
 njx.v_ram[5] = pgm_read_byte_near( BinDec + TH_bodB );
 njx.v_ram[4] = njx.znak(((njx.v_ram[5] >> 4) & B00001111));
 njx.v_ram[5] = njx.znak((njx.v_ram[5] & B00001111));
 njx.v_ram[7] = pgm_read_byte_near( BinDec + TM_bodB );
 njx.v_ram[6] = njx.znak(((njx.v_ram[7] >> 4) & B00001111));
 njx.v_ram[7] = njx.znak((njx.v_ram[7] & B00001111));
 njx.WRglass();
}

// кнопка "+" в режиме окна
// выбора параметров
void choiceP()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   // записать в стек возврата указатель
   // на предшественника (DevClockInit)
   RetSteckU = RetSteckH; RetSteckH = RetSteckL;
   RetSteckL = AdjRtcInit;
   KeyPtrP = EditP; // указатель на функцию "+" ***
   KeyPtrM = EditM; // указатель на функцию "-" ***
   // копируем позиционный номер параметра в РВХ
   TmpNumPozKur = NumPozKur;
   switch (NumPozKur) 
    {
    case 1:
      STTim();
      break;
    case 2:
      EditHM();
      break;
    case 3:
      EditDD();
      break;
    case 4:
      EditME();
      break;
    case 5:
      EditTune();
      break;
    case 8:
      EditB1();
      break;
    case 9:
      EditB2();
      break;
    default: 
      stub();
    break;
    }
  }
}

// кнопка "+" в режиме окна
// редактирования параметров
void EditP()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
  if(NumPozKur == 9)
   { byte erinp = 0;
   // закрытие окна с записью новых параметров
   switch (TmpNumPozKur) 
    {
     case 1:
     // окна редактирования секунд RTC
     // (пуск по сигналу точного времени 00 секунд)
     // "C0"
        Wrtc(adr_rtc_sec, 0);
       break;
     case 2:
     // окна редактирования значений
     // часов и минут RTC
     // "C1"
       EditP_normC();
       if(njx.v_ram[6] >= 60){ erinp = 1; }
       if(njx.v_ram[3] >= 24){ erinp = 1; }
       if(!erinp)
        {
         tmp_rtc_min = njx.v_ram[7];
         tmp_rtc_hours = njx.v_ram[4];
         Wrtc2(adr_rtc_min, njx.v_ram[7], njx.v_ram[4]);
        }
        else if(erinp){ErInp();}
       break;
     case 3:
      // окна редактирования значений
      // дня недели и числа RTC
      // "C2"
       EditP_normC();
       if(njx.v_ram[6] >= 32){ erinp = 1; }
       if(njx.v_ram[3] >= 8){ erinp = 1; }
       if(njx.v_ram[3] == 0){ erinp = 1; }
       if(!erinp)
        {
         tmp_rtc_date = njx.v_ram[7];
         tmp_rtc_day = njx.v_ram[4];
         Wrtc2(adr_rtc_day, njx.v_ram[4], njx.v_ram[7]);
        }
        else if(erinp){ErInp();}
       break;
     case 4:
      // окна редактирования значений
      // месяца и года RTC
      // "C3"
       EditP_normC();
       if(njx.v_ram[3] >= 13){ erinp = 1; }
       if(!erinp)
        {
         tmp_rtc_year = njx.v_ram[7];
         tmp_rtc_mons = njx.v_ram[4];
         Wrtc2(adr_rtc_mons, njx.v_ram[4], njx.v_ram[7]);
        }
        else if(erinp){ErInp();}
       break;
     case 5:
      // окна редактирования значений
      // корректора точности хода RTC
      // "C4"
        if(njx.v_ram[3] == fnt_minus)
        { data_Tune = (~data_Tune) + 1; }
        tmp_rtc_Tune = data_Tune;
        Wrtc(adr_rtc_offset, data_Tune);
       break;
     case 8:
      /* окна редактирования значений
      * параметров будильника 1
      * "B1"
      * упакованный двоично-десятичный в 7 и 5
      * двоичный эквивалент в 6 и 4
      */
        EditP_normB();
        if(njx.v_ram[4] >= 24){ erinp = 1; }
        if(!erinp)
        {
         if(njx.v_ram[2] == fnt_E){ EN_bodA = 1; }
         else{ EN_bodA = 0; }
         if(njx.v_ram[3] == fnt_H){ Lw_bodA = 1; }
         else{ Lw_bodA = 0; }
         TM_bodA = njx.v_ram[6]; TH_bodA = njx.v_ram[4];
         protectBodAB();
        }
        else if(erinp){ErInp();}
       break;
     case 9:
      /* окна редактирования значений
      * параметров будильника 2
      * "B2"
      * упакованный двоично-десятичный в 7 и 5
      * двоичный эквивалент в 6 и 4
      * контроль на совпадение b1  и b2
      * в случае совпадения установить
      * b2 +1 минуту
      */
        EditP_normB();
        if(njx.v_ram[4] >= 24){ erinp = 1; }
        if(!erinp)
        {
         if(njx.v_ram[2] == fnt_E){ EN_bodB = 1; }
         else{ EN_bodB = 0; }
         if(njx.v_ram[3] == fnt_H){ Lw_bodB = 1; }
         else{ Lw_bodB = 0; }
         TM_bodB = njx.v_ram[6]; TH_bodB = njx.v_ram[4];
         protectBodAB();
        }
        else if(erinp){ ErInp(); }
      break;
     default: 
       stub();
      break;
    }
    RetPtr = RetSteckL;
    RetSteckL = RetSteckH; RetSteckH = RetSteckU;
   }
  else
   {
    /* при входе
     * NumPozKur = позиции курсора под знакоместом
     * текущего отображения на дисплеев
     * TmpNumPozKur = номеру позиции курсора в вышестоящем
     * меню (индекс-номеру субустройства, тип которого
     * указан в позиции njx.v_ram[0] текущего отображения 
     * на дисплеев виде символа или цифры)
    */
    // обычный + с модулем 9 для RTC
    if(njx.v_ram[0] == fnt_C)
    {
      // для поправки корекции
     if(njx.v_ram[1] == fnt_4)
      {
       if(data_Tune != 127)
        { data_Tune++; }
       RDiTune();
       njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
      }
     else { incKey(9); } // для остальных позиций
    }
    // и селектор для бодунов
    if(njx.v_ram[0] == fnt_b)
    {
     switch (NumPozKur) {
      case 2:
      // флаг разрешения/запрета работы
      // "E" = 1, "d" = 0
        njx.v_ram[2] = njx.v_ram[2] & (~fnt_coma);
        if(njx.v_ram[2] == fnt_E)
        { njx.v_ram[2] = fnt_d | fnt_coma; }
        else { njx.v_ram[2] = fnt_E | fnt_coma; }
        break;
      case 3:
      // флаг активного уровня на выводе HLbud
      // "H" = 1, "L" = 0
        njx.v_ram[3] = njx.v_ram[3] & (~fnt_coma);
        if(njx.v_ram[3] == fnt_H)
        { njx.v_ram[3] = fnt_L | fnt_coma; }
        else { njx.v_ram[3] = fnt_H | fnt_coma; }
        break;
      case 4:
      // десятки часов инкремент по модулю 2
        incKey(2);
        break;
      case 5:
      // единицы часов инкремент по модулю 9
      // с проверкой корректности по завершению ввода
        incKey(9);
        break;
      case 6:
      // десятки минут инкремент по модулю 5
        incKey(5);
        break;
      case 7:
      // единицы минут инкремент по модулю 9
        incKey(9);
        break;
      default: 
        stub();
        break;
     }
    }
    njx.WRglass();
   }
  }
}

// кнопка "-" в режиме окна
// выбора параметров
void choiceM()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   // возврат в предыдущую панель
   RetPtr = RetSteckL;
   RetSteckL = RetSteckH; RetSteckH = RetSteckU;
  }
}

// кнопка "-" в режиме окна
// редактирования параметров
void EditM()
{
 // первичное исполнение (одиночное)
 if (!WS_Lock)
  {
   WS_Lock=1;
   if(NumPozKur == 9)
    {
     // закрытие окна без записи новых параметров
     RetPtr = RetSteckL;
     RetSteckL = RetSteckH; RetSteckH = RetSteckU;
    }
   else
   {
    /* при входе
     * NumPozKur = позиции курсора под знакоместом
     * текущего отображения на дисплеев
     * TmpNumPozKur = номеру позиции курсора в вышестоящем
     * меню (индекс-номеру субустройства, тип которого
     * указан в позиции njx.v_ram[0] текущего отображения 
     * на дисплеев виде символа или цифры)
    */
    // обычный - с модулем 9 для RTC
    if(njx.v_ram[0] == fnt_C)
    {
     // для позиции поправки корекции
      if(njx.v_ram[1] == fnt_4)
      {
       if(data_Tune == 0)
        {
         njx.v_ram[3] = fnt_minus;
         data_Tune++;
        }
       else if((data_Tune == 1) && (njx.v_ram[3] == fnt_minus))
        { data_Tune--; njx.v_ram[3] = fnt_bl; }
       else { data_Tune--; }
       RDiTune();
       njx.v_ram[NumPozKur] = njx.v_ram[NumPozKur] | fnt_coma;
      }
     else { decKey(9); } // для остальных позиций
    }
    // и селектор для бодунов
    if(njx.v_ram[0] == fnt_b)
    {
     switch (NumPozKur) {
      case 2:
      // флаг разрешения/запрета работы
      // "E" = 1, "d" = 0
        njx.v_ram[2] = njx.v_ram[2] & (~fnt_coma);
        if(njx.v_ram[2] == fnt_E)
        { njx.v_ram[2] = fnt_d | fnt_coma; }
        else { njx.v_ram[2] = fnt_E | fnt_coma; }
        break;
      case 3:
      // флаг активного уровня на выводе HLbud
      // "H" = 1, "L" = 0
        njx.v_ram[3] = njx.v_ram[3] & (~fnt_coma);
        if(njx.v_ram[3] == fnt_H)
        { njx.v_ram[3] = fnt_L | fnt_coma; }
        else { njx.v_ram[3] = fnt_H | fnt_coma; }
        break;
      case 4:
      // десятки часов декремент по модулю 2
        decKey(2);
        break;
      case 5:
      // единицы часов декремент по модулю 9
      // с проверкой корректности по завершению ввода
        decKey(9);
        break;
      case 6:
      // десятки минут декремент по модулю 5
        decKey(5);
        break;
      case 7:
      // единицы минут декремент по модулю 9
        decKey(9);
        break;
      default: 
        stub();
        break;
     }
    }
    njx.WRglass();
   }
  }
}

// чтение байта data_Tune с
// нормированием для индикации
void RDiTune()
{
 if(data_Tune >= 100)
 { njx.v_ram[6] = data_Tune - 100; njx.v_ram[4] = fnt_1;}
 else { njx.v_ram[4] = fnt_0; njx.v_ram[6] = data_Tune; }
 njx.v_ram[6] = pgm_read_byte_near( BinDec + njx.v_ram[6] );
 njx.v_ram[5] = njx.znak(((njx.v_ram[6] >> 4) & B00001111));
 njx.v_ram[6] = njx.znak((njx.v_ram[6] & B00001111));
}

// фрагмент нормирования для проверки и ввода
// кнопа EditP для RTC часов/календаря
void EditP_normC()
{
 njx.v_ram[7] = njx.overZnak(njx.v_ram[7]);
 njx.v_ram[6] = njx.overZnak(njx.v_ram[6]);
 njx.v_ram[4] = njx.overZnak(njx.v_ram[4]);
 njx.v_ram[3] = njx.overZnak(njx.v_ram[3]);
 // упакованный двоично-десятичный в 7 и 4
 njx.v_ram[7] = njx.v_ram[7] | (njx.v_ram[6] << 4);
 njx.v_ram[4] = njx.v_ram[4] | (njx.v_ram[3] << 4);
 // двоичный эквивалент в 6 и 3
 njx.v_ram[6] = pgm_read_byte_near( DecBin + njx.v_ram[7] );
 njx.v_ram[3] = pgm_read_byte_near( DecBin + njx.v_ram[4] );
}

// фрагмент нормирования для проверки и ввода
// кнопа EditP для будильников
void EditP_normB()
{
 njx.v_ram[7] = njx.overZnak(njx.v_ram[7]);
 njx.v_ram[6] = njx.overZnak(njx.v_ram[6]);
 njx.v_ram[5] = njx.overZnak(njx.v_ram[5]);
 njx.v_ram[4] = njx.overZnak(njx.v_ram[4]);
 // упакованный двоично-десятичный в 7 и 5
 njx.v_ram[7] = njx.v_ram[7] | (njx.v_ram[6] << 4);
 njx.v_ram[5] = njx.v_ram[5] | (njx.v_ram[4] << 4);
 // двоичный эквивалент в 6 и 4
 njx.v_ram[6] = pgm_read_byte_near( DecBin + njx.v_ram[7] );
 njx.v_ram[4] = pgm_read_byte_near( DecBin + njx.v_ram[5] );
}

// сигнал при ошибке диапазона ввода
void ErInp()
{
 njx.v_ram[3] = fnt_E;
 njx.v_ram[4] = fnt_r;
 njx.v_ram[5] = fnt_bl;
 njx.v_ram[6] = fnt_I;
 njx.v_ram[7] = fnt_n;
 njx.v_ram[8] = fnt_P;
 njx.v_ram[9] = fnt_bl;
 njx.WRglass();
 tone(DTM, 2000); delay(1000); noTone(DTM);
}

// общий заголовок окна редактирования бодунов
void BlockBodus()
{
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 // запись заставки окна выбора параметров редактирования
 njx.v_ram[0] = fnt_b;
 njx.v_ram[9] = fnt_qest | fnt_coma;
 LdMas(EnKurF, LenPozDisp, 0); NumPozKur = 9;
 EnKurF[9] = 1; EnKurF[7] = 1; EnKurF[6] = 1;
 EnKurF[5] = 1; EnKurF[4] = 1; EnKurF[3] = 1;
 EnKurF[2] = 1;
 //njx.WRglass();
}


//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
