/* 
 *  вариант дисплея на основе NJU6432
 *            файл nju6432xl.h
 */
// защита от переоперделения с заключительным
// #endif в конце файла
#ifndef _nju6432xl_H
#define _nju6432xl_H

//------------------
/*
 * обязательная "магическая добавка", 
 * включая заключительный #endif
 */
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
//------------------
/*
 * варианты раскладки сегментов
 * указываем тип "стекла" индикатора
 * 
 * 1 = старое "стекло на резинках"
 * 2 = вариант А "стекло на лапках"
 * 
*/
#define GLASS 2

//------------------
// собственно объявление класса

class nju
{ 
  public:
// объявление конструктора
#if GLASS == 1
   nju (byte, byte, byte, byte);
   // линии интерфейса и указатель на массив
/*
 *  (ln_no_inh, ln_dn, ln_scl, ln_ce)
 * ln_no_inh = 9; // линия управления дисплея (бланкирование)
 * ln_dn = 10; // линия данных дисплея
 * ln_scl = 11; // тактовый строб сопровождения данных дисплея
 * ln_ce = 12; // линия разрешения обмена дисплея
 * 
*/
#elif GLASS == 2
   nju (byte, byte, byte);
/*
 *  (ln_dn, ln_scl, ln_ce)
 * ln_dn = 10; // линия данных дисплея
 * ln_scl = 11; // тактовый строб сопровождения данных дисплея
 * ln_ce = 12; // линия разрешения обмена дисплея
 * 
*/
#endif

// объявление (и начальная инициализация) открытых членов класса

#if GLASS == 1

#define s_A 1 // значение номера сегмента A
#define s_B 7 // значение номера сегмента B
#define s_C 5 // значение номера сегмента C
#define s_D 4 // значение номера сегмента D
#define s_E 2 // значение номера сегмента E
#define s_F 0 // значение номера сегмента F
#define s_G 3 // значение номера сегмента G
#define s_H 6 // значение номера сегмента H

#elif GLASS == 2

#define s_A 3 // значение номера сегмента A
#define s_B 5 // значение номера сегмента B
#define s_C 4 // значение номера сегмента C
#define s_D 6 // значение номера сегмента D
#define s_E 0 // значение номера сегмента E
#define s_F 1 // значение номера сегмента F
#define s_G 7 // значение номера сегмента G
#define s_H 2 // значение номера сегмента H

#endif

//------------------------------------------------------------------

/* "кодовая страница кракозябр 7-сегментных"
 раскладка сегментов по символам определяется стандартной разметкой A-H
 по условию, что активный уровень(сегмент астивен/светится) принят за 1 */

#define fnt_bl 0
#define fnt_0 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F) // цифра 0 или символ "О"
#define fnt_1 (1<<s_B | 1<<s_C) // цифра 1
#define fnt_2 (1<<s_A | 1<<s_B | 1<<s_D | 1<<s_E | 1<<s_G) // цифра 2
#define fnt_3 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G) // цифра 3 или символ "Э/З"
#define fnt_4 (1<<s_B | 1<<s_C | 1<<s_F | 1<<s_G) // цифра 4 или символ "Ч"
#define fnt_5 (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // цифра 5 или символ "S"
#define fnt_6 (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // цифра 6
#define fnt_7 (1<<s_A | 1<<s_B | 1<<s_C) // цифра 7
#define fnt_8 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // цифра 8
#define fnt_9 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // цифра 9
#define fnt_A (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "A"
#define fnt_b (1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // символ "b"
#define fnt_C (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F) // символ "C" (прямая скобка '[' )
#define fnt_d (1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_G) // символ "d"
#define fnt_E (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // символ "E"
#define fnt_F (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G) // символ "F"
#define fnt_P (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G | 1<<s_B) // символ "P"
#define fnt_L (1<<s_E | 1<<s_F | 1<<s_D) // символ "L"
#define fnt_H (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "H"
#define fnt_U (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_D) // символ "U"
#define fnt_I (1<<s_E | 1<<s_F) // левая 1 или латинская I
#define fnt_S (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // аналог цифры 5
#define fnt_J (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E) // символ "J"
#define fnt_G (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F) // символ "G"
#define fnt_r (1<<s_G | 1<<s_E) // символ "r"
#define fnt_n (1<<s_G | 1<<s_E | 1<<s_C) // символ "п"
#define fnt_c (1<<s_G | 1<<s_E | 1<<s_D) // символ "с" или '<'
#define fnt_o (1<<s_G | 1<<s_E | 1<<s_D | 1<<s_C) // нижний кружок "о"
#define fnt_u (1<<s_C | 1<<s_E | 1<<s_D) // символ "u"
#define fnt_h (1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "h"
#define fnt_rusg (1<<s_A | 1<<s_E | 1<<s_F) // символ "Г"
#define fnt_rusP (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_B | 1<<s_C) // символ "П"
#define fnt_rus_iE (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G) // символ Э/З/цифра 3 (инверсное Е)
#define fnt_rusY (1<<s_F | 1<<s_G | 1<<s_B | 1<<s_C | 1<<s_D) // символ "У"
#define fnt_qest (1<<s_A | 1<<s_B | 1<<s_E | 1<<s_G) // символ "?"
#define fnt_rC (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D) // символ ']' (обратная скобка/"вывернутая С")
#define fnt_rc (1<<s_G | 1<<s_C | 1<<s_D) // символ '>'
#define fnt_gradus (1<<s_A | 1<<s_B | 1<<s_F | 1<<s_G) // верхний кружок "символ грвдуса"
#define fnt_minus (1<<s_G) // символ "-" (средняя черта)
#define fnt_aplin (1<<s_A) // символ "верхняя черта"
#define fnt_dnlin (1<<s_D) // символ "_" (нижняя черта)
#define fnt_trlin (1<<s_A | 1<<s_G | 1<<s_D) // символ "три черты"
#define fnt_coma (1<<s_H) // символ "," (децимальная точка)
#define fnt_T_sk (1<<s_E | 1<<s_F | 1<<s_G) // символ "кракозябровое Т боком"



/*
 *    v_ram
 * буфер-массив видеопамяти дисплея NJU6432
 * развертка позиций слева направо (0:1:2:3:4:5:6:7:8:9)
 */
byte v_ram[10]{0,0,0,0,0,0,0,0,0,0};

// объявление функций внешнего доступа

// запись данных из буфера в дисплей
// !исполнение зависит от определения типа стекла в cpnju.h!
  void WRglass();
  void init(); // инициализация интерфейса дисплея
// запись бланк-кода сегментов во все ячейки масива wideo_ram
  void BlankVram(byte);
  byte znak(byte); // утилитка знакогенератора
// "обратный конвертор" сегментного кода из v_ram
// в байт двоичного кода 0-F
  byte overZnak(byte);

private:
  // объявление закрытых членов класса

  #define s_ter0 B00110000 // служебная тетрада битового блока 0
  #define s_ter1 B10010000 // служебная тетрада битового блока 1
  #define H_tetr_mask B11110000
  #define L_tetr_mask B00001111

  byte disp_buf[14] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0}; // массив буфера для преобразования 
  // и последующей передачи битового блока в ОЗУ индикатора. Содержимое разрушается при обработке

#if GLASS == 1
  byte _ln_no_inh; byte _ln_dn; byte _ln_scl; byte _ln_ce;
#elif GLASS == 2
  byte _ln_dn; byte _ln_scl; byte _ln_ce;
#endif

  void send_blok(byte, byte);
  void modus(byte, byte);
  
}; // обязательное заключительное ";"
// объявление объекта njx класса nju как extern
extern nju njx;

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
