
#include "nju6432xl.h" // заголовочный *.h файл комплекта библиотеки nju6432

/* 
 *  описание конструктора
 * задаем соответствие физических линий интерфейса закрытым переменным членам класса
*/

#if GLASS == 1
 nju::nju(byte PinNoInh, byte PinDn, byte PinScl, byte PinCe)
 {
  _ln_no_inh = PinNoInh; // линия управления дисплея (бланкирование)
  _ln_dn = PinDn; // линия данных дисплея
  _ln_scl = PinScl; // тактовый строб сопровождения данных дисплея
  _ln_ce = PinCe; // линия разрешения обмена дисплея
 }
#elif GLASS == 2
 nju::nju(byte PinDn, byte PinScl, byte PinCe)
 {
  _ln_dn = PinDn; // линия данных дисплея
  _ln_scl = PinScl; // тактовый строб сопровождения данных дисплея
  _ln_ce = PinCe; // линия разрешения обмена дисплея
 }
#endif

//------------------
// запись данных из буфера в дисплей
// !исполнение зависит от определения типа стекла в cpnju.h!
void nju::WRglass()
{
 #if (GLASS == 1)
   for (int cnt=0; cnt<=9 ; cnt++)
    { disp_buf[cnt]=v_ram[cnt]; }
   for (int cnt=6; cnt<=13; cnt++)
    { 
     byte tmp0=0; static byte tmp1=0; byte data=0;
     // получаем новое значение старшего блока данных, сдвинутое на 4 бита
     data=disp_buf[cnt]; tmp0=((data<<4) & H_tetr_mask) | tmp1;
     tmp1=(data>>4) & L_tetr_mask; //старшая тетрада для следующего цикла
     disp_buf[cnt]=tmp0; // возврат нового значения
    }
 #elif (GLASS == 2)
   for (byte cnt=0, cnt1=0; cnt<=4; cnt++)
    {
     disp_buf[cnt] = v_ram[cnt1] & L_tetr_mask; cnt1++;
     disp_buf[cnt] = disp_buf[cnt] | (v_ram[cnt1] << 4); cnt1++;
    }
   for (byte cnt=7, cnt1=9; cnt<=11; cnt++)
    {
     disp_buf[cnt] = (v_ram[cnt1] >> 4) & L_tetr_mask; cnt1--;
     disp_buf[cnt] = disp_buf[cnt] | (v_ram[cnt1] & H_tetr_mask);
     cnt1--;
    }
   for (byte cnt=0, dist=12, src=11; cnt<=5; cnt++)
    {
     disp_buf[dist]=disp_buf[dist]&B11000000;
     disp_buf[dist]=disp_buf[dist]|((disp_buf[src]>>2)&B00111111);
     disp_buf[src]=disp_buf[src]<<6; dist--; src--;
    }
 #endif
  // вводим в коды блоков служебную информацию
   modus(6, s_ter0);
   modus(13, s_ter1);
 // предобработка битового поля данных для вывода 
 // в соответствии с документацией протокола обмена завершена
  digitalWrite(_ln_ce, HIGH); // активирована выборка кристалла
  send_blok(0,6); // участок передачи младшего блока данных
  digitalWrite(_ln_dn, LOW); // генерация разделительного импульса
  delayMicroseconds(1);
  digitalWrite(_ln_ce, LOW);
  delayMicroseconds(5);
  digitalWrite(_ln_ce, HIGH);
  delayMicroseconds(1);
  send_blok(7,13); // участок передачи старшего блока данных
  digitalWrite(_ln_dn, LOW);
  digitalWrite(_ln_ce, LOW); // интерфейсные линии деактивированы
}

//------------------

void nju::send_blok(byte on_poz, byte off_poz)
{
 // побитовая передача данных
  for (byte cnt=on_poz; cnt<=off_poz; cnt++)
  {
   for (byte poz=0; poz<=7; poz++)
   {
    digitalWrite(_ln_dn,(bitRead(disp_buf[cnt],poz)));
     delayMicroseconds(1);
     digitalWrite(_ln_scl, HIGH);
     delayMicroseconds(1);
     digitalWrite(_ln_scl, LOW);
     delayMicroseconds(1);
   }
  }
}

//------------------

void nju::modus(byte num, byte ster)
 {
 disp_buf[num]=((disp_buf[num]>>4) & L_tetr_mask) | ster;
 // s_ter0 = B00110000, s_ter1 = B10010000
 }

//------------------
// запись бланк-кода сегментов во все ячейки масива wideo_ram
void nju::BlankVram(byte blank)
 {
  for (byte cnt=0; cnt<=9; cnt++)
   { v_ram[cnt]=blank; }
 }

//------------------

void nju::init()
{
 #if (GLASS == 1)
 pinMode(_ln_no_inh, OUTPUT); // режим вывод
 digitalWrite(_ln_no_inh, LOW); // исходное состояние = 0 (индикация запрещена)
 #endif
 pinMode(_ln_dn, OUTPUT); // режим вывод
 pinMode(_ln_scl, OUTPUT); // режим вывод
 pinMode(_ln_ce, OUTPUT); // режим вывод
 digitalWrite(_ln_dn, LOW); // исходное состояние = 0
 digitalWrite(_ln_scl, LOW); // исходное состояние = 0
 digitalWrite(_ln_ce, LOW); // исходное состояние = 0
 BlankVram(0); // fnt_bl отсутствует в данной области видимости
 //можно было бы использовать при условии, что эта константа знакогенератора
 // передается параметром функции nju::init_ksda()
 WRglass(); // начальная инициализация дисплея пробелами
 #if (GLASS == 1)
 digitalWrite(_ln_no_inh, HIGH); // индикация разрешена
 #endif
}

//------------------

// утилитка знакогенератора

byte nju::znak(byte tetr)
 { byte buf;
  switch (tetr)
  {
   case 0:
    buf=fnt_0;
   break;
   case 1:
    buf=fnt_1;
   break;
   case 2:
    buf=fnt_2;
   break;
   case 3:
    buf=fnt_3;
   break;
   case 4:
    buf=fnt_4;
   break;
   case 5:
    buf=fnt_5;
   break;
   case 6:
    buf=fnt_6;
   break;
   case 7:
    buf=fnt_7;
   break;
   case 8:
    buf=fnt_8;
   break;
   case 9:
    buf=fnt_9;
   break;
   case 10:
    buf=fnt_A;
   break;
   case 11:
    buf=fnt_b;
   break;
   case 12:
    buf=fnt_C;
   break;
   case 13:
    buf=fnt_d;
   break;
   case 14:
    buf=fnt_E;
   break;
   case 15:
    buf=fnt_F;
   break;
   default: 
    buf=fnt_bl;
   break;
  }
  return buf;
 }

// "обратный конвертор" сегментного кода из v_ram
// в байт двоичного кода 0-F
byte nju::overZnak(byte segKod)
{ byte buf;
 switch (segKod)
  {
   case fnt_0:
    buf=0;
   break;
   case fnt_1:
    buf=1;
   break;
   case fnt_2:
    buf=2;
   break;
   case fnt_3:
    buf=3;
   break;
   case fnt_4:
    buf=4;
   break;
   case fnt_5:
    buf=5;
   break;
   case fnt_6:
    buf=6;
   break;
   case fnt_7:
    buf=7;
   break;
   case fnt_8:
    buf=8;
   break;
   case fnt_9:
    buf=9;
   break;
   case fnt_A:
    buf=10;
   break;
   case fnt_b:
    buf=11;
   break;
   case fnt_C:
    buf=12;
   break;
   case fnt_d:
    buf=13;
   break;
   case fnt_E:
    buf=14;
   break;
   case fnt_F:
    buf=15;
   break;
   default: 
    buf=fnt_bl;
   break;
  }
  return buf;
}

//-------------конец файла/end of file---------------------
