/*
 * библиотека программного I2C протокола для мастера/ведущего шины
 * для применения с ардуино на основе МК AVR
 *
 * в методах блочного чтения/записи
 * используется внешний массив dpad размером 1-255 байт
 * 
*/

#ifndef mxiicr_H   // Блокируем повторное включение этого модуля
#define mxiicr_H   // включая заключительный #endif в конце файла
//------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------
//******************************************************************
//  Секция include: здесь подключаются заголовочные файлы
//                используемых модулей 
//******************************************************************

//------------------------------------------------------------------

// собственно описание класса

class mxiic
{
  public:
  
  // объявление конструктора
  
   mxiic (byte, byte); // Номера выводов для сигналов mx_Sda, mx_Scl
   

 // объявление (и начальная инициализация) открытых членов класса


 // объявление функций внешнего доступа

void mx_init(); // модуль инициализации

#define mx_Ack 1 // флаг задачи генерации ACK ведущим
#define mx_noAck 0 // флаг задачи генерации NO_ACK ведущим

void mx_Start(); // отработка статуса СТАРТ
void mx_Stop(); // отработка статуса СТОП
void mx_reStart(); // отработка статуса РЕСТАРТ

byte mx_Txd(byte); // передача байта, возвращает статус ошибки
                   // (0 или 1=AckError)
byte mx_Txda(byte); // модуль передачи без завершающего контроля АСК=1
            // используется для передачи адреса устройства с R/W=1
            //  возвращает статус ошибки (0 или 1=AckError)
byte mx_Rxd(byte); // прием байта, возвращает байт данных,
                  // параметрами  являются флаг mx_Ack в серии
                  // или mx_noAck, если читается последний байт


  private:
  
  // объявление закрытых членов класса


#define tim_wait_er 48 // время ожидания ответа слэйва N*2мкС
#define mx_AckError 1 // флаг статуса ошибки приема ACK от ведомого

volatile byte _mx_Scl;
volatile byte _mx_Sda;
volatile byte er_tcnt; // счетчик тайм-аута ошибки ожидания
                      // ACK слэйва
void mx_Stb(); // отработка строба сопроводжения

}; // обязательное заключительное ";"
extern mxiic my_iic;


#endif
//-------------конец файла/end of file---------------------