//******************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю 
//******************************************************************

// заголовочный *.h файл комплекта библиотеки mxiic
#include "mxiicr.h" 

//------------------------------------------------------------------

/* 
 *  конструктор
 * задаем соответствие физических линий интерфейса закрытым 
 * переменным членам класса
*/

 mxiic::mxiic(byte mx_Sda, byte mx_Scl)
 {
   //_dpad_ptr = dpad_ptr; // указатель на начало массива
	                   // буфера блокнота данных dpad_ptr
	 _mx_Sda = mx_Sda; // переменная со значением номера вывода
	                   // линии данных
   _mx_Scl = mx_Scl; // переменная со значением номера вывода
	                   // линии строба записи
 }


//------------------------------------------------------------------
void mxiic::mx_init()
{
  digitalWrite(_mx_Sda, LOW);
  digitalWrite(_mx_Scl, LOW);
  pinMode(_mx_Scl, INPUT); // HIGH за счет внешнего резистора
  pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
}

//------------------------------------------------------------------
// отработка статуса СТАРТ
void mxiic::mx_Start()
{
  pinMode(_mx_Scl, INPUT);
  pinMode(_mx_Sda, INPUT);
  digitalWrite(_mx_Scl, LOW);
  digitalWrite(_mx_Sda, LOW);
  pinMode(_mx_Sda, OUTPUT);
  delayMicroseconds(12);
  pinMode(_mx_Scl, OUTPUT);
  delayMicroseconds(6);
 // по выходу mx_Sda=mx_Scl=0 режим вывод
}

//------------------------------------------------------------------
// отработка статуса СТОП
void mxiic::mx_Stop()
{
  delayMicroseconds(2);
   pinMode(_mx_Sda, OUTPUT);
  delayMicroseconds(6);
  pinMode(_mx_Scl, INPUT); //digitalWrite(_mx_Scl, HIGH);
  delayMicroseconds(12);
  pinMode(_mx_Sda, INPUT); //digitalWrite(_mx_Sda, HIGH);
  delayMicroseconds(6);
 // по выходу mx_Sda=mx_Scl=Z, режим INPUT
 // ввод с внешним резистором подтяжки к + питания
}

//------------------------------------------------------------------
// отработка статуса РЕСТАРТ
void mxiic::mx_reStart()
{
  pinMode(_mx_Scl, OUTPUT); // ТОЛЬКО СТРАХОВКА
  delayMicroseconds(6);
  pinMode(_mx_Sda, INPUT);
  delayMicroseconds(6);
  while(!digitalRead(_mx_Sda))
  { } // ждем подтверждение ведомого
/*
 *  ОПАСНО! незащищенный от зацикливания участок!
 * работает в предположении, что отлов ошибки
 * ответа слэйва произойдет
 * на этапе передачи адреса устройства
 */
  delayMicroseconds(6);
  pinMode(_mx_Scl, INPUT);
  delayMicroseconds(12);
  pinMode(_mx_Sda, OUTPUT); //digitalWrite(_mx_Sda, LOW);
  delayMicroseconds(12);
  pinMode(_mx_Scl, OUTPUT); //digitalWrite(_mx_Scl, LOW);
  delayMicroseconds(6);
  // по выходу mx_Sda=mx_Scl=0 режим вывод
}

//------------------------------------------------------------------
// отработка строба сопроводжения
void mxiic::mx_Stb()
{
  delayMicroseconds(6);
  pinMode(_mx_Scl, INPUT); // HIGH за счет внешнего резистора
  delayMicroseconds(12);
  pinMode(_mx_Scl, OUTPUT); // LOW
  delayMicroseconds(6);
}

//------------------------------------------------------------------
/*
 * передача байта
 * возвращает статус ошибки (0 или 1=AckError)
 */
byte mxiic::mx_Txd(byte data) // 
                     // 
{ byte flag_error=0; byte index=7;
  for (byte cnt=0; cnt<=7; cnt++)
  {
   if (bitRead(data, index))
    {
     pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
    }
    else
     {
      pinMode(_mx_Sda, OUTPUT); // LOW
     }
    mx_Stb(); index--;
  }
  pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
        // ждем АСК СЛЭЙВА
   er_tcnt=0;
  while (digitalRead(_mx_Sda))
   {
    delayMicroseconds(2);
    if (er_tcnt>=tim_wait_er)
    {
      flag_error=mx_AckError; break;
    }
    er_tcnt++;
   }
    if (!flag_error) // если выход без ошибки продолжаем
     {
      mx_Stb(); // генерируем строб получения АСК слэйва
                // и ждем перевод слэйвом шины mx_Sda в 1
       er_tcnt=0;
      while (!digitalRead(_mx_Sda))
       {
        delayMicroseconds(2);
        if (er_tcnt>=tim_wait_er)
        {
         flag_error=mx_AckError; break;
        }
        er_tcnt++;
       }
     }
 return flag_error;
/*
 *  по выходу mx_Scl=0 режим вывод,
 *  mx_Sda=Z, режим INPUT
 *  ввод с внешним резистором подтяжки к + питания
 */
}

//------------------------------------------------------------------
/*
 *  прием байта, возвращает принятый
 *  байт, параметрами являются флаг mx_Ack в серии
 *  или mx_noAck, если читается последний байт
 */
byte mxiic::mx_Rxd(byte flag)
{ pinMode(_mx_Sda, INPUT); byte index=7; byte dati=0;
  for (byte cnt=0; cnt<=7; cnt++)
  {
   delayMicroseconds(6);
   pinMode(_mx_Scl, INPUT); // HIGH за счет внешнего резистора
   delayMicroseconds(6);
   bitWrite(dati, index, digitalRead(_mx_Sda));
   index--;
   delayMicroseconds(6);
   pinMode(_mx_Scl, OUTPUT); // LOW
   delayMicroseconds(6);
  }
  if (flag) // генерация АСК мастером (flag == mx_Ack) 
  {
    pinMode(_mx_Sda, OUTPUT); // LOW
    mx_Stb();
    pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
  }
   else // генерация NO_ACK мастером
    {
      pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
      mx_Stb();
    }
 return dati;
/*
 *  по выходу mx_Scl=0 режим вывод,
 *  mx_Sda=Z, режим INPUT
 *  ввод с внешним резистором подтяжки к + питания
 */
}

//------------------------------------------------------------------
/*
 *  передача байта
 *   возвращает статус ошибки (0 или 1=AckError)
 */
byte mxiic::mx_Txda(byte data)
{ byte flag_error=0; byte index=7;
  for (byte cnt=0; cnt<=7; cnt++)
  {
   if (bitRead(data, index))
    {
     pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
    }
    else
     {
      pinMode(_mx_Sda, OUTPUT); // LOW
     }
    mx_Stb(); index--;
  }
   pinMode(_mx_Sda, INPUT); // HIGH за счет внешнего резистора
              // ждем АСК СЛЭЙВА
   er_tcnt=0;
  while (digitalRead(_mx_Sda))
   {
    delayMicroseconds(2);
    if (er_tcnt>=tim_wait_er)
    {
      flag_error=mx_AckError; break;
    }
    er_tcnt++;
   }
    //если выход без ошибки продолжаем
     if (!flag_error)
     {
      mx_Stb();
/*
 * генерируем строб получения АСК слэйва
 * на этом участке слэйв выдает старший бит предварительно 
 * заявленной ячейки устройства I2C
 *  посему контроль перевода слэйвом шины mx_Sda в 1
 * может дать некорректный результат (0 по первому байту к передаче)
 * и следовательно должен быть отключен
 */
     }
 return flag_error;
/*
 *  по выходу mx_Scl=0 режим вывод,
 *  mx_Sda=Z, режим INPUT
 *  ввод с внешним резистором подтяжки к + питания
 */
}

//------------------------------------------------------------------

//-------------конец файла/end of file---------------------