/* ---------------------------------------------------- */
/*  исполнительный файл библиотеки программного обработчика    */
/*                    Dallas CRC7/CRC8                   */
//-------------------------------------------------------

//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

 #include "dscrc.h" // заголовочный *.h файл текущего проекта

// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// если задано task=test_crc (task=0) то функция
// возвращает или 0 при совпадении CRC
// или 1 при ошибке CRC
// если задано task=gen_crc (task=1) то функция
// возвращает собственно байт CRC
// *pad = адресу начала буфер-массива данных "блокнота"
// mod = crc_7 (mod = 7) для работы с адресным пакетом (8 байт)
// или
// mod = crc_8 (mod = 8) для работы с пакетом данных (9 байт)

byte dscrc::pcrc(byte *pad, byte mod, byte task)
 {
   byte tmp_crc = 0; byte ret_data = 0;
 for (byte cnt=0; cnt<mod; cnt++)
   {
    byte tmp = pad[cnt];//*(pad + cnt);
    for (byte a=0; a<8; a++)
     {
       if ((tmp_crc ^ tmp) & 0x01) // по результату обработки первого узла
        {
         tmp_crc = ((tmp_crc ^ 0x18) >> 1) | 0x80;
        } // если результату обработки первого узла=1
       else
        {
         tmp_crc = (tmp_crc >> 1) & 0x7F;
        } // если результату обработки первого узла=0
       tmp = tmp >> 1; // сдвигаем текущие данные
     }
   }

  if (task)
   {
    ret_data = tmp_crc; // результат в байте возврата 
    pad[mod] = tmp_crc; //*(pad + mod) = tmp_crc; результат в последнем байте блокнота
   }
  else
    {
     ret_data = (tmp_crc == pad[mod]) ? 0 : 1 ; //(tmp_crc == *(pad + mod)) ? 0 : 1 ;
    }

  return ret_data;
 }
