//  файл дефайнов карты памяти
//      RTC  DS3231M
//      ds3231_map.h

#ifndef ds3231_map_H   // Блокируем повторное включение этого модуля
#define ds3231_map_H   // включая заключительный #endif в конце файла
//------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------

// линии интерфейса связи для программного I2C обмена
//const byte p_sda = 6; // I2C SDA на D6
//const byte p_scl = 7; // I2C SCL на D7
//#define l_sqw_out 8

// карта памяти DS3231
#define adr_rtc_sec 0x00 // адрес регистра секунд
#define adr_rtc_min 0x01 // адрес регистра минут
#define adr_rtc_hours 0x02 // адрес регистра часов
#define adr_rtc_day 0x03 // адрес регистра дня недели
#define adr_rtc_date 0x04 // адрес регистра даты (число)
#define adr_rtc_mons 0x05 // адрес регистра месяца
#define adr_rtc_year 0x06 // адрес регистра года
#define adr_a1_sec 0x07 // адрес регистра секунд блока alarm1
#define adr_a1_min 0x08 // адрес регистра минут блока alarm1
#define adr_a1_hours 0x09 // адрес регистра часов блока alarm1
#define adr_a1_dd 0x0A // адрес регистра дня недели/даты(число)
                     // блока alarm1
#define adr_a2_min 0x0B // адрес регистра минут блока alarm2
#define adr_a2_hours 0x0C // адрес регистра часов блока alarm2
#define adr_a2_dd 0x0D // адрес регистра дня недели/даты(число)
                     // блока alarm2
#define adr_rtc_control 0x0E // адрес регистра контроля и управления
#define adr_rtc_status 0x0F // адрес регистра status
#define adr_rtc_offset 0x10 // адрес регистра align offset
                   // содержит число со знаком (+127/-128)
#define adr_termo_h 0x11 // адрес регистра термодатчика, H байт
          // содержит целую часть и знак
#define adr_termo_l 0x12 // адрес регистра термодатчика, L байт
          // содержит дробную часть в старших двух битах

#define adr_apm_bit 6 // адрес позиции бита режима представления часов
    // размещен в rtc_hours (во всех блоках rtc и a1, a2)
   // apm_bit=0 -> 24 часовой фромат
   // apm_bit=1 -> 12 часовой фромат, статус бита 5 определяет
   // rtc_hours.5=0 -> АМ , rtc_hours.5=1 -> РМ
#define adr_dd_bit 5 // адрес позиции бита режима представления
   // день недели/число
   // размещен в adr_aN_dd (N=1 or 2)
   // adr_dd_bit=0 регистр работает как число
   // adr_dd_bit=1 регистр работает как день недели

//       регистр rtc_control
#define adr_eosc_bit 7 // адрес позиции бита eosc
// eosc=0 разрешает работу генератора
// eosc=1 остановит работу генератора при питании от Vbat
// при первой подаче питания eosc=0
// при работе от Vcc eosc игнорируется

#define adr_bbsqw_bit 6 // адрес позиции бита bbsqw
// при первой подаче питания bbsqw=0
// разрешение выдачи 1Гц импульсов на вывод INT/SQW
// при работе от батарейки при bbsqw=1
// при bbsqw=0 на выводе INT/SQW высокоимпедансное состояние

#define adr_conv_bit 5 // адрес позиции бита conv
// "ручная" инициализация цикла преобразования температуры
// делается не чаще, чем раз в секунду при внешнем питании
// и раз в 10 секунд при батарейном. Устанавливается программно
// желательно при bsy=0, сбрасывается аппаратно по завершении
// преобразования. При первой подаче питания conv=0

#define adr_intcn_bit 2 // адрес позиции бита intcn
// разрешение выдачи сигнала прерывания на выход INT/SQW
// при intcn=0 на INT/SQW 1Гц (при батарейном питании см. bbsqw)
// при intcn=1 на INT/SQW выводится результат сработки
// блоков совпадения, если работа этих блоков разрешена
// (активный 0)
// При первой подаче питания intcn=1

#define adr_a2ie_bit 1 // адрес позиции бита a2ie
// разрешение прерывания по сработке блока совпадения А2
// при a2ie=1 и intcn=1 разрешен сигнал INT/SQW=0 (при a2f=1)
// При первой подаче питания a2ie=0

#define adr_a1ie_bit 0 // адрес позиции бита бита a1ie
// разрешение прерывания по сработке блока совпадения А1
// при a1ie=1 и intcn=1 разрешен сигнал INT/SQW=0 (при a1f=1)
// При первой подаче питания a1ie=0


//       регистр rtc_status
#define adr_osf_bit 7 // адрес позиции бита osf
// устанавливаеися программно или аппаратно
// сброс программно
// osf=0 - генератор работает
// osf=1 - генератор остановлен
// При первой подаче питания osf=1

#define adr_en32khz_bit 3 // адрес позиции бита en32khz
// en32khz=0 вывод 32KHz  в Z-состоянии
// en32khz=1 на выводе 32KHz меандр 32,768КГц
// При первой подаче питания en32khz=1

#define adr_bsy_bit 2 // адрес позиции бита bsy
// индикация занятости блока преобразования температуры
// bsy = 1 - блок занят(доступ закрыт)
// bsy = 0 - блок свободен для программного запуска
// При первой подаче питания bsy НЕ ОПРЕДЕЛЕНО

#define adr_a2f_bit 1 // адрес позиции бита a2f
// флаг статуса сработки блока совпадения А2
// при a2ie=1 и intcn=1 появление a2f=1 приводит к
// INT/SQW=0
// установка только аппаратная, сброс записью 0
// (если статус события пройден/отменен)
// При первой подаче питания a2f НЕ ОПРЕДЕЛЕНО

#define adr_a1f_bit 0 // адрес позиции бита бита a1f
// флаг статуса сработки блока совпадения А1
// при a1ie=1 и intcn=1 появление a1f=1 приводит к
// INT/SQW=0
// установка только аппаратная, сброс записью 0
// (если статус события пройден/отменен)
// При первой подаче питания a1f НЕ ОПРЕДЕЛЕНО

//    регистр adr_a1_sec
#define adr_a1m1_bit 7 // адрес позиции бита
//    регистр adr_a1_min
#define adr_a1m2_bit 7 // адрес позиции бита
//    регистр adr_a1_hours
#define adr_a1m3_bit 7 // адрес позиции бита
//    регистр adr_a1_dd
#define adr_a1m4_bit 7 // адрес позиции бита

//    регистр adr_a2_min
#define adr_a2m2_bit 7 // адрес позиции бита
//    регистр adr_a2_hours
#define adr_a2m3_bit 7 // адрес позиции бита
//    регистр adr_a2_dd
#define adr_a2m4_bit 7 // адрес позиции бита

/*
 *   таблица настроек интервалов сработки блоков совпадений
 * 
 *  DD:A1M4:A1M3:A1M2:A1M1
 *  x    1    1    1    1   ежесекундная сработка
 *  х    1    1    1    0   при совпадении значений регистра секунд
 *  х    1    1    0    0   при совпадении значений регистров минут и секунд
 *  х    1    0    0    0   при совпадении секунд, минут и часов
 *  0    0    0    0    0   при совпадении секунд, минут, часов и даты(числа)
 *  1    0    0    0    0   при совпадении секунд, минут, часов и дня недели
 * 
 *  DD:A2M4:A2M3:A2M2
 *  х    1    1    1   каждую минуту при 00 секунд
 *  х    1    1    0   при совпадении значений регистров минут
 *  х    1    0    0   при совпадении минут и часов
 *  0    0    0    0   при совпадении минут, часов и даты(числа)
 *  1    0    0    0   при совпадении минут, часов и дня недели
 *  
 *  выходной втекающий ток на INT/SQW (при INT/SQW=0) 3мА максимум (при 0,4В)
 */

// командные байты DS3231
// под ассемблер
//#define N_ds3231 0b1101000 // 0b1101000 имя устройства совпадает с таковым для DS1307
//#define ds3231_W 0b11010000 // обращение в режиме "запись"
//#define ds3231_R 0b11010001 // обращение в режиме "чтение"
// под С++/Си ардуино
#define ds3231_W B11010000 // обращение в режиме "запись"
#define ds3231_R B11010001 // обращение в режиме "чтение"

//------------------------------------------------------------------

#endif
//-------------конец файла/end of file---------------------
