//     файл дефайнов карты памяти
//    датчик температуры  DS18B20
//      ds18b20_map.h

#ifndef ds18b20_map_H   // Блокируем повторное включение этого модуля
#define ds18b20_map_H   // включая заключительный #endif в конце файла
//------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------

//extern const byte DQ; // линиия интерфейса связи
//extern byte present; // контрольный флаг OneWire
//extern byte data[]; // массив данных (блокнота) OneWire (12/9)
//extern byte addr[]; // массив данных (адреса) OneWire (8)

// карта памяти DS18B20

//     scratchpad
#define TLdt 0 // адрес младшего байта температуры (0х50)
#define THdt 1 // адрес старшего байта температуры (0х05)
#define TUbh 2 // адрес верхней уставки пользователя
#define TUbl 3 // адрес нижней уставки пользователя
#define Conf 4 // адрес регистра конфигурации
#define rsv0 5 // резерв (0хFF)
#define rsv1 6 // резерв (0х0C)
#define rsv2 7 // резерв (0х10)
#define Crcd 8 // байт контрольной суммы

//       EEPROM
#define TUbh_E 1 // адрес верхней уставки пользователя
#define TUbl_E 2 // адрес нижней уставки пользователя
#define Conf_E 3 // адрес регистра конфигурации

//   64-bit lasered ROM
#define F_code 0 // family code (0x28)
#define F_adr0 1
#define F_adr1 2
#define F_adr2 3
#define F_adr3 4
#define F_adr4 5
#define F_adr5 6
#define F_Crca 7

// флаги конфигурации разрешающей способности
// результата преобразования температуры
#define CFR0 0
#define CFR1 1
/*
*   R1  R0   resolution   max_conversion_time
*   0   0      9-bit           93.75 mS
*   0   1     10-bit          187.5 mS
*   1   0     11-bit          375 mS
*   1   1     12-bit          750 mS
*/

// весовые коэффициенты дробной части данных
// биты 3:2:1:0 байта TLdt
#define TLdt_0 625  // 0,0625 * 1000
#define TLdt_1 1250 // 0,125 * 1000
#define TLdt_2 2500 // 0,25 * 1000
#define TLdt_3 5000 // 0,5 * 1000

//            ROM Commands
#define Search_R 0xF0 // поиск устройств на шине
#define Read_R 0x33 // чтение содержимого ROM (8 байт)
#define Match_R 0x55 // выборка заданного мастером устройства
#define Skip_R 0xCC // обход команд идентификации кристалла
#define Alarm_Search_R 0xEC // ...

//      DS18B20 Function Commands
#define ConvertT_F 0x44 // запуск преобразования
#define WrScrPad_F 0x4E // запись в блокнот
#define RdScrPad_F 0xBE // чтение блокнота
#define CopiScrPad_F 0x48 // запись содержимого 
                     // в ЕЕПРОМ TUbh_E:TUbl_E:Conf_E
#define ReCallEEP_F 0xB8 // чтение содержимого
                     // из ЕЕПРОМ TUbh_E:TUbl_E:Conf_E
                     // в регистры блокнота TUbh:TUbl:Conf
#define RdPowerSup_F 0xB4 // проверка статуса "паразитного питания"
//------------------------------------------------------------------

#endif
//-------------конец файла/end of file---------------------
