/* --------------------------------------------------------- */
/* заголовочный файл табличного преобразователя кодов bdbc.h */
/*---------------------------------------------------------- */
#ifndef _bdbc_H        // Блокируем повторное включение этого модуля
#define _bdbc_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
// подключить библиотеку работ с таблицами в ПЗУ
#include <avr/pgmspace.h> 

//------------------------------------------------------------------------
//            табличные преобразователи

// массив скоростного преобразователя байта со значением 0-99
// из бинарного в упакованный двоично-десятичный формат
extern const byte BinDec[]PROGMEM;

// массив скоростного преобразователя байта со значением 0-99
// из упакованного двоично-десятичного в бинарный формат
extern const byte DecBin[]PROGMEM;

/*
 * пример 
 * byte tmp с исходным кодом
 * tmp = pgm_read_byte_near( BinDec + tmp )
 * или
 * tmp = pgm_read_byte_near( DecBin + tmp )
 * в tmp результат преобразования
 */

//------------------------------------------------------------------------

#endif      // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
