/*
*            K145M.ino
*  базовый модуль имиации часов 
*   на основе К145ИК1901
*  расширенная версия на основе
*  ардуино-нано (про-мини),
*  RTC DS3231,
*  10-позиционного ЖКИ дисплея на NJU6432x
*  и минимальной клавиатуры (4-5 кнопок)
*  используюшей курсор с привязкой
*  к "пиктограммам"
*  с возможностью расширения функционала ПРВ
*  
*/
//---------------------------------------------------------
#include "K145M.h"

//---------------------------------------------------------
// создание экземпляра класса индикатора nju
#if GLASS == 1
nju njx(PinNoInh, PinDn, PinScl, PinCe);
#elif GLASS == 2
nju njx(PinDn, PinScl, PinCe);
#endif

// создание экземпляра класса mxiic
mxiic my_iic(L_SDA, L_SCL);

// создание экземпляра класса NeoPixel SmartLeds
//Adafruit_NeoPixel SmartLeds(PIXEL_COUNT, PIXEL_PIN, NEO_GRB + NEO_KHZ800);

//---------------------------------------------------------
void setup() {
  // put your setup code here, to run once:

 //Serial.begin(9600);

// SmartLeds.begin(); // Initialize NeoPixel SmartLeds object (REQUIRED)
// SmartLeds.show();  // Initialize all pixels to 'off'

// активация линий внешнего разъёма "по умолчанию"
// как входов с "подтягивающим резистором"
// вывод SSW используется как контроль наличия шлейфа термодатчика
digitalWrite(SSW, HIGH); digitalWrite(TxD, HIGH);
digitalWrite(RxD, HIGH); digitalWrite(DQ, HIGH);
pinMode(SSW, INPUT_PULLUP); pinMode(TxD, INPUT_PULLUP);
pinMode(RxD, INPUT_PULLUP); pinMode(DQ, INPUT_PULLUP);

// запуск генератора опорноно напряжения АЦП (1,1V for mega328)
 analogReference(INTERNAL);
// запуск сканера кнопок
 skan_init();
// инициализация сигнально-силовых выходных линий
 iTmrO(); i_bodOut();
 digitalWrite(DTM, LOW); pinMode(DTM, OUTPUT);
// инициализация аппаратных выводов программного I2C
 my_iic.mx_init();
// инициализация дисплея
 njx.init();
/* первичная инициализация RTC DS3231 при
 первичной подаче питания и зажатой
 при включении питания(после аппаратного reset)
 кнопке RK
*/
 tone(DTM, 500);
// заставка при подаче питания
 njx.BlankVram(fnt_bl);
 njx.v_ram[2] = fnt_minus;
 njx.v_ram[3] = fnt_1;
 njx.v_ram[4] = fnt_4;
 njx.v_ram[5] = fnt_5;
 njx.v_ram[6] = fnt_L;
 njx.v_ram[7] = fnt_minus;
 njx.WRglass(); delay(500);
 for (byte cnt = 0; cnt <= 100; cnt++)
  {
   if(digitalRead(PinToV)){ HardRTC_init(); break; }
   delay(10);
  }
 noTone(DTM); delay(1000);
// запуск обработчика секунд-генератора
 genSecInit();
// открытие панели главных часов
 dev0_init(); //DevClockInit();
 

}

//---------------------------------------------------------

void loop() {
  // put your main code here, to run repeatedly:

 if (QtTm)
 {
  QtTm = 0; KeyDevFnSel(); ErIrqRTC++;
  if (ErIrqRTC >= 150){ ERROR_RTC(); }
 }
 if (SecF)
 {
  SecF = 0; clock();
  if(!DisClcInd){ vrClcDisp(); }
  if(SecEN){ SecPlus(); }
  if(En_TmrF){ Tmr_wrk(); }
  if(Clc_cntS == 0)
  {
   if(EN_bodA){ bod_Wrk(TH_bodA, TM_bodA, Lw_bodA, 1); }
   if(EN_bodB){ bod_Wrk(TH_bodB, TM_bodB, Lw_bodB, 2); }
  }
  if (ENTermo)
  {
   if(F_termo){ RD_termo(); }
   else{ T_work(); }
   T_print();
  }
  if (EN_volt){ Volt(); njx.WRglass(); }
  if(EnZud)
  {
    if(ZudMode){tone(DTM, 700, 400); ZudMode=0;}
    else {tone(DTM, 250, 400); ZudMode=1;}
  }

  /* 
   * обработка линейки шустрых светиков
   * в зависимости от выставленных 
   * программами устройств флагов
   * вероятно по варианту switch-case
   * с изменяемыми функциями согласно текущей задачи
   */
  // "низкое напряжение" = 273 = 3.05V
  if(analogRead(Apwr) <= 273){ lowBat(); }
 }

}


//------------------------------------------------------------------------

// индикация необходимости включить зарядку
void lowBat()
{
 // деактивация аппаратных выводов
 // остановка таймеров и секундомеров
 digitalWrite(HLtmr, (!HLtmrWrk));
 digitalWrite(HLbud, (!HLbudWrk)); EnZud = 0;
 SecEN = 0; En_TmrF = 0;
 njx.BlankVram(fnt_bl); // очистка видеопамяти
 njx.v_ram[2]=fnt_L;
 njx.v_ram[3]=fnt_o;
 njx.v_ram[4]=fnt_u;
 njx.v_ram[6]=fnt_b;
 njx.v_ram[7]=fnt_A;
 njx.WRglass(); // вывод v_ram в индикатор
 for(byte cnt=0; cnt<=2; cnt++)
  {
   tone(DTM, 1000); delay(100); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(100); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(100); noTone(DTM); delay(400);
   tone(DTM, 1000); delay(300); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(300); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(300); noTone(DTM); delay(400);
   tone(DTM, 1000); delay(100); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(100); noTone(DTM); delay(200);
   tone(DTM, 1000); delay(100); noTone(DTM); delay(1000);
  }
  while(analogRead(Apwr) <= 282){  }
  // "зарядное подключено" при Vcc = 3,15 V
  njx.BlankVram(fnt_bl); // очистка видеопамяти
  njx.v_ram[2]=fnt_C;
  njx.v_ram[3]=fnt_h;
  njx.v_ram[4]=fnt_A;
  njx.v_ram[5]=fnt_r;
  njx.v_ram[6]=fnt_G;
  njx.v_ram[7]=fnt_E;
  njx.WRglass(); // вывод v_ram в индикатор
  tone(DTM, 250); delay(1000);
 // реинициализация как устройства "главные часы"
 PGset = 0; DevClockInit();
}

//------------------------------------------------------------------------
//-------------конец файла/end of file---------------------
