/*
*            K145M.h
*       заголовочный файл
*  базового модуля имиации часов 
*   на основе К145ИК1901
*  расширенная версия на основе
*  ардуино-нано (про-мини),
*  RTC DS3231,
*  10-позиционного ЖКИ дисплея на NJU6432x
*  и минимальной клавиатуры (4-5 кнопок)
*  используюшей курсор с привязкой
*  к "пиктограммам"
*  с возможностью расширения функционала ПРВ
*  
*/
//-------------------------------------------------------
 #ifndef _K145M_H  // Блокируем повторное включение этого модуля
 #define _K145M_H

//------------------
// подключение функционала референса arduinoIDE
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif

//------------------

//---------------------------------------------------------
// #include <avr/pgmspace.h> // подключить библиотеку работ с таблицами в ПЗУ
// #include <EEPROM.h> // "стандартная" ардуино библиотека ЕЕПРОМ
// #include <Adafruit_NeoPixel.h> // библиотека WS2812
 #include "sksi.h" // заголовочник сканера кноп консоли

//         ------- devices -------

#include "mainrtc.h" // заголовочник устройства "главные часы" (RTC)
#include "secmetr.h" // заголовочник субустройства "секундомер"
#include "timer.h" // заголовочный субустройства
                   //  "таймер обратного отсчета"
#include "termo.h" // заголовочный *.h файл датчика DS18B20

//------------------------------------------------------------------------
// раскладка управляющих линий (выводов)

//------------------------------------------------------------------------
// определение/инициализация входных линий МК в соответствии
// с номерами кнопок (сенсоров),
// активный уровень на линии сенсора = 0
const byte PinToV = 13; // D13 линия кнопки S4(Vkey)
const byte PinToM = 17; // D17 линия кнопки S3(Down)
const byte PinToP = 16; // D16 линия кнопки S2(Up)
const byte PinToR = 15; // D15 линия кнопки S1(Right)
const byte PinToL = 14; // D14 линия кнопки S0(Left)

// обьявление и инициализация управляющих выводов NJU6432

#if GLASS == 1
const byte PinNoInh = 18; // линия управления дисплея (бланкирование)
#endif

const byte PinDn = 8; // линия данных дисплея
const byte PinScl = 9; // тактовый строб сопровождения данных дисплея
const byte PinCe = 7; // линия разрешения обмена дисплея

// константа интервала опросов клавиатуры (сенсоров) в милисекундах
const byte skstm = 70; // *для механических кноп = 35; 

//------------------------------------------------------------------------
// инициализация управляющих выводов RTC
const byte L_QS = 3; // вывод строба/прерываний RTC
const byte L_SDA = 5; // вывод данных I2C
const byte L_SCL = 4; // вывод строба I2C

//------------------------------------------------------------------------
// инициализация системных силовых выводов аппаратной обвязки 
const byte HLtmr = 10; // сигнального выхода таймера
const byte HLbud = 11; // сигнальный вывод комплекта бодунов *!!
const byte DTM = 12; // сигнальный вывод звуковой головки

//------------------------------------------------------------------------
// ---------- линии внешнего разъёма ----------

// контроль наличия внешнего датчика на выводе D6 (SSW)
// (внешний разъём контакт 1)
// *** данный вывод может использоваться только как вход или выход с ОК! ***
// так как на кабеле внешнего датчика установлена перемычка "на корпус"
const byte SSW = 6;

//   линия DS18B20 (или иного устройства с возможностью INT0)
// (внешний разъём контакт 7)
const byte DQ = 2;

//   линия RxD (или иного устройства)
// (внешний разъём контакт 5)
const byte RxD = 0;

//   линия TxD (или иного устройства)
// (внешний разъём контакт 3)
const byte TxD = 1;

//------------------------------------------------------------------------

//#define PIXEL_PIN 13 // Digital IO pin connected to the NeoPixels.
//#define PIXEL_COUNT 9  // Number of NeoPixels

// инициализация констант схемотехнических активных уровней для
// системных силовых выводов аппаратной обвязки
const byte HLtmrWrk = 0; // сигнального выхода таймера
const byte HLbudWrk = 0; // сигнальный вывод комплекта бодунов *!!

// инициализация константы активного уровня кнопок
// Al_Sn = 0 для простых механических замыкателей на "корпус"
// Al_Sn = 1 для "активных" (емкостные модули) генерирующих 1
const byte Al_Sn = 1;

//------------------------------------------------------------------------
// инициализация константы номера вывода
// системы контроля питающего напряжения
const byte Apwr = 6; // вход АЦП A6

/*
 * ******************************************
 * обязательно учитывать, что в ардуино-нано 
 * (или про-мини) могут быть "по умолчанию"
 * выставлены BOD - фузы !!!
 * к примеру:
 * BODLEVEL2:BODLEVEL1:BODLEVEL0 = 1:0:1
 * т.е. аппаратный сброс 
 * при уровне питающего напряжения
 * 2,5 - 2,7 - 2,9 вольта
 * ******************************************
 */
// индикация необходимости включить зарядку
void lowBat();

//------------------------------------------------------------------------
// указатели на функции возврата в предыдущий модуль устройства
// (стек возврата из субменю) 3 уровня
// "растет вверх"
// заполняется при вызове субменю,
// опустошается по завершении выполнения
// функции возврата из субменю
// extern volatile KeyPtr RetSteckUH; // уровень 4
// extern volatile KeyPtr RetSteckUL; // уровень 3
volatile KeyPtr RetSteckU = stub; // уровень 2
volatile KeyPtr RetSteckH = stub; // уровень 1
volatile KeyPtr RetSteckL = stub; // уровень 0
// указатель на выполняемую при "все отключены"
// функцию возврата на предыдущий уровень
volatile KeyPtr RetPtr = stub;

// указатели на функции инициализации
// имеющихся в системе "устройств"
volatile KeyPtr dev0_init = DevClockInit; // основная панель главных часов
volatile KeyPtr dev1_init = secmetrInit; // секундомер
volatile KeyPtr dev2_init = Tmr_Init; // таймер обратного отсчета
volatile KeyPtr dev3_init = AdjRtcInit; // настройка параметров RTC и будильников
volatile KeyPtr dev4_init = TermoInit; // термодатчик DS18b20
/*
volatile KeyPtr dev5_init = stub; //
volatile KeyPtr dev6_init = stub; //
volatile KeyPtr dev7_init = stub; //
*/

//------------------------------------------------------------------------

#endif

//-------------конец файла/end of file---------------------
