// include the library code:
#include <LiquidCrystal.h>
#define PIN_INT0 2                    // Входной пин может быть 2 или 3
#define PIN_INT1 3

// Выводы ардуино при использовании шилда
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

const int dt1 = 104;              //Постоянные собственной задержки.
const int dt2 = 104;
const String delimiter = " ; ";  // Разделитель данных

int cnt = 0;                      //Счетчик замеров
unsigned int val = 60000;
String Values_str[4] = {"n/a", "n/a", "n/a", "n/a"}; //Значения замеренных параметров в текстовом виде

volatile boolean enabled = false;
volatile unsigned long delay_tics = 0;
volatile boolean OVF = false;

void setup() {
  Serial.begin(115200);
  noInterrupts(); //Настройка таймера
  TCCR1A = 0x00;
  TCCR1B = 0x00;
  TCCR1C = 0x00;
  TIMSK1 = 0x01;
  interrupts();
  pinMode(A4, OUTPUT);    //Выход управления оптроном
  pinMode(PIN_INT0, INPUT);      //Вход сигнала с оптрона
  pinMode(PIN_INT1, INPUT);      //Вход сигнала с оптрона

  //Заставка перед началом работы
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);
  lcd.print("Optocoupler test");
  lcd.setCursor(3, 1);
  lcd.print("V2.1 2025");
  delay(1000);
  lcd.clear(); 
  lcd.setCursor(0, 0);
  lcd.print("DN:Test");
  lcd.setCursor(9, 0);
  lcd.print("UP:Send");
  lcd.setCursor(0, 1);
  lcd.print("Select:Test+Send");
  for (int i = 0; i <= 3; i++) {
    Values_str[i] = "XXXXX";
  }
  Serial.println("Optocoupler test, V2.1, 2025");
}

void IntCapt () {       //Прерывание по сигналу с оптопары
  TCCR1B = 0x00;        //Стоп таймера
  delay_tics = TCNT1;   //Измеренное число тактов
  enabled = true;       //Разрешить дальнейшую работу
}

ISR (TIMER1_OVF_vect) { //Прерывание по истечению времени (~4мс)
  TCCR1B = 0x00;        //Стоп таймера
  OVF = true;           //Значение обозначает переполнение, например, если ничего не подключено
  enabled = true;       //Разрешить дальнейшую работу
}

void GetMeasurement(int PIN, boolean Rising) {  //Проведение замера для заданной полярности (фронт/спад)
  TCCR1B = 0x00;                      //Стоп таймера
  TCNT1 = 0x00;                       //Сброс счетчика таймера
  enabled = false;                    //Сброс флаг ожидания конца измерения
  OVF = false;                        //Сброс флага переполнения
  delay_tics = 0;

  if (Rising) {                       //Если полярность положительная (Off-On)
    digitalWrite(A4, LOW);            //Установка низкого уровня на выходе - Начальное состояние
    delayMicroseconds(100);           //Задержка 100мкс
    attachInterrupt(digitalPinToInterrupt(PIN), IntCapt, FALLING); //Разрешение прерывания по входу
    TCCR1B = 0x01;                    //Запуск таймера
    digitalWrite(A4, HIGH);           //Установка высокого уровня на выходе - Конечное состояние
    delayMicroseconds(100);           //Длительность активного импульса 100мкс
    digitalWrite(A4, LOW);            //Выключение выхода
  }  else {                           //Для отрицательной полярности (On-Off)
    digitalWrite(A4, HIGH);           //Устанавка высокого уровня на выходе - Начальное состояние
    delayMicroseconds(100);           //Задержка 100мкс
    attachInterrupt(digitalPinToInterrupt(PIN), IntCapt, RISING); //Разрешение прерывания по входу
    TCCR1B = 0x01;                    //Запуск таймера
    digitalWrite(A4, LOW);            //Установка низкого уровня на выходе - Конечное состояние
    delayMicroseconds(100);
    digitalWrite(A4, LOW);            //Выключение выхода
  }
}

void ShowResults() {
  lcd.clear();
  // Шапка таблицы
  lcd.setCursor(0, 0);
  lcd.print("CH1");
  lcd.setCursor(0, 1);
  lcd.print("CH2");
  delay(100);
  //Канал 1 - возрастающий фронт
  lcd.setCursor(4, 0);
  lcd.print("     ");
  lcd.setCursor(4, 0);
  lcd.print(Values_str[0]);
  //Канал 1 - спадающий фронт
  lcd.setCursor(10, 0);
  lcd.print("     ");
  lcd.setCursor(10, 0);
  lcd.print(Values_str[1]);
  //Канал 2 - возрастающий фронт
  lcd.setCursor(4, 1);
  lcd.print("     ");
  lcd.setCursor(4, 1);
  lcd.print(Values_str[2]);
  //Канал 2 - спадающий фронт
  lcd.setCursor(10, 1);
  lcd.print("     ");
  lcd.setCursor(10, 1);
  lcd.print(Values_str[3]);
}

void Analysis() {
  GetMeasurement(PIN_INT0, true);                     // Измерение CH1 - возрастание
  while (!enabled);                                   //Ожидание завершения измерения
  detachInterrupt(digitalPinToInterrupt(PIN_INT0));
  if (OVF) {
    Values_str[0] = "n/a";
  } else {
    Values_str[0] = String((delay_tics - dt1) * 62);
  }
  delay(100);

  GetMeasurement(PIN_INT0, false);                    // Измерение CH1 - спад
  while (!enabled);                                   //Ожидание завершения измерения
  detachInterrupt(digitalPinToInterrupt(PIN_INT0));
  if (OVF) {
    Values_str[1] = "n/a";
  } else {
    Values_str[1] = String((delay_tics - dt2) * 62);
  }
  delay(100);

  GetMeasurement(PIN_INT1, true);                     // Измерение CH2 - возрастание
  while (!enabled);                                   //Ожидание завершения измерения
  detachInterrupt(digitalPinToInterrupt(PIN_INT1));
  if (OVF) {
    Values_str[2] = "n/a";
  } else {
    Values_str[2] = String((delay_tics - dt1) * 62);
  }
  delay(100);

  GetMeasurement(PIN_INT1, false);                    // Измерение CH2 - спад
  while (!enabled);                                   //Ожидание завершения измерения
  detachInterrupt(digitalPinToInterrupt(PIN_INT1));
  if (OVF) {
    Values_str[3] = "n/a";
  } else {
    Values_str[3] = String((delay_tics - dt2) * 62);
  }
  delay(100);

  ShowResults();
}

void USART_TX(){
    if (cnt == 0) {                                     //Показать шапку при первом нажатии
      Serial.println("Counter ; CH1_R ; CH1_F ; CH2_R ; CH2_F");
    }
    cnt++; 

    Serial.print(cnt);    Serial.print(" ; ");          //Отправка данных в порт с разделителем ";"
    Serial.print(Values_str[0]);    Serial.print(" ; ");
    Serial.print(Values_str[1]);    Serial.print(" ; ");
    Serial.print(Values_str[2]);    Serial.print(" ; ");
    Serial.println(Values_str[3]);
    delay(250);  
}

void loop() {                       //Основной цикл

  int x = analogRead(A0);           //Считывание клавиш

  delay(50);

  if ((x > 200) && (x < 400)) {                         // DOWN - TEST
    Analysis();
  }

  if ((x > 50) && (x < 150)) {                            //UP кнопка отпрвляет данные в порт
    USART_TX();
  }

  if ((x > 500) && (x < 750)) {                            //SELECT тестируем и отпрвляет данные в порт
    Analysis();
    USART_TX();
  }
  
  x = 0;
}


