;  12  88  
;  2-    ,    88  
;PD0-C8, PD1-C7...
;PB0-B7, PB1-B6...
;   https://ru.wikipedia.org
;7	 	C8	 	4186,01
;6	 	B7	 	3951,07
;#6 (?6) 	A#7/B?7 	3729,31
;6	 	A7	 	3520,00
;#6 (?6) 	G#7/A?7 	3322,44
;6 		G7	 	3135,96
;#6 (?6) 	F#7/G?7 	2959,96
;6	 	F7 		2793,83
;6 		E7	 	2637,02
;#6 (?6) 	D#7/E?7 	2489,02
;6 		D7	 	2349,32
;#6 (?6) 	C#7/D?7 	2217,46
;6 		C7	 	2093,00
	.INCLUDE "tn2313def.inc"

;.equ	Fo=20000000
.equ	Fo=20011318

.equ	NOTA_C8=100*Fo/418601/2
.equ	NOTA_B7=100*Fo/395107/2
;************************************************
	.CSEG

.ORG	$0000
RESET:
	LDI	R20,LOW(RAMEND)
	OUT	SPL,R20
	SBI	ACSR,ACD	;   

	RJMP	START	; On Reset

.ORG	$0004
COMPA_T1:		; Timer 1A compare
	INC	R18
	OUT	PORTD,R18
	ADD	R1,XL
	ADC	R0,XH
	OUT	OCR1AH,R0
	OUT	OCR1AL,R1
	RETI

.ORG	$000C
COMPB_T1:		; Timer 1B compare
	INC	R19
	OUT	PORTB,R19
	ADD	R3,YL
	ADC	R2,YH
	OUT	OCR1BH,R2
	OUT	OCR1BL,R3
	RETI 
;*************************************************
;*************************************************
;*************************************************
START:
	SER	R20
	OUT	DDRA,R20
	OUT	DDRB,R20
	OUT	DDRD,R20	; 
;*************************************************
	LDI	R16,1<<SE
	OUT	MCUCR,R16	;  SLEEP IDLE

	LDI	XH,HIGH(NOTA_C8-1)
	LDI	XL,LOW(NOTA_C8-1)
	MOV	R0,XH
	MOV	R1,XL
	OUT	OCR1AH,XH
	OUT	OCR1AL,XL
	LDI	XH,HIGH(NOTA_C8)
	LDI	XL,LOW(NOTA_C8)

	LDI	YH,HIGH(NOTA_B7-1)
	LDI	YL,LOW(NOTA_B7-1)
	MOV	R2,YH
	MOV	R3,YL
	OUT	OCR1BH,YH
	OUT	OCR1BL,YL
	LDI	YH,HIGH(NOTA_B7)
	LDI	YL,LOW(NOTA_B7)

	CLR	R18
	CLR	R19

	LDI	R17,1<<OCIE1A|1<<OCIE1B
	OUT	TIMSK,R17
	OUT	TIFR,R17

	LDI	R16,1<<CS10		; Fo/1
	OUT	TCCR1B,R16
WAIT_BEGIN:
	SEI
WAIT:
	SLEEP
	RJMP	WAIT_BEGIN

.EXIT


 .equ step_C =  ;          8372,0
 .equ step_CD = ;    C#/Db  8869,8
 .equ step_D =  ;    D      9397,3
 .equ step_DE = ;    D#/Eb  9956,1
 .equ step_E =  ;    E     10548,0
 .equ step_F =  ;    F     11175
 .equ step_FG = ;    F#/Gb 11840
 .equ step_G =  ;    G     12544
 .equ step_GA = ;    G#/Ab 13290
 .equ step_A =  ;    A     14080
 .equ step_AH = ;    A#/Hb 14917
 .equ step_H =  ;    H     15804
