
;CodeVisionAVR C Compiler V3.12 Advanced
;(C) Copyright 1998-2014 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Build configuration    : Debug
;Chip type              : ATtiny13
;Program type           : Application
;Clock frequency        : 1,200000 MHz
;Memory model           : Tiny
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 16 byte(s)
;Heap size              : 0 byte(s)
;Promote 'char' to 'int': No
;'char' is unsigned     : Yes
;8 bit enums            : Yes
;Global 'const' stored in FLASH: Yes
;Enhanced function parameter passing: Yes
;Automatic register allocation for global variables: On
;Smart register allocation: Off

	#define _MODEL_TINY_

	#pragma AVRPART ADMIN PART_NAME ATtiny13
	#pragma AVRPART MEMORY PROG_FLASH 1024
	#pragma AVRPART MEMORY EEPROM 64
	#pragma AVRPART MEMORY INT_SRAM SIZE 64
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E

	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x009F
	.EQU __DSTACK_SIZE=0x0010
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	PUSH R26
	PUSH R27
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	POP  R27
	POP  R26
	ICALL
	.ENDM

	.MACRO __CALL2EX
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	RCALL __EEPROMRDD
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R30,SPL
	IN   R31,SPH
	ADIW R30,@0+1
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1STACK
	IN   R30,SPL
	IN   R31,SPH
	ADIW R30,@0+1
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z
	MOV  R30,R0
	MOV  R31,R1
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOV  R30,R0
	MOV  R31,R1
	.ENDM

	.MACRO __GETB2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOV  R26,R0
	MOV  R27,R1
	.ENDM

	.MACRO __GETBRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _mode=R3
	.DEF _maxmode=R4
	.DEF _currentStage=R5
	.DEF _maxStage=R6
	.DEF _timer=R7
	.DEF _timer_msb=R8
	.DEF _currentPeriod=R9
	.DEF _currentPeriod_msb=R10
	.DEF _maxPeriod=R11
	.DEF _maxPeriod_msb=R12
	.DEF _currentAngle=R13

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP _ext_int0_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_compa_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_EFF:
	.DB  0x39,0x4,0x81,0x6,0x18,0x60,0x2,0xA5
	.DB  0x5A,0x8,0xC0,0xF0,0x30,0x3C,0xC,0xF
	.DB  0x3,0xC3,0x4,0x3,0xC,0x30,0xC0,0x4
	.DB  0xC3,0xF,0x3C,0xF0,0x4,0xE1,0x87,0x1E
	.DB  0x78,0x5,0x0,0xC0,0xF0,0xFC,0xFF,0x5
	.DB  0x42,0xD0,0xF4,0xFD,0xAB,0xC,0x31,0x23
	.DB  0x42,0xC4,0x8C,0x9,0x13,0x32,0x24,0x4C
	.DB  0xC8,0x90,0x11,0x33,0x0,0x33,0x0,0xCC
	.DB  0x0,0xCC,0x0,0xF0,0xF0,0xF0,0xF0,0xF
	.DB  0xF,0xF,0xF,0x0,0x1,0xFF,0x1,0x0
	.DB  0xC8
_MAPA:
	.DB  0x9,0x5,0x50,0xA,0x1,0x0,0x1,0x5
	.DB  0x1,0xA,0x1,0xF,0x1,0xA,0x1,0x5
	.DB  0x21,0x1,0x17,0xA,0x27,0xA,0x1C,0xA
	.DB  0x27,0xA,0x6,0x2,0x6,0xA,0x6,0x1E
	.DB  0x12,0x1E,0x12,0x5,0x9,0x0,0x9,0xA
_MAPM:
	.DB  0x9,0x5,0x50,0xA,0x2D,0xA,0x1,0x0
	.DB  0x1,0xF,0x21,0x1,0x3A,0x1,0x17,0xA
	.DB  0x27,0xA,0x1C,0xA,0x4C,0xA,0x27,0xA
	.DB  0x6,0x2,0x6,0xA,0x6,0x1E,0x12,0x1E
	.DB  0x12,0x5,0x9,0x0,0x9,0xA

_0x3:
	.DB  0x0,0x0,0x0,0xA

__GLOBAL_INI_TBL:
	.DW  0x04
	.DW  _Angles
	.DW  _0x3*2

_0xFFFFFFFF:
	.DW  0

#define __GLOBAL_INI_TBL_PRESENT 1

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM
	ADIW R30,1
	MOV  R24,R0
	LPM
	ADIW R30,1
	MOV  R25,R0
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM
	ADIW R30,1
	MOV  R26,R0
	LPM
	ADIW R30,1
	MOV  R27,R0
	LPM
	ADIW R30,1
	MOV  R1,R0
	LPM
	ADIW R30,1
	MOV  R22,R30
	MOV  R23,R31
	MOV  R31,R0
	MOV  R30,R1
__GLOBAL_INI_LOOP:
	LPM
	ADIW R30,1
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOV  R30,R22
	MOV  R31,R23
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x70

	.CSEG
;/**********************************************************************
; * tiny13_lights                                                      *
; *  ATtiny13   4-  . *
; *      Effects.c                  *
; **********************************************************************/
;
;//#define F_CPU 1200000UL
;#include <tiny13.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x18
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_powerdown=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#define uint8_t unsigned char
;#define uint16_t unsigned int
;
;//
;#define EL0     PORTB4       //  0
;#define EL1     PORTB3       //  1
;#define EL2     PORTB0       //  2
;#define EL3     PORTB2       //  3
;#define BUTTON  PORTB5       // 
;#define ZC      PORTB1       //   (INT0)
;
;#define BUTTON_PRESSED    (!(PINB & (1 << BUTTON)))    //  
;
;uint8_t  mode;               //  
;uint8_t  maxmode;            //   
;uint8_t  currentStage;       //   
;uint8_t  maxStage;           //   
;uint16_t timer;              //    
;uint16_t currentPeriod;      //    
;uint16_t maxPeriod;          //        
;uint8_t  currentAngle;       //    ( 0  maxAngle)
;#define  minAngle      Angles[3]     //        
;#define  risingAngle   Angles[2]     //     
;#define  fallingAngle  Angles[1]     //     
;#define  maxAngle      Angles[0]     //        
;uint8_t  angle[4];                   //    1-4 
;#define  Flags ADMUX                // ,      
;/*
;#define  pulse0 Flags.0
;#define  pulse1 Flags.1
;#define  pulse2 Flags.2
;#define  pulse3 Flags.3
;*/
;#define  AUTOB  Flags.6              // 
;#define  DIR    Flags.5              //   
;#define  SINHRO Flags.1              // 
;#define  FRSTRN Flags.0
;
;//#define halfAngle minAngle+STEPS/2
;#include <Effects.c>
;//Settings
;#define PWM_ENABLED           0      //   (  -   ,  )
;#define FILTER                20     //      (    - )
;#define AUTOBUTTON            5     //     
;#define Otstup1               10      //    (   - ,   ...
;#define Otstup2               10     //    (   - ,   ...
;#define STEPS                 100    // {48-250}   
;
;
;//Effects
;
;//PATTERNS  (  )
;//-   ,  .....
;// : =4  .
;//: 00 -  , 01 - , 11 - , 10 - 
;const uint8_t EFF[] =
;      {57,         // 0b 11 10 00 01       = 1 , 2 , 3  , 4  //ALLINCLUSIV  1 ( ...
;        4,0b10000001,0b00000110,0b00011000,0b01100000,                                             //1  VOLNA     5
;        2,0b10100101,0b01011010,                                                                   //6  KASHKA    8
;        8,0b11000000,0b11110000,0b00110000,0b00111100,0b00001100,0b00001111,0b00000011,0b11000011, //9  TWOSTEP   17
;        4,0b00000011,0b00001100,0b00110000,0b11000000,                                             //18 STEP      22
;        4,0b11000011,0b00001111,0b00111100,0b11110000,                                             //23 STEP2     27
;        4,0b11100001,0b10000111,0b00011110,0b01111000,                                             //28 PEREBEG   32
;        5,0b00000000,0b11000000,0b11110000,0b11111100,0b11111111,                                  //33 KASKADUP  38
;        5,0b01000010,0b11010000,0b11110100,0b11111101,0b10101011,                                  //39 KASKAD2   44
;       12,0b00110001,0b00100011,0b01000010,0b11000100,0b10001100,0b00001001,0b00010011,0b00110010, //45 DOLGIY    57
;          0b00100100,0b01001100,0b11001000,0b10010000,
;       17,0b00110011,0b00000000,0b00110011,0b00000000,0b11001100,0b00000000,0b11001100,0b00000000, //58 MIGMIG    75
;          0b11110000,0b11110000,0b11110000,0b11110000,0b00001111,0b00001111,0b00001111,0b00001111,0b00000000,
;        1,0b11111111,                                                                              //76 ALL_ON    77
;        1,0b00000000,                                                                              //78 ALL_OFF   79
;      200};                                                                                        //80 - RANDOM
;//  =    +        
;
;//NAME OF PATTERNS
;// ,      
;#define ALLINCLUSIV 0,
;#define VOLNA       1,
;#define KASHKA      6,
;#define TWOSTEP     9,
;#define STEP        18,
;#define STEP2       23,
;#define PEREBEG     28,
;#define KASKADUP    33,
;#define KASKAD2     39,
;#define DOLGIY      45,
;#define MIGMIG      58,
;#define ALL_ON      76,
;#define ALL_OFF     78,
;#define RANDOM      80,
;
;//  :    (  ),  (  -  ) //
;//--------------------------------------------------------------------------------------------------//
;//    
;const uint8_t MAPA[] =
;              {
;              TWOSTEP  5,
;              RANDOM   10,
;              VOLNA    0,
;              VOLNA    5,
;              VOLNA    10,
;              VOLNA    15,
;              VOLNA    10,
;              VOLNA    5,
;              KASKADUP 1,
;              STEP2    10,
;              KASKAD2  10,
;              PEREBEG  10,
;              KASKAD2  10,
;              KASHKA   2,
;              KASHKA   10,
;              KASHKA   30,
;              STEP     30,
;              STEP     5,
;              TWOSTEP  0,
;              TWOSTEP  10,
;              };
;
;//    
;const uint8_t MAPM[] =
;              {
;              TWOSTEP  5,
;              RANDOM   10,
;              DOLGIY   10,
;              VOLNA    0,
;              VOLNA    15,
;              KASKADUP 1,
;              MIGMIG   1,
;              STEP2    10,
;              KASKAD2  10,
;              PEREBEG  10,
;              ALL_ON   10,
;              KASKAD2  10,
;              KASHKA   2,
;              KASHKA   10,
;              KASHKA   30,
;              STEP     30,
;              STEP     5,
;              TWOSTEP  0,
;              TWOSTEP  10,
;              };
;uint8_t  Angles[4]={0,0,0,Otstup1};

	.DSEG
;
;void main(void)
; 0000 0035 {// Reset Source checking

	.CSEG
_main:
; .FSTART _main
; 0000 0036 if (MCUSR & (1<<EXTRF))
	IN   R30,0x34
	SBRS R30,1
	RJMP _0x4
; 0000 0037     {
; 0000 0038     // External Reset
; 0000 0039     maxmode=(sizeof(MAPM))&0xFE;
	LDI  R30,LOW(38)
	MOV  R4,R30
; 0000 003A      mode++;
	INC  R3
; 0000 003B     if(AUTOB) mode=maxmode;
	SBIC 0x7,6
	MOV  R3,R4
; 0000 003C     AUTOB=0;
	CBI  0x7,6
; 0000 003D     }
; 0000 003E if (MCUSR & ((1<<PORF)|(1<<BORF)))
_0x4:
	IN   R30,0x34
	ANDI R30,LOW(0x5)
	BREQ _0x8
; 0000 003F     {
; 0000 0040     // Power-on Reset  // Brown-Out Reset
; 0000 0041     maxmode=(sizeof(MAPA))&0xFE;
	LDI  R30,LOW(40)
	MOV  R4,R30
; 0000 0042     AUTOB=1;
	SBI  0x7,6
; 0000 0043     mode=maxmode;
	MOV  R3,R4
; 0000 0044     }
; 0000 0045 
; 0000 0046     MCUSR=0;
_0x8:
	LDI  R30,LOW(0)
	OUT  0x34,R30
; 0000 0047     /*//if ((mode&0x01)==1)
; 0000 0048     {
; 0000 0049     // Power-on Reset  // Brown-Out Reset
; 0000 004A     maxmode=(sizeof(MAPA))&0xFE;
; 0000 004B     AUTOB=1;
; 0000 004C     //FRSTRN=1;
; 0000 004D     mode++;
; 0000 004E     //mode=maxmode;
; 0000 004F     }
; 0000 0050     else
; 0000 0051     {
; 0000 0052     // External Reset
; 0000 0053     maxmode=(sizeof(MAPM))&0xFE;
; 0000 0054      mode++;
; 0000 0055     if(AUTOB) mode=maxmode;
; 0000 0056     AUTOB=0;
; 0000 0057     } */
; 0000 0058 
; 0000 0059      timer=0;
	CLR  R7
	CLR  R8
; 0000 005A 
; 0000 005B 
; 0000 005C     // Crystal Oscillator division factor: 4
; 0000 005D #pragma optsize-
; 0000 005E     CLKPR=(1<<CLKPCE);
	LDI  R30,LOW(128)
	OUT  0x26,R30
; 0000 005F     CLKPR=(0<<CLKPCE) | (2<<CLKPS0);
	LDI  R30,LOW(2)
	OUT  0x26,R30
; 0000 0060 #ifdef _OPTIMIZE_SIZE_
; 0000 0061 #pragma optsize+
; 0000 0062 #endif
; 0000 0063 
; 0000 0064     //   /:
; 0000 0065     DDRB  = 0b00011101; // PB1, PB5 - ; PB0, PB2, PB3, PB4 - 
	LDI  R30,LOW(29)
	OUT  0x17,R30
; 0000 0066     PORTB = 0b00100000; //    PB5
	LDI  R30,LOW(32)
	OUT  0x18,R30
; 0000 0067 
; 0000 0068     //   :
; 0000 0069 #if PWM_ENABLED
; 0000 006A     GIMSK=(0<<INT0) | (0<<PCIE);        //    .
; 0000 006B #else
; 0000 006C     GIFR = (1<<INTF0) | (0<<PCIF);
	RCALL SUBOPT_0x0
; 0000 006D     GIMSK= (1<<INT0)  | (0<<PCIE);        //    INT0.
; 0000 006E #endif
; 0000 006F     MCUCR = 0b00100001;        //    INT0    (   )
	LDI  R30,LOW(33)
	OUT  0x35,R30
; 0000 0070 
; 0000 0071     //   T0   10 (F=1200000/120=10000, =1/10000=100):
; 0000 0072     TCCR0A    = 0b00000010;    //  CTC (    OCR0A)
	LDI  R30,LOW(2)
	OUT  0x2F,R30
; 0000 0073     TCCR0B    = 0b00000010;    //    
	OUT  0x33,R30
; 0000 0074     OCR0A     = (3000/(STEPS+Otstup2+Otstup1))-1; //119;           //    A     ...
	LDI  R30,LOW(24)
	OUT  0x36,R30
; 0000 0075     TIMSK0    = 0b00000100;    //       OCR0A
	LDI  R30,LOW(4)
	OUT  0x39,R30
; 0000 0076 
; 0000 0077 
; 0000 0078 // Watchdog Timer initialization
; 0000 0079 // Watchdog Timer Prescaler: OSC/8k
; 0000 007A // Watchdog timeout action: Reset
; 0000 007B #pragma optsize-
; 0000 007C WDTCR=(0<<WDTIF) | (0<<WDTIE) | (0<<WDP3) | (1<<WDCE) | (1<<WDE) | (0<<WDP0);
	LDI  R30,LOW(24)
	OUT  0x21,R30
; 0000 007D WDTCR=(0<<WDTIF) | (0<<WDTIE) | (0<<WDP3) | (0<<WDCE) | (1<<WDE) | (3<<WDP0);
	LDI  R30,LOW(11)
	OUT  0x21,R30
; 0000 007E #ifdef _OPTIMIZE_SIZE_
; 0000 007F #pragma optsize+
; 0000 0080 #endif
; 0000 0081 
; 0000 0082 
; 0000 0083     #asm("sei") //  
	sei
; 0000 0084 
; 0000 0085     //  
; 0000 0086     while(1)
_0xB:
; 0000 0087     {
; 0000 0088     while(SINHRO){};
_0xE:
	SBIC 0x7,1
	RJMP _0xE
; 0000 0089     SINHRO=1;
	SBI  0x7,1
; 0000 008A 
; 0000 008B     if (AUTOB) timer++;
	SBIS 0x7,6
	RJMP _0x13
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 7,8,30,31
; 0000 008C 
; 0000 008D if (mode&0x01)
_0x13:
	SBRS R3,0
	RJMP _0x14
; 0000 008E     {
; 0000 008F     uint8_t tmp;
; 0000 0090     uint8_t i=4;
; 0000 0091     if (AUTOB)
	SBIW R28,2
	LDI  R30,LOW(4)
	ST   Y,R30
;	tmp -> Y+1
;	i -> Y+0
	SBIS 0x7,6
	RJMP _0x15
; 0000 0092         {
; 0000 0093         maxPeriod = MAPA[mode];
	MOV  R30,R3
	LDI  R31,0
	SUBI R30,LOW(-_MAPA*2)
	SBCI R31,HIGH(-_MAPA*2)
	RCALL SUBOPT_0x1
; 0000 0094         tmp = MAPA[mode-1];
	SUBI R30,LOW(-_MAPA*2)
	SBCI R31,HIGH(-_MAPA*2)
	RJMP _0x36
; 0000 0095         }
; 0000 0096     else
_0x15:
; 0000 0097         {
; 0000 0098         maxPeriod = MAPM[mode];
	MOV  R30,R3
	LDI  R31,0
	SUBI R30,LOW(-_MAPM*2)
	SBCI R31,HIGH(-_MAPM*2)
	RCALL SUBOPT_0x1
; 0000 0099         tmp = MAPM[mode-1];
	SUBI R30,LOW(-_MAPM*2)
	SBCI R31,HIGH(-_MAPM*2)
_0x36:
	LPM
	STD  Y+1,R0
; 0000 009A         };
; 0000 009B     maxPeriod++;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 11,12,30,31
; 0000 009C     maxPeriod<<=2;
	LSL  R11
	ROL  R12
	LSL  R11
	ROL  R12
; 0000 009D     maxStage  = EFF[tmp];
	LDD  R30,Y+1
	LDI  R31,0
	SUBI R30,LOW(-_EFF*2)
	SBCI R31,HIGH(-_EFF*2)
	LPM
	MOV  R6,R0
; 0000 009E     tmp =  EFF[tmp+currentStage];
	MOV  R30,R5
	LDD  R26,Y+1
	ADD  R30,R26
	LDI  R31,0
	SUBI R30,LOW(-_EFF*2)
	SBCI R31,HIGH(-_EFF*2)
	LPM
	STD  Y+1,R0
; 0000 009F     do
_0x18:
; 0000 00A0         {
; 0000 00A1         i--;
	LD   R30,Y
	SUBI R30,LOW(1)
	ST   Y,R30
; 0000 00A2         angle[i] = Angles[tmp&3];
	LD   R26,Y
	SUBI R26,-LOW(_angle)
	LDD  R30,Y+1
	ANDI R30,LOW(0x3)
	SUBI R30,-LOW(_Angles)
	LD   R30,Z
	ST   X,R30
; 0000 00A3         tmp>>=2;
	LDD  R30,Y+1
	LSR  R30
	LSR  R30
	STD  Y+1,R30
; 0000 00A4         }
; 0000 00A5     while (i);
	LD   R30,Y
	CPI  R30,0
	BRNE _0x18
; 0000 00A6     }
	ADIW R28,2
; 0000 00A7 else
	RJMP _0x1A
_0x14:
; 0000 00A8     {
; 0000 00A9     mode++;
	INC  R3
; 0000 00AA     DIR=(TCNT0&1)? 1:0;   //  
	IN   R30,0x32
	SBRS R30,0
	RJMP _0x1B
	LDI  R30,LOW(1)
	RJMP _0x1C
_0x1B:
	LDI  R30,LOW(0)
_0x1C:
	CPI  R30,0
	BRNE _0x1E
	CBI  0x7,5
	RJMP _0x1F
_0x1E:
	SBI  0x7,5
_0x1F:
; 0000 00AB     currentPeriod = 0;    //..
	CLR  R9
	CLR  R10
; 0000 00AC     currentStage = 1;
	LDI  R30,LOW(1)
	MOV  R5,R30
; 0000 00AD     if (mode>maxmode) mode=1;
	CP   R4,R3
	BRSH _0x20
	MOV  R3,R30
; 0000 00AE     };
_0x20:
_0x1A:
; 0000 00AF }
	RJMP _0xB
; 0000 00B0 }
_0x21:
	RJMP _0x21
; .FEND
;
;//  
;#if PWM_ENABLED
;void in_sinhro (void){
;PORTB &= ~((1<<EL0)|(1<<EL1)|(1<<EL2)|(1<<EL3)); //    
;#else
;interrupt [EXT_INT0] void ext_int0_isr(void){
; 0000 00B7 interrupt [2] void ext_int0_isr(void){
_ext_int0_isr:
; .FSTART _ext_int0_isr
	ST   -Y,R30
	IN   R30,SREG
	ST   -Y,R30
; 0000 00B8 #endif
; 0000 00B9  #asm("wdr")
	wdr
; 0000 00BA maxAngle = currentAngle - Otstup2; //         
	MOV  R30,R13
	SUBI R30,LOW(10)
	STS  _Angles,R30
; 0000 00BB currentAngle = 0; //   
	CLR  R13
; 0000 00BC 
; 0000 00BD GIMSK=(0<<INT0) | (0<<PCIE);
	LDI  R30,LOW(0)
	OUT  0x3B,R30
; 0000 00BE SINHRO=0;
	CBI  0x7,1
; 0000 00BF }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R30,Y+
	RETI
; .FEND
;
;// 
;interrupt [TIM0_COMPA] void timer0_compa_isr(void){
; 0000 00C2 interrupt [7] void timer0_compa_isr(void){
_timer0_compa_isr:
; .FSTART _timer0_compa_isr
	ST   -Y,R26
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00C3 #if !PWM_ENABLED
; 0000 00C4     PORTB &= ~((1 << EL0) | (1 << EL1) | (1 << EL2) | (1 << EL3)); //     
	IN   R30,0x18
	ANDI R30,LOW(0xE2)
	OUT  0x18,R30
; 0000 00C5 #endif
; 0000 00C6 
; 0000 00C7 if ( currentAngle == angle[0]) { PORTB |= (1 << EL0);}; //   ( )   1 
	LDS  R30,_angle
	CP   R30,R13
	BRNE _0x24
	SBI  0x18,4
_0x24:
; 0000 00C8 if ( currentAngle == angle[1]) { if (DIR) PORTB |= (1 << EL1); else PORTB |= (1<<EL3); }; //   (  ...
	__GETB1MN _angle,1
	CP   R30,R13
	BRNE _0x25
	SBIS 0x7,5
	RJMP _0x26
	SBI  0x18,3
	RJMP _0x27
_0x26:
	SBI  0x18,2
_0x27:
_0x25:
; 0000 00C9 if ( currentAngle == angle[2]) { PORTB |= (1 << EL2);}; //   ( )   3 
	__GETB1MN _angle,2
	CP   R30,R13
	BRNE _0x28
	SBI  0x18,0
_0x28:
; 0000 00CA if ( currentAngle == angle[3]) { if (DIR) PORTB |= (1 << EL3); else PORTB |= (1<<EL1); }; //   (  ...
	__GETB1MN _angle,3
	CP   R30,R13
	BRNE _0x29
	SBIS 0x7,5
	RJMP _0x2A
	SBI  0x18,2
	RJMP _0x2B
_0x2A:
	SBI  0x18,3
_0x2B:
_0x29:
; 0000 00CB 
; 0000 00CC if (~currentAngle) currentAngle++; else GIMSK = (1<<INT0) | (0<<PCIE); //   
	MOV  R30,R13
	COM  R30
	CPI  R30,0
	BREQ _0x2C
	INC  R13
	RJMP _0x2D
_0x2C:
	LDI  R30,LOW(64)
	OUT  0x3B,R30
; 0000 00CD 
; 0000 00CE //    :
; 0000 00CF if ( currentPeriod < maxPeriod )     //  
_0x2D:
	__CPWRR 9,10,11,12
	BRSH _0x2E
; 0000 00D0     currentPeriod++;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 9,10,30,31
; 0000 00D1 else
	RJMP _0x2F
_0x2E:
; 0000 00D2     {currentPeriod = 0; //   
	CLR  R9
	CLR  R10
; 0000 00D3 
; 0000 00D4     if ( risingAngle < maxAngle )
	RCALL SUBOPT_0x2
	CP   R26,R30
	BRSH _0x30
; 0000 00D5         {
; 0000 00D6         risingAngle++; //   
	__GETB1MN _Angles,2
	SUBI R30,-LOW(1)
	__PUTB1MN _Angles,2
; 0000 00D7         }
; 0000 00D8         else
	RJMP _0x31
_0x30:
; 0000 00D9         {
; 0000 00DA         risingAngle = minAngle; //   
	__GETB1MN _Angles,3
	__PUTB1MN _Angles,2
; 0000 00DB 
; 0000 00DC         if ( currentStage < maxStage ) currentStage++; //     
	CP   R5,R6
	BRSH _0x32
	INC  R5
; 0000 00DD             else                       currentStage=1; //     (  )
	RJMP _0x33
_0x32:
	LDI  R30,LOW(1)
	MOV  R5,R30
; 0000 00DE 		}
_0x33:
_0x31:
; 0000 00DF 	fallingAngle = maxAngle - risingAngle + minAngle;  //   
	RCALL SUBOPT_0x2
	SUB  R30,R26
	MOV  R26,R30
	__GETB1MN _Angles,3
	ADD  R30,R26
	__PUTB1MN _Angles,1
; 0000 00E0 	}
_0x2F:
; 0000 00E1 
; 0000 00E2 #if PWM_ENABLED
; 0000 00E3 if (currentAngle==(STEPS+Otstup2+Otstup1))  in_sinhro();
; 0000 00E4 #else
; 0000 00E5 if (currentAngle==(STEPS+Otstup2+Otstup1-FILTER))
	LDI  R30,LOW(100)
	CP   R30,R13
	BRNE _0x34
; 0000 00E6     {
; 0000 00E7     GIFR = (1<<INTF0) | (0<<PCIF);
	RCALL SUBOPT_0x0
; 0000 00E8     GIMSK = (1<<INT0) | (0<<PCIE);    //    INT0,
; 0000 00E9     }
; 0000 00EA #endif
; 0000 00EB 
; 0000 00EC if (timer>(AUTOBUTTON*100)) {mode++; timer=0;};   // 
_0x34:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	CP   R30,R7
	CPC  R31,R8
	BRSH _0x35
	INC  R3
	CLR  R7
	CLR  R8
_0x35:
; 0000 00ED }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R26,Y+
	RETI
; .FEND

	.DSEG
_angle:
	.BYTE 0x4
_Angles:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x0:
	LDI  R30,LOW(64)
	OUT  0x3A,R30
	OUT  0x3B,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1:
	LPM
	MOV  R11,R0
	CLR  R12
	MOV  R30,R3
	SUBI R30,LOW(1)
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2:
	__GETB2MN _Angles,2
	LDS  R30,_Angles
	RET


	.CSEG
;END OF CODE MARKER
__END_OF_CODE:
