/**********************************************************************
 * tiny13_lights                                                      *
 *  ATtiny13   4-  . *
 *      Effects.c                  *
 **********************************************************************/
 
//#define F_CPU 1200000UL
#include <tiny13.h>
#include <delay.h>
#define uint8_t unsigned char
#define uint16_t unsigned int

//
#define EL0     PORTB4       //  0
#define EL1     PORTB3       //  1
#define EL2     PORTB0       //  2
#define EL3     PORTB2       //  3
#define BUTTON  PORTB5       // 
#define ZC      PORTB1       //   (INT0)

#define BUTTON_PRESSED    (!(PINB & (1 << BUTTON)))    //  

uint8_t  mode;               //  
uint8_t  maxmode;            //   
uint8_t  currentStage;       //   
uint8_t  maxStage;           //   
uint16_t timer;              //    
uint16_t currentPeriod;      //    
uint16_t maxPeriod;          //        
uint8_t  currentAngle;       //    ( 0  maxAngle)
#define  minAngle      Angles[3]     //        
#define  risingAngle   Angles[2]     //     
#define  fallingAngle  Angles[1]     //     
#define  maxAngle      Angles[0]     //        
uint8_t  angle[4];                   //    1-4 
#define  Flags ADMUX                // ,      
/*
#define  pulse0 Flags.0
#define  pulse1 Flags.1
#define  pulse2 Flags.2
#define  pulse3 Flags.3
*/
#define  AUTOB  Flags.6              // 
#define  DIR    Flags.5              //   
#define  SINHRO Flags.1              // 
#define  FRSTRN Flags.0 

//#define halfAngle minAngle+STEPS/2
#include <Effects.c>
uint8_t  Angles[4]={0,0,0,Otstup1};

void main(void)
{// Reset Source checking  
if (MCUSR & (1<<EXTRF))
    {
    // External Reset
    maxmode=(sizeof(MAPM))&0xFE;
     mode++;
    if(AUTOB) mode=maxmode;
    AUTOB=0;
    }
if (MCUSR & ((1<<PORF)|(1<<BORF)))
    {
    // Power-on Reset  // Brown-Out Reset
    maxmode=(sizeof(MAPA))&0xFE;
    AUTOB=1;
    mode=maxmode;
    }

    MCUSR=0;    
    /*//if ((mode&0x01)==1)  
    {
    // Power-on Reset  // Brown-Out Reset
    maxmode=(sizeof(MAPA))&0xFE;
    AUTOB=1; 
    //FRSTRN=1; 
    mode++;
    //mode=maxmode;
    }
    else
    {
    // External Reset
    maxmode=(sizeof(MAPM))&0xFE;
     mode++;
    if(AUTOB) mode=maxmode;
    AUTOB=0;
    } */

     timer=0;
   

    // Crystal Oscillator division factor: 4
#pragma optsize-
    CLKPR=(1<<CLKPCE);
    CLKPR=(0<<CLKPCE) | (2<<CLKPS0);
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

    //   /:
    DDRB  = 0b00011101; // PB1, PB5 - ; PB0, PB2, PB3, PB4 - 
    PORTB = 0b00100000; //    PB5

    //   :
#if PWM_ENABLED
    GIMSK=(0<<INT0) | (0<<PCIE);        //    .
#else
    GIFR = (1<<INTF0) | (0<<PCIF);
    GIMSK= (1<<INT0)  | (0<<PCIE);        //    INT0.
#endif
    MCUCR = 0b00100001;        //    INT0    (   )

    //   T0   10 (F=1200000/120=10000, =1/10000=100):
    TCCR0A    = 0b00000010;    //  CTC (    OCR0A)
    TCCR0B    = 0b00000010;    //    
    OCR0A     = (3000/(STEPS+Otstup2+Otstup1))-1; //119;           //    A     ...
    TIMSK0    = 0b00000100;    //       OCR0A
    
       
// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/8k
// Watchdog timeout action: Reset
#pragma optsize-
WDTCR=(0<<WDTIF) | (0<<WDTIE) | (0<<WDP3) | (1<<WDCE) | (1<<WDE) | (0<<WDP0);
WDTCR=(0<<WDTIF) | (0<<WDTIE) | (0<<WDP3) | (0<<WDCE) | (1<<WDE) | (3<<WDP0);
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

    
    #asm("sei") //  

    //  
    while(1)
    {
    while(SINHRO){};
    SINHRO=1;

    if (AUTOB) timer++;

if (mode&0x01)
    {
    uint8_t tmp;
    uint8_t i=4;
    if (AUTOB)
        {
        maxPeriod = MAPA[mode];
        tmp = MAPA[mode-1];
        }
    else
        {
        maxPeriod = MAPM[mode];
        tmp = MAPM[mode-1];
        };
    maxPeriod++;
    maxPeriod<<=2;
    maxStage  = EFF[tmp];
    tmp =  EFF[tmp+currentStage];
    do
        {
        i--;
        angle[i] = Angles[tmp&3];
        tmp>>=2;
        }
    while (i);
    }
else
    {
    mode++;
    DIR=(TCNT0&1)? 1:0;   //  
    currentPeriod = 0;    //..
    currentStage = 1;
    if (mode>maxmode) mode=1;
    };
}
}

//  
#if PWM_ENABLED
void in_sinhro (void){
PORTB &= ~((1<<EL0)|(1<<EL1)|(1<<EL2)|(1<<EL3)); //    
#else
interrupt [EXT_INT0] void ext_int0_isr(void){
#endif
 #asm("wdr")
maxAngle = currentAngle - Otstup2; //         
currentAngle = 0; //   

GIMSK=(0<<INT0) | (0<<PCIE);
SINHRO=0;
}

// 
interrupt [TIM0_COMPA] void timer0_compa_isr(void){
#if !PWM_ENABLED
    PORTB &= ~((1 << EL0) | (1 << EL1) | (1 << EL2) | (1 << EL3)); //     
#endif

if ( currentAngle == angle[0]) { PORTB |= (1 << EL0);}; //   ( )   1 
if ( currentAngle == angle[1]) { if (DIR) PORTB |= (1 << EL1); else PORTB |= (1<<EL3); }; //   (  ...
if ( currentAngle == angle[2]) { PORTB |= (1 << EL2);}; //   ( )   3 
if ( currentAngle == angle[3]) { if (DIR) PORTB |= (1 << EL3); else PORTB |= (1<<EL1); }; //   (  ...

if (~currentAngle) currentAngle++; else GIMSK = (1<<INT0) | (0<<PCIE); //   

//    :
if ( currentPeriod < maxPeriod )     //  
    currentPeriod++;
else
    {currentPeriod = 0; //   

    if ( risingAngle < maxAngle )
        {
        risingAngle++; //   
        }
        else
        {
        risingAngle = minAngle; //   

        if ( currentStage < maxStage ) currentStage++; //     
            else                       currentStage=1; //     (  )
		}
	fallingAngle = maxAngle - risingAngle + minAngle;  //   
	}

#if PWM_ENABLED
if (currentAngle==(STEPS+Otstup2+Otstup1))  in_sinhro();
#else
if (currentAngle==(STEPS+Otstup2+Otstup1-FILTER))
    {
    GIFR = (1<<INTF0) | (0<<PCIF);
    GIMSK = (1<<INT0) | (0<<PCIE);    //    INT0,
    }
#endif

if (timer>(AUTOBUTTON*100)) {mode++; timer=0;};   // 
}
