﻿module vram(clk_wr, addr_w, data_w, addr_r, data_r);
  parameter ADDR_WIDTH = 12;
  parameter DATA_WIDTH = 3;
  input clk_wr;
  input [ADDR_WIDTH - 1 : 0] addr_r, addr_w;
  output [DATA_WIDTH - 1 : 0] data_r;
  input [DATA_WIDTH - 1 : 0] data_w;
  reg [DATA_WIDTH - 1 : 0] mem [0 : (1<<ADDR_WIDTH) - 1];
  assign data_r = mem[addr_r];
  always @ (posedge clk_wr) mem[addr_w] <= data_w;
endmodule
