﻿// https://raw.githubusercontent.com/afiskon/fpga-vga/master/main.sv
/* vim: set ai et ts=4 sw=4: */
`include "videoram.sv"
`default_nettype none

module video(
    input logic clkin, // input clock: 12 Mhz
    output logic hsync,
    output logic vsync,
    output logic [2:0] data,
    output logic D5,
    output r,
    output g,
    output b,
    input [12:0] addrv,
    input [2:0] pixel,
    input we,
    input [6:0] x,
    input [6:0] y
);

logic clk;

// 800x600 @ 56Hz

// 38.250 Mhz, see `icepll -i 12 -o 38`
SB_PLL40_CORE #(
    .FEEDBACK_PATH("SIMPLE"),
    .PLLOUT_SELECT("GENCLK"),
    .DIVR(4'b0000),
    .DIVF(7'b0110010),
    .DIVQ(3'b100),
    .FILTER_RANGE(3'b001),
) uut (
    .REFERENCECLK(clkin),
    .PLLOUTCORE(clk),
    .LOCK(D5), // keep this!
    .RESETB(1'b1),
    .BYPASS(1'b0)
);

parameter horiz_sync_pulse = 128;
parameter horiz_back_porch = 128;
parameter horiz_active_pixels = 800;
parameter horiz_front_porch = 32;

parameter vert_sync_pulse = 4;
parameter vert_back_porch = 14;
parameter vert_active_pixels = 600;
parameter vert_front_porch = 1;

parameter horiz_pixels = (horiz_sync_pulse + horiz_back_porch +
                          horiz_active_pixels + horiz_front_porch);
parameter horiz_vis_begin = (horiz_sync_pulse + horiz_back_porch);
parameter horiz_vis_end = (horiz_pixels - horiz_front_porch);

parameter vert_pixels = (vert_sync_pulse + vert_back_porch +
                         vert_active_pixels + vert_front_porch);
parameter vert_vis_begin = (vert_sync_pulse + vert_back_porch);
parameter vert_vis_end = (vert_pixels - vert_front_porch);

logic [11:0] hctr; // 12 bits will be enough for <= 1920x1080
logic [10:0] vctr; // 10 bits will be enough for <= 1920x1080
reg oe;
reg addr;
reg [7:0] pix;
assign addr = hctr+vctr*800;
vram vidram(we, addrw, pix, addr, {r,g,b});
always_ff @(posedge clk)
begin
	oe <= 0;
    if(hctr < horiz_pixels - 1)
    begin
        hctr <= hctr + 1;
    end
    else
    begin
        hctr <= 0;
        if(vctr < vert_pixels - 1)
        begin
            vctr <= vctr + 1;
        end
        else
        begin
            vctr <= 0;
        end
    end
    oe <= 1;
end

assign hsync = (hctr < horiz_sync_pulse) ? 0 : 1;
assign vsync = (vctr < vert_sync_pulse) ? 0 : 1;

    if(hctr >= horiz_vis_begin && hctr < horiz_vis_end &&
       vctr >= vert_vis_begin  && vctr < vert_vis_end)
    begin
        r <= ;
        g <= ;
        b <= ;
    end
end*/

endmodule
