# yosys -p "read_verilog -overwrite test.v ; hierarchy -top bus ; fsm ; techmap ; abc -lut 4; synth_ice40 ; write_blif -top bus -gates bus.blif"
function doit {
for i in cpu.sv 256fs.sv keyboard.sv video.sv bus.sv
do
yosys -p "read_verilog ${i} ; write_json ${i}.json" || exit 1
done
yosys -p "read_json cpu.sv.json 256fs.sv.json keyboard.sv.json video.sv.json bus.sv.json ; hierarchy -top bus ; fsm ; techmap ; abc -lut 4; synth_ice40 ; write_blif -top bus -gates bus.blif" || exit 1
}

doit && arachne-pnr -d 1k -P vq100 -p bus.pin bus.blif -o bus.asc && icepack bus.asc bus.bin && iceprog bus.bin
