module cpu
(
output [15:0] addr,
input  ready,
input  [255:0] cmd,
input read,
output [64:0] dout,
output [64:0] pnum,
input [64:0] din,
inout [15:0] data,
output reg we,
output wire cs,
output reg oe,
output [17:0] adr
);

assign cs = oe;

reg [63:0] ra [0:64];
wire [6:0] r1, r2, r3;
assign r1 = cmd[5:0];
assign r2 = cmd[11:6];
assign r3 = cmd[17:11];
always@(posedge ready)
if(!data)
case(cmd[255:248])
1:ra[r1] <= ra[r2] + ra[r3];
2:ra[r1] <= ra[r2] - ra[r3];
3:ra[r1] <= ra[r2] * ra[r3];
4:ra[r1] <= ra[r2] / ra[r3];
5:ra[r1] <= ra[r2] % ra[r3];
6:ra[r1] <= ra[r2] ^ ra[r3];
7:ra[r1] <= ra[r2] & ra[r3];
8:ra[r1] <= ra[r2] | ra[r3];
9:ra[r1] <= ~ra[r2];
10:ra[r1] <= cmd[68:6];
11:addr <= cmd[68:6];
12:addr <= ra[r1];
13:pnum <= ra[r1];
14:dout <= ra[r1];
15:ra[r1] <= din;
16:read<= (ra[r1]>0)?1:0;
17:we<= (ra[r1]>0)?1:0;
18:oe<= (ra[r1]>0)?1:0;
19:adr<=ra[r1];
20:data<=ra[r1];
endcase
endmodule
