module fs256(
inout sda,
output wire scl,
output [7:0] din,
input [7:0] dout,
input s,
input clk,
input reset,
input cont
);
assign scl = ~clk;
reg[2:0] count;
reg[7:0] dat;
always@(posedge reset)
if(s==1) begin
  count <= 0;
  dat <= dout;
end

always@(posedge clk)
if(s==1) begin
  if((!read) && (count < 8) && (!cont))
  begin
    sda <= dout & 1;
    dout <= dout >> 1;
    count <= count + 1;
  end
  else if((!read) && (count < 8) && (cont))
  begin
    dat <= (dat << 1) | (sda);
    count <= count + 1;
  end
  else if((read) && (count < 8) && (!cont))
  begin
    sda <= dout & 1;
    dout <= dout >> 1;
    count <= count + 1;
  end
  else if((read) && (count < 8) && (cont))
  begin
    sda <= dout & 1;
    dout <= dout >> 1;
    count <= count + 1;
  end
end

endmodule
