int BCD2DEC(int x) { return ((x)>>4)*10+((x)&0xf); }        // Процедура конвертации шестнадцатиричных в десятичные
int DEC2BCD(int x) { return (((x)/10)<<4)+((x)%10); }       // Процедура конвертации из десятичных в шестнадцатиричные
                                                            // ЕСЛИ выбран стандатрный модуль RTC то используем шину I2C с библиотекой Wire
#define I2CStart(x)   Wire.beginTransmission(x)             // Присваеваем переменной I2CStart функцию инициализации начала передачи по шине I2C(адрес)
#define I2CStop()     Wire.endTransmission()                // Присваеваем переменной I2CStop функцию инициализации конца передачи по шине I2C
#define I2CWrite(x)   Wire.write(x)                         // Присваеваем переменной I2CWrite функцию записи данных по адресу(х)
#define I2CRead()     Wire.read()                           // Присваеваем переменной I2CRead функцию чтения данных из следующей ячейки
#define I2CReq(x,y)   Wire.requestFrom(x,y)
#define I2CReady      while(!Wire.available()) {};

#define DS3231_I2C_ADDRESS 0x68                             // Адрес нашего RTC модуля 0х68
#define DS3231_I2C_ADDRESS_EEPROM 0x57                      // Адрес нашего EEPROM RTC модуля 0х57
#define DS3231_TIME    0x00                                 // Начало блока часов
#define DS3231_DOW     0x03                                 // Начало блока день недели
#define DS3231_DATE    0x04                                 // Начало блока даты
#define DS3231_MEM     0x08                                 // Начало блока пользовательских данных

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- 
void  setRTCDateTime() {                                    // УСТАНОВКА ВРЕМЕНИ И ДАТЫ (тут мы ее не используем)(секунды, минуты, часы, день недели, день месяца, месяц, (год-2000))
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_TIME);                                    // Переходим на адрес начала блока часов 0х00
  I2CWrite(DEC2BCD(second));                                // записываем секунды переведенные из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(minute));                                // записываем минуты переведенные из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(hour));                                  // записываем часы переведенные из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(dayOfWeek));                             // записываем день недели переведенный из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(day));                                   // записываем день месяца переведенный из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(month));                                 // записываем месяц переведенный из десятичных в шестнадщатиричные
  I2CWrite(DEC2BCD(year-2000));                             // записываем год без 2000 переведенный из десятичных в шестнадщатиричные
  I2CStop();                                                // Конец I2C  протокола
}
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void setRTCTime() {                                         // УСТАНОВКА ВРЕМЕНИ (секунды, минуты, часы)
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_TIME);                                    // Переходим на адрес начала блока часов 0х00
  I2CWrite(DEC2BCD(second));                                // Запись новых секунд
  I2CWrite(DEC2BCD(minute));                                // Запись новых минут
  I2CWrite(DEC2BCD(hour));                                  // Запись ноаых часов
  I2CStop();                                                // Конец I2C  протокола
}
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void setRTCTimeNotSec() {                                   // УСТАНОВКА ВРЕМЕНИ (без секунд)
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_TIME+0x01);                               // Переходим на адрес начала блока часов 0х00
  I2CWrite(DEC2BCD(minute));                                // Запись новых минут
  I2CWrite(DEC2BCD(hour));                                  // Запись ноаых часов
  I2CStop();                                                // Конец I2C  протокола
}
//---------------------------------------------------------------------------------------------------------------------------------------------
void setRTCDate() {                                         // УСТАНОВКА ДАТЫ (день, месяц, год)
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_DATE);                                    // Устанавливаем адрес даты 0х04
  I2CWrite(DEC2BCD(day));                                   // Запись значения даты в ячейку
  I2CWrite(DEC2BCD(month));                                 // Запись значения месяа в ячейку
  I2CWrite(DEC2BCD(year-2000));                             // Запись в ячейку значение года - 2000
  I2CStop();                                                // Конец I2C  протокола
}
//----------------------------------------------------------------------------------------------------------------------------------------------
void setRTCDoW() {                                          // УСТАНОВКА ДНЯ НЕДЕЛИ
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_DOW);                                     // Устанавливаем адрес ячейки где хранится наш день недели
  I2CWrite(DEC2BCD(dayOfWeek));                             // Записываем новый день недели в шестнацдатиричном формате
  I2CStop();                                                // Конец I2C  протокола
}
//----------------------------------------------------------------------------------------------------------------------------------------------
void getRTCDateTime(void) {                                 // СЧИТЫВАНИЕ ВРЕМЕНИ и ДАТЫ из RTC в (second, minute, hour, dayOfWeek, day,month, year)
  int v;                                                    // Просто временная переменная
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_TIME);                                    // Переходим на адрес начала блока часов 0х00
  I2CStop();                                                // Конец I2C  протокола
  I2CReq(DS3231_I2C_ADDRESS, 7);                            //
  I2CReady;                                                 //
  v = I2CRead() & 0x7f;                                     // считываем в переменную v - значение секунд равное 7 битам (мах=63)
  second = BCD2DEC(v);                                      // записываем в переменную секунд значение v - в десятичном формате
  v = I2CRead() & 0x7f;                                     // считываем в переменную v - значение минут равное 7 битам (мах=63)
  minute = BCD2DEC(v);                                      // записываем в переменную минут значение v - в десятичном формате
  v = I2CRead() & 0x3f;                                     // считываем в переменную v - значение часов равное 6 битам (мах=31)
  hour = BCD2DEC(v);                                        // записываем в переменную часов значение v - в десятичном формате
  v = I2CRead() & 0x07;                                     // считываем в переменную v - значение дней недели равное 3 битам (мах=7)
  dayOfWeek = BCD2DEC(v);                                   // записываем в переменную дней недели значение v - в десятичном формате
  v = I2CRead() & 0x3f;                                     // считываем в переменную v - значение дней месяца равное 6 битам (мах=31)
  day = BCD2DEC(v);                                         // записываем в переменную дней месяца значение v - в десятичном формате
  v = I2CRead() & 0x3f;                                     // считываем в переменную v - значение месяца равное 6 битам (мах=31)
  month = BCD2DEC(v);                                       // записываем в переменную месяца значение v - в десятичном формате
  v = I2CRead() & 0xff;                                     // считываем в переменную v - значение года равное 8 битам (мах=255)
  year = BCD2DEC(v) + 2000;                                 // записываем в переменную года значение v - в десятичном формате + 2000
  I2CStop();                                                // Конец I2C  протокола
}
//------------------------------------------------------------------------------------------------------------------------------------------------
void writeRTCMem(unsigned char addr, byte val) {            // ЗАПИСЬ В ПЯМЯТЬ RTC к примеру будильники
//Serial.print("write addr = ");Serial.println(addr);
  if(addr < 6){                                             // Выше 5 ячейки пишем во флеш память
    I2CStart(DS3231_I2C_ADDRESS);                           // Адрес нашего RTC модуля 0х68
    I2CWrite(DS3231_MEM + addr);                            // Переходим на начало блока пользовательских данных + наша ячейка
    I2CWrite(val);                                          // Записываем данные в нашу ячейку
    I2CStop();                                              // Конец I2C  протокола
  }
  else {
  Wire.beginTransmission(DS3231_I2C_ADDRESS_EEPROM);        // I2CStart(DS3231_I2C_ADDRESS_EEPROM);
  Wire.write((int)((addr - 6) >> 8));                       // I2CWrite(DS3231_MEM + addr);
  Wire.write((int)((addr - 6) & 0xFF));
  Wire.write(val);                                          // I2CWrite(val);
  Wire.endTransmission();                                   // I2CStop();
  }
}
//-------------------------------------------------------------------------------------------------------------------------------------------------
byte readRTCMem(byte addr) {                                // ЧТЕНИЕ ИЗ ПАМЯТИ RTC (область пользователя)
//  Serial.print("read addr = ");Serial.print(addr);
//  if(addr>56) return 0;                                   // нельзя считать выше 56 ячейки
  if (addr < 6){
  I2CStart(DS3231_I2C_ADDRESS);                             // Адрес нашего RTC модуля 0х68
  I2CWrite(DS3231_MEM + addr);                              // Переходим на начало блока пользовательских данных + наша ячейка
  I2CStop();                                                // Конец I2C  протокола
  I2CReq(DS3231_I2C_ADDRESS, 1);
  I2CReady;
  unsigned char v = I2CRead();
  I2CStop();                                                // Конец I2C  протокола
  return v;
  }
  else{
  byte v = 0xFF;
  Wire.beginTransmission(DS3231_I2C_ADDRESS_EEPROM);        // I2CStart(DS3231_I2C_ADDRESS_EEPROM);
  Wire.write((int)((addr - 6) >> 8));                       // I2CWrite(DS3231_MEM + addr);
  Wire.write((int)((addr - 6) & 0xFF));
  Wire.endTransmission();                                   // I2CStop();
  Wire.requestFrom(DS3231_I2C_ADDRESS_EEPROM, 3);           // I2CReq(DS3231_I2C_ADDRESS_EEPROM, 1);
  if (Wire.available()) v = Wire.read();
  return v; 
  }
}
//--------------------------------------------------------------------------------------------------------------------------------------------------
/*float readTherm() {                                         // ЧТЕНИЕ ТЕМПЕРАТУРЫ RTC модуля(только на DS3231)
    byte temp;                                              // в виде значения с плавающей запятой.
    Wire.beginTransmission(DS3231_I2C_ADDRESS);             // Адрес нашего RTC модуля 0х68
    Wire.write(0x11);                                       // Переходмна адрес где хранится температура
    Wire.endTransmission();

    Wire.requestFrom(DS3231_I2C_ADDRESS, 2);
    temp = Wire.read();                                     // Here's the MSB
    return float(temp) + 0.25*(Wire.read()>>6);
}
*/
