/* CONNECTIONS:
 pin 11 подключаем MAX7219 DataIn
 pin 13 подключаем MAX7219 CLK
 pin 10 подключаем MAX7219 LOAD/CS
 pins A4/A5 SDA/SCL контакты RTC модуля
 pin 2 - audio на базу через резистор 220ohm, эмитер GND, speaker на коллектор и через резистор 10ohm на VCC
 pin 4 - клавиатура 1 клавишa Mode/Set
 pin 5 - клавиатура 2 клавишa "+"/Next
 pin 6 - клавиатура 3 клавишa "-"/"+1"
 pin A0 - ds18b20
 pin A1 - фоторезистор на корпус, 100К на +5в */
// NOKIA tunes:----------------------------------------------------------------------------------------------------------------------------------------------------------------------
const unsigned char mess[] PROGMEM = "Triple:d=8,o=5,b=635:c,e,g,c,e,g,c,e,g,c6,e6,g6,c6,e6,g6,c6,e6,g6,c7,e7,g7,c7,e7,g7,c7,e7,g7";
const unsigned char bday[] PROGMEM = "Happy birthday:d=4,o=5,b=125:8d.,16d,e,d,g,2f#,8d.,16d,e,d,a,2g,8d.,16d,d6,b,g,f#,2e,8c.6,16c6,b,g,a,2g";
const unsigned char alarm0[] PROGMEM = "MissionImp:d=16,o=6,b=95:32d,32d#,32d,32d#,32d,32d#,32d,32d#,32d,32d,32d#,32e,32f,32f#,32g,g,8p,g,8p,a#,p,c7,p,g,8p,g,8p,f,p,f#,p,g,8p,g,8p,a#,p,c7,p,g,8p,g,8p,f,p,f#,p,a#,g,2d,32p,a#,g,2c#,32p,a#,g,2c,a#5,8c,2p,32p,a#5,g5,2f#,32p,a#5,g5,2f,32p,a#5,g5,2e,d#,8d";
const unsigned char alarm1[] PROGMEM = "TakeOnMe:d=4,o=4,b=160:8f#5,8f#5,8f#5,8d5,8p,8b,8p,8e5,8p,8e5,8p,8e5,8g#5,8g#5,8a5,8b5,8a5,8a5,8a5,8e5,8p,8d5,8p,8f#5,8p,8f#5,8p,8f#5,8e5,8e5,8f#5,8e5,8f#5,8f#5,8f#5,8d5,8p,8b,8p,8e5,8p,8e5,8p,8e5,8g#5,8g#5,8a5,8b5,8a5,8a5,8a5,8e5,8p,8d5,8p,8f#5,8p,8f#5,8p,8f#5,8e5,8e5";
const unsigned char alarm2[] PROGMEM = "Mission Impossible:d=32,o=5,b=125:d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,e6,f#6,d#6,8g.6,8g.,8g.,8a#,8c6,8g.,8g.,8f,8f#,8g.,8g.,8a#,8c6,8g.,8g.,8f,8f#,16a#6,16g6,2d6,16a#6,16g6,2c#6,16a#6,16g6,2c6,16a#,8c.6,4p,16a#,16g,2f#6,16a#,16g,2f6,16a#,16g,2e6,16d#6,8d.6";
const unsigned char alarm3[] PROGMEM = "Popcorn:d=4,o=5,b=160:8c6,8a#,8c6,8g,8d#,8g,c,8c6,8a#,8c6,8g,8d#,8g,c,8c6,8d6,8d#6,16c6,8d#6,16c6,8d#6,8d6,16a#,8d6,16a#,8d6,8c6,8a#,8g,8a#,c6";
const unsigned char alarm4[] PROGMEM = "Smurfs:d=32,o=5,b=200:4c#6,16p,4f#6,p,16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,16a#,p,8f#,p,8a#,p,4g#,4p,g#,p,a#,p,b,p,c6,p,4c#6,16p,4f#6,p,16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,16a#,p,8b,p,8f,p,4f#";
const unsigned char alarm5[] PROGMEM = "Indiana:d=4,o=5,b=250:e,8p,8f,8g,8p,1c6,8p.,d,8p,8e,1f,p.,g,8p,8a,8b,8p,1f6,p,a,8p,8b,2c6,2d6,2e6,e,8p,8f,8g,8p,1c6,p,d6,8p,8e6,1f.6,g,8p,8g,e.6,8p,d6,8p,8g,e.6,8p,d6,8p,8g,f.6,8p,e6,8p,8d6,2c6";
const unsigned char alarm6[] PROGMEM = "Entertainer:d=4,o=5,b=140:8d,8d#,8e,c6,8e,c6,8e,2c.6,8c6,8d6,8d#6,8e6,8c6,8d6,e6,8b,d6,2c6,p,8d,8d#,8e,c6,8e,c6,8e,2c.6,8p,8a,8g,8f#,8a,8c6,e6,8d6,8c6,8a,2d6";
//const unsigned char alarm7[] PROGMEM = "Muppets:d=4,o=5,b=250:c6,c6,a,b,8a,b,g,p,c6,c6,a,8b,8a,8p,g.,p,e,e,g,f,8e,f,8c6,8c,8d,e,8e,8e,8p,8e,g,2p,c6,c6,a,b,8a,b,g,p,c6,c6,a,8b,a,g.,p,e,e,g,f,8e,f,8c6,8c,8d,e,8e,d,8d,c";
//const unsigned char alarm8[] PROGMEM = "Xfiles:d=4,o=5,b=125:e,b,a,b,d6,2b.,1p,e,b,a,b,e6,2b.,1p,g6,f#6,e6,d6,e6,2b.,1p,g6,f#6,e6,d6,f#6,2b.,1p,e,b,a,b,d6,2b.,1p,e,b,a,b,e6,2b.,1p,e6,2b.";
//const unsigned char alarm9[] PROGMEM = "Looney:d=4,o=5,b=140:32p,c6,8f6,8e6,8d6,8c6,a.,8c6,8f6,8e6,8d6,8d#6,e.6,8e6,8e6,8c6,8d6,8c6,8e6,8c6,8d6,8a,8c6,8g,8a#,8a,8f";
//const unsigned char alarm10[] PROGMEM = "20thCenFox:d=16,o=5,b=140:b,8p,b,b,2b,p,c6,32p,b,32p,c6,32p,b,32p,c6,32p,b,8p,b,b,b,32p,b,32p,b,32p,b,32p,b,32p,b,32p,b,32p,g#,32p,a,32p,b,8p,b,b,2b,4p,8e,8g#,8b,1c#6,8f#,8a,8c#6,1e6,8a,8c#6,8e6,1e6,8b,8g#,8a,2b";
//const unsigned char alarm11[] PROGMEM = "Bond:d=4,o=5,b=80:32p,16c#6,32d#6,32d#6,16d#6,8d#6,16c#6,16c#6,16c#6,16c#6,32e6,32e6,16e6,8e6,16d#6,16d#6,16d#6,16c#6,32d#6,32d#6,16d#6,8d#6,16c#6,16c#6,16c#6,16c#6,32e6,32e6,16e6,8e6,16d#6,16d6,16c#6,16c#7,c.7,16g#6,16f#6,g#.6";
//const unsigned char alarm12[] PROGMEM = "MASH:d=8,o=5,b=140:4a,4g,f#,g,p,f#,p,g,p,f#,p,2e.,p,f#,e,4f#,e,f#,p,e,p,4d.,p,f#,4e,d,e,p,d,p,e,p,d,p,2c#.,p,d,c#,4d,c#,d,p,e,p,4f#,p,a,p,4b,a,b,p,a,p,b,p,2a.,4p,a,b,a,4b,a,b,p,2a.,a,4f#,a,b,p,d6,p,4e.6,d6,b,p,a,p,2b";
//const unsigned char alarm13[] PROGMEM = "StarWars:d=4,o=5,b=45:32p,32f#,32f#,32f#,8b.,8f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32e6,8c#.6,32f#,32f#,32f#,8b.,8f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32e6,8c#6";
//const unsigned char alarm14[] PROGMEM = "GoodBad:d=4,o=5,b=56:32p,32a#,32d#6,32a#,32d#6,8a#.,16f#.,16g#.,d#,32a#,32d#6,32a#,32d#6,8a#.,16f#.,16g#.,c#6,32a#,32d#6,32a#,32d#6,8a#.,16f#.,32f.,32d#.,c#,32a#,32d#6,32a#,32d#6,8a#.,16g#.,d#";
//const unsigned char alarm15[] PROGMEM = "TopGun:d=4,o=4,b=31:32p,16c#,16g#,16g#,32f#,32f,32f#,32f,16d#,16d#,32c#,32d#,16f,32d#,32f,16f#,32f,32c#,16f,d#,16c#,16g#,16g#,32f#,32f,32f#,32f,16d#,16d#,32c#,32d#,16f,32d#,32f,16f#,32f,32c#,g#";
//const unsigned char alarm16[] PROGMEM = "A-Team:d=8,o=5,b=125:4d#6,a#,2d#6,16p,g#,4a#,4d#.,p,16g,16a#,d#6,a#,f6,2d#6,16p,c#.6,16c6,16a#,g#.,2a#";
//const unsigned char alarm17[] PROGMEM = "Flinstones:d=4,o=5,b=40:32p,16f6,16a#,16a#6,32g6,16f6,16a#.,16f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c6,d6,16f6,16a#.,16a#6,32g6,16f6,16a#.,32f6,32f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c6,a#,16a6,16d.6,16a#6,32a6,32a6,32g6,32f#6,32a6,8g6,16g6,16c.6,32a6,32a6,32g6,32g6,32f6,32e6,32g6,8f6,16f6,16a#.,16a#6,32g6,16f6,16a#.,16f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c.6,32d6,32d#6,32f6,16a#,16c.6,32d6,32d#6,32f6,16a#6,16c7,8a#.6";
//const unsigned char alarm18[] PROGMEM = "Jeopardy:d=4,o=6,b=125:c,f,c,f5,c,f,2c,c,f,c,f,a.,8g,8f,8e,8d,8c#,c,f,c,f5,c,f,2c,f.,8d,c,a#5,a5,g5,f5,p,d#,g#,d#,g#5,d#,g#,2d#,d#,g#,d#,g#,c.7,8a#,8g#,8g,8f,8e,d#,g#,d#,g#5,d#,g#,2d#,g#.,8f,d#,c#,c,p,a#5,p,g#.5,d#,g#";
//const unsigned char alarm19[] PROGMEM = "Gadget:d=16,o=5,b=50:32d#,32f,32f#,32g#,a#,f#,a,f,g#,f#,32d#,32f,32f#,32g#,a#,d#6,4d6,32d#,32f,32f#,32g#,a#,f#,a,f,g#,f#,8d#";
//const unsigned char alarm20[] PROGMEM = "MahnaMahna:d=16,o=6,b=125:c#,c.,b5,8a#.5,8f.,4g#,a#,g.,4d#,8p,c#,c.,b5,8a#.5,8f.,g#.,8a#.,4g,8p,c#,c.,b5,8a#.5,8f.,4g#,f,g.,8d#.,f,g.,8d#.,f,8g,8d#.,f,8g,d#,8c,a#5,8d#.,8d#.,4d#,8d#.";
//const unsigned char alarm21[] PROGMEM = "LeisureSuit:d=16,o=6,b=56:f.5,f#.5,g.5,g#5,32a#5,f5,g#.5,a#.5,32f5,g#5,32a#5,g#5,8c#.,a#5,32c#,a5,a#.5,c#.,32a5,a#5,32c#,d#,8e,c#.,f.,f.,f.,f.,f,32e,d#,8d,a#.5,e,32f,e,32f,c#,d#.,c#";
//const unsigned char alarm22[] PROGMEM = "The Simpsons:d=4,o=5,b=160:c.6,e6,f#6,8a6,g.6,e6,c6,8a,8f#,8f#,8f#,2g,8p,8p,8f#,8f#,8f#,8g,a#.,8c6,8c6,8c6,c6";
//------------------------------------------------MAX7219 matrices----------------------------------------------------------------------------------------
#define NUM_MAX          4                         // Устанавливаем количество наших модулей с LED 8х8
#define DIN_PIN          11//D7//                        //
#define CS_PIN           10//D8//                        //
#define CLK_PIN          13//D5//                        //
//------------------------------------------------Kлавиатура, динамик, термистор, фоторезистор------------------------------------------------------------
#define BUTTON_1         4                         // Пин клавиши 1
#define BUTTON_2         5                         // Пин клавиши 2
#define BUTTON_3         6                         // Пин клавиши 3
#define AUDIO_PIN        2                         // Аудио пин
#define ONE_WIRE_PIN     A0                        // пин для подключения DS18B20
#define BRIGHT_PIN       A1                        // Пин фоторезистора
//------------------------------------------------Кукушка, Оповещения Дней рождения-----------------------------------------------------------------------
#define CHIME_START      7                         // от этого часа каждый час будет сигнал
#define CHIME_END        22                        // после этого часа ежечасного сигнала не будет
#define BDAY_START       15                        // С этого часа будет звуковое оповещение специального дня
#define BDAY_END         22                        // Конец оповещений специального дня
//------------------------------------------------Дневное врем, будильники--------------------------------------------------------------------------------
#define DAY_START        7                         // Время начала дневного режима
#define DAY_END          22                        // Время начала ночного режима
#define AMOUNT_ALARM     4                         // КОЛИЧЕСТВО БУДИЛЬНИКОВ (00-99) имейте совесь с количеством, вам же их потом настраивать)))



//------------------------------------------------Начальные установки будильников, времени и даты, позднее будут считаны из памяти модуля RTC-------------
int hourAlarm[AMOUNT_ALARM],minuteAlarm[AMOUNT_ALARM],modeAlarm[AMOUNT_ALARM];
int hour=22,minute=55,second=0;                    //
int year=2020,month=1,day=7,dayOfWeek=5;            //
//------------------------------------------------Подключаем библиотеки внешние и в наших закладках-------------------------------------------------------
#include <Wire.h>                                  // Подключаем библиотеку I2C
#include "rtc.h"                                   // Подключаем нашу библиотеку часов
#include "audio.h"                                 // Подключаем нашу библиотеку аудио
#include "max7219.h"                               // Подключаем нашу библиотеку вывода на экран
#include "fonts.h"                                 // Подключаем нашу библиотеку шрифтов
#include <OneWire.h>
#include <EEPROM.h>
// -----------------------------------------------К переменным режимов привязываем значения---------------------------------------------------------------
#define CLOCKBIG    0                              // mode 1  (22:55) Большие часы 
#define CLOCKBIG1   1                              // mode 1  (22:55) Большие часы
#define CLOCKMED    2                              // mode 2  (22:55_04)-  переберает режимы по списку АВТО
#define CLOCKMED1   3                              // mode 3  (22:55_04) 
#define CLOCK       4                              // mode 4  (22:55_04)-  переберает режимы по списку АВТО
#define CLOCK1      5                              // mode 5  (22:55_04) 
#define TEMP        6                              // mode 6  (+20,7oC)
#define CLOCKBIGJMP 7                              // mode 7  (большие часы летают по экрану)
#define DATEClock   8                              // mode 8  дата
#define SPECIAL     9                              // дата или печатает текст специального дня
#define TEXT        10                             // текст специального дня
#define INIT_KEY    50                             // ключ первого запуска. 0-254, на выбор
#define INIT_ADDR 1023                             // номер резервной ячейки



//------------------------------------------------ Инициализируем переменные-------------------------------------------------------------------------------
OneWire oneWire(ONE_WIRE_PIN);
bool alarme=false;                                 // флаг включенного будильника Нужен для отображения разного стиля точек на бигклоке)))
int dx=0;                                          // начальные координаты на светодиодной матрице
int dy=0;                                          // --//--
int alarmCnt=0;                                    // 0 - не воспроизводим мелодию звонка. ксли больше "0" - то это количество проиграшей мелодии
int h1,h0,m1,m0,s1,s0,secFr,lastSec=1,lastMin=0;   // h1 - десятки часов, h0 - еденицы часов и так далее, secFr- минутный цикл,
int d1, d0, mn1, mn0, y1, y0, dw, lastDay=-1;      // d1 - десятки дней, d0 - еденицы дней и так далее...
int  lasth1, lasth0 ,lastm1, lastm0 ,lasts1 , lasts0 ; 
int mode, prevMode;                            // моде - режим вывода на экран, превмоде - предыдущий режим
int stx=1, sty=1;                                  // напавление смещения для скачущего дисплея
int st=1;                                          // направление смещения экранов -1 или +1
int disp, prevDisp;                            // номер текущего дисплея и предыдущего дисплея
int tr1=0, tr2=0;                                  // временные координаты "х" старого и нового дисплея
int trdisp1=1, trdisp2=1;                          // временный дисплеи для режима смены дисплеев
int trans=0, prevTrans=0;                          // переменные для формирования числа 1-4 исп. для смены стиля режмимов дисплея (влево, вправо, сверху, снизу)
int dots=0;                                        // необходима для мигания точек каждые 0,5 секунд
int dots2=0;                                       // меняет значение каждую секунду
float temp;                                      // Переменная температуры
uint32_t startTime;                                // какая то задержка 0,025 сек
int setMode=0;                                     // режим настройки 0-выключен, 1-часы, 2-дата, 3-день недели, 4-будильники, 5-яркость экрана
int key=0;                                         // в зависимости от нажатых клавиш принимает значение 0, 1, 2, 3 - по номерам кнопок
int keyOld=0;                                      // старое значение нажатой клавиши
int keySpeed=0;                                    // переменная задает скорость повтора нажатых клавиш
int brightSet=0;                                  // яркость экрана 0-15, 16-автоматическая рег., 17-день/ночь
unsigned long now;                                 // переменная для счетчиков реального времени


const int timerMenu=10000;                         // время (в мс) перед автоматическим выходом из режима настроек
static unsigned long oldMillis = 0;
static int shag = 0;
unsigned long nov; 


byte dispTab[20] = {                                 // CLOCKBIG, CLOCKMED, CLOCK, DATE, DATE1, DATE2, TEMP, CLOCKBIG(1),SPECIAL, 
CLOCKBIG,CLOCKBIG,CLOCKBIG,DATEClock,
CLOCKBIG,CLOCKBIG,CLOCKBIG,CLOCKBIG,
CLOCKBIG,CLOCKBIG,CLOCKBIG,TEMP,
CLOCKBIG,CLOCKBIG,CLOCKBIG,CLOCKBIG,
CLOCKBIG,CLOCKBIG,CLOCKBIG,SPECIAL
};

byte dispTab1[20] = {                               // CLOCKBIG, CLOCKMED, CLOCK, DATE, DATE1, DATE2, TEMP, CLOCKBIG(1),SPECIAL, 
CLOCKMED,CLOCKMED,CLOCKMED,DATEClock, 
CLOCKMED,CLOCKMED,CLOCKMED,TEMP,
CLOCKMED,CLOCKMED,CLOCKMED,DATEClock,
CLOCKMED,CLOCKMED,CLOCKMED,TEMP,
CLOCKMED,CLOCKMED,CLOCKMED,SPECIAL
};

byte dispTab2[20] = {                               // CLOCKBIG, CLOCKMED, CLOCK, DATE, DATE1, DATE2, TEMP, CLOCKBIG(1),SPECIAL, 
CLOCK,CLOCK,CLOCK,DATEClock, 
CLOCK,CLOCK,CLOCK,TEMP,
CLOCK,CLOCK,CLOCK,DATEClock,
CLOCK,CLOCK,CLOCK,TEMP,
CLOCK,CLOCK,CLOCK,SPECIAL

};

byte dispTab2155[20] = {                           //
CLOCKBIG,TEXT,TEXT,CLOCKBIG,TEXT,TEXT,             //
CLOCKBIG,TEXT,TEXT,CLOCKBIG,TEXT,TEXT,             //
CLOCKBIG,TEXT,TEXT,CLOCKBIG,TEXT,TEXT,             //
CLOCKBIG,CLOCKBIG                                  //
};                                                 //

//------------------------------------------------ void SETUP----------------------------------------------------------------------------------------------
void setup(){                                      //
  Serial.begin (115200);                             //
  pinMode(AUDIO_PIN, OUTPUT);                      //
  digitalWrite(BUTTON_1, HIGH);                    //
  digitalWrite(BUTTON_2, HIGH);                    //
  digitalWrite(BUTTON_3, HIGH);                    //
  initMAX7219();                                   //
  eeprom ();
  clrAll();                                        //
  refreshAll();                                    //
  sendCmdAll(CMD_SHUTDOWN,1);                      //
  sendCmdAll(CMD_INTENSITY,10);                     // Яркость свечения при старте (0-5)
  Wire.begin();                                    //
  for(int i=0; i<AMOUNT_ALARM; i++){               // Загружаем из памяти RTC модуля значения будильников в переменные
    hourAlarm[i]=readRTCMem(i*3);                  //
    minuteAlarm[i]=readRTCMem(i*3+1);              //
    modeAlarm[i]=readRTCMem(i*3+2);                //
    Serial.print(i);Serial.print("\t");Serial.print(hourAlarm[i]);Serial.print("\t");Serial.print(minuteAlarm[i]);Serial.print("\t");Serial.println(modeAlarm[i]);
  }                                                //
  playChime();                                     // Два пика))
  playRTTTL(mess);                                 // при подачи питания сыграет мелодию
      clrAll();                                    //
      showString(1, "Ghbdtn");                     // Выводим на дисплей "Привет"
      refreshAll();                                //
      delay(3000);                                  //
}

//-------------------------------------------------------------------------------------------------------------------------
void eeprom () {
  if (EEPROM.read(INIT_ADDR) != INIT_KEY) {              // первый запуск
    EEPROM.write(INIT_ADDR, INIT_KEY);                   // записали ключ
    int brightSet = 17;                                  // яркость экрана 0-15, 16-автоматическая рег., 17-день/ночь
    int mode = 3;                                        // моде - режим вывода на экран
    EEPROM.update(0, brightSet);                         // записали по адресу 0
    EEPROM.update(1, mode);                              // записали по адресу 1

  }
  
  // --------------------------- загрузить данные из eeprom ----------------------------------

     brightSet = EEPROM.read(0);      // прочитали яркость
     mode = EEPROM.read(1);           // прочитали режим
 }      
      
//----------------------------------------------------------------------------------------- 
//------------------------------------------------ ПРОЦЕДУРА ОПРОСА КЛАВИШ (кнопок)------------------------------------------------------------------------
void klav(){                                       //
  key=0;                                           //
  if(digitalRead(BUTTON_1)==LOW) key=1;            // опрашиваем клавишу 1 и если нажата переменной присваиваем 1
  if(digitalRead(BUTTON_2)==LOW) key=2;            // тоже самое для клавиши 2
  if(digitalRead(BUTTON_3)==LOW) key=3;            // тоже длч клавиши 3, при чем если нажаты все одновременно - результат будет 3
  if(key!=0){                                      // есил клавиши нажаты 
    delay(keySpeed<8? 200:20);                     // устанавливаем паузу между между опросами 
    keySpeed++;                                    // эта переменная ружна для того что бы через 8 циклов уменьшить паузу между опрасами с 200 до 20
  }                                                //
  if(key!=keyOld) keySpeed=0;                      // если была смена клавиш то флаг скорости опросов сбрасываем в 0
  keyOld=key;                                      // в переменную предыдущего состояния клавиш записываем текущее состояние клавиш
}                                                  //

//======================================================================= void LOOP===============================================================================================
void loop(){                                                              //
  startTime=millis();                                                     //
  getRTCDateTime();                                                       // Получаем значения времени и даты
  if(secFr==0){                                                           //
    h1=hour/10;                                                           // записываем десятки часов
    h0=hour%10;                                                           // еденицы часов
    m1=minute/10;                                                         // десятки минут
    m0=minute%10;                                                         // еденицы минут
    s1=second/10;                                                         // десятки секунд
    s0=second%10;                                                         // еденицы секунд
    d1=day/10;                                                            // десятки дней
    d0=day%10;                                                            // еденицы дней
    mn1=month/10;                                                         // десятки месяца
    mn0=month%10;                                                         // еденицы месяца
    y1=(year-2000)/10;                                                    // десятки года
    y0=(year-2000)%10;                                                    // еденицы года
  }                                                                       //
  if(second!=lastSec){                                                    // проверка начала новой секунды
    lastSec=second;                                                       // в переменную сатрой секунды устанавливаем значение новой секунды
    oldMillis = nov;                                                      // в начале новой секунды сбрасываем в "0"
    shag = 0;                                                             // в начале новой секунды сбрасываем в "0"
    secFr=0;                                                              // в начале новой секунды сбрасываем в "0"
  } else secFr++;                                                         // далее просто счетчик циклов
  dots=(secFr<20)? 1:0;                                                   // dots - меняет значение каждые 0,5 сек (период 1 секунда)
  dots2=(second%2)? 1:0;                                                  // dots2 - меняет значение при смене четных и не четных секунд (период 2 секунды)
   temp=readDS18B20();                                                    // Считываем значение температуры
   
  //===================================================================== Корректировка времени RTC модуля - в полночь на  -5 secs================================================
 /* if(hour==23&&minute==0&&second==0&&lastDay!=day){                      // Если наступил новый день, то
    lastDay=day;                                                        // сбрасываем переменную ластдей что бы больше проверка в этот день не выполнялась
    second=5;                                                           // корректируем секунды на 5 секунд назад
    setRTCTime();                                                       // записываем новое время в RTC модуль
  }
*/
  //===================================================================== ОПРОС КЛАВИШ========================================================================================
  klav();                                                                 // Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
  if(key==2||key==3){ //------------------------- ВХОД в режим смены режимов работы дисплея
    playSound(AUDIO_PIN,1500,60);                                         //
    if(key==2){if(++mode>7) mode=0;}                                      // выбираем следующий режим
    else if(--mode<0) mode=7;                                             // выбираем предыдущий режим
    disp=mode;                                                            //
     EEPROM.update(1, mode); 
    clrAll();                                                             //
    dx=dy=0;                                                              //
    showString(0, "Ht;bv");                                               // Выводим "Режим"
    showDigit(mode, 27, dig5x8rn);                                        // и номер режима 
                                                                          //
    refreshAll();                                                         //
    delay(500);                                                           //
  }  
   
  //------------------------------------ ВХОД  режим УСТАНОВКИ часов, будильников... 

    if(key==1){ //------------------------------------------------------- ВХОД в режим настройки времени, даты, дня недели, будильника и яркости экрана
      playChime();                                                        //
      dx=dy=0;                                                            //
      clrAll();                                                           //
      showString(1, "ECNFYJDRB");                                         // Выводим на дисплей "УСТАНОВКА"
      refreshAll();                                                       //
      delay(500);                                                         //
      setMode=1;                                                          // включаем флаг установки
      setUp();                                                            // переходим в подпрограмму установок
      key=0;                                                              //
    }                                                                     //
                                                                     //
  //===================================================================== УСТАНОВКА РЕЖИМОВ ЯРКОСТИ ЭКРАНА========================================================
  if(brightSet==16){//--------------------------------------------------- ВКЛЮЧЕНИЕ режима автоматической регулировки яркости
    if(secFr==0){                                                         // Проверка и изменение яркости каждую секунду
      int ledLevel=map(analogRead(BRIGHT_PIN), 1023, 0, 0, 15);           // Считываем показания с фоторезистора и преводим их к виду от 0 до 12
      //Serial.println(analogRead(BRIGHT_PIN));                           //
      //Serial.println(ledLevel);                                         //
      ledLevel=constrain(ledLevel, 0, 12);                                // ограничиваем верхнее значение ledLevel до 12
      sendCmdAll(CMD_INTENSITY, ledLevel);                                // Отсылаем команду на установку яркости экрана
    }                                                                     //
  }                                                                       //
  if(brightSet==17){//--------------------------------------------------- ВКЛЮЧЕНИЕ режима регулировки яркости День/Ночь
    if(hour>=DAY_START&&hour<DAY_END&&(minute!=lastMin)){                 // каждую минуту проверяем ночной режим или дневной
      sendCmdAll(CMD_INTENSITY, 10);                                       // посылаем команду на изменение яркости
      lastMin=minute;                                                     //
    }                                                                     //
    else if(minute!=lastMin){                                             // 
      sendCmdAll(CMD_INTENSITY, 0);                                       // посылаем команду на изменение яркости
      lastMin=minute;                                                     //
    }                                                                     //
  }                                                                       //
  
  //===================================================================== CТИЛЬ СМЕНЫ РЕЖИМОВ отображения дисплея=================================================
    
    
    prevDisp=disp;                                                              // сохраняем предыдущий дисплей
  
  if(mode==0){if(hour==21&&minute==55){disp=dispTab2155[second/3];prevTrans=0;} // Если режим Авто - дисплей меняется каждые 3 секунды согласно таблице дисплеев
  else disp=dispTab[second/3];}

  if(mode==1) disp=CLOCKBIG;

  if(mode==2){if(hour==21&&minute==55){disp=dispTab2155[second/3];prevTrans=0;}                                                                     //
    else disp=dispTab1[second/3];}

  if(mode==3) disp=CLOCKMED1;
  
  if(mode==4){if(hour==21&&minute==55){disp=dispTab2155[second/3];prevTrans=0;}                                                                     //
    else disp=dispTab2[second/3];}

  if(mode==5) disp=CLOCK1;  
    
  if(mode==6) disp=TEMP;

  if(mode==7) disp=CLOCKBIGJMP;

      
  
  clrAll();                                                               // очищаем данные дисплея из памяти
  if(disp!=prevDisp){                                                     // Если изменился дисплей то:
    trans=1+(prevTrans%4);                                                // формируется число от 1 до 4 
    if(disp==TEXT) trans=1;                                               //
    prevTrans=trans;                                                      // сохраняем это число до следующего цикла
    switch(trans){                                                        // переключаем стиль смены экранов согласно нашему текущему числу 1-4
      case 1:  tr1=0; tr2= 38;    st=-1; break;                           // стиль смены режимов - сдвиг в право
      case 2:  tr1=0; tr2=-38;    st=+1; break;                           // стиль смены режимов -  сдвиг в лево
      case 3:  tr1=0; tr2= 11<<1; st=-1; break;                           // стиль смены режимов -  сдвиг в верх
      case 4:  tr1=0; tr2=-11<<1; st=+1; break;                           // стиль смены режимов -  сдвиг в низ
    }                                                                     //
    trdisp1=prevDisp;                                                     // сохраняем предыдущий дисплей
    trdisp2=disp;                                                         // сохраняем текущий дисплей
    if(prevDisp==CLOCKBIGJMP||disp==CLOCKBIGJMP){                         // если хотим вывести или сменить прыгающие часы, то координаты в "0" + trans в "0"
      trans=dx=dy=0;                                                      // необходимо что бы следующий стиль у нас не поплыл с середины экрана))
    }                                                                     //
  }                                                                       //
  if(!trans) render(disp);                                                // если trans в "0" выводим новый дисплей без эфектов, просто с нуля 
  else{                                                                   // в ином случае применяем эфекты смены старого экрана на новый
    if(trans==1||trans==2) dx=tr1;                                        //
    else dy = tr1>>1;                                                     // c эфектами убираем старый дисплей
    render(trdisp1);                                                      // 
    if(trans==1||trans==2) dx=tr2;                                        //
    else dy = tr2>>1;                                                     // "накатываем" новый дисплей
    render(trdisp2);                                                      // 
    tr1+=st;                                                              // +1 или -1 к временной переменной координаты х предыдущего дисплея
    tr2+=st;                                                              // +1 или -1 к временной переменной координаты х новго диспле
    if(tr2==(disp==TEXT? 98:0)) trans=dx=dy=0;                            // если координата х нового дисплея достигла "0" то trans = 0  и координаты x и y тоже в "0"
  }                                                                       //
                                                 // записали по адресу 1
     refreshAll();                                                        // обновить дисплей из памяти
   //===================================================================== Бить куранты (chime) каждый час=============================================================================
  if(hour>=CHIME_START&&hour<CHIME_END&&minute==0&&second==0&&secFr==0) playChime(); showString(32, " ghbdtn Dfy.if ");
  //===================================================================== Напоминание знаменого часа==================================================================================
 // if(hour==22&&minute==54&&second==58&&secFr==0) playRTTTL(mess);
  //===================================================================== Поздравление в специальный день=============================================================================
  if(hour>=BDAY_START&&hour<BDAY_END&&minute==5&&disp==SPECIAL&&trans==0&&isBDay()>=0) playRTTTL(bday);
  //===================================================================== Проверка будильника=========================================================================================
  if(alarme!=false) alarme=false;                                         //
  for(int j=0; j<AMOUNT_ALARM; j++){                                      //
    if(hour==hourAlarm[j]&&minute==minuteAlarm[j]&&second==1&&(isAlarmDay()||modeAlarm[j]!=8)){  //провека выходных дней будет только если режми будильника не равен рабочим дням (пн-пя)
      if(modeAlarm[j]==0||modeAlarm[j]==dayOfWeek||(modeAlarm[j]==8&&(dayOfWeek>0&&dayOfWeek<6))||(modeAlarm[j]==9&&(dayOfWeek>5&&dayOfWeek<8))||modeAlarm[j]==10){
        if(modeAlarm[j]==10){                                             // если сработал разовый будильник
          hourAlarm[j]=24;                                                // часы устанавливаем как 24 - условие выключения будильника
          writeRTCMem((j*3),hourAlarm[j]);                                // в память RTC записываем данные часов будильника(№)
        }                                                                 //
        alarmCnt=3;                                                       //
   //    disp=CLOCKBIG;                                                    //
   //    trans=dx=dy=0;                                                    //
        playAlarm();                                                      //
      }                                                                   //
    }                                                                     //
    if(hourAlarm[j]<24) alarme=true;                                      //
  }                                                                       //
  while(millis()-startTime<25);                                           //
}                                                                         //

//======================================================================= КОНЕЦ void loop()===========================================================================================
// ---------------------------------------------------------------------- Выходные дни 
const byte noAlarmDays[] PROGMEM = {                                      //
  1,1, 20,1,                                                              // Новый год
  8,3,                                                                    // Женский день
  1,5,  9,5,                                                              // Майские праздники и день победы над Фашизмом
  23,2,              
};                                                                        //

//----------------------------------------------------------------------- Программа возвращает false если сейчас суббота, воскресение, или праздничный день
bool isAlarmDay(){                                                        //
  for(int i=0; i<sizeof(noAlarmDays)/2; i++)                              // цилк по количесту выходных дней
    if(day==pgm_read_byte(noAlarmDays+i*2)&&month==pgm_read_byte(noAlarmDays+i*2+1)) return false; // сравниваем текущий день с таблицей выходных дней если совпадает возвращаем false
  return true;                                                            // возвращаем true
}                                                                         //

//----------------------------------------------------------------------- Играем мелодию будильника
void playAlarm(){                                                         //
  while(alarmCnt>0){                                                      // цикл по количеству проигрывания мелодии звонка
    alarmCnt--;                                                           // уменьшаем переменную количества проигрываний
    klav();                                                               // опрос клавиатуры на предмет нажатия кнопки выключения будильника
    if(key==1){                                                           // проверяем нажатие кнопки "3"
      alarmCnt=0;                                                         // сбрасываем счетчик количества проигрываний
      return;                                                             // выходим из програмы проигрывания будильника
    }                                                                     //
    dots=1; trans=dx=dy=0;                                                //
    clrAll(); render(CLOCKBIG);  refreshAll();                            // выводим на экран большие часы 
    switch(dayOfWeek){                                                    // проигрвываем мелодию соответственно дню недели
      case 1: playRTTTL(alarm0); break;                                   //
      case 2: playRTTTL(alarm1); break;                                   //
      case 3: playRTTTL(alarm2); break;                                   //
      case 4: playRTTTL(alarm3); break;                                   //
      case 5: playRTTTL(alarm4); break;                                   //
      case 6: playRTTTL(alarm5); break;                                   //
      case 7: playRTTTL(alarm6); break;                                   //
    }                                                                     //
     refreshAll();                                                        //   обновляем
  }                                                                       //
}                                                                         //

// ---------------------------------------------------------------------- Двойной бип)
void playChime(){                                                         //
  playSound(AUDIO_PIN,2000,40);                                           //
  delay(200);                                                             //
  playSound(AUDIO_PIN,2000,40);                                           //
}                                                                         //

// ---------------------------------------------------------------------- Тройной бип)
void playExit(){                                                          //
  playSound(AUDIO_PIN,1500,60);                                           //
  delay(100);                                                             //
  playSound(AUDIO_PIN,1500,60);                                           //
  delay(100);                                                             //
  playSound(AUDIO_PIN,1500,60);                                           //
}                                                                         //

// ---------------------------------------------------------------------- обращаемся к функции 
float readDS18B20(){
 
    oneWire.reset();                                                      // сброс шины
    oneWire.write(0xCC);                                                  //обращение ко всем датчикам (если всего один DS18B20)
    //oneWire.select(sensorAddress);                                      // выбор конкретного адреса - если несколько DS18B20
    oneWire.write(0x44);                                                  // начать преобразование (без паразитного питания)
 
    oneWire.reset();                                                      // сброс шины
    oneWire.write(0xCC);                                                  //обращение ко всем датчикам (если всего один DS18B20)
    //oneWire.select(sensorAddress);                                      // выбор конкретного адреса - если несколько DS18B20
    oneWire.write(0xBE);                                                  // Read Scratchpad (чтение регистров)
    temp = (oneWire.read() | oneWire.read() << 8) / 16.0;                 //прочитаны 2 байта
                                                                          //
}                                                                         //

// ---------------------------------------------------------------------- ВЫВОД ТЕМПЕРАТУРЫ НА ДИСПЛЕЕ
void showTemp(){                                                          //
   if(secFr==0) temp=readDS18B20();                                        // читаем датчик DS18B20. Для DS18S20 не подходит!
   if(temp<0) showDigit(11, 0, dig5x8rn);                                 // Если температура отрицательная печатаем в начале "-"
   else showDigit(10, 0, dig5x8rn);                                       // Иначе печатаем "+"
    int t1=(int)temp/10;                                                  // число десятков
    int t0=(int)temp%10;                                                  // число едениц
    int tf=(temp-int(temp))*10.0;                                         // число десятых
    if(t1) showDigit(t1, 4, dig4x8);                                    // если десяки = "0" то не печатаем
    showDigit(t0, 9, dig4x8);                                          // печатаем еденицы
    showDigit(tf, 16, dig4x8);                                          // печатаем десятые
  setCol(14, 0xC0);                                                       // выводим запятую между целыми и десятыми градусов
  showDigit(7, 22, dweek_ru);                                               // Выводим значек градусов и "С"
}                                                                         //


//----------------------------------------------------------------------- ВЫВОД DATE
void showDate(){                                                          //
  showDigit(d1, 0, dig4x8);                                               // if(d1) 
  showDigit(d0, 5, dig4x8);                                               //
  showDigit(mn1, 12, dig4x8);                                             // if(mn1) 
  showDigit(mn0, 17, dig4x8);                                             //
  showDigit(y1, 23, dig4x8);                                              //
  showDigit(y0, 28, dig4x8);                                              // 
  setCol(10, 0x80);                                                       // выводим точку
  setCol(22, 0x80);                                                       // выводим точку
}                                                                         //

//----------------------------------------------------------------------- ВЫВОД DATE1 Херово продуман
void showDate1(){                                                         //
  if(d1) showDigit(d1, 0, dig3x8);                                        //
  showDigit(d0, 4, dig3x8);                                               //
  showDigit(mn1, 9, dig3x8);                                              // if(mn1) showDigit(mn1, 9, dig3x8);
  showDigit(mn0, 12, dig3x8);                                             //
  showDigit(2, 18, dig3x8);                                               //
  showDigit(0, 22, dig3x8);                                               //
  showDigit(y1, 26, dig3x8);                                              //
  showDigit(y0, 29, dig3x8);                                              //
  setCol(8, 0x80);                                                        // выводим точку
  setCol(16,0x80);                                                        // выводим точку
}                                                                         //

//----------------------------------------------------------------------- ВЫВОД DATE2
void showDateClock(){                                                         //
  if (d1==0 ){ showDigit(10, 0, dig4x8);}                                 // если 0 не выводим
  else{showDigit(d1, 6, dig4x8);}                                         //
  showDigit(d0, 10, dig4x8);                                              //
  if (dayOfWeek != 7) showDigit(dayOfWeek, 17, dweek_ru);                 //
  else showDigit(0, 17, dweek_ru);                                        // выводим воскресенье
}                                                                    //

//----------------------------------------------------------------------- ВЫВОД DATE2
void showDateMed(){                                                         //                                                                       //
  if (d1==0 ){ showDigit(10, 0, dig5x8rn);}                                 // если 0 не выводим
  else{showDigit(d1, 5, dig5x8rn);}                                         //
  showDigit(d0, 10, dig5x8rn);                                              //
  if (dayOfWeek != 7) showDigit(dayOfWeek, 17, dweek_ru);                 //
  else showDigit(0, 17, dweek_ru);                                        // выводим воскресенье
}                                                                         //


//----------------------------------------------------------------------- ВЫВОД ЧАСОВ полужирные часы и минуты, секунды маленькие рубленые
void showClock(){                                                  //
  if (h1 > 0) showDigit(h1, 0, dig5x8rn);                                 //
  showDigit(h0, h1==2 ? 6 : 5, dig5x8rn);                                 //
  showDigit(m1, 13, dig5x8rn);                                            //
  showDigit(m0, 19, dig5x8rn);                                            //
  showDigit(s1, 25, dig3x6);                                              //
  showDigit(s0, 29, dig3x6);                                              //
  setCol((hour==20) ? 12 : 11, dots ? 0x24 : 0);                          // 
}                                                                         //

//----------------------------------------------------------------------- ВЫВОД БОЛЬШИХ ЧАСОВ
void showClockBig(int jump=0){                                            //
  if(jump && !trans) {                                                    // если jump отличен от нуля (trans в "0")то часы будут летать
    dx+=stx; if(dx>25 || dx<-25) stx=-stx;                                //
    dy+=sty; if(dy>6 || dy<-6) sty=-sty;                                  //
    delay(40);                                                            //
  }                                                                       //
  if (h1 > 0) showDigit(h1, h1 == 2 ? 1 : 2, dig6x8);                     //
  showDigit(h0, 8, dig6x8);                                               //
  showDigit(m1, 18, dig6x8);                                              //
  showDigit(m0, 25, dig6x8);                                              //
  if (alarme == true){                                                    // если установлен будильник, выводим анимированые точки
    if ((secFr > 6 && secFr < 14) || secFr > 20)  {                       //
      setCol(15, 0x66);                                                   //
      setCol(16, 0x66);                                                   //
    }                                                                     //
    if (secFr >= 0 && secFr < 7){                                         //
      setCol(15, 0x24);                                                   //
      setCol(16, 0x42);                                                   //
    }                                                                     //
    if (secFr > 13 && secFr < 21){                                        //
      setCol(15, 0x42);                                                   //
      setCol(16, 0x24);                                                   //
    }                                                                     //
  }                                                                       //
  else{                                                                   // если будильники не установлены, просто мигаем точками
    if (dots){                                                            //
      setCol(15, 0x66);                                                   //
      setCol(16, 0x66);                                                   //
    }                                                                     //
  }                                                                       //
}                                                                         //

//----------------------------------------------------------------------- ВЫВОД ПОЛНЫХ ЧАСОВ
void showClockMed(){                                                      //
    
   /*    
    int flag = millis() % 1000;                                                  // счетчик будет считать до тысячи и все заново
    if ( flag > 500) { setCol(10, 0x24);}                                        // если флаг больше 500, рисуем точки
    */
    if (dots) setCol(10, 0x24);                                           // двоеточие выводится когда dots отличен от "0"

      
    if (s0 != lasts0){showDigit( s0 * 12 + shag, 28, dig3x7q);}          // s0 * 12 + q - номер строки в масиве dig3x7q (смотрим вкладку "fonts.h")
    else showDigit(s0, 28, dig3x7s);                                     // s0 - номер строки в масиве dig3x7s (смотрим вкладку "fonts.h")

    if (s1 != lasts1) showDigit( s1 * 12 + shag, 24, dig3x7q);           //24- позиция экрана с которой начинать печать
    else showDigit(s1, 24, dig3x7s);                                     //24- позиция экрана с которой начинать печать
     
    if (m0 != lastm0) showDigit( m0 * 12 + shag, 17, dig4x8q);           // dig3x7q - указатель на масив данных (смотрим вкладку "fonts.h")
    else showDigit(m0, 17, dig4x8);                                      // dig4x8 - указатель на масив данных  (смотрим вкладку "fonts.h")
   
    if (m1 != lastm1) showDigit( m1 * 12 + shag, 12, dig4x8q);           // (m1 != lastm1)- проверяем изменилась цифра или нет
    else  showDigit(m1, 12, dig4x8);
 
    if (h0 != lasth0) showDigit( h0 * 12 + shag, 5, dig4x8q);
    else showDigit(h0, 5, dig4x8);
       
    if (h1>0){
    if (h1 != lasth1)showDigit( h1 * 12 + shag, 0, dig4x8q);
    else showDigit(h1, 0, dig4x8);}
    
    refreshAll(); // обновляем экран после каждой строки  
  
     unsigned long nov = millis();
     if (nov - oldMillis >= 75) {
      shag++; Serial.print(nov - oldMillis); 
     oldMillis = nov; 
      }
  if (shag >= 12) { shag=0; lasth1 = h1; lasth0 = h0; lastm1 = m1; lastm0 = m0; lasts1 = s1; lasts0 = s0;} 
}


//------------------------------------------------------------------ВЫВОД ТЕКСТОВЫХ СООБЩЕНИЙ (бегущая строка)
void showText(){                                                          //
  showString(32, " cgjrjqyjq yjxb  ");     //
}  


// ---------------------------------------------------------------------- Програмы перебора режимов вывода на экран
void render(int d){                                                       //
  switch(d) {                                                             //
    case CLOCKBIG:    showClockBig(); break;
    case CLOCKBIG1:    showClockBig(); break;                             // Большие цифры без секунд                    
    case CLOCKMED:    showClockMed(); break;                              // Большие цифры без секунд 
    case CLOCKMED1:   showClockMed(); break;                              // простые цифровые часы с маленькими секундами
    case CLOCK:       showClock(); break;                                 // простые цифровые часы с маленькими секундами
    case CLOCK1:      showClock(); break;                                 // простые цифровые часы с маленькими секундами
    case TEMP:        showTemp(); break;                                  // Температура
    case CLOCKBIGJMP: showClockBig(1); break;                             // Большие цифры без минут скачут по экрану
    case DATEClock:   showDateClock(); break;                                 // 28. 3.пон
    case SPECIAL:     showSpecial(); break;                               // Специальная дата
    case TEXT:        showText(); break;                                  // Бегущая строка
   
  }                                                                       //
}
// ---------------------------------------------------------------------- Ставьте ниже специальные дни, праздники, дни рождения и т. Д.
const byte specialDays[] PROGMEM = {                                      //
  1, 1, // НовыйГод                                                      //
  20,1, // ДР_Яны                                                        //
  29,9, // ДР_Леры                                                       //
  1, 5, // ДР_Риты                                                       //
  26,6,
  13,8
 };                                                                        //

// ---------------------------------------------------------------------- Текст выводимый в специальный день
char specialText[][8] = {                                                 //
  "YjdsqUjl",                                                             //
  "LH_gfgf",                                                           //
  "LH_,f,f",                                                              //
  "LH_vfvf",
  "LH_Bkmz",   
  "LH_Dfyz"
};                                                                        //
// ---------------------------------------------------------------------- Програма возвращаее -1 если день не праздничный
int isBDay(){                                                             //
  for(int i=0; i<sizeof(specialDays)/2; i++)                              //
    if(day==pgm_read_byte(specialDays+i*2)&&month==pgm_read_byte(specialDays+i*2+1)) return i;
  return -1;                                                              //
}                                                                         //

// ---------------------------------------------------------------------- Выводим текст специального дня в специальный день, в другой день, выводим температуру
void showSpecial(){                                                       // 
  int bd = isBDay();                                                      //
  if(bd < 0) showTemp();                                              //
  else showString(0, specialText[bd]);                                    //
}                                                                         //

// ---------------------------------------------------------------------- Выводим символ из блока фонтов
void showDigit(char ch, int col, const uint8_t *data) {                   // ch- номер строки в масиве; col- позиция экрана с которой начинать печать; *data- указатель на масив данных
  if(dy<-8||dy>8) return;                                                 //
  int len=pgm_read_byte(data);                                            // len - это количество символов в строке нашашего масива, считываем первый байт из масива и записываем его в len
  int w=pgm_read_byte(data+1+ch*len);                                     // w - (ссылка намасив + 1 (первый байт)  + номер строки умноженный на длину строк) - считываем первый байт из нужной строки    
  col+=dx;                                                                // наша позиция для вывода + dx???
  for(int i=0; i<w; i++)                                                  // запускаем цикл размерностью нашего первого байта из нашей строки (размерность символа)
    if(col+i>=0&&col+i<NUM_MAX*8) {                                       // Если наша новая позиция + i больше ноля и меньше количества точек в строке нашего экрана, то
      byte v=pgm_read_byte(data+1+ch*len+1+i);                            // в v - считываем следующий байт из нашей строки масива
      if(!dy) scr[col+i].byte_data=v;                                     //
      else scr[col+i].byte_data |= dy>0 ? v>>dy : v<<-dy;                 // если dy(0) 
    }                                                                     //
}                                                                         //
// ---------------------------------------------------------------------- Выводим символ
int showChar(char ch, int col, const uint8_t *data){                      // 112 - позиция русской А, col =0, data = font
  int len=pgm_read_byte(data);                                            // = 6 
  int i,w=pgm_read_byte(data+1+ch*len);                                   //
  if(dy<-8||dy>8) return w;                                               //
  col+=dx;                                                                //
  for(i=0; i<w; i++)                                                      //
    if(col+i>=0&&col+i<NUM_MAX*8){                                        //
      byte v=pgm_read_byte(data+1+ch*len+1+i);                            //
      if(!dy) scr[col+i].byte_data=v;                                     //
      else scr[col+i].byte_data |= dy>0 ? v>>dy : v<<-dy;                 //
    }                                                                     //
  return w;                                                               //
}                                                                         //

// ---------------------------------------------------------------------- Печатаем текст
void showString(int x, char *s) {                                         // в х координаты начала текста (0-31), s - ссылка на масив символов.
  while(*s) {                                                             // запускаем цикл пока s не будет равна "0"
    unsigned char c = *s++;                                               //
    c -= 32;                                                              // наша таблица символов не содержит первых 32 символа по этому и - 32
    int w = showChar(c, x, font_ru);                                      // в W возвращаем значение из функции showChar (значение символа, где его печатать, какой шрифт)
    x += w + 1;                                                           // к координате прибавляем возвратное значение w (количество строк нашего символа + 1 пробел между символами)
  }                                                                       //
}                                                                         //

// ---------------------------------------------------------------------- Печатаем значение v в столбец col
void setCol(int col, byte v){                                             //
  if(dy <- 8 | dy > 8) return;                                            //
  col += dx;                                                              //
  if(col >= 0 && col < 32)                                                //
    if(!dy) scr[col].byte_data = v; else scr[col].byte_data |= dy > 0 ? v >> dy : v << -dy;
}                                                                         //


//----------------------------------------------------------------------- УСТАНОВКА ЧАСОВ, ДАТЫ, ДНЯ НЕДЕЛИ, БУДИЛЬНИКОВ, ЯРКОСТИ
void setUp(){                                                             //
  now = millis();                                                         // сбарсываем переменную счета таймера в (миллис)
  while (millis()-now < timerMenu){                                       // запускаем таймер
    clrAll();                                                             //
    switch(setMode){                                                      // Выводим на экран надпись в соответствии с режимом
        case 1: showString(1, "Dhtvz"); break;                            // Печатаем "Время";
        case 2: showString(1, "Lfnf"); break;                             // Печатаем "Дата";
        case 3: showString(0, "Ytltkz"); break;                           // Печатаем "Неделя";
        case 4: showString(0, "<elbkmybr"); break;                        // Печатаем "Будильник";
        case 5: showString(0, "Zhrjcnm"); break;                          // Печатаем "Яркость";
    }                                                                     //
    refreshAll();                                                         //
    klav();                                                               //  Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key == 1){                                                         //
      playExit();                                                         //
      setMode = 0, key=0;                                                 //
      return;                                                             //
    }                                                                     //
    if(key == 3) {                                                        //
      playSound(AUDIO_PIN,1500,60);                                       //
      switch(setMode){                                                    //
        case 1: setUpTime(); break;                                       //
        case 2: setUpData(); break;                                       //
        case 3: setUpDoW(); break;                                        //
        case 4: setUpAlarm(); break;                                      //
        default: brightDisp(); break;                                     //
      }                                                                   //
      now = millis();                                                     //
    }                                                                     //
    if(key == 2){                                                         //
      playSound(AUDIO_PIN,1500,60);                                       //
      now = millis();                                                     //
      setMode++;                                                          //
      if(setMode == 6) setMode = 1;                                       //
    }                                                                     //
  }                                                                       //
  playExit();                                                             //
  setMode = 0;                                                            //
}                                                                         //

//----------------------------------------------------------------------- УСТАНОВКА ЧАСОВ
void setUpTime(){                                                         //
  int i;                                                                  //
  int j = 0;                                                              // переменная для хранения позиции изменяемого значения
  now = millis();                                                         // сбарсываем переменную счета таймера в (миллис)
  while (millis()-now < timerMenu+60000*(j==4)){                          // запускаем таймер автовыхода из подпрограмы, если мы сейчас в позии секунд то таймер увеличиваем на 60 секунд
    clrAll();                                                             // очистка экрана
    getRTCDateTime();                                                     // считываем данные часы, минуты, секунды
    h1 = hour / 10;
    h0 = hour % 10;                                       //
    m1 = minute / 10;
    m0 = minute % 10;                                     //
    s1 = second / 10;
    s0 = second % 10;                                     //
    showClock();                                                         //
    i=((millis()-now)/350%2);                                             // создаем переменную которая меняет значение с периодом 3 Гц.
    klav();                                                               // Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key == 1){                                                         // если нажата кнопка 1, то выходим из подпрограмы
      playExit();                                                         //
      return;                                                             //
    }                                                                     //
    if(key == 2){                                                         // если нажата кнопка 2, то переходим к следующей позиции установки
      playSound(AUDIO_PIN,1500,60);                                       //
      now = millis();                                                     // сбрасывае счетчик автовыхода из подпрограмы
      j++;                                                                //
      if(j>4) j=0;                                                        //
    }                                                                     //
    if(key == 3){                                                         // если нажата кнопка 3, то меняеме значение переменной отображаемой в данной позиции
      playSound(AUDIO_PIN,1500,60);                                       //
      now = millis();                                                     //
      i=0;                                                                //
      switch(j){                                                          //
        case 0: h1 = 0 + 1*(h1==0) + 2*(h1==1)*(h0<4); break;             //
        case 1: h0 = 0 + (h0+1)*(h0<9)*(h1<2) + (h0+1)*(h0<3)*(h1==2); break;  //
        case 2: m1 = 0 + (m1+1)*(m1<5); break;                            //
        case 3: m0 = 0 + (m0+1)*(m0<9); break;                            //
        //case 4: second = 0; break;                                      //
        default: second = 0; break;                                       // секунды просто сбрасываем в "0"
      }                                                                   //
      hour = h1*10+h0;                                                    //
      minute = m1*10+m0;                                                  //
      if(j==4) setRTCTime();                                              // если была установка секнд то устанавливаем новые часы, минуты, секунды 
      else setRTCTimeNotSec();                                            // если мы меняли или часы или минуты, то устанавливаем только часы и минуты, секунды не трогаем! 
      }                                                                   //
    if(i) clr(j*4+3*(j==2)+4*(j==3)+7*(j>3), 5+1*(j>0)+3*(j>3));          // стераем символ которым меняем (моргаем) или //invert()
      refreshAll();                                                       //
  }                                                                       //
}                                                                         //

//----------------------------------------------------------------------- УСТАНОВКА ДАТЫ
void setUpData(){                                                         //
  int i;                                                                  //
  int j = 0;                                                              // переменная для хранения позиции изменяемого значения
  now = millis();                                                         // сбарсываем переменную счета таймера в (миллис)
  while (millis()-now < timerMenu){                                       // запускаем таймер
    clrAll();                                                             // очистка экрана
    getRTCDateTime();                                                     // считываем данные дня, месяца, года
    d1 = day / 10;                                                        // десятки дней
    d0 = day % 10;                                                        // еденицы дней
    mn1 = month / 10;                                                     // десятки месяца
    mn0 = month % 10;                                                     // еденицы месяца
    y1 = (year - 2000)/10;                                                // десятки года
    y0 = (year - 2000)%10;                                                // еденицы года
    showDate();                                                           // записываем дату в память экрана
    i=((millis()-now)/350%2);                                             // создаем переменную которая меняет значение с периодом 3 Гц.
    klav();                                                               // опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key == 1){                                                         // клавиша 1 - выходим обратно в установку
      playExit();                                                         // сигнал выхода 
      return;                                                             // возврат
    }                                                                     //
    if(key == 2){                                                         // клавиша 2 - выбираем следующее значение для изменения
      playSound(AUDIO_PIN,1500,60);                                       // подтверждение нажатия клавиши
      now = millis();                                                     // сброс счетчика цикла автоматического выхода
      j++;                                                                // счетчик позиции изменяемого значения увеличиваем на 1
      if(j>5) j=0;                                                        // сброс счетчика позиции если достигнута последняя (всего у нас 6 позиций (0-5))
    }                                                                     //
    if(key == 3){                                                         // если нажата кнопка 3 - изменяем значение в выбранной позиции
      playSound(AUDIO_PIN,1500,60);                                       // подтверждение нажатия клавиши
      now = millis();                                                     // сброс счетчика цикла автоматического выхода
      i=0;                                                                //
      switch(j){                                                          // в зависимости от позиции - применяем условия изменения данного значения
        case 0: d1 = 0+1*(d1==0)+2*(d1==1)+3*(d1==2)*(d0<2); break;       // десятки дня - устанавливаем 1 если до этого был 0, 2 есили была 1, 3 если была 2 с провекой едениц дней
        case 1: d0 = 0+(d0+1)*(d0<9)*(d1<3)+(d0+1)*(d0<1)*(d1==3); break; // еденицы дня - прибавляем 1 если десятки меньше 3, есил десятки 3 то еденицы 0 или 1 
        case 2: mn1 = 0+1*(mn1==0); break;                                // десятки месяца устанавливаем 1 если до этого был 0, и наооборот
        case 3: mn0 = 0+(mn0+1)*(mn0<9); break;                           // еденицы месяца устанавливаем от 0 до 9
        case 4: y1 = 0+(y1+1)*(y1<9); break;                              // дестки лет устанавливаем от 0 до 9
        default: y0 = 0+(y0+1)*(y0<9); break;                             // еденицы лет устанавливаем от 0 до 9
      }                                                                   //
      if(mn1==1 && mn0>2 || mn1==0 && mn0==0){                            // если десяки и еденицы лет = 00 или больше 12 то устанавливае 01 - первый месяц
        mn1=0 ;                                                           //
        mn0=1;                                                            //
      }                                                                   //
      month = mn1*10+mn0;                                                 // в переменную месяца - складываем десятки и еденицы месяца
      if(d1==0&&d0==0) d0 = 1;                                            // если десятки и еденицы дня = 00 то устанавливаем 01 - первый день
      if(d1==3&&d0==1&&(month==2||month==4||month==6||month==9||month==11)) d0=0; // проверяем 31 число в каком месяце не может быть и меняем его на 30
      day = d1*10+d0;                                                     // в переменную день складываем десятки и еденицы дней
      year = y1*10+y0+2000;                                               // в переменную года складываем десяки и еденицы лет + 2000
      if(month == 2 && day >= 29 && (year%4 != 0)){                       // проверяем в ферале месяце число больше 29 и проверяем не высокосный ли год, если нет:
        d1=2;                                                             // десятки дней = 2
        d0=8;                                                             // еденицы дней = 8
        day=28;                                                           // день равен 28
      }                                                                   //
      if(month == 2 && day >= 29 && (year%4 == 0)){                       // проверяем в ферале месяце число больше 29 и если год высокосный:
        d1=2;                                                             // десятки дней = 2
        d0=9;                                                             // еденицы дней = 9
        day=29;                                                           // день равен 29
      }                                                                   //
      setRTCDate();                                                       // запись даты (день, месяц, год)в память RTC
    }                                                                     //
    if(i) clr(j*4+3*(j==2)+4*(j==3)+7*(j>3), 5+1*(j>0)*(j<4));            // invert - инвертируем часть экрана (начальная позиция и кол-во столбцов, а так просто мигаем значением
    refreshAll();                                                         // все данные из памяти экрана выводим на экран
  }                                                                       //
}                                                                         //

//----------------------------------------------------------------------- УСТАНОВКА ДНЯ НЕДЕЛИ
void setUpDoW(){                                                          //
  int i;                                                                  //
  now = millis();                                                         // сбарсываем переменную счета таймера в (миллис)
  while (millis()-now < timerMenu){                                       // запускаем таймер
    clrAll();                                                             //
    getRTCDateTime();                                                     //
    i=((millis()-now)/350%2);                                             // создаем переменную которая меняет значение с периодом 3 Гц.
    klav();                                                               //  Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key == 1){                                                         //
      playExit();                                                         //
      return;                                                             //
    }                                                                     //
    if(key == 2){                                                         //
      playSound(AUDIO_PIN,1500,60);                                       //
      i=1;                                                                //
      dayOfWeek++;                                                        //
      if(dayOfWeek > 7) dayOfWeek = 1;                                    //
      setRTCDoW();                                                        // УСТАНОВКА ДАТЫ (день, месяц, год)
      now = millis();                                                     //
    }                                                                     //
    if(key == 3){                                                         //
      playSound(AUDIO_PIN,1500,60);                                       //
      i=1;                                                                //
      dayOfWeek--;                                                        //
      if(dayOfWeek == 0) dayOfWeek = 7;                                   //
      setRTCDoW();                                                        // УСТАНОВКА ДАТЫ (день, месяц, год)
      now = millis();                                                     //
    }                                                                     //
    if(i){                                                                //
      switch(dayOfWeek){                                                  //
        case 1: showString(2, "Gjytltkmybr"); break;                      //
        case 2: showString(3, "Dnjhybr"); break;                          //
        case 3: showString(3, "Chtlf"); break;                            //
        case 4: showString(3, "Xtndthu"); break;                          //
        case 5: showString(3, "Gznybwf"); break;                          //
        case 6: showString(3, "Ce,,jnf"); break;                          //
        case 7: showString(3, "Djcrhtctymt"); break;                      //
      }                                                                   //
    }                                                                     //
    refreshAll();                                                         //
  }                                                                       //
  playExit();                                                             //
}                                                                         // 

//----------------------------------------------------------------------- УСТАНОВКА БУДИЛЬНИКОВ
void setUpAlarm(){                                                        //
  int i, j=0, jx=0;                                                       // j- номер будильника, jx- значения которое будем менять (0-номер будильника, 1-режим, 2 часы, 3-минуты
//for(int i=0; i<AMOUNT_ALARM; i++){                                      // Загружаем из памяти RTC модуля значения будильников в переменные
//  hourAlarm[i]=readRTCMem(i*3);                                         //
//  minuteAlarm[i]=readRTCMem(i*3+1);                                     //
//  modeAlarm[i]=readRTCMem(i*3+2);                                       //
//}                                                                       //
  now=millis();                                                           // сбарсываем переменную счета таймера в (миллис)
  while(millis()-now<timerMenu){                                          // запускаем таймер
    clrAll();                                                             // очистка экрана
    i=((millis()-now)/350%2);                                             // создаем переменную которая меняет значение с периодом 3 Гц.
    showDigit((!i ? 13:(hourAlarm[j]>23 ? 13:14)), 0, dig5x8rn);          // Выводим значек колокольчика, и если будильник включен, то машим язычком колокольчика
    showDigit(((int) j/10), 6, dig3x6alarm);                              // выводим номер будильника - десятки
    showDigit(((int) j%10), 10, dig3x6alarm);                             // выводим номер будильника - еденицы
    klav();                                                               // Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key==1){                                                           // если нажата клавиша "1" - выходим из подпрограмы
      playExit(); return;                                                 //
    }                                                                     //
    if(key==2){                                                           // если нажата клавиша "2" - переходим к следующему полю
      playSound(AUDIO_PIN,1500,60); now=millis(); jx++;                   //
      if(jx>3) jx=0;                                                      //
    }                                                                     //
    if(key==3){                                                           // если нажата клавиша "1" - изменяем значение поля в соответствии с его назначением
      playSound(AUDIO_PIN,1500,60); i=0; now=millis();                    //
      if(jx==0){                                                          // если выбрано поле номер будильника
        j++;                                                              // увеличиваем номер будильника
        if(j>(AMOUNT_ALARM-1)) j=0;                                       // если номер будильника больше чем разрешенное кол-во будильников то переходим к первому будильнику (0)
      }                                                                   //
      if(jx==1){                                                          // если выбрано поле дней работы будильника
        modeAlarm[j]++;                                                   // перебераем дни работы
        if(modeAlarm[j]>10) modeAlarm[j]=0;                               // 
        writeRTCMem((j*3+2),modeAlarm[j]);                                // в память RTC записываем данные дней работы  будильника(№)
      }                                                                   //
      if(jx==2){                                                          // если выбрано поле часов будильника
        hourAlarm[j]++;                                                   // увеличиваем часы будильника
        if(hourAlarm[j]>24) hourAlarm[j]=0;                               // больше 24 сбрасываем в 0
        writeRTCMem((j*3),hourAlarm[j]);                                  // в память RTC записываем данные часов будильника(№)
      }                                                                   //
      if(jx==3){                                                          // если выбрано поле минут будильника
        minuteAlarm[j]++;                                                 // увеличиваем минуты будильника
        if(minuteAlarm[j]>59) minuteAlarm[j]=0;                           // если больше 59 сбрасываем в 0
        writeRTCMem((j*3+1),minuteAlarm[j]);                              // в память RTC записываем данные часов будильника(№)
      }                                                                   //
    }                                                                     //
    if(jx<2){                                                             //
      if(hourAlarm[j]>23){                                                //    отключен
        showDigit(18, 17, dig3x6alarm);                                   // о
        showDigit(22, 21, dig3x6alarm);                                   // т
        showDigit(16, 25, dig3x6alarm);                                   // к
        showDigit(26, 29, dig3x6alarm);                                   // л
      }                                                                   //
      else{                                                               //
        switch(modeAlarm[j]){                                             //
          case 0: {                                                       //    понедельни-воскресенье
            showDigit(19, 14, dig3x6alarm);                               // п
            showDigit(17, 18, dig3x6alarm);                               // н
            showDigit(10, 22, dig3x6alarm);                               // -
            showDigit(13, 25, dig3x6alarm);                               // в
            showDigit(21, 29, dig3x6alarm);                               // с
            }; break;                                                     // 
          case 1: {                                                       //    понедельник
            showDigit(19, 17, dig3x6alarm);                               // п
            showDigit(18, 21, dig3x6alarm);                               // о
            showDigit(17, 25, dig3x6alarm);                               // н
            showDigit(15, 29, dig3x6alarm);                               // е
            }; break;                                                     //
          case 2: {                                                       //    вторник
            showDigit(13, 17, dig3x6alarm);                               // в
            showDigit(22, 21, dig3x6alarm);                               // т
            showDigit(18, 25, dig3x6alarm);                               // о
            showDigit(20, 29, dig3x6alarm);                               // р
            }; break;                                                     //
          case 3: {                                                       //    среда
            showDigit(21, 17, dig3x6alarm);                               // с
            showDigit(20, 21, dig3x6alarm);                               // р
            showDigit(15, 25, dig3x6alarm);                               // е
            showDigit(14, 29, dig3x6alarm);                               // д
            }; break;                                                     // 
          case 4: {                                                       //    четверг
            showDigit(24, 17, dig3x6alarm);                               // ч
            showDigit(15, 21, dig3x6alarm);                               // е
            showDigit(22, 25, dig3x6alarm);                               // т
            showDigit(13, 29, dig3x6alarm);                               // в
            }; break;                                                     // 
          case 5: {                                                       //    пятница
            showDigit(19, 17, dig3x6alarm);                               // п
            showDigit(25, 21, dig3x6alarm);                               // я
            showDigit(22, 25, dig3x6alarm);                               // т
            showDigit(17, 29, dig3x6alarm);                               // н
            }; break;                                                     // 
          case 6: {                                                       //    суббота
            showDigit(21, 17, dig3x6alarm);                               // с
            showDigit(23, 21, dig3x6alarm);                               // у
            showDigit(12, 25, dig3x6alarm);                               // б
            showDigit(12, 29, dig3x6alarm);                               // б 
          }; break;                                                       // 
          case 7: {                                                       //    воскресенье
            showDigit(13, 17, dig3x6alarm);                               // в
            showDigit(18, 21, dig3x6alarm);                               // о
            showDigit(21, 25, dig3x6alarm);                               // с
            showDigit(16, 29, dig3x6alarm);                               // к
          }; break;                                                       // 
          case 8: {                                                       //    понедельник-пятница
            showDigit(19, 14, dig3x6alarm);                               // п
            showDigit(17, 18, dig3x6alarm);                               // н
            showDigit(10, 22, dig3x6alarm);                               // -
            showDigit(19, 25, dig3x6alarm);                               // п
            showDigit(25, 29, dig3x6alarm);                               // я
          }; break;                                                       // 
          case 9: {                                                       //    суббота-воскресенье
            showDigit(21, 14, dig3x6alarm);                               // с
            showDigit(23, 18, dig3x6alarm);                               // у
            showDigit(10, 22, dig3x6alarm);                               // -
            showDigit(13, 25, dig3x6alarm);                               // в
            showDigit(21, 29, dig3x6alarm);                               // с
          }; break;                                                       //
          default: {                                                      //    1-раз
            showDigit(1, 15, dig3x6alarm);                                // 1 
            showDigit(10, 19, dig3x6alarm);                               // -
            showDigit(20, 22, dig3x6alarm);                               // р
            showDigit(11, 25, dig3x6alarm);                               // а
            showDigit(27, 29, dig3x6alarm);                               // з
          }; break;                                                       //
        }                                                                 //
      }                                                                   //
    }                                                                     //
    if(jx>1){                                                             //
      if(hourAlarm[j]>24) hourAlarm[j]=24;                                // Делаем проверку часов и минут будильника на тот случай если 
      if(minuteAlarm[j]>59) minuteAlarm[j]=0;                             // по какой то причине они более возможных
      if(modeAlarm[j]>10) modeAlarm[j]=10;                                // 10 - одноразовое срабатывание будильника
      showDigit(((int) hourAlarm[j]/10), 15, dig3x6alarm);                // выводим десятки часов
      showDigit(((int) hourAlarm[j]%10), 19, dig3x6alarm);                // выводим единицы часов
      setCol(23, 0x28);                                                   // печатаем двоеточие
      showDigit(((int) minuteAlarm[j]/10), 25, dig3x6alarm);              // выводим десятки минут
      showDigit(((int) minuteAlarm[j]%10), 29, dig3x6alarm);              // выводим единицы минут
    }                                                                     //
    if(i) clr(0+5*(jx==0)+13*(jx==1)+14*(jx==2)+24*(jx==3), 0+9*(jx!=1)+19*(jx==1));  //стераем те части экра, которые должны мигать
    refreshAll();                                                         //
  }                                                                       //
  playExit();                                                             //
}                                                                         //

//----------------------------------------------------------------------- УСТАНОВКА ЯРКОСТИ ЭКРАНА
void brightDisp(){                                                        //
  int i;                                                                  //
  now=millis();                                                           // сбарсываем переменную счета таймера в (миллис)
  while(millis()-now<timerMenu){                                          // запускаем таймер
    clrAll();                                                             //
    i=((millis()-now)/350%2);                                             // создаем переменную которая меняет значение с периодом 3 Гц.
    showDigit(i==0 ? 1 :2 , 0, dig8x8);                                   // выводим значек солнышка (анимированый)
    klav();                                                               // Опрашиваем клавиши 0- не нажаты, 1-3 клавиши нажаты
    if(key==1){                                                           //
      playExit(); return;                                                 //
    }                                                                     //
    if(key==2){                                                           // увеличиваем яркость дисплея
      playSound(AUDIO_PIN,1500,60); now=millis(); brightSet++;            //
      if(brightSet>17) brightSet=0;                                       //
    }                                                                     //
    if(key==3){                                                           // уменьшаем яркость дисплея
      playSound(AUDIO_PIN,1500,60); now=millis(); brightSet--;            //
      if(brightSet<0) brightSet=17;                                       //
    }                                                                     // 
    if(brightSet<16){                                                     //
      if(brightSet/10) showDigit(brightSet/10, 13, dig6x8);               // выводим десятки яркости если больше 9
      showDigit(brightSet%10, brightSet/10? 21: 17, dig6x8);              // выводим единицы яркости сдвигаем вывод если меньше 10
      sendCmdAll(CMD_INTENSITY, brightSet);                               // посылаем команду изменения яркости
    }                                                                     //
    if(brightSet==16){                                                    //
      showString(10, "FDNJ");                                             // выводим "АВТО"
      sendCmdAll(CMD_INTENSITY, 2);                                       //
    }                                                                     //
    if(brightSet==17){                                                    //
      showString(12, "L|Y");                                              // выводим "Д/Н"
      sendCmdAll(CMD_INTENSITY, 10);                                      //
    }                                                                     //
    refreshAll();                                                         //
  }                                                                       //
  playExit();                                                             //
}                                                                         //

//----------------------------------------------------------------------- конец---------------------------------------------------------------

